// -*- c++ -*-

/*
 *  Copyright (C) 2001-2003, Richard J. Moore <rich@kde.org>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this library; see the file COPYING.LIB.  If not, write to
 *  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 *  Boston, MA 02111-1307, USA.
 */

#ifndef KJSEMBEDJSOPAQUEPROXY_H
#define KJSEMBEDJSOPAQUEPROXY_H

#include <qcstring.h>
#include <qevent.h>

#include <kjs/object.h>
#include <kjsembed/jsproxy.h>

class QTextStream;

namespace KJSEmbed {

/**
 * Provides a binding to an opaque pointer value. This class stores a pointer
 * without interpreting its type, it also stores the name of the type allowing
 * it to retain type-safety.
 *
 * @author Richard Moore, rich@kde.org
 */
class JSOpaqueProxy : public JSProxy
{
public:
    /** Creates an opaque proxy. */
    JSOpaqueProxy();

    /** Creates an opaque proxy. */
    JSOpaqueProxy( void *ptr, const char *ptrtype );

    /** Creates an opaque proxy. */
    JSOpaqueProxy( QTextStream *ts );

    /** Creates an opaque proxy. */
    JSOpaqueProxy( const QEvent *ev );

    /** Cleans up. */
    virtual ~JSOpaqueProxy();

    /** Returns the type of the wrapped object.*/
    QString typeName() const;

    /** Sets the value of the proxy and its type. */
    void setValue( void *ptr, const char *ptrtype );

    /** Sets the value of the proxy to a QTextStream. */
    void setValue( QTextStream *ts );

    /** Sets the value of the proxy to a QEvent. */
    void setValue( const QEvent *ev );

    /** Returns the proxy value as a void pointer. */
    void *toVoidStar() { return ptr; }

    /** Returns true iff the content of this proxy inherits the specified base-class. */
    bool inherits( const char *clazz );

    /**
     * Returns the QTextStream stored in the proxy. If proxy does not contain
     * a value of type QTextStream then 0 is returned.
     */
    QTextStream *toTextStream();

    const QEvent *toEvent();

    /** Adds the bindings for the opaque proxy to the specified js object. */
    virtual void addBindings( KJS::ExecState *state, KJS::Object &object );

    /** Reimplemented to return the name and class of the target. */
    virtual KJS::UString toString( KJS::ExecState *exec ) const;

private:
    void *ptr;
    QTextStream *textstream;
    const QEvent *event;
    QCString ptrtype;

    class JSOpaqueProxyPrivate *d;
};

} // namespace KJSEmbed

#endif // KJSEMBEDJSOPAQUEPROXYIMP_H

// Local Variables:
// c-basic-offset: 4
// End:
