/*
*  Copyright (C) 2003, Ian Reinhart Geiser <geiseri@kde.org>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this library; see the file COPYING.LIB.  If not, write to
 *  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 *  Boston, MA 02111-1307, USA.
 */

 #include "kconfig_imp.h"
 #include "kconfig_imp.moc"

 #include <kconfig.h>
 #include <kstddirs.h>
 #include <kapplication.h>
 #include <kdebug.h>

namespace KJSEmbed {
namespace Bindings {

Config::Config( QObject *parent, const char *name)
    : BindingObject(parent, name)
{
	if( name == 0)
		m_config = kapp->config();
	else
		m_config = new KConfig(name);
}

Config::Config( QObject *parent, const char *name , const QString& confName)
        : BindingObject(parent, name)
{
    QString fileName = ::locate("kde_config", confName);
    kdDebug() << " filename " << fileName << endl;
    m_config = new KConfig(fileName);
}

Config::~Config()
{
    delete m_config;
}

KConfig *Config::kconfig()
{
    return m_config;
}

void Config::setDesktopGroup()
{
    m_config->setDesktopGroup();
}

void Config::setGroup(const QString& group)
{
    m_config->setGroup(group);
}

QString Config::group()
{
    return m_config->group();
}

QStringList Config::groupList()
{
    return m_config->groupList();
}

QString Config::locale()
{
    return m_config->locale();
}

void Config::setForceGlobal( bool force )
{
    m_config->setForceGlobal(force);
}

bool Config::forceGlobal( ) const
{
    return m_config->forceGlobal();
}

void Config::setDollarExpansion( bool _bExpand )
{
    m_config->setDollarExpansion(_bExpand);
}

bool Config::isDollarExpansion() const
{
    return m_config->isDollarExpansion();
}

void Config::setReadOnly(bool _ro)
{
    m_config->setReadOnly(_ro);
}

bool Config::isReadOnly() const
{
    return m_config->isReadOnly();
}

void Config::setReadDefaults(bool b)
{
    m_config->setReadDefaults(b);
}

bool Config::readDefaults() const
{
    return m_config->readDefaults();
}

void Config::rollback( bool bDeep  )
{
    m_config->rollback(bDeep);
}

void Config::sync()
{
    m_config->sync();
}

bool Config::hasKey( const QString& key ) const
{
    return m_config->hasKey(key);
}

bool Config::entryIsImmutable(const QString &key) const
{
    return m_config->entryIsImmutable(key);
}

void Config::revertToDefault(const QString &key)
{
    m_config->revertToDefault(key);
}

bool Config::hasDefault(const QString &key) const
{
    return m_config->hasDefault(key);
}

void Config::setFileWriteMode(int mode)
{
    m_config->setFileWriteMode(mode);
}

QString Config::readEntry(const QString& pKey, const QString& aDefault ) const
{
    return m_config->readEntry(pKey,aDefault);
}

QVariant Config::readPropertyEntry( const QString& pKey, const QVariant &pDefault) const
{
    return m_config->readPropertyEntry(pKey,pDefault);
}

QStringList Config::readListEntry( const QString& pKey, char sep  ) const
{
    return m_config->readListEntry(pKey,sep);
}

QString Config::readPathEntry( const QString& pKey, const QString & aDefault ) const
{
    return m_config->readPathEntry(pKey,aDefault);
}

QStringList Config::readPathListEntry( const QString& pKey, char sep  ) const
{
    return m_config->readPathListEntry(pKey,sep);
}

int Config::readNumEntry( const QString& pKey, int nDefault) const
{
    return m_config->readNumEntry(pKey,nDefault);
}

uint Config::readUnsignedNumEntry( const QString& pKey, uint nDefault) const
{
    return m_config->readUnsignedNumEntry(pKey,nDefault);
}

long Config::readLongNumEntry( const QString& pKey, long nDefault) const
{
    return m_config->readLongNumEntry(pKey,nDefault);
}

double Config::readDoubleNumEntry( const QString& pKey, double nDefault ) const
{
    return m_config->readDoubleNumEntry(pKey,nDefault);
}

QFont Config::readFontEntry( const QString& pKey, const QFont* pDefault ) const
{
    return m_config->readFontEntry(pKey,pDefault);
}

bool Config::readBoolEntry( const QString& pKey, const bool bDefault ) const
{
    return m_config->readBoolEntry(pKey,bDefault);
}

QRect Config::readRectEntry( const QString& pKey, const QRect* pDefault ) const
{
    return m_config->readRectEntry(pKey,pDefault);
}

QPoint Config::readPointEntry( const QString& pKey, const QPoint* pDefault ) const
{
    return m_config->readPointEntry(pKey,pDefault);
}

QSize Config::readSizeEntry( const QString& pKey, const QSize* pDefault  ) const
{
    return m_config->readSizeEntry(pKey,pDefault);
}

QColor Config::readColorEntry( const QString& pKey, const QColor* pDefault ) const
{
    return m_config->readColorEntry(pKey,pDefault);
}

QDateTime Config::readDateTimeEntry( const QString& pKey, const QDateTime* pDefault) const
{
    return m_config->readDateTimeEntry(pKey,pDefault);
}

QString Config::readEntryUntranslated( const QString& pKey, const QString& aDefault ) const
{
    return m_config->readEntryUntranslated(pKey,aDefault);
}
void Config::writeEntry( const QString& pKey, const QString& pValue, bool bPersistent  , bool bGlobal , bool bNLS  )
{
    m_config->writeEntry(pKey, pValue,  bPersistent  ,bGlobal , bNLS);
}

void Config::writeEntry( const QString& pKey, const QVariant& pValue, bool bPersistent  , bool bGlobal , bool bNLS  )
{
    m_config->writeEntry(pKey, pValue,  bPersistent  ,bGlobal , bNLS );
}

void Config::writeEntry( const QString& pKey, const QStringList &rValue, char sep , bool bPersistent  , bool bGlobal , bool bNLS  )
{
    m_config->writeEntry(pKey, rValue, sep,  bPersistent  ,bGlobal , bNLS );
}

// void Config::writeEntry( const QString& pKey, const QStringList& pValue, bool bPersistent  , bool bGlobal , bool bNLS  )
// {
//     m_config->writeEntry(pKey, pValue,  bPersistent  ,bGlobal , bNLS );
// }

void Config::writeEntry( const QString& pKey, int nValue, bool bPersistent  , bool bGlobal , bool bNLS  )
{
    m_config->writeEntry(pKey, nValue,  bPersistent  ,bGlobal , bNLS );
}
void Config::writeEntry( const QString& pKey, uint nValue, bool bPersistent  , bool bGlobal , bool bNLS  )
{
    m_config->writeEntry(pKey, nValue,  bPersistent  ,bGlobal , bNLS );
}
void Config::writeEntry( const QString& pKey, unsigned long nValue, bool bPersistent  , bool bGlobal , bool bNLS  )
{
    m_config->writeEntry(pKey, nValue,  bPersistent  ,bGlobal , bNLS );
}
void Config::writeEntry( const QString& pKey, double nValue, bool bPersistent  , bool bGlobal , char format, int precision ,bool bNLS  )
{
    m_config->writeEntry(pKey, nValue,  bPersistent  ,bGlobal,format ,precision, bNLS );
}
void Config::writeEntry( const QString& pKey, bool bValue, bool bPersistent  , bool bGlobal , bool bNLS  )
{
    m_config->writeEntry(pKey, bValue,  bPersistent  ,bGlobal , bNLS );
}
void Config::writeEntry( const QString& pKey, const QFont& rFont, bool bPersistent  , bool bGlobal , bool bNLS  )
{
    m_config->writeEntry(pKey, rFont,  bPersistent  ,bGlobal , bNLS );
}
void Config::writeEntry( const QString& pKey, const QColor& rColor, bool bPersistent  , bool bGlobal , bool bNLS  )
{
    m_config->writeEntry(pKey, rColor,  bPersistent  ,bGlobal , bNLS );
}
void Config::writeEntry( const QString& pKey, const QDateTime& rDateTime,bool bPersistent  , bool bGlobal ,  bool bNLS  )
{
    m_config->writeEntry(pKey, rDateTime,  bPersistent  ,bGlobal , bNLS );
}
void Config::writeEntry( const QString& pKey, const QRect& rValue, bool bPersistent  , bool bGlobal , bool bNLS  )
{
    m_config->writeEntry(pKey, rValue,  bPersistent  ,bGlobal , bNLS );
}
void Config::writeEntry( const QString& pKey, const QPoint& rValue, bool bPersistent  , bool bGlobal , bool bNLS  )
{
    m_config->writeEntry(pKey, rValue,  bPersistent  ,bGlobal , bNLS );
}
void Config::writeEntry( const QString& pKey, const QSize& rValue, bool bPersistent  , bool bGlobal , bool bNLS  )
{
    m_config->writeEntry(pKey, rValue,  bPersistent  ,bGlobal , bNLS  );
}
void Config::writePathEntry( const QString& pKey, const QString & path, bool bPersistent  , bool bGlobal , bool bNLS  )
{
    m_config->writePathEntry(pKey,path,bPersistent,bGlobal,bNLS);
}
void Config::writePathEntry( const QString& pKey, const QStringList &rValue, char sep , bool bPersistent  , bool bGlobal , bool bNLS  )
{
    m_config->writePathEntry(pKey,rValue,sep,bPersistent ,bGlobal,bNLS);
}
void Config::deleteEntry( const QString& pKey, bool bNLS , bool bGlobal )
{
    m_config->deleteEntry(pKey,bNLS,bGlobal);
}
bool Config::deleteGroup( const QString& group, bool bDeep  , bool bGlobal  )
{
    return m_config->deleteGroup(group,bDeep,bGlobal);
}

}
}
