import java.util.*;

import org.kde.qt.*;
import org.kde.koala.*;

/**
  * The base class for JavaApiTest application windows. It sets up the main
  * window and reads the config file as well as providing a menubar, toolbar
  * and statusbar. An instance of KBaseView creates your center view, which is connected
  * to the window's Doc object.
  * KBase reimplements the methods that KMainWindow provides for main window handling and supports
  * full session management as well as using KActions.
  * @see KMainWindow
  * @see KApplication
  * @see KConfig
  *
  * @author Source Framework Automatically Generated by KDevelop, (c) The KDevelop Team.
  * @version KDevelop version 1.2 code generation
  */
public class KBase extends KMainWindow
{
    public static final int ID_STATUS_MSG = 1;

	/** the configuration object of the application */
    private KConfig config;
    /** view is the main widget which represents your working area. The View
     * class should handle all events of the view widget.  It is kept empty so
     * you can create your view according to your application's needs by
     * changing the view class.
     */
    private KBaseView view;
    /** doc represents your actual document and is created only once. It keeps
     * information such as filename and does the serialization of your files.
     */
    private KBaseDoc doc;

    // KAction references to enable/disable actions
    private KAction fileNewWindow;
    private KAction fileNew;
    private KAction fileOpen;
    private KRecentFilesAction fileOpenRecent;
    private KAction fileSave;
    private KAction fileSaveAs;
    private KAction fileClose;
    private KAction filePrint;
    private KAction fileQuit;
    private KAction editCut;
    private KAction editCopy;
    private KAction editPaste;
    private KToggleAction viewToolBar;
    private KToggleAction viewStatusBar;

    /** construtor of KBase, calls all init functions to create the application.
     */
public KBase(QWidget parent, String name)
{
  super(parent, name, 0);
  KApplication kapp = KApplication.kApplication();
  config=kapp.config();

  ///////////////////////////////////////////////////////////////////
  // call inits to invoke all other construction parts
  initStatusBar();
  initActions();
  initDocument();
  initView();
	
  readOptions();

  ///////////////////////////////////////////////////////////////////
  // disable actions at startup
  fileSave.setEnabled(false);
  fileSaveAs.setEnabled(false);
  filePrint.setEnabled(false);
  editCut.setEnabled(false);
  editCopy.setEnabled(false);
 }

public KBase()
{
	this(null, null);
}

    /** initializes the KActions of the application */
protected void initActions()
{
  fileNewWindow = new KAction(tr("New &Window"), "", new KShortcut(), this, SLOT("slotFileNewWindow()"), actionCollection(),"file_new_window");
  fileNew = KStdAction.openNew(this, SLOT("slotFileNew()"), actionCollection());
  fileOpen = KStdAction.open(this, SLOT("slotFileOpen()"), actionCollection());
  fileOpenRecent = (KRecentFilesAction) KStdAction.openRecent(this, SLOT("slotFileOpenRecent(KURL)"), actionCollection());
  fileSave = KStdAction.save(this, SLOT("slotFileSave()"), actionCollection());
  fileSaveAs = KStdAction.saveAs(this, SLOT("slotFileSaveAs()"), actionCollection());
  // this one crashes for me...
//  fileClose = KStdAction.close(this, SLOT(slotFileClose()), actionCollection());
  filePrint = KStdAction.print(this, SLOT("slotFilePrint()"), actionCollection());
  fileQuit = KStdAction.quit(this, SLOT("slotFileQuit()"), actionCollection());
  editCut = KStdAction.cut(this, SLOT("slotEditCut()"), actionCollection());
  editCopy = KStdAction.copy(this, SLOT("slotEditCopy()"), actionCollection());
  editPaste = KStdAction.paste(this, SLOT("slotEditPaste()"), actionCollection());
  createStandardStatusBarAction();
//  viewToolBar = KStdAction.showToolbar(this, SLOT("slotViewToolBar()"), actionCollection());
  viewStatusBar = KStdAction.showStatusbar(this, SLOT("slotViewStatusBar()"), actionCollection());

  fileNewWindow.setToolTip(tr("Opens a new application window"));
  fileNew.setToolTip(tr("Creates a new document"));
  fileOpen.setToolTip(tr("Opens an existing document"));
  fileOpenRecent.setToolTip(tr("Opens a recently used file"));
  fileSave.setToolTip(tr("Saves the actual document"));
  fileSaveAs.setToolTip(tr("Saves the actual document as..."));
//  fileClose.setToolTip(tr("Closes the actual document"));
  filePrint .setToolTip(tr("Prints out the actual document"));
  fileQuit.setToolTip(tr("Quits the application"));
  editCut.setToolTip(tr("Cuts the selected section and puts it to the clipboard"));
  editCopy.setToolTip(tr("Copies the selected section to the clipboard"));
  editPaste.setToolTip(tr("Pastes the clipboard contents to actual position"));
//  viewToolBar.setToolTip(tr("Enables/disables the toolbar"));
  viewStatusBar.setToolTip(tr("Enables/disables the statusbar"));

  // use the absolute path to your kbaseui.rc file for testing purpose in createGUI();
  createGUI();

}



    /** sets up the kstatusBar for the main window by initialzing a statuslabel.
     */
protected void initStatusBar()
{
  ///////////////////////////////////////////////////////////////////
  // STATUSBAR
  // TODO: add your own items you need for displaying current application status.
  ((KStatusBar) statusBar()).insertItem(tr("Ready."), ID_STATUS_MSG);
}

    /** initializes the document object of the main window that is connected to the view in initView().
     * @see initView();
     */
public void initDocument()
{
  doc = new KBaseDoc(this, null);
  doc.newDocument();
}

    /** creates the centerwidget of the KTMainWindow instance and sets it as the view
     */
protected void initView()
{
  ////////////////////////////////////////////////////////////////////
  // create the main widget here that is managed by KTMainWindow's view-region and
  // connect the widget to your document to display document contents.

  view = new KBaseView(this, null);
  doc.addView(view);
  setCentralWidget(view);	
  setCaption(doc.URL().fileName(),false);

}

    /** opens a file specified by commandline option
     */
public void openDocumentFile(KURL url)
{
  slotStatusMsg(tr("Opening file..."));

//   doc.openDocument( url);
   fileOpenRecent.addURL( url );
  slotStatusMsg(tr("Ready."));
}

public void openDocumentFile()
{
	openDocumentFile(new KURL(""));
	return;
}


    /** returns a pointer to the current document connected to the KTMainWindow instance and is used by
     * the View class to access the document object's methods
     */
public KBaseDoc getDocument()
{
  return doc;
}

    /** save general Options like all bar positions and status as well as the geometry and the recent file list to the configuration
     * file
     */
protected void saveOptions()
{
  config.setGroup("General Options");
  config.writeEntry("Geometry", size());
//  config.writeEntry("Show Toolbar", viewToolBar.isChecked());
  config.writeEntry("Show Statusbar",viewStatusBar.isChecked());
//  config.writeEntry("ToolBarPos", (int) toolBar("mainToolBar").barPos());
  fileOpenRecent.saveEntries(config,"Recent Files");
}


    /** read general Options again and initialize all variables like the recent file list
     */
protected void readOptions()
{
	
  config.setGroup("General Options");

  // bar status settings
//  boolean bViewToolbar = config.readBoolEntry("Show Toolbar", true);
//  viewToolBar.setChecked(bViewToolbar);
//  slotViewToolBar();

  boolean bViewStatusbar = config.readBoolEntry("Show Statusbar", true);
  viewStatusBar.setChecked(bViewStatusbar);
  slotViewStatusBar();


  // bar position settings
//  int toolBarPos;
  //Pos=(int) config.readNumEntry("ToolBarPos", KToolBar.Top);
//  toolBar("mainToolBar").setBarPos(toolBarPos);
	
  // initialize the recent file list
  fileOpenRecent.loadEntries(config,"Recent Files");

  QSize size=config.readSizeEntry("Geometry", null);
  if(!size.isEmpty())
  {
    resize(size);
  }
}

    /** saves the window properties for each open window during session end to the session config file, including saving the currently
     * opened file by a temporary filename provided by KApplication.
     * @see KTMainWindow#saveProperties
     */
protected void saveProperties(KConfig _cfg)
{
  if(doc.URL().fileName()!=tr("Untitled") && !doc.isModified())
  {
    // saving to tempfile not necessary

  }
  else
  {
    KURL url=doc.URL();	
    _cfg.writeEntry("filename", url.url());
    _cfg.writeEntry("modified", doc.isModified());
    String tempname = KApplication.kApplication().tempSaveName(url.url());
    String tempurl= KURL.encode_string(tempname, 0);
    KURL _url = new KURL(tempurl);
    doc.saveDocument(_url);
  }
}


    /** reads the session config file and restores the application's state including the last opened files and documents by reading the
     * temporary files saved by saveProperties()
     * @see KTMainWindow#readProperties
     */
protected void readProperties(KConfig _cfg)
{
  String filename = _cfg.readEntry("filename", "");
  KURL url = new KURL(filename);
  boolean modified = _cfg.readBoolEntry("modified", false);
  if(modified)
  {
    boolean canRecover = false;
    String tempname = KApplication.kApplication().checkRecoverFile(filename, canRecover);
    KURL _url = new KURL(tempname);
  	
    if(canRecover)
    {
      doc.openDocument(_url);
      doc.setModified();
      setCaption(_url.fileName(),true);
      QFile.remove(tempname);
    }
  }
  else
  {
    if(filename.length() > 0)
    {
      doc.openDocument(url);
      setCaption(url.fileName(),false);
    }
  }
}		

    /** queryClose is called by KTMainWindow on each closeEvent of a window. Against the
     * default implementation (only returns true), this calles saveModified() on the document object to ask if the document shall
     * be saved if Modified; on cancel the closeEvent is rejected.
     * @see KTMainWindow#queryClose
     * @see KTMainWindow#closeEvent
     */
protected boolean queryClose()
{
  return doc.saveModified();
}

    /** queryExit is called by KTMainWindow when the last window of the application is going to be closed during the closeEvent().
     * Against the default implementation that just returns true, this calls saveOptions() to save the settings of the last window's
     * properties.
     * @see KTMainWindow#queryExit
     * @see KTMainWindow#closeEvent
     */
protected boolean queryExit()
{
  saveOptions();
  return true;
}

/////////////////////////////////////////////////////////////////////
// SLOT IMPLEMENTATION
/////////////////////////////////////////////////////////////////////

    /** open a new application window by creating a new instance of KBase */
public void slotFileNewWindow()
{
  slotStatusMsg(tr("Opening a new application window..."));
	
  KBase new_window= new KBase();
  new_window.show();

  slotStatusMsg(tr("Ready."));
}

    /** clears the document in the actual view to reuse it as the new document */
public void slotFileNew()
{
  slotStatusMsg(tr("Creating new document..."));

  if(!doc.saveModified())
  {
     // here saving wasn't successful

  }
  else
  {	
    doc.newDocument();		
    setCaption(doc.URL().fileName(), false);
  }

  slotStatusMsg(tr("Ready."));
}

    /** open a file and load it into the document*/
public void slotFileOpen()
{
System.out.println("ENTER slotFileOpen()");
  slotStatusMsg(tr("Opening file..."));
	
  if(!doc.saveModified())
  {
     // here saving wasn't successful

  }
  else
  {	
    KURL url=KFileDialog.getOpenURL("",
        tr("*|All files"), this, tr("Open File..."));
    if(!url.isEmpty())
    {
      doc.openDocument(url);
      setCaption(url.fileName(), false);
      fileOpenRecent.addURL( url );
    }
  }
  slotStatusMsg(tr("Ready."));
}

    /** opens a file from the recent files menu */
public void slotFileOpenRecent(KURL url)
{
  slotStatusMsg(tr("Opening file..."));
	
  if(!doc.saveModified())
  {
     // here saving wasn't successful
  }
  else
  {
    doc.openDocument(url);
    setCaption(url.fileName(), false);
  }

  slotStatusMsg(tr("Ready."));
}

    /** save a document */
public void slotFileSave()
{
  slotStatusMsg(tr("Saving file..."));
	
  doc.saveDocument(doc.URL());

  slotStatusMsg(tr("Ready."));
}

   /** save a document by a new filename*/
public void slotFileSaveAs()
{
  slotStatusMsg(tr("Saving file with a new filename..."));

  KURL url=KFileDialog.getSaveURL(QDir.currentDirPath(),
        tr("*|All files"), this, tr("Save as..."));
  if(!url.isEmpty())
  {
    doc.saveDocument(url);
    fileOpenRecent.addURL(url);
    setCaption(url.fileName(),doc.isModified());
  }

  slotStatusMsg(tr("Ready."));
}

    /** asks for saving if the file is modified, then closes the actual file and window*/
public void slotFileClose()
{
  slotStatusMsg(tr("Closing file..."));
	
  close();

  slotStatusMsg(tr("Ready."));
}

    /** print the actual file */
public void slotFilePrint()
{
  slotStatusMsg(tr("Printing..."));

  QPrinter printer = new QPrinter();
  if (printer.setup(this))
  {
    view.print(printer);
  }

  slotStatusMsg(tr("Ready."));
}

    /** closes all open windows by calling close() on each memberList item until the list is empty, then quits the application.
     * If queryClose() returns false because the user canceled the saveModified() dialog, the closing breaks.
     */
public void slotFileQuit()
{
  slotStatusMsg(tr("Exiting..."));
  saveOptions();
  // close the first window, the list makes the next one the first again.
  // This ensures that queryClose() is called on each window to ask for closing
  KMainWindow w;
  Iterator it = memberList().iterator();
  while(it.hasNext())
  {
    w=(KMainWindow)it.next();
    // only close the window if the closeEvent is accepted. If the user presses Cancel on the saveModified() dialog,
    // the window and the application stay open.
    if(!w.close())
	  break;
  }

  slotStatusMsg(tr("Ready."));
}

    /** put the marked text/object into the clipboard and remove
     *	it from the document
     */
public void slotEditCut()
{
  slotStatusMsg(tr("Cutting selection..."));

  slotStatusMsg(tr("Ready."));
}

    /** put the marked text/object into the clipboard
     */
public void slotEditCopy()
{
  slotStatusMsg(tr("Copying selection to clipboard..."));

  slotStatusMsg(tr("Ready."));
}

    /** paste the clipboard into the document
     */
public void slotEditPaste()
{
  slotStatusMsg(tr("Inserting clipboard contents..."));

  slotStatusMsg(tr("Ready."));
}

    /** toggles the toolbar
     */
public void slotViewToolBar()
{
  slotStatusMsg(tr("Toggling toolbar..."));
  ///////////////////////////////////////////////////////////////////
  // turn Toolbar on or off
//  if(!viewToolBar.isChecked())
//  {
//    toolBar("mainToolBar").hide();
//  }
//  else
//  {
//    toolBar("mainToolBar").show();
//  }		

  slotStatusMsg(tr("Ready."));
}

    /** toggles the statusbar
     */
public void slotViewStatusBar()
{
  slotStatusMsg(tr("Toggle the statusbar..."));
  ///////////////////////////////////////////////////////////////////
  //turn Statusbar on or off
  if(!viewStatusBar.isChecked())
  {
    ((KStatusBar) statusBar()).hide();
  }
  else
  {
    ((KStatusBar) statusBar()).show();
  }

  slotStatusMsg(tr("Ready."));
}


    /** changes the statusbar contents for the standard label permanently, used to indicate current actions.
     * @param text the text that is displayed in the statusbar
     */
public void slotStatusMsg(String text)
{
  ///////////////////////////////////////////////////////////////////
  // change status message permanently
  ((KStatusBar) statusBar()).clear();
  ((KStatusBar) statusBar()).changeItem(text, ID_STATUS_MSG);
}

static String description =
	"JavaApiTest";
// INSERT A DESCRIPTION FOR YOUR APPLICATION HERE


static String[][] options =
{
  { "+[File]", "file to open", null }
  // INSERT YOUR COMMANDLINE OPTIONS HERE
};

static String VERSION = "0.1";

public static void main(String[] cmdLineArgs)
{

	KAboutData aboutData = new KAboutData( "kbase", "JavaApiTest",
		VERSION, description, KAboutData.License_GPL,
		"(c) 2001, Richard Dale");
	aboutData.addAuthor("Richard Dale",null, "Lost_Highway@tipitina.demon.co.uk");
	KCmdLineArgs.init( cmdLineArgs, aboutData );
	KCmdLineArgs.addCmdLineOptions( options ); // Add our own options.

  KApplication app = new KApplication();

  if (app.isRestored())
  {
    RESTORE("KBase");
  }
  else
  {
    KBase kbase = new KBase();
    kbase.show();
    KCmdLineArgs args = KCmdLineArgs.parsedArgs();

		if (args.count() > 0)
		{
        kbase.openDocumentFile(new KURL(args.arg(0)));
		}
		else
		{
		  kbase.openDocumentFile();
		}
		args.clear();
  }

  app.exec();
  return;
}

	static {
                qtjava.initialize();
                kdejava.initialize();
	}

}
