//Auto-generated by kalyptus. DO NOT EDIT.
package org.kde.koala;

import org.kde.qt.Qt;
import org.kde.qt.QMetaObject;
import org.kde.qt.QtSupport;
import org.kde.qt.QPoint;
import java.util.ArrayList;
import org.kde.qt.QDropEvent;
import org.kde.qt.QWidget;
import org.kde.qt.QResizeEvent;
import org.kde.qt.QWidget;

/**

 This widget works as a network transparent filebrowser. You specify a URL
 to display and this url will be loaded via KDirLister. The user can
 browse through directories, highlight and select files, delete or rename
 files.
 It supports different views, e.g. a detailed view (see KFileDetailView),
 a simple icon view (see KFileIconView), a combination of two views,
 separating directories and files ( KCombiView).
 Additionally, a preview view is available (see KFilePreview), which can
 show either a simple or detailed view and additionally a preview widget
 (see setPreviewWidget()). KImageFilePreview is one implementation
 of a preview widget, that displays previews for all supported filetypes
 utilizing KIO.PreviewJob.
 Currently, those classes don't support Drag&Drop out of the box -- there
 you have to use your own view-classes. You can use some DnD-aware views
 from Bjrn Sahlstrm <bjorn@kbear.org> until they will be integrated
 into this library. See http://devel-home.kde.org/~pfeiffer/DnD-classes.tar.gz
 This widget is the one used in the KFileDialog.
 Basic usage is like this:
 <pre>
   KDirOperator op = new KDirOperator( KURL( "file:/home/gis" ), this );
   // some signals you might be interested in
   connect(op, SIGNAL("urlEntered(KURL)"),
           SLOT("urlEntered(KURL)"));
   connect(op, SIGNAL("fileHighlighted(const KFileItem )"),
           SLOT("fileHighlighted(const KFileItem )"));
   connect(op, SIGNAL("fileSelected(const KFileItem )"),
           SLOT("fileSelected(const KFileItem )"));
   connect(op, SIGNAL("finishedLoading()"),
           SLOT("slotLoadingFinished()"));
   op.readConfig( KGlobal.config(), "Your KDiroperator ConfigGroup" );
   op.setView(KFile.Default);
 </pre>
 This will create a childwidget of 'this' showing the directory contents
 of /home/gis in the default-view. The view is determined by the readConfig()
 call, which will read the KDirOperator settings, the user left your program
 with (and which you saved with op.writeConfig()).
 See {@link KDirOperatorSignals} for signals emitted by KDirOperator
		@author Stephan Kulow <coolo@kde.org>, Carsten Pfeiffer <pfeiffer@kde.org>
 
		@short A widget for displaying files and browsing directories.

*/
public class KDirOperator extends QWidget  {
	protected KDirOperator(Class dummy){super((Class) null);}
	/**	
		 The various action types. These values can be or'd together
				@short    The various action types.
	*/
	public static final int SortActions = 1;
	public static final int ViewActions = 2;
	public static final int NavActions = 4;
	public static final int FileActions = 8;
	public static final int AllActions = 15;

	public native QMetaObject metaObject();
	public native String className();
	/**	
		 Constructs the KDirOperator with no initial view. As the views are
		 configurable, call readConfig() to load the user's configuration
		 and then setView to explicitly set a view.
			 This constructor doesn't start loading the url, setView will do it.
		     		@short    Constructs the KDirOperator with no initial view.
	*/
	public KDirOperator(KURL urlName, QWidget parent, String name) {
		super((Class) null);
		newKDirOperator(urlName,parent,name);
	}
	private native void newKDirOperator(KURL urlName, QWidget parent, String name);
	public KDirOperator(KURL urlName, QWidget parent) {
		super((Class) null);
		newKDirOperator(urlName,parent);
	}
	private native void newKDirOperator(KURL urlName, QWidget parent);
	public KDirOperator(KURL urlName) {
		super((Class) null);
		newKDirOperator(urlName);
	}
	private native void newKDirOperator(KURL urlName);
	public KDirOperator() {
		super((Class) null);
		newKDirOperator();
	}
	private native void newKDirOperator();
	/**	
		 Enables/disables showing hidden files.
		     		@short    Enables/disables showing hidden files.
	*/
	public native void setShowHiddenFiles(boolean s);
	/**	
				@return true when hidden files are shown or false otherwise.
     
		@short
	*/
	public native boolean showHiddenFiles();
	/**	
		 Stops loading immediately. You don't need to call this, usually.
		     		@short    Stops loading immediately.
	*/
	public native void closeLoading();
	/**	
		 Sets a filter like "*.cpp .h .o". Only files matching that filter
		 will be shown. Call updateDir() to apply it.
				@short    Sets a filter like " .
		@see KDirLister#setNameFilter
		@see #nameFilter
	*/
	public native void setNameFilter(String filter);
	/**	
				@return the current namefilter.

		@short   
		@see #setNameFilter
	*/
	public native String nameFilter();
	/**	
		 Sets a list of mimetypes as filter. Only files of those mimetypes
		 will be shown.
			 Example:
		 <pre>
		 ArrayList filter;
		 filter << "text/html" << "image/png" << "inode/directory";
		 dirOperator.setMimefilter( filter );
		 </pre>
			 Node: Without the mimetype inode/directory, only files would be shown.
		 Call updateDir() to apply it.
				@short    Sets a list of mimetypes as filter.
		@see KDirLister#setMimeFilter
		@see #mimeFilter
	*/
	public native void setMimeFilter(String[] mimetypes);
	/**	
				@return the current mime filter.
     
		@short
	*/
	public native ArrayList mimeFilter();
	/**	
		 Clears both the namefilter and mimetype filter, so that all files and
		 directories will be shown. Call updateDir() to apply it.
				@short    Clears both the namefilter and mimetype filter, so that all files and  directories will be shown.
		@see #setMimeFilter
		@see #setNameFilter
	*/
	public native void clearFilter();
	/**	
				@return the current url
     
		@short
	*/
	public native KURL url();
	/**	
		 Sets a new url to list.
			@param clearforward specifies whether the "forward" history should be cleared.
			@param url the URL to set
		     		@short    Sets a new url to list.
	*/
	public native void setURL(KURL url, boolean clearforward);
	/**	
		 Clears the current selection and attempts to set <code>filename</code>
		 the current file. filename is just the name, no path or url.
		     		@short    Clears the current selection and attempts to set <code>filename</code>  the current file.
	*/
	public native void setCurrentItem(String filename);
	/**	
		 Sets a new KFileView to be used for showing and browsing files.
		 Note: this will read the current url() to fill the view.
				@short    Sets a new KFileView to be used for showing and browsing files.
		@see KFileView
		@see KFileIconView
		@see KFileDetailView
		@see KFileCombiView
		@see #view
	*/
	public native void setView(KFileViewInterface view);
	/**	
				@return the currently used view.

		@short   
		@see #setView
	*/
	public native KFileViewInterface view();
	/**	
		 Returns the widget of the current view. null if there is no view/widget.
		 (KFileView itself is not a widget.)
		     		@short    Returns the widget of the current view.
	*/
	public native QWidget viewWidget();
	/**	
		 Sets one of the predefined fileviews
				@short    Sets one of the predefined fileviews 
		@see KFile#FileView
	*/
	public native void setView(int view);
	/**	
		 Sets the way to sort files and directories.
		     		@short    Sets the way to sort files and directories.
	*/
	public native void setSorting(int arg1);
	/**	
				@return the current way of sorting files and directories
     
		@short
	*/
	public native int sorting();
	/**	
				@return true if we are displaying the root directory of the current url
     
		@short
	*/
	public native boolean isRoot();
	/**	
				@return the object listing the directory
     
		@short
	*/
	public native KDirLister dirLister();
	/**	
				@return the progress widget, that is shown during directory listing.
 You can for example reparent() it to put it into a statusbar.
     
		@short
	*/
	public native KProgress progressBar();
	/**	
		 Sets the listing/selection mode for the views, an OR'ed combination of
		
			<li>
			File
			</li>
			
			<li>
			Directory
			</li>
			
			<li>
			Files
			</li>
			
			<li>
			ExistingOnly
			</li>
			
			<li>
			LocalOnly
			</li>
				 You cannot mix File and Files of course, as the former means
		 single-selection mode, the latter multi-selection.
		     		@short    Sets the listing/selection mode for the views, an OR'ed combination of
	*/
	public native void setMode(int m);
	/**	
				@return the listing/selection mode.
     
		@short
	*/
	public native int mode();
	/**	
		 Sets a preview-widget to be shown next to the file-view.
		 The ownership of <code>w</code> is transferred to KDirOperator, so don't
		 delete it yourself!
		     		@short    Sets a preview-widget to be shown next to the file-view.
	*/
	public native void setPreviewWidget(QWidget w);
	/**	
				@return a list of all currently selected items. If there is no view,
 then 0L is returned.
     
		@short
	*/
	public native ArrayList selectedItems();
	/**	
				@return true if <code>item</code> is currently selected, or false otherwise.
     
		@short
	*/
	public native boolean isSelected(KFileItem item);
	/**	
				@return the number of directories in the currently listed url.
 Returns 0 if there is no view.
     
		@short
	*/
	public native int numDirs();
	/**	
				@return the number of files in the currently listed url.
 Returns 0 if there is no view.
     
		@short
	*/
	public native int numFiles();
	/**	
				@return a KCompletion object, containing all filenames and
 directories of the current directory/URL.
 You can use it to insert it into a KLineEdit or KComboBox
 Note: it will only contain files, after prepareCompletionObjects()
 has been called. It will be implicitly called from makeCompletion()
 or makeDirCompletion()
     
		@short
	*/
	public native KCompletion completionObject();
	/**	
				@return a KCompletion object, containing only all directories of the
 current directory/URL.
 You can use it to insert it into a KLineEdit or KComboBox
 Note: it will only contain directories, after
 prepareCompletionObjects() has been called. It will be implicitly
 called from makeCompletion() or makeDirCompletion()
     
		@short
	*/
	public native KCompletion dirCompletionObject();
	/**	
		 an accessor to a collection of all available Actions. The actions
		 are static, they will be there all the time (no need to connect to
		 the signals KActionCollection.inserted() or removed().
			 There are the following actions:
		
			<li>
			popupMenu : an ActionMenu presenting a popupmenu with all actions
			</li>
			
			<li>
			up : changes to the parent directory
			</li>
			
			<li>
			back : goes back to the previous directory
			</li>
			
			<li>
			forward : goes forward in the history
			</li>
			
			<li>
			home : changes to the user's home directory
			</li>
			
			<li>
			reload : reloads the current directory
			</li>
			
			<li>
			separator : a separator
			</li>
			
			<li>
			mkdir : opens a dialog box to create a directory
			</li>
			
			<li>
			delete : deletes the selected files/directories
			</li>
			
			<li>
			sorting menu : an ActionMenu containing all sort-options
			</li>
			
			<li>
			by name : sorts by name
			</li>
			
			<li>
			by date : sorts by date
			</li>
			
			<li>
			by size : sorts by size
			</li>
			
			<li>
			reversed : reverses the sort order
			</li>
			
			<li>
			dirs first : sorts directories before files
			</li>
			
			<li>
			case insensitive : sorts case insensitively
			</li>
			
			<li>
			view menu : an ActionMenu containing all actions concerning the view
			</li>
			
			<li>
			short view : shows a simple fileview
			</li>
			
			<li>
			detailed view : shows a detailed fileview (dates, permissions ,...)
			</li>
			
			<li>
			show hidden : shows hidden files
			</li>
			
			<li>
			separate dirs : shows directories in a separate pane
			</li>
			
			<li>
			preview  : shows a preview next to the fileview
			</li>
			
			<li>
			single : hides the separate view for directories or the preview
			</li>
			
			<li>
			properties : shows a KPropertiesDialog for the selected files
			</li>
				 The short and detailed view are in an exclusive group. The sort-by
		 actions are in an exclusive group as well. Also the "separate dirs",
		 "preview" and "single" actions are in an exclusive group.
			 You can e.g. use
		 <pre>
		 actionCollection().action( "up" ).plug( someToolBar );
		 </pre>
		 to add a button into a toolbar, which makes the dirOperator change to
		 its parent directory.
				@return all available Actions
     
		@short    an accessor to a collection of all available Actions.
	*/
	public native KActionCollection actionCollection();
	/**	
		 Sets the config object and the to be used group in KDirOperator. This
		 will be used to store the view's configuration via
		 KFileView.writeConfig() (and for KFileView.readConfig()).
		 If you don't set this, the views cannot save and restore their
		 configuration.
			 Usually you call this right after KDirOperator creation so that the view
		 instantiation can make use of it already.
			 Note that KDirOperator does NOT take ownership of that object (typically
		 it's KGlobal.config() anyway.
				@short    Sets the config object and the to be used group in KDirOperator.
		@see #viewConfig
		@see #viewConfigGroup
	*/
	public native void setViewConfig(KConfig config, String group);
	/**	
		 Returns the KConfig object used for saving and restoring view's
		 configuration.
				@return the KConfig object used for saving and restoring view's
 configuration.

		@short    Returns the KConfig object used for saving and restoring view's  configuration.
	*/
	public native KConfig viewConfig();
	/**	
		 Returns the group name used for saving and restoring view's
		 configuration.
				@return the group name used for saving and restoring view's
 configuration.

		@short    Returns the group name used for saving and restoring view's  configuration.
	*/
	public native String viewConfigGroup();
	/**	
		 Reads the default settings for a view, i.e. the default KFile.FileView.
		 Also reads the sorting and whether hidden files should be shown.
		 Note: the default view will not be set - you have to call
		 <pre>
		 setView( KFile.Default )
		 </pre>
		 to apply it.
				@short    Reads the default settings for a view, i.
		@see #setView
		@see #setViewConfig
		@see #writeConfig
	*/
	public native void readConfig(KConfig arg1, String group);
	public native void readConfig(KConfig arg1);
	/**	
		 Saves the current settings like sorting, simple or detailed view.
				@short    Saves the current settings like sorting, simple or detailed view.
		@see #readConfig
		@see #setViewConfig
	*/
	public native void writeConfig(KConfig arg1, String group);
	public native void writeConfig(KConfig arg1);
	/**	
		 This is a KFileDialog specific hack: we want to select directories with
		 single click, but not files. But as a generic class, we have to be able
		 to select files on single click as well.
			 This gives us the opportunity to do both.
			 The default is false, set it to true if you don't want files selected
		 with single click.
		     		@short    This is a KFileDialog specific hack: we want to select directories with  single click, but not files.
	*/
	public native void setOnlyDoubleClickSelectsFiles(boolean enable);
	/**	
				@return whether files (not directories) should only be select()ed by
 double-clicks.

		@short   
		@see #setOnlyDoubleClickSelectsFiles
	*/
	public native boolean onlyDoubleClickSelectsFiles();
	/**	
		 Creates the given directory/url. If it is a relative path,
		 it will be completed with the current directory.
		 If enterDirectory is true, the directory will be entered after a
		 successful operation. If unsuccessful, a messagebox will be presented
		 to the user.
				@return true if the directory could be created.
     
		@short    Creates the given directory/url.
	*/
	public native boolean mkdir(String directory, boolean enterDirectory);
	public native boolean mkdir(String directory);
	/**	
		 Starts and returns a KIO.DeleteJob to delete the given <code>items.</code>
			@param items the list of items to be deleted
			@param ask specifies whether a confirmation dialog should be shown
			@param showProgress passed to the DeleteJob to show a progress dialog
		     		@short    Starts and returns a KIO.DeleteJob to delete the given <code>items.</code>
	*/
	public native DeleteJob del(ArrayList items, boolean ask, boolean showProgress);
	public native DeleteJob del(ArrayList items, boolean ask);
	public native DeleteJob del(ArrayList items);
	/**	
		 Starts and returns a KIO.DeleteJob to delete the given <code>items.</code>
			@param parent the parent widget used for the confirmation dialog
			@param ask specifies whether a confirmation dialog should be shown
			@param showProgress passed to the DeleteJob to show a progress dialog
				@short    Starts and returns a KIO.DeleteJob to delete the given <code>items.</code>
	*/
	public native DeleteJob del(ArrayList items, QWidget parent, boolean ask, boolean showProgress);
	public native DeleteJob del(ArrayList items, QWidget parent, boolean ask);
	public native DeleteJob del(ArrayList items, QWidget parent);
	/**	
		 Clears the forward and backward history.
		     		@short    Clears the forward and backward history.
	*/
	public native void clearHistory();
	/**	
		 When going up in the directory hierarchy, KDirOperator can highlight
		 the directory that was just left.
			 I.e. when you go from /home/gis/src to /home/gis, the item "src" will
		 be made the current item.
			 Default is off.
		     		@short    When going up in the directory hierarchy, KDirOperator can highlight  the directory that was just left.
	*/
	public native void setEnableDirHighlighting(boolean enable);
	/**	
			 Default is false.
		     		@return whether the last directory will be made the current item
 when going up in the directory hierarchy.

		@short
	*/
	public native boolean dirHighlighting();
	/**	
				@return true if we are in directory-only mode, that is, no files are
 shown.
     
		@short
	*/
	public native boolean dirOnlyMode();
	/**	
		 Sets up the action menu.
			@param whichActions is an value of OR'd ActionTypes that controls which actions to show in the action menu
		     		@short    Sets up the action menu.
	*/
	public native void setupMenu(int whichActions);
	/**	
		 Reimplemented - allow dropping of files if <code>b</code> is true
			@param b true if the widget should allow dropping of files
		     		@short    Reimplemented - allow dropping of files if <code>b</code> is true
	*/
	public native void setAcceptDrops(boolean b);
	/**	
		 Sets the options for dropping files.
				@short    Sets the options for dropping files.
		@see KFileView#DropOptions
	*/
	public native void setDropOptions(int options);
	/**	
		 Goes one step back in the history and opens that url.
		     		@short    Goes one step back in the history and opens that url.
	*/
	public native void back();
	/**	
		 Goes one step forward in the history and opens that url.
		     		@short    Goes one step forward in the history and opens that url.
	*/
	public native void forward();
	/**	
		 Enters the home directory.
		     		@short    Enters the home directory.
	*/
	public native void home();
	/**	
		 Goes one directory up from the current url.
		     		@short    Goes one directory up from the current url.
	*/
	public native void cdUp();
	/**	
		 to update the view after changing the settings
		     		@short    to update the view after changing the settings
	*/
	public native void updateDir();
	/**	
		 Re-reads the current url.
		     		@short    Re-reads the current url.
	*/
	public native void rereadDir();
	/**	
		 Opens a dialog to create a new directory.
		     		@short    Opens a dialog to create a new directory.
	*/
	public native void mkdir();
	/**	
		 Deletes the currently selected files/directories.
		     		@short    Deletes the currently selected files/directories.
	*/
	public native void deleteSelected();
	/**	
		 Enables/disables actions that are selection dependent. Call this e.g.
		 when you are about to show a popup menu using some of KDirOperators
		 actions.
		     		@short    Enables/disables actions that are selection dependent.
	*/
	public native void updateSelectionDependentActions();
	/**	
		 Tries to complete the given string (only completes files).
		     		@short    Tries to complete the given string (only completes files).
	*/
	public native String makeCompletion(String arg1);
	/**	
		 Tries to complete the given string (only completes directores).
		     		@short    Tries to complete the given string (only completes directores).
	*/
	public native String makeDirCompletion(String arg1);
	public static native boolean dirOnlyMode(int mode);
	/**	
		 A view factory for creating predefined fileviews. Called internally by setView
		 , but you can also call it directly. Reimplement this if you depend on self defined fileviews.
			@param parent is the QWidget to be set as parent
			@param view is the predefined view to be set, note: this can be several ones OR:ed together.
				@return the created KFileView

		@short    A view factory for creating predefined fileviews.
		@see KFileView
		@see KCombiView
		@see KFileDetailView
		@see KFileIconView
		@see KFilePreview
		@see KFile#FileView
		@see #setView
	*/
	protected native KFileViewInterface createView(QWidget parent, int view);
	/**	
		 Sets a custom KDirLister to list directories.
		     		@short    Sets a custom KDirLister to list directories.
	*/
	protected native void setDirLister(KDirLister lister);
	protected native void resizeEvent(QResizeEvent arg1);
	/**	
		 Sets up all the actions. Called from the constructor, you usually
		 better not call this.
		     		@short    Sets up all the actions.
	*/
	protected native void setupActions();
	/**	
		 Updates the sorting-related actions to comply with the current sorting
				@short    Updates the sorting-related actions to comply with the current sorting 
		@see #sorting
	*/
	protected native void updateSortActions();
	/**	
		 Updates the view-related actions to comply with the current
		 KFile.FileView
		     		@short    Updates the view-related actions to comply with the current  KFile.FileView
	*/
	protected native void updateViewActions();
	/**	
		 Sets up the context-menu with all the necessary actions. Called from the
		 constructor, you usually don't need to call this.
				@short    Sets up the context-menu with all the necessary actions.
	*/
	protected native void setupMenu();
	/**	
		 Synchronizes the completion objects with the entries of the
		 currently listed url.
			 Automatically called from makeCompletion() and
		 makeDirCompletion()
		     		@short    Synchronizes the completion objects with the entries of the  currently listed url.
	*/
	protected native void prepareCompletionObjects();
	/**	
		 Checks if there support from KIO.PreviewJob for the currently
		 shown files, taking mimeFilter() and nameFilter() into account
		 Enables/disables the preview-action accordingly.
		     		@short    Checks if there support from KIO.PreviewJob for the currently  shown files, taking mimeFilter() and nameFilter() into account  Enables/disables the preview-action accordingly.
	*/
	protected native boolean checkPreviewSupport();
	/**	
		 Restores the normal cursor after showing the busy-cursor. Also hides
		 the progressbar.
		     		@short    Restores the normal cursor after showing the busy-cursor.
	*/
	protected native void resetCursor();
	/**	
		 Called after setURL() to load the directory, update the history,
		 etc.
		     		@short    Called after setURL() to load the directory, update the history,  etc.
	*/
	protected native void pathChanged();
	/**	
		 Adds a new list of KFileItems to the view
		 (coming from KDirLister)
		     		@short    Adds a new list of KFileItems to the view  (coming from KDirLister)
	*/
	protected native void insertNewFiles(ArrayList newone);
	/**	
		 Removes the given KFileItem item from the view (usually called from
		 KDirLister).
		     		@short    Removes the given KFileItem item from the view (usually called from  KDirLister).
	*/
	protected native void itemDeleted(KFileItem arg1);
	/**	
		 Enters the directory specified by the given <code>item.</code>
		     		@short    Enters the directory specified by the given <code>item.</code>
	*/
	protected native void selectDir(KFileItem item);
	/**	
		 Emits fileSelected( item )
		     		@short    Emits fileSelected( item )
	*/
	protected native void selectFile(KFileItem item);
	/**	
		 Emits fileHighlighted( i )
		     		@short    Emits fileHighlighted( i )
	*/
	protected native void highlightFile(KFileItem i);
	/**	
		 Called upon right-click to activate the popupmenu.
		     		@short    Called upon right-click to activate the popupmenu.
	*/
	protected native void activatedMenu(KFileItem arg1, QPoint pos);
	/**	
		 Changes sorting to sort by name
		     		@short    Changes sorting to sort by name
	*/
	protected native void sortByName();
	/**	
		 Changes sorting to sort by size
		     		@short    Changes sorting to sort by size
	*/
	protected native void sortBySize();
	/**	
		 Changes sorting to sort by date
		     		@short    Changes sorting to sort by date
	*/
	protected native void sortByDate();
	/**	
		 Changes sorting to reverse sorting
		     		@short    Changes sorting to reverse sorting
	*/
	protected native void sortReversed();
	/**	
		 Toggles showing directories first / having them sorted like files.
		     		@short    Toggles showing directories first / having them sorted like files.
	*/
	protected native void toggleDirsFirst();
	/**	
		 Toggles case sensitive / case insensitive sorting
		     		@short    Toggles case sensitive / case insensitive sorting
	*/
	protected native void toggleIgnoreCase();
	/**	
		 Tries to make the given <code>match</code> as current item in the view and emits
		 completion( match )
		     		@short    Tries to make the given <code>match</code> as current item in the view and emits  completion( match )
	*/
	protected native void slotCompletionMatch(String match);
	/** Deletes the wrapped C++ instance */
	protected native void finalize() throws InternalError;
	/** Delete the wrapped C++ instance ahead of finalize() */
	public native void dispose();
	/** Has the wrapped C++ instance been deleted? */
	public native boolean isDisposed();
}
