/* Copyright (C) 2002 Mickael Marchand <marchand@kde.org> -*-c++-*-

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public
License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.
*/


#ifndef VIMVIEW_H
#define VIMVIEW_H

#include <kparts/part.h>
#include <ktexteditor/document.h>
#include <ktexteditor/view.h>
#include <ktexteditor/viewcursorinterface.h>
#include <ktexteditor/clipboardinterface.h>
#include <ktexteditor/dynwordwrapinterface.h>
#include <vimwidget.h>
#include <kdebug.h>

class VimWidget;

namespace Vim {

  class Document;

  class View : public KTextEditor::View,
	       public KTextEditor::ViewCursorInterface,
	       public KTextEditor::ClipboardInterface,
				 public KTextEditor::DynWordWrapInterface
  {
    Q_OBJECT
			
  public:
    View( Document *, QWidget *, const char * = 0);
    virtual ~View();
	
    KTextEditor::Document *document() const;
    VimWidget *vwidget() { return _vimWidget; }
	
  protected:	

		void focusInEvent( QFocusEvent *e ) { kdDebug(90000) << "View : FocusIN" <<endl;
		_vimWidget->setFocus(); }

		void focusOutEvent( QFocusEvent *e ) { kdDebug(90000)<< "View : FocusOUT" << endl;
		_vimWidget->setFocus(); }

    void vimRealised();			
//		void keyPressEvent(QKeyEvent *e);
//		void mousePressEvent(QMouseEvent *e);

  public slots:
    QPoint cursorCoordinates();
    void cursorPosition(uint *line, uint *col);
    void cursorPositionReal (uint *line, uint *col);
    bool setCursorPosition (uint line, uint col);
    bool setCursorPositionReal (uint line, uint col);
		void emitCursorPositionChanged();

    uint cursorLine ();
    uint cursorColumn();
    uint cursorColumnReal();

		void save();
		void undo();
		void redo();
		void saveAs();
		void gotoLine();
		void selectAll();
		void find();
		void close();
		
	signals:
    void cursorPositionChanged(); // won't be easy ...

  private:
		void setupActions();
		
    Document *m_doc;
    VimWidget *_vimWidget;
    int ready;	//0 no, 1 yes, 2 problem occurred

		// -- ClipboardInterface
  public slots:
    void copy ( ) const;
    void cut ( );
    void paste ( );

		// -- DynWordWrapInterface
	public slots:
    void setDynWordWrap (bool);
    bool dynWordWrap () const;		
			
  };

}

#endif // VIMVIEW_H
