//
//      loadsave.hpp - Map IO for starting the game, saving and loading
//

#define MAX_SAVES 1000 // This many savegame slots

// Functions

extern void LoadMap(int mapno);
extern void load_map(int mapno);
extern void save_map(int mapno);
extern void erase_curmap();

extern void load_z1(char *filename);
extern void save_z1(char *filename);
extern void load_z1A(char *filename);
extern void save_z1A(char *filename);
extern void wipe_z1();

extern void load_z2(int mapno);
extern void save_z2(int mapno);

extern void load_z3(int mapno);
extern void save_z3(int mapno);

extern void load_ms(char *filename);
extern void save_ms(char *filename);

extern void load_lightstate(int mapno, int sgnum);
extern void save_lightstate(int mapno, int sgnum);

extern void write_sgheader(int sgnum, int world, char *title);
extern char *read_sgheader(int sgnum, int *world);

extern void save_objects();
extern void restore_objects();

extern int GetLoadSaveSlot(int saving); // Menu
extern int GetTextBox(char *text, char *prompt);

// Are we storing every tiny detail (savegame) or just the layout?
extern "C" int MZ1_SavingGame;

