#This is a minimalistic module which doesn't really do anything other than the minimum requirements.

# Modules are loaded in the order they are listed in your profile.
# Modules are saved in the order they are loaded.
# If you unload a module mid run and then save, that module will nolonger be loaded automatically.

# use /eval self.loadModule("modname") to load a module
# and /eval self.unloadModule("modname") to unload a module  -- until I add real commands
import sys
import traceback



# You MUST name your module the same name as the file its in, minus the extension.
class conferencecolorsmodule:
  def __init__(self, confignode):
    self.oldColor = None
    self.myColor = "red"
    self.othersColor = "purple"
    if confignode != None:
      for child in confignode.childNodes:
        if child.nodeType == child.ELEMENT_NODE:
          self.myColor = child.getAttribute("mycolor")
          self.othersColor = child.getAttribute("otherscolor")


  # You MUST implement a registerCallbacks(self, cli) function.
  # cli is a reference to an CLI object.
  # The purpose of this call is to register your callbacks.
  # Make a bunch of calls to cli.registerCallback
  def registerCallbacks(self, cli):
    if not self.myColor in cli.prefs.colors.cdict:
      self.myColor = "red"
    if not self.othersColor in cli.prefs.colors.cdict:
      self.othersColor = "purple"

    self.myColorValue = cli.prefs.colors.cdict[self.myColor]
    self.othersColorValue = cli.prefs.colors.cdict[self.othersColor]

    cli.registerCallback("handleConferenceMessage", cli.PRE,  self.myHandleConferenceMessagePRE)
    cli.registerCallback("handleConferenceMessage", cli.POST, self.myHandleConferenceMessagePOST)


  # You MUST implement an unRegisterCallbacks(self, cli) function.
  # cli is a reference to an CLI object.
  # The purpose of this call is to unregister your callbacks.
  # Make a bunch of calls to cli.unRegisterCallback
  def unRegisterCallbacks(self, cli):
    cli.unRegisterCallback("handleConferenceMessage", cli.PRE,  self.myHandleConferenceMessagePRE)
    cli.unRegisterCallback("handleConferenceMessage", cli.POST, self.myHandleConferenceMessagePOST)

  # You MUST implement a getName() function which returns a string containing the name of this module.
  def getName(self):
    return "conferencecolorsmodule"

  # You MUST implement a printShortDescription()  it gets called when the module is loaded to print out version/short description/whatever
  def printShortDescription(self):
    print "Conference Colors module loaded"

  # You MUST implement a getConfigurationString(self, prependString) function.
  # it returns None if there is no configuration
  # it returns a string containing the XML for your configuration. ESCAPE IT PROPERLY!
  # the return string MUST end with a newline
  # each line in the return string MUST be prepended by the prependString, this is for proper spacing in the config file.
  def getConfigurationString(self, prependString):
    retval = prependString + "<colors mycolor='" + self.myColor + "' otherscolor='" + self.othersColor + "'/>\n"
    return retval


  def configureModuleCLI(self, cli):
    print("\nNow configuring the Conference Colors Module\n")
    validcolors = ["darkgray", "brightred", "brightgreen", "yellow",
                   "brightblue", "purple", "brightcyan", "white",
                   "black", "red", "green", "brown", "blue", "magenta",
                   "cyan", "lightgray"]
    validcolorsstring = ""
    for item in validcolors:
      validcolorsstring = validcolorsstring + cli.prefs.colors.cdict[item] + item + cli.colorscheme["defaultcolor"] + " "
    print("Valid color choices are: " + validcolorsstring)

    print("\nWhat color would you like to use for messages from you? (type cancel to abort)")
    mycolorchoice = ""
    while not mycolorchoice in validcolors:
      mycolorchoice = raw_input("color> ")
      if mycolorchoice == "cancel":
        return

    print("\nWhat color would you like to use for messages from others? (cancel to abort)")
    othercolorchoice = ""
    while not othercolorchoice in validcolors:
      othercolorchoice = raw_input("color> ")
      if othercolorchoice == "cancel":
        return
    self.myColor = mycolorchoice
    self.othersColor = othercolorchoice
    self.myColorValue = cli.prefs.colors.cdict[self.myColor]
    self.othersColorValue = cli.prefs.colors.cdict[self.othersColor]


  # it is good habit to contain all your callback functions in
  # try-except blocks so that they don't poison the rest of the
  # system.
  # Return -1 if you don't want the rest of the callbacks or the function itself called.
  # returning a list of the exact same length as the number of args in the callback results on those becoming the args.
  # returning anything else is meaningless.
  def myHandleConferenceMessagePRE(self, cli, conf, nick, body, delay):
    try:
      if((nick == "" or nick == None) and len(body) > 10 and
         (body[-10:] == "has joined" or body[-8:] == "has left")):
        return -1

      confjid = None
      if cli.imcom.confnick.has_key(conf):
        confjid = cli.imcom.confnick[conf]

      if confjid != None and cli.imcom.conferences.has_key(confjid) and cli.imcom.conferences[confjid][1] == nick:
        self.oldColor = cli.overrideColor("messagebodycolor", self.myColorValue)
      else:
        self.oldColor = cli.overrideColor("messagebodycolor", self.othersColorValue)
    except:
      traceback.print_exc()

  def myHandleConferenceMessagePOST(self, cli, conf, nick, body, delay):
    try:
      if(self.oldColor != None):
        cli.overrideColor("messagebodycolor", self.oldColor)
    except:
      traceback.print_exc()


def getText(parent):
  rc = ""
  for node in parent.childNodes:
    if node.nodeType == node.TEXT_NODE:
      rc = rc + node.data
  return rc

def getElementByName(startElement, wantedName):
  """Returns the first child of startElement who's name is wantedName."""
  for blah in startElement.childNodes:
    if blah.nodeName == wantedName:
      return blah
  return None

def getElementsByName(startElement, wantedName):
  """Returns all direct children of startElement whose name is wantedName."""
  result = []
  for blah in startElement.childNodes:
    if blah.nodeName == wantedName:
      result.append(blah)
  return result
