<?php
// File           user.php / ibWebAdmin
// Purpose        panels for user administration, roles, granting permissions
// Author         Lutz Brueckner <irie@gmx.de>
// Copyright      (c) 2000, 2001, 2002, 2003, 2004 by Lutz Brueckner,
//                published under the terms of the GNU General Public Licence v.2,
//                see file LICENCE for details
// Created        <02/05/26 10:07:22 lb>
//
// $Id: user.php,v 1.11 2004/01/25 15:33:51 lbrueckner Exp $


require('inc/script_start.inc.php');

//
// user stuff / gsec interface
//
$idx = get_panel_index($s_users_panels, 'usr_user');
if ($s_users_panels[$idx][2] == 'open'  &&  $s_connected) {

    include('inc/users.inc.php');

    // init the array users[]
    $users = get_user();

    $s_sysdba_pw = get_sysdba_pw();

    if (isset($HTTP_POST_VARS['usr_user_del'])
    ||  isset($HTTP_POST_VARS['usr_user_create'])
    ||  isset($HTTP_POST_VARS['usr_user_mod'])) {
        if (!isset($s_sysdba_pw)  ||  empty($s_sysdba_pw)) {
            $warning = $WARNINGS['NEED_SYSDBA_PW'];
        }
    }

    if (empty($warning)) {
        // remove the selected user
        if (isset($HTTP_POST_VARS['usr_user_del'])
        && $HTTP_POST_VARS['usr_user_dname'] != '') {

            $duser =  $HTTP_POST_VARS['usr_user_dname'];

            if ($s_cust['askdel'] == TRUE) {
                $s_confirmations['user'] = 
                     array('msg' => sprintf($MESSAGES['CONFIRM_USER_DELETE'], $duser),
                           'obj' => $duser);
            }
            else {
                drop_user($duser);
            }
        }
        
        // the Create button on the User panel was pushed
        if (isset($HTTP_POST_VARS['usr_user_create'])){
            $user_add_flag = TRUE;
        }
        
        // create the user from the form values
        if (isset($HTTP_POST_VARS['usr_user_create_doit'])) {
            if (!create_user()) {
                // show the create user form again
                $user_add_flag = TRUE;
            }
        }
        
        // the Modify button on the User panel was pushed
        if (isset($HTTP_POST_VARS['usr_user_mod'])  
        &&  !empty($HTTP_POST_VARS['usr_user_mname'])) {
            $s_user_name = $HTTP_POST_VARS['usr_user_mname'];
        }
        
        // modify the user from the form values
        if (isset($HTTP_POST_VARS['usr_user_mod_doit'])) {
            if (modify_user($s_user_name)) {
                // on success don't show the modify user form again
                unset($s_user_name);
            }        
        }
        
        // modifying an index was canceled
        if (isset($HTTP_POST_VARS['usr_user_mod_cancel'])) {
            unset($s_user_name);
        }
    }
}


//
// roles initialisations and form handling
//
$idx = get_panel_index($s_users_panels, 'usr_role');
if ($s_users_panels[$idx][2] == 'open'  &&  $s_connected) {

    include('inc/roles.inc.php');

    $roles = get_roles();

    // create a role
    if (isset($HTTP_POST_VARS['usr_role_create'])
    &&  $HTTP_POST_VARS['usr_role_name'] != '') {

        create_role($HTTP_POST_VARS['usr_role_name']);
    }

    // drop a role
    if (isset($HTTP_POST_VARS['usr_role_del'])
    &&  $HTTP_POST_VARS['usr_role_dname'] != '') {

        drop_role($HTTP_POST_VARS['usr_role_dname']);
    }

    // add user to role
    if (isset($HTTP_POST_VARS['usr_role_add'])
    &&  $HTTP_POST_VARS['usr_role_addname'] != ''
    &&  $HTTP_POST_VARS['usr_role_adduser'] != '') {

        grant_role_to_user($HTTP_POST_VARS['usr_role_addname'], $HTTP_POST_VARS['usr_role_adduser']);
    }

    // remove user from role
    if (isset($HTTP_POST_VARS['usr_role_remove'])
    &&  $HTTP_POST_VARS['usr_role_removename'] != ''
    &&  $HTTP_POST_VARS['usr_role_removeuser'] != '') {

        revoke_role_from_user($HTTP_POST_VARS['usr_role_removename'], $HTTP_POST_VARS['usr_role_removeuser']);
    }
}


// deleting a subject is confirmed
if (isset($HTTP_POST_VARS['confirm_yes'])) {
    switch ($HTTP_POST_VARS['confirm_subject']) {
        case 'user':
            drop_user($s_confirmations['user']['obj']);
            break;
    }

    unset($s_confirmations['user']);
}

// deleting a subject is canceled
if (isset($HTTP_POST_VARS['confirm_no'])) {
    unset($s_confirmations[$HTTP_POST_VARS['confirm_subject']]);
}


//
// customizing
//
if (isset($HTTP_POST_VARS['usr_cust_save'])) {

    $old_settings = $s_cust;

    // color settings
    foreach (get_colornames() as $cname) {
        if (!preg_match('/^[0-9A-F#]{7}$/i', $HTTP_POST_VARS['usr_cust_'.$cname])) {
            $error = 'Bad Color!';
            $s_cust['color'] = $old_settings['color'];
            break;
        }
        $s_cust['color'][$cname] = strtoupper($HTTP_POST_VARS['usr_cust_'.$cname]);
    }
    
    $s_cust['language'] = $HTTP_POST_VARS['usr_cust_language'];
    $s_cust['fontsize'] = $HTTP_POST_VARS['usr_cust_fontsize'];
    $s_cust['textarea'] = array('cols' => $HTTP_POST_VARS['usr_cust_tacols'],
                                'rows' =>$HTTP_POST_VARS['usr_cust_tarows']);

    $s_cust['askdel'] = $HTTP_POST_VARS['usr_cust_askdel'] == $usr_strings['Yes'] ? 1 : 0;

    $settings_changed = TRUE;
}

// reset the customizing values to the configuration defaults
if (isset($HTTP_POST_VARS['usr_cust_defaults'])) {

    $old_settings = $s_cust;
    $s_cust = get_customize_defaults($s_useragent);

    $settings_changed = TRUE;
}

if ($settings_changed = TRUE  &&  isset($old_settings)) {

    if ($old_settings['language'] != $s_cust['language']) {

        include('./lang/' . $s_cust['language'] . '.inc.php');
        fix_language($s_cust['language']);
    }

    set_customize_cookie($s_cust);

    // force reloading of the stylesheet
    $s_stylesheet_etag = '';
}


//
// print out all the panels
//
$active = 'Users';
$panels = $s_users_panels;
require('inc/script_end.inc.php');

?>
