<?php
// File           stylesheet.php / ibWebAdmin
// Purpose        dynamic stylesheet generation
// Author         Lutz Brueckner <irie@gmx.de>
// Copyright      (c) 2000, 2001, 2002, 2003, 2004 by Lutz Brueckner,
//                published under the terms of the GNU General Public Licence v.2,
//                see file LICENCE for details
// Created        <03/09/28 19:25:07 lb>
//
// $Id: stylesheet.php,v 1.7 2004/03/20 07:47:34 lbrueckner Exp $


require('inc/configuration.inc.php');

// make sure output-compression is turned off,
// oldish browsers like ns4.7 have problems with compressed stylesheet files
ini_set('zlib.output_compression', 'Off');

session_start();

// don't send the stylesheet if 
//   a) it's not the first request
//   b) $s_stylesheet_etag was not deleted after the customizing form was submitted
//   c) stylesheet chaching is not disabled in the configuration
if (isset($HTTP_SESSION_VARS['s_stylesheet_etag'])  &&  !empty($HTTP_SESSION_VARS['s_stylesheet_etag'])  &&
    request_header_check($HTTP_SESSION_VARS['s_stylesheet_etag'])  &&
    CACHE_STYLESHEET === TRUE) {

    header("HTTP/1.1 304 Not Modified");
    send_stylesheet_headers($HTTP_SESSION_VARS['s_stylesheet_etag']);
}

// send the stylesheet
else {
    $HTTP_SESSION_VARS['s_stylesheet_etag'] = md5(get_stylesheet($HTTP_SESSION_VARS['s_cust']));

    send_stylesheet_headers($HTTP_SESSION_VARS['s_stylesheet_etag']);
    echo get_stylesheet($HTTP_SESSION_VARS['s_cust']);
}


//
// send http headers to enable caching
//
function send_stylesheet_headers($etag) {

    header('Expires: ' . gmdate('D, d M Y H:i:s', (time() + 20000000)) . ' GMT');
    header('Cache-Control: public');
    header('Pragma: public');
    header('Etag: "' . $etag . '"');
    header('Content-Type: text/css');
}


//
// return TRUE if the the client is sending an If-None-Match or an If-Modified-Since header
// or if the server isn't ab apache 1.3
//
function request_header_check($etag='') {

    if (!function_exists('apache_request_headers')) {
        return TRUE;
    }

    foreach (apache_request_headers() as $header => $value) {
        if (strcasecmp($header, 'If-None-Match') == 0  ||  strcasecmp($header, 'If-Modified-Since') == 0) {

            // the header values should be checked ... later

            return TRUE;
        }
    }

    return FALSE;
}


//
// return a string with the css definitions
//
function get_stylesheet($customize) {
    
    $color_background    = $customize['color']['background'];
    $color_panel         = $customize['color']['panel'];
    $color_area          = $customize['color']['area'];
    $color_headline      = $customize['color']['headline'];
    $color_menuborder    = $customize['color']['menuborder'];
    $color_link          = $customize['color']['link'];
    $color_linkhover     = $customize['color']['linkhover'];
    $color_selectedrow   = $customize['color']['selectedrow'];
    $color_selectedinput = $customize['color']['selectedinput'];
    $color_firstrow      = $customize['color']['firstrow'];
    $color_secondrow     = $customize['color']['secondrow'];

    $fontsize = $customize['fontsize'].'pt';

return <<<EOT

body { 
        background-color: $color_background;
        font-family: Verdana, Arial, Helvetica, sans-serif;
        font-size: $fontsize;
}

td, th, input, select {
        font-family: Verdana, Arial, Helvetica, sans-serif;
        font-size: $fontsize;
}

textarea {
        font-family: Courier,monospace;
        font-size: $fontsize;
}

input:focus {
        background-color : $color_selectedinput;
}

textarea:focus {
        background-color : $color_selectedinput;
}

table { 
        margin-top: 2px;
        margin-bottom: 2px;
}

th {
        background-color: $color_headline;
}

a:link, a:active, a:visited {
        color: $color_link;
        text-decoration: none;
}

a:hover {
        color: $color_linkhover;
        text-decoration: none;
}

.panel { 
        background-color: $color_panel;
}

.area { 
        background-color:  $color_area;
}

.wttr1  {
        background-color: $color_firstrow;
}

.wttr2  {
        background-color: $color_secondrow;
}

.detail {
        padding-left: 3px;
        padding-right: 3px;
}

.hex {
        font-family: monospace;
        font-size: $fontsize;
        padding-left: 5px;
        padding-right: 5px;
}

.err {
        font-weight: bold;
        color : red;
}

div.fk {
        position: static;
        left: 10px;
        width: auto;
        height: auto;
        overflow: auto;
        padding: 5px;
        display: none;
}

.selected {
        background: $color_selectedrow;
        color: HighlightText;
}

EOT;
}

?>
