/*
 * Hydrogen
 * Copyright(c) 2002-2004 by Alex >Comix< Cominu [comix@users.sourceforge.net]
 *
 * http://hydrogen.sourceforge.net
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * $Id: NullDriver.h,v 1.1 2004/04/22 12:06:28 comix Exp $
 *
 */


#ifndef NULL_AUDIO_DRIVER_H
#define NULL_AUDIO_DRIVER_H

#include "GenericDriver.h"
#include <inttypes.h>

typedef int  (*audioProcessCallback)(uint32_t, void *);

//----------------------------------------------------------------------------
/**
 * Null Audio Driver
 */
class NullDriver : public GenericDriver {
	public:
		/** Constructor */
		NullDriver(audioProcessCallback processCallback);

		/** Destructor */
		~NullDriver();

		int init(uint nBufferSize);
		int connect();
		void disconnect();
		uint getBufferSize();
		uint getSampleRate();

		float* getOut_L();
		float* getOut_R();

		virtual void play();
		virtual void stop();
		virtual void locate( unsigned long nFrame );
		virtual void updateTransportInfo();
		virtual void setBpm(float fBPM);

};

#endif

