/*
 * Hydrogen
 * Copyright(c) 2002-2004 by Alex >Comix< Cominu [comix@users.sourceforge.net]
 *
 * http://hydrogen.sourceforge.net
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * $Id: Button.cpp,v 1.13 2004/01/26 11:17:48 comix Exp $
 *
 */

#include <iostream>
#include "Button.h"

Button::Button(QWidget * parent, QSize size, string onImage, string offImage, string overImage) : QWidget(parent, 0), Object( "Button" ){
//	cout << "Button init" << endl;
	mouseOver = false;
	pressed = false;

	onPixmap = NULL;
	offPixmap = NULL;
	overPixmap = NULL;

	setMinimumSize(size.width(), size.height());
	setMaximumSize(size.width(), size.height());
	resize(size.width(), size.height());

	bool ok = onPixmap.load( onImage.c_str() );
	if( ok == false ){
		qWarning("Button: Error loading pixmap" + QString(onImage.c_str()) );
	}

	ok = offPixmap.load( offImage.c_str() );
	if( ok == false ){
		qWarning("Button: Error loading pixmap" + QString(offImage.c_str())  );
	}

	ok = overPixmap.load( overImage.c_str() );
	if( ok == false ){
		qWarning("Button: Error loading pixmap" + QString(overImage.c_str())  );
	}
	setBackgroundPixmap(offPixmap);

}




Button::~Button() {
//	cout << "Button Destroy" << endl;
}




void Button::mousePressEvent(QMouseEvent*) {
	pressed = true;
	drawButton();
}



/**
 *
 */
void Button::mouseReleaseEvent(QMouseEvent* ev)
{
	pressed = false;
	drawButton();

	if (ev->button() == LeftButton) {
		emit clicked(this);
	}
	else if (ev->button() == RightButton) {
		emit rightClicked(this);
	}

}





/**
 *
 */
void Button::setPressed(bool pressed) {
	if (pressed != this->pressed) {
		this->pressed = pressed;
		drawButton();
	}
}




/**
 *
 */
void Button::drawButton() {
	if (pressed) {
		setBackgroundPixmap(onPixmap);
	}
	else {
		if (mouseOver) {
			setBackgroundPixmap(overPixmap);
		}
		else {
			setBackgroundPixmap(offPixmap);
		}
	}
}



/**
 *
 */
void Button::enterEvent(QEvent *ev) {
	mouseOver = true;
	drawButton();
}



/**
 *
 */
void Button::leaveEvent(QEvent *ev) {
	mouseOver = false;
	drawButton();
}




/**
 * Constructor
 */
ToggleButton::ToggleButton(QWidget * parent, QSize size, string onImg, string offImg, string overImg) : Button(parent, size, onImg, offImg, overImg) {
	pressed = false;
}





/**
 * Destructor
 */
ToggleButton::~ToggleButton() {
}





/**
 *
 */
void ToggleButton::mousePressEvent(QMouseEvent*) {
	if (pressed) {
		pressed = false;
		setBackgroundPixmap(offPixmap);
	}
	else {
		pressed = true;
		setBackgroundPixmap(onPixmap);
	}

	emit clicked(this);

}




/**
 *
 */
void ToggleButton::mouseReleaseEvent(QMouseEvent*) {
	// do nothing, this method MUST override Button's one
}




