#include <string>

using namespace std;

class PolyType{
public:
  PolyType(int v):m_original(wasInt),m_isInt(true),m_isDouble(false),
    m_isString(false),m_isBool(false),m_int(v){}
  PolyType(double v):m_original(wasDouble),m_isInt(false),m_isDouble(true),
    m_isString(false),m_isBool(false),m_double(v){}
  PolyType(const string& v):m_original(wasString),m_isInt(false),
    m_isDouble(false),m_isString(true),m_isBool(false),m_string(v){}
  PolyType(const char* v):m_original(wasString),m_isInt(false),
    m_isDouble(false),m_isString(true),m_isBool(false),m_string(v){}
  PolyType(bool v):m_original(wasBool),m_isInt(false),m_isDouble(false),
    m_isString(false),m_isBool(true),m_bool(v){}
  operator int()const;
  operator double()const;
  operator string()const;
  operator bool()const;
  const int AsInt()const{operator int(); return m_int;}
  int& AsInt();
  const double AsDouble()const{operator double(); return m_double;}
  double& AsDouble();
  const string AsString()const{operator string(); return m_string;}
  string& AsString();
  const bool AsBool()const{operator bool(); return m_bool;}
  bool& AsBool();
  PolyType& operator=(const int v);
  PolyType& operator=(const double v);
  PolyType& operator=(const string& v);
  PolyType& operator=(const char* v);
  PolyType& operator=(const bool v);
private:
  enum OrigType {wasInt,wasDouble,wasString,wasBool};
  OrigType m_original;
  mutable bool m_isInt,m_isDouble,m_isString,m_isBool;
  mutable int m_int;
  mutable double m_double;
  mutable string m_string;
  mutable bool m_bool;
};
