/*Written with Emacs.*/
/*
  GtkDiskFree shows free space on your mounted partitions.  Copyright
  (C) 2001-2002 Dj-Death (Landwerlin Lionel)
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
  USA */

#ifdef HAVE_CONFIG_H            /* Config */
# include "config.h"
#endif

#ifdef STDC_HEADERS             /* Std C libraries */
# include <stdio.h>
# include <ctype.h>
# include <stdlib.h>
# include <string.h>
# include <strings.h>
#endif

#ifdef HAVE_ERRNO_H
# include <errno.h>
#endif

#ifdef HAVE_MATH_H
# include <math.h>
#endif

#ifdef HAVE_PWD_H
# include <pwd.h>
#endif
#ifdef HAVE_SYS_TYPES_H
# include <sys/types.h>
#endif
#ifdef HAVE_SYS_STAT_H
# include <sys/stat.h>
#endif

#ifdef HAVE_SYS_PARAM_H
# include <sys/param.h>
#endif

#ifdef HAVE_MNTENT_H            /* 4.3BSD, SunOS, HP-UX, Dynix, Irix, Linux. */
# include <mntent.h>
#endif

#ifdef HAVE_SYS_VFSTAB_H
# include <sys/vfstab.h>
#endif

#ifdef HAVE_SYS_MOUNT_H
# include <sys/mount.h>
#endif

#ifdef HAVE_SYS_STATFS_H
# include <sys/statfs.h>
#endif

#ifdef HAVE_SYS_VFS_H
# include <sys/vfs.h>
#endif

#ifdef HAVE_SYS_VMOUNT_H        /* AIX */
# include <sys/vmount.h>
#endif

#ifdef HAVE_FSHELP_H
# include <fshelp.h>
#endif

#ifdef HAVE_SYS_FS_S5PARAM_H	/* Fujitsu UXP/V */
# include <sys/fs/s5param.h>
#endif

#ifdef HAVE_SYS_FILSYS_H        /* SVR2 */
# include <sys/filsys.h>
#endif

#ifdef HAVE_FCNTL_H
# include <fcntl.h>
#endif

#ifdef HAVE_DUSTAT_H		/* AIX PS/2 */
# include <sys/dustat.h>
#endif

#ifdef HAVE_SYS_STATVFS_H	/* SVR4, Solaris */
# include <sys/statvfs.h>
#endif

#ifdef HAVE_SYS_MNTTAB_H
# include <sys/mnttab.h>
#endif

#ifdef HAVE_UNISTD_H
# include <unistd.h>
#endif
#ifdef HAVE_LOCALE_H
# include <locale.h>
#endif
#ifdef HAVE_GETOPT_H
# include <getopt.h>
#endif

#include <gtk/gtk.h>

// i18n support
#if defined ENABLE_NLS && defined HAVE_LIBINTL_H
# include <libintl.h>
# undef _
# define _(String) gettext (String)
# ifdef gettext_noop
#  define N_(String) gettext_noop (String)
# else
#  define N_(String) (String)
# endif /* gettext_noop */
#else
# define textdomain(S) (S)
# define gettext(S) (S)
# define dgettext(D,M) (M)
# define dcgettext(D,M,T) (M)
# define _(S) (S)
# define N_(S) (S)
#endif

// Columns
enum {
	FILESYSTEM_COLUMN,
	SIZE_COLUMN,
	USED_SPACE_COLUMN,
	FREE_SPACE_COLUMN,
	USED_PERCENT_COLUMN,
	FREE_PERCENT_COLUMN,
	FILESYSTEM_TYPE_COLUMN,
	MOUNT_OPTIONS_COLUMN,
	MOUNT_POINT_COLUMN,
	CAPACITY_COLUMN,
	
	SIZEK_COLUMN,
	USEDK_SPACE_COLUMN,
	FREEK_SPACE_COLUMN,
	USEDP_PERCENT_COLUMN,
	FREEP_PERCENT_COLUMN,
	STATUS_COLUMN,
	N_COLUMNS,
};

// Orders
typedef enum {
	DEFAULT,
	READ,
	WRITE,
	
	REFRESH,
	STOP,
	
	ADD,
	INSERT,
	UPDATE,
	REMOVE,
	MOUNT,
	UMOUNT
} order_t;

// Status
enum {
	FS_OLD,
	FS_MOUNTED,
	FS_UMOUNTED
};

enum {
	KILOBYTE,
	MEGABYTE,
	GIGABYTE,
	AUTOSIZE
};

#define NONE_FILE                "none"
#define CONFIG_DIRECTORY         "/.gtkdiskfree2/"
#define CONFIG_FILENAME          "config"

/* Error and debug definitions. */
#define INFO(args) (printf("** gtkdiskfree info: "), printf args, printf(" **\n"))
#define ERROR(args) (printf("** gtkdiskfree error: "), printf args, printf(" **\n"))

/* Only if debug is enable. */
#ifdef DEBUG
# define PRINT_DEBUG(args) (printf("** gtkdiskfree debug: "), printf args, printf(" **\n"))
#else
# define PRINT_DEBUG(args) 
#endif
