/*
 * GPG Keys 
 * functions.cpp
 * (c) 2001 Peter Mathiasson <peter@mathiasson.nu>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2, as
 * published by the Free Software Foundation
 */

#include <qapp.h>
#include <qdir.h>
#include <qstring.h>
#include <qimage.h>
#include <qpixmap.h>
#include <qiconset.h>
#include <qlistview.h>
#include <qstatusbar.h>
#include <qsettings.h>
#include <qcombobox.h>
#include <qfont.h>
#include "functions.h"
//#include "gfx.h"

#define tr(x)   qApp->translate( "functions", x )

/* --------------------------------------------------------------------------------- */

const QString getTrust( const QString trust )
{
    switch( trust[0] ) {
    case 'o': return QString( tr( "Unknown" ) );
    case 'i': return QString( tr( "Invalid" ) );
    case 'd': return QString( tr( "Disabled" ) );
    case 'r': return QString( tr( "Revoked" ) );
    case 'e': return QString( tr( "Expired" ) );
    case 'q': return QString( tr( "Undefined" ) );
    case 'n': return QString( tr( "None" ) );
    case 'm': return QString( tr( "Marginal" ) );
    case 'f': return QString( tr( "Full" ) );
    case 'u': return QString( tr( "Ultimate" ) );
    default:  return QString::null;
    }
}

/* --------------------------------------------------------------------------------- */

const QString getCipher( const QString id )
{
    switch( id.toInt() ) {
    case  1:          return QString("RSA");
    case 16: case 20: return QString("ElGamal");
    case 17:          return QString("DSA");
    default:          return QString("#" + id);
    }
}

/* --------------------------------------------------------------------------------- */

void runFailed( QStatusBar *statusBar )
{
    statusBar->message( tr( "Failed to run GPG: Check Configuration" ), 3000 );
}

/* --------------------------------------------------------------------------------- */
/*
const QPixmap getPixmap( const char *name )
{
    QPixmap pixMap;
    pixMap.convertFromImage( qembed_findImage( name ) );
    return pixMap;
}
*/
/* --------------------------------------------------------------------------------- */
/*
const QIconSet getIconSet( const char *name )
{
    return QIconSet( getPixmap( name ) );
}
*/
/* --------------------------------------------------------------------------------- */

QString readConfigString( const QString key, QString def )
{
    QSettings settings;
    settings.insertSearchPath( QSettings::Windows, "/mathiasson.nu" );
    return settings.readEntry( "/gpgkeys/" + key, def );
}

/* --------------------------------------------------------------------------------- */

int readConfigInt( const QString key, int def )
{
    QSettings settings;
    settings.insertSearchPath( QSettings::Windows, "/mathiasson.nu" );
    return settings.readNumEntry( "/gpgkeys/" + key, def );
}

/* --------------------------------------------------------------------------------- */

QFont readConfigFont( const QString key, const QString family, const int pointSize,
                      const int weight, const int italic )
{
    QSettings settings;
    settings.insertSearchPath( QSettings::Windows, "/mathiasson.nu" );
    QString def = QString( "%1:%2:%3:%4" ).arg(family).arg(pointSize).arg(weight).arg(italic);
    QString string = settings.readEntry( "/gpgkeys/fonts/" + key, def );
    QStringList list = QStringList::split( ':', string, TRUE );
    return QFont( list[0], list[1].toInt(), list[2].toInt(), list[3].toInt() );
}

/* --------------------------------------------------------------------------------- */

void writeConfigString( const QString key, const QString value )
{
    QSettings settings;
    settings.insertSearchPath( QSettings::Windows, "/mathiasson.nu" );
    settings.writeEntry( "/gpgkeys/" + key, value );
}

/* --------------------------------------------------------------------------------- */

void writeConfigInt( const QString key, int value )
{
    QSettings settings;
    settings.insertSearchPath( QSettings::Windows, "/mathiasson.nu" );
    settings.writeEntry( "/gpgkeys/" + key, value );
}

/* --------------------------------------------------------------------------------- */

void writeConfigFont( const QString key, QFont font )
{
    QSettings settings;
    settings.insertSearchPath( QSettings::Windows, "/mathiasson.nu" );
    QString value = QString( "%1:%2:%3:%4" ).arg( font.family() ).arg( font.pointSize() )
                    .arg( font.weight() ).arg( font.italic() );
    settings.writeEntry( "/gpgkeys/fonts/" + key, value );
}

/* --------------------------------------------------------------------------------- */

void setComboBoxText( QComboBox *box, const QString text )
{
    for ( int i = 0; i < box->count(); i++ ) {
        if ( box->text( i ) == text ) {
            box->setCurrentItem( i );
            return;
        }
    }
}

/* --------------------------------------------------------------------------------- */

QString fromUtf8( const QString string )
{
    if ( readConfigInt( "utf8userid", UTF8_USERID ) ) {
        return QString::fromUtf8(string);
    }
    return string;
}

/* --------------------------------------------------------------------------------- */
