indexing

	description:

		"Scanners for Eiffel parsers"

	library: "Gobo Eiffel Tools Library"
	copyright: "Copyright (c) 1999-2003, Eric Bezault and others"
	license: "Eiffel Forum License v2 (see forum.txt)"
	date: "$Date: 2003/06/26 20:04:15 $"
	revision: "$Revision: 1.19 $"

class ET_EIFFEL_SCANNER

inherit

	ET_EIFFEL_SCANNER_SKELETON

creation

	make, make_with_factory

feature -- Status report

	valid_start_condition (sc: INTEGER): BOOLEAN is
			-- Is `sc' a valid start condition?
		do
			Result := (INITIAL <= sc and sc <= VS3)
		end

feature {NONE} -- Implementation

	yy_build_tables is
			-- Build scanner tables.
		do
			yy_nxt ?= yy_nxt_template
			yy_chk ?= yy_chk_template
			yy_base ?= yy_base_template
			yy_def ?= yy_def_template
			yy_ec ?= yy_ec_template
			yy_meta ?= yy_meta_template
			yy_accept ?= yy_accept_template
			yy_acclist ?= yy_acclist_template
		end

	yy_execute_action (yy_act: INTEGER) is
			-- Execute semantic action.
		do
if yy_act <= 50 then
if yy_act <= 25 then
if yy_act <= 13 then
if yy_act <= 7 then
if yy_act <= 4 then
if yy_act <= 2 then
if yy_act = 1 then
	yy_column := yy_column + 1
--|#line 32 "et_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_scanner.l' at line 32")
end

				last_break_end := 0
				last_comment_end := 0
				process_one_char_symbol (text_item (1))
			
else
yy_set_line_column
--|#line 37 "et_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_scanner.l' at line 37")
end

				last_text_count := 1
				last_break_end := text_count
				last_comment_end := 0
				process_one_char_symbol (text_item (1))
			
end
else
if yy_act = 3 then
yy_set_line_column
--|#line 43 "et_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_scanner.l' at line 43")
end

				last_text_count := 1
				last_break_end := 0
				last_comment_end := text_count
				process_one_char_symbol (text_item (1))
			
else
yy_set_line_column
--|#line 49 "et_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_scanner.l' at line 49")
end

				last_text_count := 1
				last_break_end := 0
				last_comment_end := text_count
				process_one_char_symbol ('-')
			
end
end
else
if yy_act <= 6 then
if yy_act = 5 then
	yy_column := yy_column + 2
--|#line 55 "et_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_scanner.l' at line 55")
end

				last_break_end := 0
				last_comment_end := 0
				process_two_char_symbol (text_item (1), text_item (2))
			
else
yy_set_line_column
--|#line 60 "et_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_scanner.l' at line 60")
end

				last_text_count := 2
				last_break_end := text_count
				last_comment_end := 0
				process_two_char_symbol (text_item (1), text_item (2))
			
end
else
yy_set_line_column
--|#line 66 "et_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_scanner.l' at line 66")
end

				last_text_count := 2
				last_break_end := 0
				last_comment_end := text_count
				process_two_char_symbol (text_item (1), text_item (2))
			
end
end
else
if yy_act <= 10 then
if yy_act <= 9 then
if yy_act = 8 then
	yy_end := yy_end - 1
	yy_column := yy_column + 4
--|#line 88 "et_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_scanner.l' at line 88")
end

				last_token := E_ONCE_STRING
				last_literal_start := 1
				last_literal_end := 4
				last_break_end := 0
				last_comment_end := 0
				last_et_keyword_value := ast_factory.new_once_keyword (Current)
			
else
	yy_end := yy_end - 1
yy_set_line_column
--|#line 96 "et_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_scanner.l' at line 96")
end

				last_token := E_ONCE_STRING
				last_literal_start := 1
				last_literal_end := 4
				last_text_count := 4
				last_break_end := text_count
				last_comment_end := 0
				last_et_keyword_value := ast_factory.new_once_keyword (Current)
			
end
else
	yy_end := yy_end - 1
yy_set_line_column
--|#line 105 "et_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_scanner.l' at line 105")
end

				last_token := E_ONCE_STRING
				last_literal_start := 1
				last_literal_end := 4
				last_text_count := 4
				last_break_end := 0
				last_comment_end := text_count
				last_et_keyword_value := ast_factory.new_once_keyword (Current)
			
end
else
if yy_act <= 12 then
if yy_act = 11 then
	yy_column := yy_column + yy_end - yy_start - yy_more_len
--|#line 118 "et_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_scanner.l' at line 118")
end

				last_break_end := 0
				last_comment_end := 0
				process_identifier (text_count)
			
else
	yy_column := yy_column + yy_end - yy_start - yy_more_len
--|#line 123 "et_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_scanner.l' at line 123")
end

				last_text_count := text_count
				break_kind := identifier_break
				more
				set_start_condition (BREAK)
			
end
else
	yy_column := yy_column + 1
--|#line 138 "et_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_scanner.l' at line 138")
end

				last_token := E_FREEOP
				last_literal_start := 1
				last_literal_end := text_count
				last_break_end := 0
				last_comment_end := 0
				last_et_free_operator_value := ast_factory.new_free_operator (Current)
			
end
end
end
else
if yy_act <= 19 then
if yy_act <= 16 then
if yy_act <= 15 then
if yy_act = 14 then
	yy_column := yy_column + 2
--|#line 139 "et_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_scanner.l' at line 139")
end

				last_token := E_FREEOP
				last_literal_start := 1
				last_literal_end := text_count
				last_break_end := 0
				last_comment_end := 0
				last_et_free_operator_value := ast_factory.new_free_operator (Current)
			
else
	yy_column := yy_column + yy_end - yy_start - yy_more_len
--|#line 140 "et_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_scanner.l' at line 140")
end

				last_token := E_FREEOP
				last_literal_start := 1
				last_literal_end := text_count
				last_break_end := 0
				last_comment_end := 0
				last_et_free_operator_value := ast_factory.new_free_operator (Current)
			
end
else
	yy_column := yy_column + yy_end - yy_start - yy_more_len
--|#line 141 "et_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_scanner.l' at line 141")
end

				last_token := E_FREEOP
				last_literal_start := 1
				last_literal_end := text_count
				last_break_end := 0
				last_comment_end := 0
				last_et_free_operator_value := ast_factory.new_free_operator (Current)
			
end
else
if yy_act <= 18 then
if yy_act = 17 then
	yy_column := yy_column + yy_end - yy_start - yy_more_len
--|#line 142 "et_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_scanner.l' at line 142")
end

				last_token := E_FREEOP
				last_literal_start := 1
				last_literal_end := text_count
				last_break_end := 0
				last_comment_end := 0
				last_et_free_operator_value := ast_factory.new_free_operator (Current)
			
else
	yy_end := yy_end - 1
	yy_column := yy_column + 1
--|#line 152 "et_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_scanner.l' at line 152")
end

				last_text_count := text_count
				last_literal_start := 1
				last_literal_end := last_text_count
				break_kind := freeop_break
				more
				set_start_condition (BREAK)
			
end
else
	yy_end := yy_end - 1
	yy_column := yy_column + 2
--|#line 153 "et_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_scanner.l' at line 153")
end

				last_text_count := text_count
				last_literal_start := 1
				last_literal_end := last_text_count
				break_kind := freeop_break
				more
				set_start_condition (BREAK)
			
end
end
else
if yy_act <= 22 then
if yy_act <= 21 then
if yy_act = 20 then
	yy_end := yy_end - 1
	yy_column := yy_column + yy_end - yy_start - yy_more_len
--|#line 154 "et_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_scanner.l' at line 154")
end

				last_text_count := text_count
				last_literal_start := 1
				last_literal_end := last_text_count
				break_kind := freeop_break
				more
				set_start_condition (BREAK)
			
else
	yy_end := yy_end - 1
	yy_column := yy_column + yy_end - yy_start - yy_more_len
--|#line 155 "et_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_scanner.l' at line 155")
end

				last_text_count := text_count
				last_literal_start := 1
				last_literal_end := last_text_count
				break_kind := freeop_break
				more
				set_start_condition (BREAK)
			
end
else
	yy_end := yy_end - 1
	yy_column := yy_column + yy_end - yy_start - yy_more_len
--|#line 156 "et_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_scanner.l' at line 156")
end

				last_text_count := text_count
				last_literal_start := 1
				last_literal_end := last_text_count
				break_kind := freeop_break
				more
				set_start_condition (BREAK)
			
end
else
if yy_act <= 24 then
if yy_act = 23 then
	yy_column := yy_column + 3
--|#line 168 "et_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_scanner.l' at line 168")
end

				last_break_end := 0
				last_comment_end := 0
				process_c1_character_constant (text_item (2))
			
else
yy_set_line_column
--|#line 173 "et_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_scanner.l' at line 173")
end

				last_text_count := 3
				last_break_end := text_count
				last_comment_end := 0
				process_c1_character_constant (text_item (2))
			
end
else
yy_set_line_column
--|#line 179 "et_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_scanner.l' at line 179")
end

				last_text_count := 3
				last_break_end := 0
				last_comment_end := text_count
				process_c1_character_constant (text_item (2))
			
end
end
end
end
else
if yy_act <= 38 then
if yy_act <= 32 then
if yy_act <= 29 then
if yy_act <= 27 then
if yy_act = 26 then
	yy_column := yy_column + 4
--|#line 185 "et_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_scanner.l' at line 185")
end

				last_break_end := 0
				last_comment_end := 0
				process_c2_character_constant (text_item (3))
			
else
yy_set_line_column
--|#line 190 "et_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_scanner.l' at line 190")
end

				last_text_count := 4
				last_break_end := text_count
				last_comment_end := 0
				process_c2_character_constant (text_item (3))
			
end
else
if yy_act = 28 then
yy_set_line_column
--|#line 196 "et_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_scanner.l' at line 196")
end

				last_text_count := 4
				last_break_end := 0
				last_comment_end := text_count
				process_c2_character_constant (text_item (3))
			
else
	yy_column := yy_column + yy_end - yy_start - yy_more_len
--|#line 203 "et_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_scanner.l' at line 203")
end

				last_token := E_CHARACTER
				last_literal_start := 4
				last_literal_end := text_count - 2
				last_break_end := 0
				last_comment_end := 0
				last_et_character_constant_value := ast_factory.new_c3_character_constant (Current)
			
end
end
else
if yy_act <= 31 then
if yy_act = 30 then
	yy_end := yy_end - 1
	yy_column := yy_column + yy_end - yy_start - yy_more_len
--|#line 211 "et_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_scanner.l' at line 211")
end

				last_text_count := text_count
				last_literal_start := 4
				last_literal_end := last_text_count - 2
				break_kind := character_break
				more
				set_start_condition (BREAK)
			
else
	yy_column := yy_column + yy_end - yy_start - yy_more_len
--|#line 220 "et_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_scanner.l' at line 220")
end

					-- Syntax error: missing character / at end
					-- of special character specification %/code/.
				column := column + text_count
				error_handler.report_SCAS_error (filename, current_position)
				last_et_position_value := current_position
				column := column - text_count
				last_token := E_CHARERR
			
end
else
	yy_column := yy_column + 3
--|#line 229 "et_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_scanner.l' at line 229")
end

					-- Syntax error: missing ASCII code in
					-- special character specification %/code/.
				column := column + 3
				error_handler.report_SCAC_error (filename, current_position)
				last_et_position_value := current_position
				column := column - 3
				last_token := E_CHARERR
			
end
end
else
if yy_act <= 35 then
if yy_act <= 34 then
if yy_act = 33 then
	yy_column := yy_column + 2
--|#line 238 "et_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_scanner.l' at line 238")
end

					-- Syntax error: missing character between quotes.
				column := column + 1
				error_handler.report_SCQQ_error (filename, current_position)
				last_et_position_value := current_position
				column := column - 1
				last_token := E_CHARERR
			
else
	yy_column := yy_column + yy_end - yy_start - yy_more_len
--|#line 246 "et_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_scanner.l' at line 246")
end

					-- Syntax error: missing quote at
					-- end of character constant.
				column := column + text_count
				error_handler.report_SCEQ_error (filename, current_position)
				last_et_position_value := current_position
				column := column - text_count
				last_token := E_CHARERR
			
end
else
	yy_column := yy_column + yy_end - yy_start - yy_more_len
--|#line 259 "et_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_scanner.l' at line 259")
end

				last_token := E_STRFREEOP
				last_literal_start := 2
				last_literal_end := text_count - 1
				last_break_end := 0
				last_comment_end := 0
				last_et_manifest_string_value := ast_factory.new_regular_manifest_string (Current)
			
end
else
if yy_act <= 37 then
if yy_act = 36 then
	yy_column := yy_column + yy_end - yy_start - yy_more_len
--|#line 267 "et_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_scanner.l' at line 267")
end

				last_text_count := text_count
				last_literal_start := 2
				last_literal_end := last_text_count - 1
				break_kind := str_freeop_break
				more
				set_start_condition (BREAK)
			
else
	yy_column := yy_column + yy_end - yy_start - yy_more_len
--|#line 276 "et_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_scanner.l' at line 276")
end

					-- Regular manifest string.
				last_break_end := 0
				last_comment_end := 0
				process_regular_manifest_string (text_count)
			
end
else
	yy_column := yy_column + yy_end - yy_start - yy_more_len
--|#line 282 "et_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_scanner.l' at line 282")
end

					-- Regular manifest string.
				last_text_count := text_count
				break_kind := string_break
				more
				set_start_condition (BREAK)
			
end
end
end
else
if yy_act <= 44 then
if yy_act <= 41 then
if yy_act <= 40 then
if yy_act = 39 then
	yy_column := yy_column + yy_end - yy_start - yy_more_len
--|#line 290 "et_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_scanner.l' at line 290")
end

					-- Verbatim string.
				verbatim_marker := text_substring (2, text_count - 1)
				set_start_condition (VS1)
			
else
	yy_line := yy_line + 1
	yy_column := 1
--|#line 298 "et_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_scanner.l' at line 298")
end

				verbatim_open_white_characters := text
				last_literal_start := 1
				last_literal_end := 0
				set_start_condition (VS2)
			
end
else
	yy_column := yy_column + 1
--|#line 304 "et_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_scanner.l' at line 304")
end

					-- No final bracket-double-quote.
				last_token := E_STRERR
				last_et_position_value := current_position
				set_start_condition (INITIAL)
			
end
else
if yy_act <= 43 then
if yy_act = 42 then
	yy_column := yy_column + yy_end - yy_start - yy_more_len
--|#line 320 "et_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_scanner.l' at line 320")
end

				if is_verbatim_string_closer (last_literal_end + 1, text_count - 1) then
					last_token := E_STRING
					last_break_end := 0
					last_comment_end := 0
					last_et_manifest_string_value := ast_factory.new_verbatim_string (verbatim_marker, verbatim_open_white_characters,
						text_substring (last_literal_end + 1, text_count - verbatim_marker.count - 2), Current)
					verbatim_marker := Void
					verbatim_open_white_characters := Void
					set_start_condition (INITIAL)
				else
					more
					set_start_condition (VS3)
				end
			
else
	yy_column := yy_column + yy_end - yy_start - yy_more_len
--|#line 335 "et_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_scanner.l' at line 335")
end

				if is_verbatim_string_closer (last_literal_end + 1, text_count - 1) then
					verbatim_close_white_characters := text_substring (last_literal_end + 1, text_count - verbatim_marker.count - 2)
					last_text_count := text_count
					break_kind := str_verbatim_break
					more
					set_start_condition (BREAK)
				else
					more
					set_start_condition (VS3)
				end
			
end
else
	yy_column := yy_column + yy_end - yy_start - yy_more_len
--|#line 347 "et_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_scanner.l' at line 347")
end

				more
				set_start_condition (VS3)
			
end
end
else
if yy_act <= 47 then
if yy_act <= 46 then
if yy_act = 45 then
	yy_line := yy_line + 1
	yy_column := 1
--|#line 351 "et_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_scanner.l' at line 351")
end

				more
				last_literal_end := text_count - 2
			
else
	yy_line := yy_line + 1
	yy_column := 1
--|#line 355 "et_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_scanner.l' at line 355")
end

				more
				last_literal_end := text_count - 1
			
end
else
	yy_column := yy_column + yy_end - yy_start - yy_more_len
--|#line 359 "et_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_scanner.l' at line 359")
end

					-- No final bracket-double-quote.
				last_token := E_STRERR
				last_et_position_value := current_position
				set_start_condition (INITIAL)
			
end
else
if yy_act <= 49 then
if yy_act = 48 then
	yy_line := yy_line + 1
	yy_column := 1
--|#line 375 "et_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_scanner.l' at line 375")
end

				more
				last_literal_end := text_count - 2
				set_start_condition (VS2)
			
else
	yy_line := yy_line + 1
	yy_column := 1
--|#line 380 "et_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_scanner.l' at line 380")
end

				more
				last_literal_end := text_count - 1
				set_start_condition (VS2)
			
end
else
	yy_column := yy_column + yy_end - yy_start - yy_more_len
--|#line 385 "et_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_scanner.l' at line 385")
end

					-- No final bracket-double-quote.
				last_token := E_STRERR
				last_et_position_value := current_position
				set_start_condition (INITIAL)
			
end
end
end
end
end
else
if yy_act <= 75 then
if yy_act <= 63 then
if yy_act <= 57 then
if yy_act <= 54 then
if yy_act <= 52 then
if yy_act = 51 then
	yy_column := yy_column + yy_end - yy_start - yy_more_len
--|#line 399 "et_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_scanner.l' at line 399")
end

					-- Manifest string with special characters.
				last_token := E_STRING
				last_literal_start := 2
				last_literal_end := text_count - 1
				last_break_end := 0
				last_comment_end := 0
				last_et_manifest_string_value := ast_factory.new_special_manifest_string (Current)
			
else
	yy_column := yy_column + yy_end - yy_start - yy_more_len
--|#line 408 "et_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_scanner.l' at line 408")
end

					-- Manifest string with special characters.
				last_text_count := text_count
				last_literal_start := 2
				last_literal_end := last_text_count - 1
				break_kind := str_special_break
				more
				set_start_condition (BREAK)
			
end
else
if yy_act = 53 then
	yy_column := yy_column + yy_end - yy_start - yy_more_len
--|#line 417 "et_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_scanner.l' at line 417")
end

					-- Manifest string with special characters which may be made
					-- up of several lines or may include invalid characters.
					-- Keep track of current line and column.
				ms_line := line
				ms_column := column
				more
				set_start_condition (MS)
			
else
	yy_line := yy_line + 1
	yy_column := 1
--|#line 428 "et_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_scanner.l' at line 428")
end

					-- Multi-line manifest string.
				more
				set_start_condition (MSN)
			
end
end
else
if yy_act <= 56 then
if yy_act = 55 then
	yy_end := yy_start + yy_more_len + 2
	yy_column := yy_column + 2
--|#line 433 "et_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_scanner.l' at line 433")
end

					-- Multi-line manifest string.

					-- Syntax error: no space allowed after character
					-- % at end of line in multi-line manifest strings.
				column := yy_column - 1
				line := yy_line
				error_handler.report_SSNS_error (filename, current_position)
				column := ms_column
				line := ms_line
				more
				set_start_condition (MSN1)
			
else
	yy_column := yy_column + yy_end - yy_start - yy_more_len
--|#line 446 "et_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_scanner.l' at line 446")
end

				more
			
end
else
	yy_column := yy_column + yy_end - yy_start - yy_more_len
--|#line 449 "et_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_scanner.l' at line 449")
end

					-- Syntax error: missing character / at end of special
					-- character specification %/code/ in manifest string.
				column := yy_column
				line := yy_line
				error_handler.report_SSAS_error (filename, current_position)
				column := ms_column
				line := ms_line
				more
			
end
end
else
if yy_act <= 60 then
if yy_act <= 59 then
if yy_act = 58 then
	yy_column := yy_column + 2
--|#line 459 "et_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_scanner.l' at line 459")
end

					-- Syntax error: missing ASCII code in special character
					-- specification %/code/ in manifest string.
				column := yy_column
				line := yy_line
				error_handler.report_SSAC_error (filename, current_position)
				column := ms_column
				line := ms_line
				more
			
else
	yy_column := yy_column + 2
--|#line 469 "et_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_scanner.l' at line 469")
end

					-- Syntax error: special character specification
					-- %l where l is a letter code should be in
					-- upper-case in manifest strings.
				column := yy_column - 1
				line := yy_line
				error_handler.report_SSCU_error (filename, current_position)
				column := ms_column
				line := ms_line
				more
			
end
else
	yy_column := yy_column + yy_end - yy_start - yy_more_len
--|#line 480 "et_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_scanner.l' at line 480")
end

				more
			
end
else
if yy_act <= 62 then
if yy_act = 61 then
	yy_column := yy_column + yy_end - yy_start - yy_more_len
--|#line 483 "et_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_scanner.l' at line 483")
end

				last_token := E_STRING
				last_literal_start := 2
				last_literal_end := text_count - 1
				last_break_end := 0
				last_comment_end := 0
				last_et_manifest_string_value := ast_factory.new_special_manifest_string (Current)
				set_start_condition (INITIAL)
			
else
	yy_column := yy_column + yy_end - yy_start - yy_more_len
--|#line 492 "et_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_scanner.l' at line 492")
end

				last_text_count := text_count
				last_literal_start := 2
				last_literal_end := last_text_count - 1
				break_kind := str_special_break
				more
				set_start_condition (BREAK)
			
end
else
	yy_column := yy_column + 2
--|#line 500 "et_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_scanner.l' at line 500")
end

					-- Syntax error: Invalid special character
					-- in manifest strings.
				column := yy_column - 1
				line := yy_line
				error_handler.report_SSSC_error (filename, current_position)
				column := ms_column
				line := ms_line
				more
			
end
end
end
else
if yy_act <= 69 then
if yy_act <= 66 then
if yy_act <= 65 then
if yy_act = 64 then
	yy_column := yy_column + 1
--|#line 510 "et_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_scanner.l' at line 510")
end

					-- Syntax error: invalid special character
					-- %l in manifest strings.
				column := yy_column
				line := yy_line
				error_handler.report_SSSC_error (filename, current_position)
				last_et_position_value := current_position
				column := ms_column
				line := ms_line
				last_token := E_STRERR
				set_start_condition (INITIAL)
			
else
	yy_line := yy_line + 1
	yy_column := 1
--|#line 522 "et_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_scanner.l' at line 522")
end

					-- Syntax error: Invalid new-line in manifest string.
				column := 1
				line := yy_line
				error_handler.report_SSNL_error (filename, current_position)
				last_et_position_value := current_position
				column := ms_column
				line := ms_line
				last_token := E_STRERR
				set_start_condition (INITIAL)
			
end
else
	yy_line := yy_line + 1
	yy_column := 1
--|#line 548 "et_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_scanner.l' at line 548")
end

				more
				set_start_condition (MSN)
			
end
else
if yy_act <= 68 then
if yy_act = 67 then
	yy_column := yy_column + 1
--|#line 552 "et_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_scanner.l' at line 552")
end

					-- Should never happen.
				last_token := E_STRERR
				last_et_position_value := current_position
				set_start_condition (INITIAL)
			
else
	yy_column := yy_column + yy_end - yy_start - yy_more_len
--|#line 567 "et_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_scanner.l' at line 567")
end

				more
				set_start_condition (MS)
			
end
else
	yy_line := yy_line + 1
	yy_column := 1
--|#line 571 "et_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_scanner.l' at line 571")
end

					-- Syntax error: empty line in middle of
					-- multi-line manifest string.
				column := 1
				line := yy_line - 1
				error_handler.report_SSEL_error (filename, current_position)
				column := ms_column
				line := ms_line
				more
			
end
end
else
if yy_act <= 72 then
if yy_act <= 71 then
if yy_act = 70 then
	yy_column := yy_column + 1
--|#line 581 "et_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_scanner.l' at line 581")
end

					-- Syntax error: missing character % at beginning
					-- of line in multi-line manifest string.
				column := yy_column - 1
				line := yy_line
				error_handler.report_SSNP_error (filename, current_position)
				last_et_position_value := current_position
				column := ms_column
				line := ms_line
				last_token := E_STRERR
				set_start_condition (INITIAL)
			
else
	yy_column := yy_column + yy_end - yy_start - yy_more_len
--|#line 610 "et_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_scanner.l' at line 610")
end

				last_token := E_BIT
				last_literal_start := 1
				last_literal_end := text_count
				last_break_end := 0
				last_comment_end := 0
				last_et_bit_constant_value := ast_factory.new_bit_constant (Current)
			
end
else
	yy_column := yy_column + yy_end - yy_start - yy_more_len
--|#line 618 "et_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_scanner.l' at line 618")
end

				last_text_count := text_count
				last_literal_start := 1
				last_literal_end := last_text_count
				break_kind := bit_break
				more
				set_start_condition (BREAK)
			
end
else
if yy_act <= 74 then
if yy_act = 73 then
	yy_column := yy_column + yy_end - yy_start - yy_more_len
--|#line 630 "et_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_scanner.l' at line 630")
end

				last_token := E_INTEGER
				last_literal_start := 1
				last_literal_end := text_count
				last_break_end := 0
				last_comment_end := 0
				last_et_integer_constant_value := ast_factory.new_regular_integer_constant (Current)
			
else
	yy_column := yy_column + yy_end - yy_start - yy_more_len
--|#line 638 "et_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_scanner.l' at line 638")
end

				last_text_count := text_count
				last_literal_start := 1
				last_literal_end := last_text_count
				break_kind := integer_break
				more
				set_start_condition (BREAK)
			
end
else
	yy_column := yy_column + yy_end - yy_start - yy_more_len
--|#line 646 "et_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_scanner.l' at line 646")
end

				last_token := E_INTEGER
				last_literal_start := 1
				last_literal_end := text_count
				last_break_end := 0
				last_comment_end := 0
				last_et_integer_constant_value := ast_factory.new_underscored_integer_constant (Current)
			
end
end
end
end
else
if yy_act <= 87 then
if yy_act <= 81 then
if yy_act <= 78 then
if yy_act <= 77 then
if yy_act = 76 then
	yy_column := yy_column + yy_end - yy_start - yy_more_len
--|#line 654 "et_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_scanner.l' at line 654")
end

					-- Syntax error: an underscore may not be
					-- the first character of an integer.
				error_handler.report_SIFU_error (filename, current_position)
				last_token := E_INTEGER
				last_literal_start := 1
				last_literal_end := text_count
				last_break_end := 0
				last_comment_end := 0
				last_et_integer_constant_value := ast_factory.new_underscored_integer_constant (Current)
			
else
	yy_column := yy_column + yy_end - yy_start - yy_more_len
--|#line 665 "et_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_scanner.l' at line 665")
end

					-- Syntax error: an underscore must be followed
					-- by three digits and there must not be any
					-- consecutive group of four digits.
				error_handler.report_SITD_error (filename, current_position)
				last_token := E_INTEGER
				last_literal_start := 1
				last_literal_end := text_count
				last_break_end := 0
				last_comment_end := 0
				last_et_integer_constant_value := ast_factory.new_underscored_integer_constant (Current)
			
end
else
	yy_column := yy_column + yy_end - yy_start - yy_more_len
--|#line 677 "et_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_scanner.l' at line 677")
end

				last_text_count := text_count
				last_literal_start := 1
				last_literal_end := last_text_count
				break_kind := uinteger_break
				more
				set_start_condition (BREAK)
			
end
else
if yy_act <= 80 then
if yy_act = 79 then
	yy_column := yy_column + yy_end - yy_start - yy_more_len
--|#line 685 "et_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_scanner.l' at line 685")
end

				last_token := E_INTEGER
				last_literal_start := 1
				last_literal_end := text_count
				last_break_end := 0
				last_comment_end := 0
				last_et_integer_constant_value := ast_factory.new_hexadecimal_integer_constant (Current)
			
else
	yy_column := yy_column + yy_end - yy_start - yy_more_len
--|#line 693 "et_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_scanner.l' at line 693")
end

				last_text_count := text_count
				last_literal_start := 1
				last_literal_end := last_text_count
				break_kind := hinteger_break
				more
				set_start_condition (BREAK)
			
end
else
	yy_column := yy_column + yy_end - yy_start - yy_more_len
--|#line 705 "et_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_scanner.l' at line 705")
end

				last_text_count := text_count
				last_literal_start := 1
				last_literal_end := last_text_count
				break_kind := real_break
				more
				set_start_condition (BREAK)
			
end
end
else
if yy_act <= 84 then
if yy_act <= 83 then
if yy_act = 82 then
	yy_column := yy_column + yy_end - yy_start - yy_more_len
--|#line 706 "et_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_scanner.l' at line 706")
end

				last_text_count := text_count
				last_literal_start := 1
				last_literal_end := last_text_count
				break_kind := real_break
				more
				set_start_condition (BREAK)
			
else
	yy_column := yy_column + yy_end - yy_start - yy_more_len
--|#line 707 "et_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_scanner.l' at line 707")
end

				last_text_count := text_count
				last_literal_start := 1
				last_literal_end := last_text_count
				break_kind := real_break
				more
				set_start_condition (BREAK)
			
end
else
	yy_end := yy_end - 1
	yy_column := yy_column + yy_end - yy_start - yy_more_len
--|#line 715 "et_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_scanner.l' at line 715")
end

		-- The first regexp of this group uses a trailing context
		-- to make sure that an integer followed by two dots is
		-- not recognized as a real followed by a dot.
				last_token := E_REAL
				last_literal_start := 1
				last_literal_end := text_count
				last_break_end := 0
				last_comment_end := 0
				last_et_real_constant_value := ast_factory.new_regular_real_constant (Current)
			
end
else
if yy_act <= 86 then
if yy_act = 85 then
	yy_column := yy_column + yy_end - yy_start - yy_more_len
--|#line 716 "et_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_scanner.l' at line 716")
end

		-- The first regexp of this group uses a trailing context
		-- to make sure that an integer followed by two dots is
		-- not recognized as a real followed by a dot.
				last_token := E_REAL
				last_literal_start := 1
				last_literal_end := text_count
				last_break_end := 0
				last_comment_end := 0
				last_et_real_constant_value := ast_factory.new_regular_real_constant (Current)
			
else
	yy_column := yy_column + yy_end - yy_start - yy_more_len
--|#line 717 "et_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_scanner.l' at line 717")
end

		-- The first regexp of this group uses a trailing context
		-- to make sure that an integer followed by two dots is
		-- not recognized as a real followed by a dot.
				last_token := E_REAL
				last_literal_start := 1
				last_literal_end := text_count
				last_break_end := 0
				last_comment_end := 0
				last_et_real_constant_value := ast_factory.new_regular_real_constant (Current)
			
end
else
	yy_column := yy_column + yy_end - yy_start - yy_more_len
--|#line 728 "et_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_scanner.l' at line 728")
end

				last_text_count := text_count
				last_literal_start := 1
				last_literal_end := last_text_count
				break_kind := ureal_break
				more
				set_start_condition (BREAK)
			
end
end
end
else
if yy_act <= 93 then
if yy_act <= 90 then
if yy_act <= 89 then
if yy_act = 88 then
	yy_column := yy_column + yy_end - yy_start - yy_more_len
--|#line 729 "et_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_scanner.l' at line 729")
end

				last_text_count := text_count
				last_literal_start := 1
				last_literal_end := last_text_count
				break_kind := ureal_break
				more
				set_start_condition (BREAK)
			
else
	yy_column := yy_column + yy_end - yy_start - yy_more_len
--|#line 730 "et_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_scanner.l' at line 730")
end

				last_text_count := text_count
				last_literal_start := 1
				last_literal_end := last_text_count
				break_kind := ureal_break
				more
				set_start_condition (BREAK)
			
end
else
	yy_end := yy_end - 1
	yy_column := yy_column + yy_end - yy_start - yy_more_len
--|#line 738 "et_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_scanner.l' at line 738")
end

		-- The first regexp of this group uses a trailing context
		-- to make sure that an integer followed by two dots is
		-- not recognized as a real followed by a dot.
				last_token := E_REAL
				last_literal_start := 1
				last_literal_end := text_count
				last_break_end := 0
				last_comment_end := 0
				last_et_real_constant_value := ast_factory.new_underscored_real_constant (Current)
			
end
else
if yy_act <= 92 then
if yy_act = 91 then
	yy_column := yy_column + yy_end - yy_start - yy_more_len
--|#line 739 "et_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_scanner.l' at line 739")
end

		-- The first regexp of this group uses a trailing context
		-- to make sure that an integer followed by two dots is
		-- not recognized as a real followed by a dot.
				last_token := E_REAL
				last_literal_start := 1
				last_literal_end := text_count
				last_break_end := 0
				last_comment_end := 0
				last_et_real_constant_value := ast_factory.new_underscored_real_constant (Current)
			
else
	yy_column := yy_column + yy_end - yy_start - yy_more_len
--|#line 740 "et_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_scanner.l' at line 740")
end

		-- The first regexp of this group uses a trailing context
		-- to make sure that an integer followed by two dots is
		-- not recognized as a real followed by a dot.
				last_token := E_REAL
				last_literal_start := 1
				last_literal_end := text_count
				last_break_end := 0
				last_comment_end := 0
				last_et_real_constant_value := ast_factory.new_underscored_real_constant (Current)
			
end
else
yy_set_line_column
--|#line 755 "et_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_scanner.l' at line 755")
end

				last_literal_start := 1
				last_literal_end := 0
				last_text_count := 0
				last_break_end := text_count
				last_comment_end := 0
				last_et_break_value := ast_factory.new_break (Current)
				last_token := E_BREAK
			
end
end
else
if yy_act <= 96 then
if yy_act <= 95 then
if yy_act = 94 then
yy_set_line_column
--|#line 765 "et_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_scanner.l' at line 765")
end

				last_literal_start := 1
				last_literal_end := 0
				last_text_count := 0
				last_break_end := 0
				last_comment_end := text_count
				last_et_break_value := ast_factory.new_comment (Current)
				last_token := E_BREAK
			
else
yy_set_line_column
--|#line 776 "et_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_scanner.l' at line 776")
end

				last_break_end := text_count
				last_comment_end := 0
				process_break
				set_start_condition (INITIAL)
			
end
else
yy_set_line_column
--|#line 782 "et_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_scanner.l' at line 782")
end

				last_break_end := 0
				last_comment_end := text_count
				process_break
				set_start_condition (INITIAL)
			
end
else
if yy_act <= 98 then
if yy_act = 97 then
	yy_column := yy_column + 1
--|#line 788 "et_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_scanner.l' at line 788")
end

					-- Should never happen.
				less (0)
				last_break_end := 0
				last_comment_end := 0
				process_break
				set_start_condition (INITIAL)
			
else
	yy_column := yy_column + 1
--|#line 809 "et_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_scanner.l' at line 809")
end

				last_token := E_UNKNOWN
				last_et_position_value := current_position
			
end
else
yy_set_line_column
--|#line 0 "et_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_scanner.l' at line 0")
end
last_token := yyError_token
fatal_error ("scanner jammed")
end
end
end
end
end
end
		end

	yy_execute_eof_action (yy_sc: INTEGER) is
			-- Execute EOF semantic action.
		do
			inspect yy_sc
when 0 then
--|#line 0 "et_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_scanner.l' at line 0")
end
terminate
when 1 then
--|#line 0 "et_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_scanner.l' at line 0")
end

					-- Should never happen.
				last_break_end := 0
				last_comment_end := 0
				process_break
				set_start_condition (INITIAL)
			
when 2 then
--|#line 0 "et_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_scanner.l' at line 0")
end

					-- Syntax error: missing double quote at
					-- end of manifest string.
				column := yy_column
				line := yy_line
				error_handler.report_SSEQ_error (filename, current_position)
				last_et_position_value := current_position
				column := ms_column
				line := ms_line
				last_token := E_STRERR
				set_start_condition (INITIAL)
			
when 3 then
--|#line 0 "et_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_scanner.l' at line 0")
end

					-- Syntax error: missing character % at beginning
					-- of line in multi-line manifest string.
				column := yy_column
				line := yy_line
				error_handler.report_SSNP_error (filename, current_position)
				last_et_position_value := current_position
				column := ms_column
				line := ms_line
				last_token := E_STRERR
				set_start_condition (INITIAL)
			
when 4 then
--|#line 0 "et_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_scanner.l' at line 0")
end

					-- Should never happen.
				last_token := E_STRERR
				last_et_position_value := current_position
				set_start_condition (INITIAL)
			
when 5 then
--|#line 0 "et_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_scanner.l' at line 0")
end

					-- No final bracket-double-quote.
				last_token := E_STRERR
				last_et_position_value := current_position
				set_start_condition (INITIAL)
			
when 6 then
--|#line 0 "et_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_scanner.l' at line 0")
end

					-- No final bracket-double-quote.
				last_token := E_STRERR
				last_et_position_value := current_position
				set_start_condition (INITIAL)
			
when 7 then
--|#line 0 "et_eiffel_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_eiffel_scanner.l' at line 0")
end

					-- No final bracket-double-quote.
				last_token := E_STRERR
				last_et_position_value := current_position
				set_start_condition (INITIAL)
			
			else
				terminate
			end
		end

feature {NONE} -- Table templates

	yy_nxt_template: ANY is
			-- This is supposed to be "like FIXED_INTEGER_ARRAY_TYPE",
			-- but once functions cannot be declared with anchored types.
		once
			Result := yy_fixed_array (<<
			    0,   18,   19,   20,   19,   21,   22,   23,   18,   24,
			   25,   21,   21,   21,   26,   27,   28,   29,   30,   31,
			   32,   33,   21,   34,   35,   36,   36,   36,   36,   36,
			   36,   36,   37,   36,   21,   38,   21,   39,   36,   36,
			   36,   36,   36,   41,   42,   41,   41,   42,   41,   45,
			   65,   66,   46,  317,   47,   43,   45,  314,   43,   46,
			  309,   47,   49,   50,   49,   49,   50,   49,   51,   65,
			   66,   51,   53,   54,   53,   53,   54,   53,   56,   57,
			   56,   56,   57,   56,   59,   60,   61,  300,   62,   59,
			   60,   61,  292,   62,   67,   67,   67,   67,   67,   67,

			   69,   69,   69,   80,   80,   80,   68,  303,   82,   68,
			   83,  155,   70,   72,   73,   74,   73,  276,   63,   77,
			   77,   77,  156,   63,   84,   84,   84,  135,  136,   78,
			   78,   78,   69,   69,   69,  292,   85,   69,   69,   69,
			  106,   75,  107,  291,   70,   86,   69,   69,   69,   70,
			  257,   86,   86,  250,  117,  118,  117,   86,   70,   86,
			  119,   87,   87,   87,   88,   88,   88,  100,  100,  100,
			   69,   69,   69,   69,   69,   69,   89,   90,  241,   91,
			   91,   92,   70,  125,  126,   70,  127,  101,   93,   86,
			   86,  137,  136,   86,   86,   94,   69,   69,   69,   95,

			  177,   93,   88,   88,   88,  120,  121,  120,   70,   96,
			   96,   96,  135,  136,   89,   90,   86,   92,   92,   92,
			  269,   97,   96,   96,   96,   98,  102,  102,  102,  102,
			  102,  102,  237,   72,   97,   74,   98,   95,  103,  137,
			  136,  103,  108,  108,  108,  122,  123,  122,   67,   67,
			   67,   99,  125,  132,  109,  133,  106,  124,  107,  249,
			   68,   75,   99,  110,  111,  112,  113,  110,  114,  110,
			  114,  110,  114,  114,  110,  110,  110,  110,  115,  110,
			  110,  110,  110,  114,  110,  114,  110,  114,  114,  114,
			  110,  110,  114,  114,  110,  110,  110,  110,  110,  110,

			  116,  116,  116,  116,  116,  128,  125,  129,  248,  127,
			  128,  131,  129,  219,  127,   69,   69,   69,  139,  139,
			  139,  178,   71,  213,   71,   98,  141,   70,   74,  221,
			  140,  145,  146,  145,  178,   72,   98,   74,  190,  130,
			  147,  147,  147,  186,  130,  149,  149,  149,   80,   80,
			   80,  170,  170,  170,  142,  153,  153,  153,  157,  157,
			  157,  174,  171,   75,  169,  169,  170,  154,  205,  159,
			  158,  159,  159,  159,  100,  100,  100,  171,  171,  171,
			  320,  200,  179,  160,  188,  199,  161,  161,  161,  172,
			  100,  100,  100,  180,  100,  189,  106,  162,  107,  102,

			  102,  102,  108,  108,  108,  197,  163,  165,  165,  165,
			  101,  103,  139,  108,  109,  182,  183,  182,  192,  166,
			   74,  155,  167,  167,  167,  182,  184,  182,  185,  185,
			  185,  181,  156,  168,  174,  174,  174,  117,  118,  117,
			  120,  121,  120,  119,  125,  126,  175,  127,  104,  176,
			  176,  176,  122,  123,  122,  131,  126,   96,  127,  128,
			  125,  129,   88,  127,  128,  131,  129,  179,  127,  177,
			  125,  132,  150,  133,  241,  124,  131,  132,  180,  133,
			  188,  124,  186,  186,  186,  190,  190,  190,  193,  193,
			  193,  189,  152,  130,  187,  150,  177,  191,  130,  145,

			  146,  145,  106,  141,  107,   74,  145,  146,  145,  144,
			   72,  138,   74,  194,  194,  194,  195,  195,  195,  201,
			  201,  201,  204,  204,  204,  197,   85,  104,  196,   86,
			  320,  142,  198,  198,  198,  153,  153,  153,   75,  155,
			  155,  155,  157,  157,  157,  320,  320,  154,  211,  211,
			  212,   68,  202,  202,  158,  320,  203,  203,  203,  159,
			  159,  159,  209,  209,  320,  320,  210,  210,  210,  216,
			  320,  160,   98,  225,  206,  206,  206,  212,  212,  212,
			  213,  213,  213,   98,  226,  207,  215,  215,  215,  177,
			  177,  177,  214,  265,  208,  179,  179,  179,  217,  217,

			  217,  182,  183,  182,  188,  188,  188,  103,  218,  185,
			  185,  185,  219,  219,  219,   95,   70,  143,  193,  193,
			  193,  195,  195,  195,  220,  222,  222,  222,  224,  198,
			  198,  198,  227,  196,  229,  229,  229,  223,  203,  203,
			  203,  320,  320,  228,  159,  159,  159,  232,  232,  232,
			  233,  233,  233,  236,  236,  236,  160,  320,  320,  230,
			  230,  230,  234,  234,  320,  320,  235,  235,  235,  210,
			  210,  210,  242,  242,  242,  105,  217,  217,  217,  231,
			  237,  237,  237,  246,  320,  320,  243,  243,  243,  320,
			  244,  320,  238,  320,  247,  239,  239,  239,  245,  222,

			  222,  222,  225,  225,  225,  225,  227,  227,  227,  227,
			  320,  223,  320,  320,  154,  240,  226,  320,  158,  320,
			  228,  250,  250,  250,  253,  253,  253,  254,  254,  254,
			  255,  255,  255,  251,  246,  270,  229,  229,  229,  256,
			  256,  256,  235,  235,  235,  247,  271,  252,  257,  257,
			  257,  261,  261,  261,  262,  262,  262,  263,  263,  263,
			  258,  320,  320,  259,  259,  259,  266,  266,  266,  320,
			  267,  272,  272,  272,  320,  246,  246,  246,  268,  274,
			  274,  274,  320,  260,  165,  165,  165,  196,  273,  273,
			  320,  320,  274,  274,  274,  320,  166,  270,  320,  256,

			  256,  256,  275,  275,  275,  276,  276,  276,  271,  320,
			  264,  256,  256,  256,  280,  280,  280,  277,  281,  281,
			  281,  320,  279,  282,  282,  282,  283,  283,  283,  320,
			  320,  278,  284,  284,  284,  320,  320,  285,  285,  320,
			  163,  283,  283,  283,  287,  287,  287,  274,  274,  274,
			  266,  266,  266,  320,  267,  320,  288,  320,  320,  289,
			  289,  289,  268,  270,  270,  270,  293,  293,  293,  320,
			  290,  297,  297,  297,  320,  223,  250,  250,  250,  294,
			  294,  320,  320,  295,  295,  295,  320,  320,  251,  320,
			  320,  274,  274,  274,  296,  296,  320,  320,  297,  297,

			  297,  298,  298,  298,  276,  276,  276,  302,  302,  302,
			  283,  283,  283,  305,  305,  320,  277,  306,  306,  306,
			  292,  292,  292,  320,  307,  320,  276,  276,  276,  320,
			  299,  320,  268,  295,  295,  295,  320,  320,  277,  208,
			  300,  300,  300,  297,  297,  297,  311,  311,  311,  282,
			  282,  282,  301,  320,  320,  283,  283,  283,  276,  276,
			  276,  231,  312,  312,  320,  320,  313,  313,  313,  320,
			  277,  320,  320,  304,  304,  304,  320,  314,  314,  314,
			  306,  306,  306,  320,  299,  293,  293,  293,  320,  315,
			  317,  317,  317,  208,  276,  276,  276,  313,  313,  313,

			  320,  320,  318,  302,  302,  302,  277,  320,  320,  308,
			  308,  308,  240,  311,  311,  311,  173,  173,  173,  320,
			  320,  173,  173,  173,  320,  260,  320,  320,  320,  231,
			  309,  309,  309,  320,  320,  320,  320,  320,  320,  320,
			  320,  320,  310,  320,  320,  297,  297,  297,  314,  314,
			  314,  320,  320,  320,  320,  320,  320,  320,  320,  320,
			  315,  320,  320,  316,  316,  316,  320,  320,  320,  320,
			  320,  320,  320,  320,  320,  320,  320,  320,  320,  320,
			  320,  320,  320,  240,  317,  317,  317,  320,  320,  320,
			  320,  320,  320,  320,  320,  320,  318,  320,  320,  319,

			  319,  319,  320,  320,  320,  320,  320,  320,  320,  320,
			  320,  320,  320,  320,  320,  320,  320,  320,  320,  260,
			   40,   40,   40,   40,   40,   40,   40,   40,   40,   40,
			   40,   40,   40,   40,   40,   40,   40,   40,   40,   40,
			   40,   40,   40,   40,   44,   44,   44,   44,   44,   44,
			   44,   44,   44,   44,   44,   44,   44,   44,   44,   44,
			   44,   44,   44,   44,   44,   44,   44,   44,   48,   48,
			   48,   48,   48,   48,   48,   48,   48,   48,   48,   48,
			   48,   48,   48,   48,   48,   48,   48,   48,   48,   48,
			   48,   48,   52,   52,   52,   52,   52,   52,   52,   52,

			   52,   52,   52,   52,   52,   52,   52,   52,   52,   52,
			   52,   52,   52,   52,   52,   52,   55,   55,   55,   55,
			   55,   55,   55,   55,   55,   55,   55,   55,   55,   55,
			   55,   55,   55,   55,   55,   55,   55,   55,   55,   55,
			   58,   58,   58,   58,   58,   58,   58,   58,   58,   58,
			   58,   58,   58,   58,   58,   58,   58,   58,   58,   58,
			   58,   58,   58,   58,   64,   64,   64,   64,   64,   64,
			   64,   64,   64,   64,   64,   64,   64,   64,   64,   64,
			   64,   64,   64,   64,   64,   64,   64,   64,   71,   71,
			  320,   71,   71,   71,   71,   71,   71,   71,   71,   71,

			   71,   71,   71,   71,   71,   71,   71,   71,   71,   71,
			   71,   71,   76,   76,   76,   76,  320,  320,   76,   76,
			   76,   76,   76,   76,   76,   76,   76,   76,   76,   76,
			   76,   76,   76,   76,   76,   76,   79,   79,   79,   79,
			  320,  320,   79,   79,   79,   79,   79,   79,   79,   79,
			   79,   79,   79,   79,   79,   79,   79,   79,   79,   79,
			   81,   81,  320,   81,   81,   81,   81,   81,   81,   81,
			   81,   81,   81,   81,   81,   81,   81,   81,   81,   81,
			   81,   81,   81,   81,   98,   98,   98,  320,  320,  320,
			  320,   98,  320,   98,   98,   98,  320,  320,   98,   98,

			   98,   98,   98,   98,   98,   98,   98,  105,  105,  320,
			  105,  105,  105,  105,  105,  105,  105,  105,  105,  105,
			  105,  105,  105,  105,  105,  105,  105,  105,  105,  105,
			  105,  124,  124,  124,  124,  124,  124,  124,  124,  124,
			  124,  124,  124,  124,  124,  124,  124,  124,  124,  124,
			  124,  124,  124,  124,  124,  130,  130,  130,  130,  130,
			  130,  130,  130,  130,  130,  130,  130,  130,  130,  130,
			  130,  130,  130,  130,  130,  130,  130,  130,  130,  134,
			  134,  134,  134,  134,  134,  134,  134,  134,  134,  134,
			  134,  134,  134,  134,  134,  134,  134,  134,  134,  134,

			  134,  134,  134,   73,   73,  320,   73,   73,   73,   73,
			   73,   73,   73,   73,   73,   73,   73,   73,   73,   73,
			   73,   73,   73,   73,   73,   73,   73,  143,  143,  143,
			  143,  320,  320,  320,  320,  320,  143,  143,  143,  143,
			  143,  320,  143,  143,  148,  148,  148,  148,  320,  320,
			  148,  148,  148,  148,  320,  320,  320,  148,  148,  151,
			  151,  320,  151,  151,  151,  151,  151,  151,  151,  151,
			  151,  151,  151,  151,  151,  151,  151,  151,  151,  151,
			  151,  151,  151,   85,   85,   85,   85,   85,   85,   85,
			   85,   85,   85,   85,   85,   85,   85,   85,   85,   85,

			   85,   85,   85,   85,   85,   85,   85,  164,  164,  164,
			  164,  164,  164,  164,  164,  164,  320,  164,  164,  164,
			  164,  164,  164,  164,  164,  164,  164,  164,  164,  164,
			  164,  104,  104,  104,  104,  104,  104,  104,  104,  104,
			  104,  104,  104,  104,  104,  104,  104,  104,  104,  104,
			  104,  104,  104,  104,  104,  105,  105,  105,  105,  320,
			  320,  320,  320,  320,  105,  105,  105,  105,  105,  320,
			  105,  105,  138,  138,  138,  138,  138,  138,  138,  138,
			  138,  138,  138,  138,  138,  138,  138,  138,  138,  138,
			  138,  138,  138,  138,  138,  138,  143,  143,  320,  143,

			  143,  143,  143,  143,  143,  143,  143,  143,  143,  143,
			  143,  143,  143,  143,  143,  143,  143,  143,  143,  143,
			  148,  148,  148,  148,  320,  320,  148,  148,  148,  148,
			  148,  148,  148,  148,  148,  148,  148,  148,  148,  148,
			  148,  148,  148,  148,  199,  199,  199,  199,  199,  199,
			  199,  199,  199,  199,  199,  199,  199,  199,  199,  199,
			  199,  199,  199,  199,  199,  199,  199,  199,  200,  200,
			  200,  200,  200,  200,  200,  200,  200,  200,  200,  200,
			  200,  200,  200,  200,  200,  200,  200,  200,  200,  200,
			  200,  200,  221,  221,  221,  221,  221,  221,  221,  221,

			  221,  221,  221,  221,  221,  221,  221,  221,  221,  221,
			  221,  221,  221,  221,  221,  221,  248,  248,  248,  248,
			  248,  248,  248,  248,  248,  248,  248,  248,  248,  248,
			  248,  248,  248,  248,  248,  248,  248,  248,  248,  248,
			  286,  286,  286,  286,  286,  286,  286,  286,  286,  320,
			  286,  286,  286,  286,  286,  286,  286,  286,  286,  286,
			  286,  286,  286,  286,  291,  291,  291,  291,  291,  291,
			  291,  291,  291,  291,  291,  291,  291,  291,  291,  291,
			  291,  291,  291,  291,  291,  291,  291,  291,   17,  320,
			  320,  320,  320,  320,  320,  320,  320,  320,  320,  320,

			  320,  320,  320,  320,  320,  320,  320,  320,  320,  320,
			  320,  320,  320,  320,  320,  320,  320,  320,  320,  320,
			  320,  320,  320,  320,  320,  320,  320,  320,  320,  320,
			  320>>)
		end

	yy_chk_template: ANY is
			-- This is supposed to be "like FIXED_INTEGER_ARRAY_TYPE",
			-- but once functions cannot be declared with anchored types.
		once
			Result := yy_fixed_array (<<
			    0,    1,    1,    1,    1,    1,    1,    1,    1,    1,
			    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
			    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
			    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
			    1,    1,    1,    3,    3,    3,    4,    4,    4,    5,
			   15,   15,    5,  318,    5,    3,    6,  315,    4,    6,
			  310,    6,    7,    7,    7,    8,    8,    8,    7,   16,
			   16,    8,    9,    9,    9,   10,   10,   10,   11,   11,
			   11,   12,   12,   12,   13,   13,   13,  301,   13,   14,
			   14,   14,  291,   14,   19,   19,   19,   20,   20,   20,

			   21,   21,   21,   24,   24,   24,   19,  288,   25,   20,
			   25,   85,   21,   22,   22,   22,   22,  277,   13,   23,
			   23,   23,   85,   14,   26,   26,   26,   64,   64,   23,
			   23,   23,   32,   32,   32,  269,   26,   28,   28,   28,
			   44,   22,   44,  268,   32,   26,   27,   27,   27,   28,
			  258,   28,   32,  251,   49,   49,   49,   28,   27,   27,
			   49,   27,   27,   27,   29,   29,   29,   39,   39,   39,
			   33,   33,   33,   34,   34,   34,   29,   29,  211,   29,
			   29,   29,   33,   58,   58,   34,   58,   39,   29,   33,
			   33,   66,   66,   34,   34,   29,   35,   35,   35,   29,

			  211,   29,   31,   31,   31,   53,   53,   53,   35,   36,
			   36,   36,  134,  134,   31,   31,   35,   31,   31,   31,
			  245,   36,   37,   37,   37,   98,   41,   41,   41,   42,
			   42,   42,  238,   71,   37,   71,   98,   31,   41,  136,
			  136,   42,   46,   46,   46,   56,   56,   56,   67,   67,
			   67,   37,   63,   63,   46,   63,  105,   63,  105,  224,
			   67,   71,   37,   47,   47,   47,   47,   47,   47,   47,
			   47,   47,   47,   47,   47,   47,   47,   47,   47,   47,
			   47,   47,   47,   47,   47,   47,   47,   47,   47,   47,
			   47,   47,   47,   47,   47,   47,   47,   47,   47,   47,

			   47,   47,   47,   47,   47,   59,   59,   59,  223,   59,
			   61,   61,   61,  220,   61,   69,   69,   69,   72,   72,
			   72,   99,   73,  214,   73,   99,   73,   69,   73,  196,
			   72,   75,   75,   75,   99,   75,   99,   75,  191,   59,
			   76,   76,   76,  187,   61,   78,   78,   78,   79,   79,
			   79,   92,   92,   92,   73,   84,   84,   84,   86,   86,
			   86,  175,  172,   75,   91,   91,   91,   84,  166,  160,
			   86,   87,   87,   87,  100,  100,  100,   93,   93,   93,
			   91,  158,  104,   87,  138,  154,   87,   87,   87,   93,
			  101,  101,  101,  104,  100,  138,  114,   87,  114,  102,

			  102,  102,  106,  106,  106,  151,   87,   90,   90,   90,
			  101,  102,  140,  109,  106,  111,  111,  111,  143,   90,
			  143,  156,   90,   90,   90,  113,  113,  113,  115,  115,
			  115,  107,  156,   90,   95,   95,   95,  117,  117,  117,
			  120,  120,  120,  117,  124,  124,   95,  124,  103,   95,
			   95,   95,  122,  122,  122,  126,  126,   97,  126,  128,
			  128,  128,   89,  128,  129,  129,  129,  180,  129,   95,
			  130,  130,   83,  130,  212,  130,  132,  132,  180,  132,
			  189,  132,  133,  133,  133,  141,  141,  141,  144,  144,
			  144,  189,   82,  128,  133,   81,  212,  141,  129,  142,

			  142,  142,  218,  142,  218,  142,  145,  145,  145,   74,
			  145,   70,  145,  148,  148,  148,  150,  150,  150,  161,
			  161,  161,  163,  163,  163,  152,   68,   43,  150,   38,
			   30,  142,  152,  152,  152,  153,  153,  153,  145,  155,
			  155,  155,  157,  157,  157,   17,    0,  153,  169,  169,
			  169,  155,  162,  162,  157,    0,  162,  162,  162,  167,
			  167,  167,  168,  168,    0,    0,  168,  168,  168,  178,
			    0,  167,  178,  199,  167,  167,  167,  170,  170,  170,
			  173,  173,  173,  178,  199,  167,  176,  176,  176,  177,
			  177,  177,  173,  242,  167,  179,  179,  179,  181,  181,

			  181,  182,  182,  182,  188,  188,  188,  179,  185,  185,
			  185,  185,  192,  192,  192,  242,  188,  193,  193,  193,
			  193,  195,  195,  195,  192,  197,  197,  197,  198,  198,
			  198,  198,  200,  195,  201,  201,  201,  197,  202,  202,
			  202,    0,    0,  200,  203,  203,  203,  204,  204,  204,
			  206,  206,  206,  208,  208,  208,  203,    0,    0,  203,
			  203,  203,  207,  207,    0,    0,  207,  207,  207,  209,
			  209,  209,  215,  215,  215,  217,  217,  217,  217,  203,
			  210,  210,  210,  221,    0,    0,  216,  216,  216,    0,
			  216,    0,  210,    0,  221,  210,  210,  210,  216,  222,

			  222,  222,  225,  225,  225,  226,  227,  227,  227,  228,
			    0,  222,    0,    0,  225,  210,  226,    0,  227,    0,
			  228,  229,  229,  229,  230,  230,  230,  231,  231,  231,
			  232,  232,  232,  229,  247,  248,  229,  229,  229,  233,
			  233,  233,  234,  234,  234,  247,  248,  229,  235,  235,
			  235,  236,  236,  236,  239,  239,  239,  240,  240,  240,
			  235,    0,    0,  235,  235,  235,  243,  243,  243,    0,
			  243,  249,  249,  249,    0,  246,  246,  246,  243,  253,
			  253,  253,    0,  235,  241,  241,  241,  246,  252,  252,
			    0,    0,  252,  252,  252,    0,  241,  271,    0,  241,

			  241,  241,  254,  254,  254,  255,  255,  255,  271,    0,
			  241,  256,  256,  256,  259,  259,  259,  255,  260,  260,
			  260,    0,  256,  261,  261,  261,  262,  262,  262,    0,
			    0,  255,  263,  263,  263,    0,    0,  264,  264,    0,
			  255,  264,  264,  264,  265,  265,  265,  273,  273,  273,
			  266,  266,  266,    0,  266,    0,  265,    0,    0,  265,
			  265,  265,  266,  270,  270,  270,  275,  275,  275,    0,
			  265,  280,  280,  280,    0,  270,  274,  274,  274,  278,
			  278,    0,    0,  278,  278,  278,    0,    0,  274,    0,
			    0,  274,  274,  274,  279,  279,    0,    0,  279,  279,

			  279,  281,  281,  281,  282,  282,  282,  284,  284,  284,
			  285,  285,  285,  290,  290,    0,  282,  290,  290,  290,
			  292,  292,  292,    0,  292,    0,  293,  293,  293,    0,
			  282,    0,  292,  294,  294,  294,    0,    0,  293,  282,
			  283,  283,  283,  296,  296,  296,  298,  298,  298,  304,
			  304,  304,  283,    0,    0,  283,  283,  283,  289,  289,
			  289,  293,  299,  299,    0,    0,  299,  299,  299,    0,
			  289,    0,    0,  289,  289,  289,    0,  302,  302,  302,
			  305,  305,  305,    0,  289,  308,  308,  308,    0,  302,
			  311,  311,  311,  289,  295,  295,  295,  312,  312,  312,

			    0,    0,  311,  316,  316,  316,  295,    0,    0,  295,
			  295,  295,  302,  319,  319,  319,  343,  343,  343,    0,
			    0,  343,  343,  343,    0,  311,    0,    0,    0,  295,
			  297,  297,  297,    0,    0,    0,    0,    0,    0,    0,
			    0,    0,  297,    0,    0,  297,  297,  297,  306,  306,
			  306,    0,    0,    0,    0,    0,    0,    0,    0,    0,
			  306,    0,    0,  306,  306,  306,    0,    0,    0,    0,
			    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
			    0,    0,    0,  306,  313,  313,  313,    0,    0,    0,
			    0,    0,    0,    0,    0,    0,  313,    0,    0,  313,

			  313,  313,    0,    0,    0,    0,    0,    0,    0,    0,
			    0,    0,    0,    0,    0,    0,    0,    0,    0,  313,
			  321,  321,  321,  321,  321,  321,  321,  321,  321,  321,
			  321,  321,  321,  321,  321,  321,  321,  321,  321,  321,
			  321,  321,  321,  321,  322,  322,  322,  322,  322,  322,
			  322,  322,  322,  322,  322,  322,  322,  322,  322,  322,
			  322,  322,  322,  322,  322,  322,  322,  322,  323,  323,
			  323,  323,  323,  323,  323,  323,  323,  323,  323,  323,
			  323,  323,  323,  323,  323,  323,  323,  323,  323,  323,
			  323,  323,  324,  324,  324,  324,  324,  324,  324,  324,

			  324,  324,  324,  324,  324,  324,  324,  324,  324,  324,
			  324,  324,  324,  324,  324,  324,  325,  325,  325,  325,
			  325,  325,  325,  325,  325,  325,  325,  325,  325,  325,
			  325,  325,  325,  325,  325,  325,  325,  325,  325,  325,
			  326,  326,  326,  326,  326,  326,  326,  326,  326,  326,
			  326,  326,  326,  326,  326,  326,  326,  326,  326,  326,
			  326,  326,  326,  326,  327,  327,  327,  327,  327,  327,
			  327,  327,  327,  327,  327,  327,  327,  327,  327,  327,
			  327,  327,  327,  327,  327,  327,  327,  327,  328,  328,
			    0,  328,  328,  328,  328,  328,  328,  328,  328,  328,

			  328,  328,  328,  328,  328,  328,  328,  328,  328,  328,
			  328,  328,  329,  329,  329,  329,    0,    0,  329,  329,
			  329,  329,  329,  329,  329,  329,  329,  329,  329,  329,
			  329,  329,  329,  329,  329,  329,  330,  330,  330,  330,
			    0,    0,  330,  330,  330,  330,  330,  330,  330,  330,
			  330,  330,  330,  330,  330,  330,  330,  330,  330,  330,
			  331,  331,    0,  331,  331,  331,  331,  331,  331,  331,
			  331,  331,  331,  331,  331,  331,  331,  331,  331,  331,
			  331,  331,  331,  331,  332,  332,  332,    0,    0,    0,
			    0,  332,    0,  332,  332,  332,    0,    0,  332,  332,

			  332,  332,  332,  332,  332,  332,  332,  333,  333,    0,
			  333,  333,  333,  333,  333,  333,  333,  333,  333,  333,
			  333,  333,  333,  333,  333,  333,  333,  333,  333,  333,
			  333,  334,  334,  334,  334,  334,  334,  334,  334,  334,
			  334,  334,  334,  334,  334,  334,  334,  334,  334,  334,
			  334,  334,  334,  334,  334,  335,  335,  335,  335,  335,
			  335,  335,  335,  335,  335,  335,  335,  335,  335,  335,
			  335,  335,  335,  335,  335,  335,  335,  335,  335,  336,
			  336,  336,  336,  336,  336,  336,  336,  336,  336,  336,
			  336,  336,  336,  336,  336,  336,  336,  336,  336,  336,

			  336,  336,  336,  337,  337,    0,  337,  337,  337,  337,
			  337,  337,  337,  337,  337,  337,  337,  337,  337,  337,
			  337,  337,  337,  337,  337,  337,  337,  338,  338,  338,
			  338,    0,    0,    0,    0,    0,  338,  338,  338,  338,
			  338,    0,  338,  338,  339,  339,  339,  339,    0,    0,
			  339,  339,  339,  339,    0,    0,    0,  339,  339,  340,
			  340,    0,  340,  340,  340,  340,  340,  340,  340,  340,
			  340,  340,  340,  340,  340,  340,  340,  340,  340,  340,
			  340,  340,  340,  341,  341,  341,  341,  341,  341,  341,
			  341,  341,  341,  341,  341,  341,  341,  341,  341,  341,

			  341,  341,  341,  341,  341,  341,  341,  342,  342,  342,
			  342,  342,  342,  342,  342,  342,    0,  342,  342,  342,
			  342,  342,  342,  342,  342,  342,  342,  342,  342,  342,
			  342,  344,  344,  344,  344,  344,  344,  344,  344,  344,
			  344,  344,  344,  344,  344,  344,  344,  344,  344,  344,
			  344,  344,  344,  344,  344,  345,  345,  345,  345,    0,
			    0,    0,    0,    0,  345,  345,  345,  345,  345,    0,
			  345,  345,  346,  346,  346,  346,  346,  346,  346,  346,
			  346,  346,  346,  346,  346,  346,  346,  346,  346,  346,
			  346,  346,  346,  346,  346,  346,  347,  347,    0,  347,

			  347,  347,  347,  347,  347,  347,  347,  347,  347,  347,
			  347,  347,  347,  347,  347,  347,  347,  347,  347,  347,
			  348,  348,  348,  348,    0,    0,  348,  348,  348,  348,
			  348,  348,  348,  348,  348,  348,  348,  348,  348,  348,
			  348,  348,  348,  348,  349,  349,  349,  349,  349,  349,
			  349,  349,  349,  349,  349,  349,  349,  349,  349,  349,
			  349,  349,  349,  349,  349,  349,  349,  349,  350,  350,
			  350,  350,  350,  350,  350,  350,  350,  350,  350,  350,
			  350,  350,  350,  350,  350,  350,  350,  350,  350,  350,
			  350,  350,  351,  351,  351,  351,  351,  351,  351,  351,

			  351,  351,  351,  351,  351,  351,  351,  351,  351,  351,
			  351,  351,  351,  351,  351,  351,  352,  352,  352,  352,
			  352,  352,  352,  352,  352,  352,  352,  352,  352,  352,
			  352,  352,  352,  352,  352,  352,  352,  352,  352,  352,
			  353,  353,  353,  353,  353,  353,  353,  353,  353,    0,
			  353,  353,  353,  353,  353,  353,  353,  353,  353,  353,
			  353,  353,  353,  353,  354,  354,  354,  354,  354,  354,
			  354,  354,  354,  354,  354,  354,  354,  354,  354,  354,
			  354,  354,  354,  354,  354,  354,  354,  354,  320,  320,
			  320,  320,  320,  320,  320,  320,  320,  320,  320,  320,

			  320,  320,  320,  320,  320,  320,  320,  320,  320,  320,
			  320,  320,  320,  320,  320,  320,  320,  320,  320,  320,
			  320,  320,  320,  320,  320,  320,  320,  320,  320,  320,
			  320>>)
		end

	yy_base_template: ANY is
			-- This is supposed to be "like FIXED_INTEGER_ARRAY_TYPE",
			-- but once functions cannot be declared with anchored types.
		once
			Result := yy_fixed_array (<<
			    0,    0,    0,   41,   44,   46,   53,   60,   63,   70,
			   73,   76,   79,   82,   87,   47,   66,  545, 1888,   92,
			   95,   98,  107,  117,  101,  100,  122,  144,  135,  162,
			  497,  200,  130,  168,  171,  194,  207,  220,  494,  150,
			 1888,  224,  227,  513,  134, 1888,  240,  262, 1888,  152,
			 1888, 1888, 1888,  203, 1888, 1888,  243, 1888,  180,  303,
			 1888,  308, 1888,  249,  124, 1888,  188,  246,  512,  313,
			  497,  227,  316,  320,  493,  329,  338, 1888,  343,  346,
			 1888,  485,  476,  462,  353,  108,  356,  369, 1888,  448,
			  405,  347,  334,  375,    0,  432, 1888,  443,  194,  294,

			  357,  373,  397,  434,  379,  250,  400,  415, 1888,  399,
			 1888,  413, 1888,  423,  390,  411, 1888,  435, 1888, 1888,
			  438, 1888,  450, 1888,  441, 1888,  452, 1888,  457,  462,
			  467, 1888,  473,  480,  209, 1888,  236, 1888,  381, 1888,
			  398,  483,  497,  412,  471,  504, 1888, 1888,  511, 1888,
			  514,  395,  515,  533,  371,  537,  418,  540,  367, 1888,
			  355,  502,  539,  505, 1888, 1888,  354,  557,  549,  531,
			  560, 1888,  348,  578, 1888,  347,  569,  572,  541,  593,
			  464,  581,  599, 1888, 1888,  592, 1888,  329,  602,  477,
			 1888,  324,  610,  601, 1888,  619,  315,  623,  612,  570,

			  629,  617,  621,  642,  630, 1888,  633,  649,  636,  652,
			  678,  163,  459, 1888,  309,  655,  684,  659,  496, 1888,
			  299,  680,  697,  294,  249,  700,  702,  704,  706,  719,
			  707,  710,  713,  722,  725,  746,  734, 1888,  218,  737,
			  740,  782,  578,  764, 1888,  206,  773,  731,  732,  769,
			 1888,  139,  775,  762,  785,  803,  794, 1888,  136,  797,
			  801,  806,  809,  815,  824,  842,  848, 1888,  129,  132,
			  861,  794, 1888,  830,  874,  849, 1888,  103,  866,  881,
			  854,  884,  902,  938,  890,  893, 1888, 1888,   93,  956,
			  900,   89,  918,  924,  916,  992,  926, 1028,  929,  949,

			 1888,   73,  975, 1888,  932,  963, 1046, 1888,  968, 1888,
			   46,  988,  980, 1082, 1888,   43,  986, 1888,   39,  996,
			 1888, 1119, 1143, 1167, 1191, 1215, 1239, 1263, 1287, 1311,
			 1335, 1359, 1382, 1406, 1430, 1454, 1478, 1502, 1522, 1543,
			 1558, 1582, 1606, 1005, 1630, 1650, 1671, 1695, 1719, 1743,
			 1767, 1791, 1815, 1839, 1863>>)
		end

	yy_def_template: ANY is
			-- This is supposed to be "like FIXED_INTEGER_ARRAY_TYPE",
			-- but once functions cannot be declared with anchored types.
		once
			Result := yy_fixed_array (<<
			    0,  320,    1,  321,  321,  322,  322,  323,  323,  324,
			  324,  325,  325,  326,  326,  327,  327,  320,  320,  320,
			  320,  320,  328,  329,  330,  331,  320,  320,  320,  320,
			   29,  320,  320,  320,  320,  320,  332,  332,  320,  320,
			  320,  320,  320,  320,  333,  320,  320,  320,  320,  320,
			  320,  320,  320,  320,  320,  320,  320,  320,  334,  334,
			  320,  334,  320,  335,  336,  320,  336,  320,  320,  320,
			  320,  328,  320,  337,  338,  328,  329,  320,  339,  330,
			  320,  320,  340,  320,  320,  341,  320,  320,  320,  320,
			  342,   29,   31,  320,  343,  320,  320,  320,   37,   37,

			   95,  320,  320,  320,  344,  333,  320,  345,  320,  320,
			  320,  320,  320,  320,  333,  320,  320,  320,  320,  320,
			  320,  320,  320,  320,  334,  320,  334,  320,  334,  334,
			  335,  320,  335,  320,  336,  320,  336,  320,  346,  320,
			  320,  320,  337,  347,  320,  328,  320,  320,  348,  320,
			  320,  320,  320,  320,  320,  320,  341,  320,  320,  320,
			  320,   87,  320,  320,  320,  320,  320,  320,  320,   91,
			   92,  320,  320,  343,  320,  320,   95,  176,   37,  320,
			  344,  320,  320,  320,  320,  320,  320,  320,  320,  346,
			  320,  320,  320,  320,  320,  320,  320,  320,  320,  349,

			  350,  161,  320,  320,  320,  320,  167,  320,  320,  320,
			  320,  169,  170,  320,  320,  177,  332,  320,  333,  320,
			  320,  351,  320,  320,  320,  320,  349,  320,  350,  320,
			  203,  320,  320,  206,  320,  320,  320,  320,  320,  210,
			  320,  342,  177,  320,  320,  320,  320,  351,  352,  320,
			  320,  320,  320,  230,  320,  320,  229,  320,  320,  235,
			  320,  320,  239,  320,  320,  353,  320,  320,  320,  354,
			  320,  352,  320,  320,  320,  320,  320,  320,  320,  320,
			  259,  320,  320,  320,  320,  320,  320,  320,  320,  320,
			  320,  354,  320,  320,  320,  320,  320,  320,  320,  320,

			  320,  320,  320,  320,  289,  320,  320,  320,  295,  320,
			  320,  320,  320,  320,  320,  320,  306,  320,  320,  313,
			    0,  320,  320,  320,  320,  320,  320,  320,  320,  320,
			  320,  320,  320,  320,  320,  320,  320,  320,  320,  320,
			  320,  320,  320,  320,  320,  320,  320,  320,  320,  320,
			  320,  320,  320,  320,  320>>)
		end

	yy_ec_template: ANY is
			-- This is supposed to be "like FIXED_INTEGER_ARRAY_TYPE",
			-- but once functions cannot be declared with anchored types.
		once
			Result := yy_fixed_array (<<
			    0,    1,    1,    1,    1,    1,    1,    1,    1,    2,
			    3,    1,    1,    4,    1,    1,    1,    1,    1,    1,
			    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
			    1,    1,    2,    5,    6,    7,    5,    8,    9,   10,
			   11,   11,   12,   13,    5,   14,   15,   16,   17,   18,
			   19,   19,   19,   19,   19,   19,   19,   19,   20,    5,
			   21,   22,   23,   24,    9,   25,   26,   27,   25,   28,
			   25,   29,   30,   29,   29,   29,   30,   29,   31,   32,
			   29,   30,   30,   30,   30,   30,   30,   29,   33,   29,
			   29,   34,   35,   36,    5,   37,    1,   38,   39,   40,

			   38,   28,   38,   29,   41,   29,   29,   29,   41,   29,
			   42,   32,   29,   41,   41,   41,   41,   41,   41,   29,
			   33,   29,   29,    5,    9,    5,    5,    1,    1,    1,
			    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
			    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
			    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
			    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
			    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
			    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
			    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,

			    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
			    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
			    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
			    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
			    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
			    1,    1,    1,    1,    1,    1,    1>>)
		end

	yy_meta_template: ANY is
			-- This is supposed to be "like FIXED_INTEGER_ARRAY_TYPE",
			-- but once functions cannot be declared with anchored types.
		once
			Result := yy_fixed_array (<<
			    0,    1,    2,    3,    4,    1,    5,    1,    6,    1,
			    7,    8,    1,    1,    9,   10,    7,   11,   12,   13,
			    1,   14,    1,   15,    1,   16,   17,   18,   11,   19,
			   20,   21,   22,   23,    1,    1,    1,   24,   11,   11,
			   11,   19,   19>>)
		end

	yy_accept_template: ANY is
			-- This is supposed to be "like FIXED_INTEGER_ARRAY_TYPE",
			-- but once functions cannot be declared with anchored types.
		once
			Result := yy_fixed_array (<<
			    0,    1,    1,    1,    1,    1,    1,    1,    1,    1,
			    1,    1,    1,    1,    2,    3,    4,    5,    6,    8,
			   12,   15,   18,   21,   24,   27,   30,   33,   36,   39,
			   45,   51,   57,   60,   63,   66,   69,   73,   77,   79,
			   81,   83,   87,   90,   92,   94,   96,   99,  101,  103,
			  105,  107,  110,  112,  114,  116,  118,  120,  122,  124,
			  126,  128,  130,  132,  134,  136,  138,  140,  142,  142,
			  144,  144,  145,  149,  150,  150,  152,  153,  154,  155,
			  156,  157,  158,  159,  161,  162,  163,  164,  168,  170,
			  170,  171,  175,  179,  181,  181,  183,  184,  184,  186,

			  188,  191,  192,  194,  194,  195,  196,  198,  198,  199,
			  199,  200,  201,  202,  203,  205,  207,  209,  209,  210,
			  211,  211,  212,  212,  213,  214,  215,  216,  217,  218,
			  219,  220,  222,  223,  226,  227,  228,  229,  231,  232,
			  234,  234,  240,  242,  243,  243,  244,  245,  246,  247,
			  248,  249,  250,  252,  254,  254,  255,  256,  258,  258,
			  260,  260,  264,  264,  264,  265,  267,  268,  272,  273,
			  277,  281,  282,  282,  284,  285,  285,  287,  289,  291,
			  292,  293,  293,  293,  294,  296,  297,  298,  298,  299,
			  300,  303,  303,  305,  305,  306,  308,  308,  309,  310,

			  311,  312,  316,  316,  320,  320,  321,  325,  325,  325,
			  325,  329,  333,  337,  338,  338,  340,  342,  342,  344,
			  345,  345,  346,  348,  348,  349,  350,  351,  352,  353,
			  355,  359,  359,  359,  363,  363,  371,  371,  373,  373,
			  377,  377,  378,  381,  382,  383,  383,  384,  385,  386,
			  387,  388,  388,  388,  392,  392,  394,  396,  400,  400,
			  408,  408,  408,  412,  412,  413,  414,  414,  416,  416,
			  417,  418,  419,  420,  420,  422,  422,  423,  423,  423,
			  423,  431,  431,  433,  435,  435,  435,  436,  438,  439,
			  441,  442,  442,  442,  444,  444,  446,  446,  450,  450,

			  450,  451,  451,  453,  454,  456,  456,  458,  459,  461,
			  463,  463,  467,  467,  471,  472,  472,  474,  476,  476,
			  480,  480>>)
		end

	yy_acclist_template: ANY is
			-- This is supposed to be "like FIXED_INTEGER_ARRAY_TYPE",
			-- but once functions cannot be declared with anchored types.
		once
			Result := yy_fixed_array (<<
			    0,   47,   47,   50,   50,  100,   98,   99,   93,   94,
			   98,   99,   93,   94,   99,    1,   98,   99,   53,   98,
			   99,   13,   98,   99,   17,   98,   99,   34,   98,   99,
			    1,   98,   99,    1,   98,   99,    1,   98,   99,   73,
			   77,   98,   99, -173, -177,   73,   77,   98,   99, -173,
			 -177,   73,   77,   98,   99, -173, -177,    1,   98,   99,
			    1,   98,   99,    1,   98,   99,    1,   98,   99,   11,
			   98,   99, -111,   11,   98,   99, -111,   98,   99,   98,
			   99,   97,   99,   95,   96,   97,   99,   95,   96,   99,
			   97,   99,   60,   99,   65,   99,   61,   99, -161,   64,

			   99,   70,   99,   70,   99,   69,   99,   68,   70,   99,
			   67,   99,   67,   99,   66,   99,   41,   99,   41,   99,
			   40,   99,   47,   99,   47,   99,   46,   99,   47,   99,
			   44,   99,   47,   99,   50,   99,   49,   99,   50,   99,
			   93,   94,    2,    3,   53,   37,   51, -137, -151,   53,
			   53, -138,   16,   18,   14,   17,   22,   34,   34,   33,
			   34,    2,   94,    5,   86,   92, -182, -188,  -74,  -78,
			 -180,   73,   77, -173, -177,   73,   77, -173, -177,   71,
			 -171,   77, -177,  -12,   11, -111,   11, -111,   76,   77,
			 -177,   76,   95,   96,   96,   60,   61, -161,  -62,   63,

			   63,   54,   63,   60,   63,   58,   63,   59,   63,   69,
			   68,   66,   40,   47,   46,   47,   44,   47,   47,   47,
			   45,   46,   47,   42,   44, -142,   50,   49,   50,   48,
			   49,    3,  -38,  -52,   35,   37,   51, -135, -137, -151,
			   53, -138,   53,   53,  -39,   21,   15,   19,   23,   34,
			   32,   34,    2,    4,   94,   94,    6,    7,  -83,  -89,
			   86,   92, -182, -188,   84,  -81,   84,   84,   86,   92,
			 -182, -188,   84,   73,   77, -173, -177,   73,   77, -173,
			 -177,  -72,   79, -179,  -78,   77, -177,   77, -177,   11,
			 -111,   96,   96,   55,   54,   55,   57,  -43,    3,    3,

			  -36,  -38,  -52,   51, -151,   20,   24,   25,   26,   31,
			    4,    7,   86,   92, -182, -188,   86,   92, -182, -188,
			  -81,   86,   92, -182, -188,   85,   91, -181, -187,   73,
			   77, -173, -177,   73,   77, -173, -177,  -80,   77, -177,
			   11, -111,   56,   60,  -52,   25,   27,   28,   34,    4,
			    4,    7,    7,   86, -182,   86,   92, -182, -188,   86,
			   92, -182, -188,   85,   86,   91,   92, -181, -182, -187,
			 -188,  -82,  -88,   85,   91, -181, -187, -180,   75,   77,
			 -177,  -12,    8,   25,   25,   28,   29,  -83,   86,   92,
			 -182, -188,   92, -188,   86, -182,  -82,  -83,  -88,  -89,

			   85,   86,   91,   92, -181, -182, -187, -188,   85,   91,
			 -181, -187,   84, -186,    9,   10,  -12,   28,   28,   30,
			   86, -182,  -89,   85,   86,   91,   92, -181, -182, -187,
			 -188,   92, -188,   85, -181,   90,  -87,   90,   90,   92,
			 -188,   90,   92, -188,   92, -188,   85,   86, -181, -182,
			  -82,   91, -187,  -87,   92, -188,   91, -187,   10,   92,
			 -188,  -82,  -83,   91,   92, -187, -188,   91,   92, -187,
			 -188,  -88,   91, -187,  -88,  -89,   91,   92, -187, -188>>)
		end

feature {NONE} -- Constants

	yyJam_base: INTEGER is 1888
			-- Position in `yy_nxt'/`yy_chk' tables
			-- where default jam table starts

	yyJam_state: INTEGER is 320
			-- State id corresponding to jam state

	yyTemplate_mark: INTEGER is 321
			-- Mark between normal states and templates

	yyNull_equiv_class: INTEGER is 1
			-- Equivalence code for NULL character

	yyReject_used: BOOLEAN is false
			-- Is `reject' called?

	yyVariable_trail_context: BOOLEAN is true
			-- Is there a regular expression with
			-- both leading and trailing parts having
			-- variable length?

	yyReject_or_variable_trail_context: BOOLEAN is true
			-- Is `reject' called or is there a
			-- regular expression with both leading
			-- and trailing parts having variable length?

	yyNb_rules: INTEGER is 99
			-- Number of rules

	yyEnd_of_buffer: INTEGER is 100
			-- End of buffer rule code

	yyLine_used: BOOLEAN is true
			-- Are line and column numbers used?

	yyPosition_used: BOOLEAN is false
			-- Is `position' used?

	INITIAL: INTEGER is 0
	BREAK: INTEGER is 1
	MS: INTEGER is 2
	MSN: INTEGER is 3
	MSN1: INTEGER is 4
	VS1: INTEGER is 5
	VS2: INTEGER is 6
	VS3: INTEGER is 7
			-- Start condition codes

feature -- User-defined features



end
