/* goats client */

#include <config.h>
#include <gnome.h>
#include <bonobo.h> 
#include <panel-applet.h>
#include <glade/glade.h>
#include <gconf/gconf-client.h>

#include "goats-applet.h"
#include "goats-applet-callbacks.h"
#include "goats-applet-preferences.h"
#include "goats-applet-summary.h"
	
static const BonoboUIVerb goats_menu_verbs[] = {
        BONOBO_UI_VERB("GoatsPreferences", show_preferences_cb),
        BONOBO_UI_VERB("GoatsHelp",        show_help_cb),
        BONOBO_UI_VERB("GoatsAbout",       show_about_cb),
        BONOBO_UI_VERB("GoatsSummary",     show_summary_cb),
	BONOBO_UI_VERB("GoatsRaiseAll",    raise_all_cb),
	BONOBO_UI_VERB("GoatsLowerAll",    lower_all_cb),
	BONOBO_UI_VERB("GoatsHideAll",     hide_all_cb),
	BONOBO_UI_VERB("GoatsShowAll",     show_all_cb),
	BONOBO_UI_VERB("GoatsShadeAll",    shade_all_cb),
	BONOBO_UI_VERB("GoatsUnshadeAll",  unshade_all_cb),
	BONOBO_UI_VERB("GoatsDeleteAll",   delete_all_cb),
        BONOBO_UI_VERB_END
};

static void init_gconf(GoatsApplet *goats)

{
  goats->gconf_client = gconf_client_get_default();
  g_assert(goats->gconf_client != NULL);

  gconf_client_add_dir(goats->gconf_client, 
		       "/apps/goats",
		       GCONF_CLIENT_PRELOAD_NONE, NULL);
}

static void create_goats_applet(GoatsApplet *goats)
{
  GdkPixbuf *pixbuf;
  gchar *pixmap_file_lit, *pixmap_file_unlit;

  goats->panel_size = 
    panel_applet_get_size(PANEL_APPLET(goats->applet));

  pixmap_file_lit = g_strdup_printf("%sgoats_focus.png",
				    GOATS_DIR);
  pixmap_file_unlit = g_strdup_printf("%sgoats.png",
				      GOATS_DIR);
  goats->xml_file = g_strdup_printf("%s%s", GOATS_DIR, 
				    "goats.glade2");

  goats->button = gtk_event_box_new();

  //  gtk_frame_set_shadow_type (GTK_FRAME(goats->button), GTK_SHADOW_NONE);
  //  gtk_button_set_relief(GTK_BUTTON(goats->button), GTK_RELIEF_NONE);
  //  gtk_container_set_border_width(GTK_CONTAINER(goats->button), 0);

  goats->pixbuf_unlit = 
    gdk_pixbuf_new_from_file(pixmap_file_unlit, NULL);
  goats->pixbuf_lit = 
    gdk_pixbuf_new_from_file(pixmap_file_lit, NULL);

  pixbuf = gdk_pixbuf_scale_simple(goats->pixbuf_unlit, 
				   goats->panel_size-2, 
				   goats->panel_size-2, 
				   GDK_INTERP_BILINEAR);
  goats->pixmap = gtk_image_new_from_pixbuf(pixbuf);
  g_object_unref(pixbuf);

  gtk_container_add(GTK_CONTAINER(goats->button), goats->pixmap);
  gtk_container_add(GTK_CONTAINER(goats->applet), 
		    goats->button);
  gtk_widget_show_all(goats->applet);

  panel_applet_setup_menu_from_file (PANEL_APPLET (goats->applet),
				     NULL,
				     "GNOME_GoatsApplet.xml",
				     NULL,
				     goats_menu_verbs,
				     goats);

  g_free(pixmap_file_lit);
  g_free(pixmap_file_unlit);
}

static void connect_signals(GoatsApplet *goats)
{
  g_signal_connect(G_OBJECT(goats->applet), "change_size",
		   G_CALLBACK(panel_resize_cb), goats);

  g_signal_connect(G_OBJECT(goats->button),"button_press_event",
		   G_CALLBACK(applet_pressed_cb),
		   goats);

  g_signal_connect(G_OBJECT(goats->button),"enter_notify_event",
		   G_CALLBACK(applet_prelight_cb),
		   goats);

  g_signal_connect(G_OBJECT(goats->button),"leave_notify_event",
		   G_CALLBACK(applet_prelight_off_cb),
		   goats);
  g_signal_connect(G_OBJECT(goats->applet), "focus_in_event", 
		   G_CALLBACK(applet_prelight_cb), 
		   goats); 

  g_signal_connect(G_OBJECT(goats->applet), "focus_out_event", 
		   G_CALLBACK(applet_prelight_off_cb), 
		   goats); 

  g_signal_connect(G_OBJECT(goats->applet), "key_press_event",
		   G_CALLBACK(applet_key_press_cb),
		   goats);

  goats->gconf_defaults_notify_id = 
    gconf_client_notify_add(goats->gconf_client,
			    "/apps/goats/defaults",
			    (GConfClientNotifyFunc)goats_client_defaults_changed_cb, 
			    goats, NULL, NULL);

  goats->gconf_herd_notify_id = 
    gconf_client_notify_add(goats->gconf_client,
			    "/apps/goats/herd",
			    (GConfClientNotifyFunc)goats_client_herd_changed_cb, 
			    goats, NULL, NULL);
}

static void check_version(GoatsApplet *goats)

   
     /* Check installed version */
{
  gchar *current_version, *filename, *font_name;
  
  current_version = gconf_client_get_string(goats->gconf_client,
					    "/apps/goats/settings/version",
					    NULL);
  goats->version = g_strdup(VERSION);
  if (current_version == NULL) current_version = "0";

  if(strcmp(current_version, "0") == 0) {
    /* First install */
    filename = g_strdup_printf("%s%s", SOUNDDIR, "goat_bleat.au");
    gconf_client_set_string(goats->gconf_client, "/apps/goats/defaults/alarm_sound_filename",
			    filename, NULL);
    font_name = gconf_client_get_string(goats->gconf_client, "/desktop/gnome/interface/font_name", NULL);
    gconf_client_set_string(goats->gconf_client, "/apps/goats/defaults/font_name",
			    font_name, NULL);
    g_free(font_name);
    g_free(filename);
  }

  if(strcmp(current_version, goats->version) != 0) {
    /* New version (probably an upgrade) */
    gconf_client_set_string(goats->gconf_client,
 			    "/apps/goats/settings/version",
 			    goats->version, NULL);
  }

  g_free(current_version);
}

static void load_goats(GoatsApplet *goats)
{
  GSList *goat_list;
  gchar *key, *name;
  int i, start, length;

  goat_list = gconf_client_all_dirs(goats->gconf_client, "/apps/goats/herd", NULL);

  for (i=0; i<g_slist_length(goat_list); i++) {
    key = g_slist_nth_data(goat_list, i);
    length = strlen(key);
    for (start=length; start>=0; start--) if (key[start] == '/') break;
    if (start > 0) {
      start++;
      name = key + start * sizeof(char);
      goat_new(name, FALSE);
      g_free(key);
    }
  }

  g_slist_free(goat_list);
}

GoatsApplet *goats_applet_new (PanelApplet *applet)
{
  GoatsApplet *goats;
  Bonobo_Unknown factory;

  goats = (GoatsApplet *)g_malloc(sizeof(GoatsApplet));
  goats->applet = GTK_WIDGET(applet);

  init_gconf(goats); 
  create_goats_applet(goats);
  connect_signals(goats);
  goats_client_preferences_init(goats); 
  goats_client_summary_init(goats);
  check_version(goats);
  load_goats(goats);

  return goats;
}

static gboolean
goats_applet_factory (PanelApplet *applet,
                      const gchar *iid,
                      gpointer data)
{
  GoatsApplet *goats;

  if (!strcmp (iid, "OAFIID:GNOME_GoatsApplet"))
    goats = goats_applet_new(applet);

  return TRUE;
}

PANEL_APPLET_BONOBO_FACTORY ("OAFIID:GNOME_GoatsApplet_Factory",
                             PANEL_TYPE_APPLET,
                             "goats",
                             VERSION,
                             goats_applet_factory,
                             NULL);
