/* goats client summary */

#include <config.h>
#include <gnome.h>
#include <glade/glade.h>
#include <gconf/gconf-client.h>

#include "goats-applet.h"

void add_goat(GoatsApplet *goats, GtkTreeStore *tree,
	      const gchar *goat_key)
{
  gchar *key, *text=NULL, *goat_text;
  gboolean hidden, alarm;
  time_t alarm_time;
  GDate *date;
  struct tm *time;
  gint row, i;
  GtkTreeIter iter;

  gtk_tree_store_append(tree, &iter, NULL);

  key = g_strdup_printf("%s/title", goat_key);
  text = gconf_client_get_string(goats->gconf_client,
				 key, NULL);
  if (text == NULL) text = g_strdup(_("(no title)"));
  gtk_tree_store_set(tree, &iter, 0, text, -1);

  g_free(text);
  g_free(key);

  key = g_strdup_printf("%s/text", goat_key);
  goat_text = gconf_client_get_string(goats->gconf_client,
				      key, NULL);
  text = g_strndup(goat_text, 20);
  if (text) {
    for (i=0; i<strlen(text); i++) 
      if (text[i] == '\n') text[i] = ' ';
  }

  gtk_tree_store_set(tree, &iter, 1, text, -1);
  g_free(text);
  g_free(key);
  g_free(goat_text);

  key = g_strdup_printf("%s/hidden", goat_key);
  hidden = gconf_client_get_bool(goats->gconf_client,
				 key, NULL);
  g_free(key);
  if (hidden) text = _("No");
  else text = _("Yes");
  gtk_tree_store_set(tree, &iter, 2, text, -1);

  key = g_strdup_printf("%s/alarm_active", goat_key);
  alarm = gconf_client_get_bool(goats->gconf_client,
				key, NULL);
  g_free(key);
  if (!alarm) text = g_strdup(_("Not set"));
  else {
    date = g_date_new();
    key = g_strdup_printf("%s/alarm_time", goat_key);
    alarm_time = gconf_client_get_int(goats->gconf_client,
				      key, NULL);
    g_free(key);
    g_date_set_time(date, alarm_time);
    time = localtime(&alarm_time);
    text = g_strdup_printf(" %02i:%02i   %i/%i/%i",
			   time->tm_hour,
			   time->tm_min,
			   g_date_get_day(date),
			   g_date_get_month(date),
			   g_date_get_year(date));
    g_free(date);
  }
  gtk_tree_store_set(tree, &iter, 3, text, -1);
  g_free(text);

  gtk_tree_store_set(tree, &iter, 4, goat_key, -1);
}

void update(GoatsApplet *goats)
{
  GtkWidget *tree_view;
  gint i;
  GSList *goat_list;
  gchar *key;

  gtk_tree_store_clear(GTK_TREE_STORE(goats->summary_tree));
  
  goat_list = gconf_client_all_dirs(goats->gconf_client, "/apps/goats/herd", NULL);

  for (i=0; i<g_slist_length(goat_list); i++) {
    key = g_slist_nth_data(goat_list, i);
    add_goat(goats, goats->summary_tree, key);
    g_free(key);
  }

  g_slist_free(goat_list);
}

static void popup(GtkTreeModel *model,
		  GtkTreePath *path,
		  GtkTreeIter *iter,
		  GoatsApplet *goats)

{
  gchar *goat_key, *key;

  gtk_tree_model_get (model, iter, 
		      4, &goat_key, -1);

  key = g_strdup_printf("%s/%s", goat_key, "popup");
  gconf_client_set_bool(goats->gconf_client, key, TRUE, NULL);
  g_free(goat_key);
  g_free(key);
}

static void raise(GtkTreeModel *model,
		  GtkTreePath *path,
		  GtkTreeIter *iter,
		  GoatsApplet *goats)
{
  gchar *goat_key, *key;

  gtk_tree_model_get (model, iter, 
		      4, &goat_key, -1);

  key = g_strdup_printf("%s/%s", goat_key, "raised");
  gconf_client_set_bool(goats->gconf_client, key, TRUE, NULL);
  g_free(goat_key);
  g_free(key);
}

static void lower(GtkTreeModel *model,
		  GtkTreePath *path,
		  GtkTreeIter *iter,
		  GoatsApplet *goats)
{
  gchar *goat_key, *key;

  gtk_tree_model_get (model, iter, 
		      4, &goat_key, -1);

  key = g_strdup_printf("%s/%s", goat_key, "lowered");
  gconf_client_set_bool(goats->gconf_client, key, TRUE, NULL);
  g_free(goat_key);
  g_free(key);
}

static void show(GtkTreeModel *model,
		 GtkTreePath *path,
		 GtkTreeIter *iter,
		 GoatsApplet *goats)
{
  gchar *goat_key, *key;

  gtk_tree_model_get (model, iter, 
		      4, &goat_key, -1);

  key = g_strdup_printf("%s/%s", goat_key, "hidden");
  gconf_client_set_bool(goats->gconf_client, key, FALSE, NULL);
  g_free(goat_key);
  g_free(key);
}

static void hide(GtkTreeModel *model,
		 GtkTreePath *path,
		 GtkTreeIter *iter,
		 GoatsApplet *goats)
{
  gchar *goat_key, *key;

  gtk_tree_model_get (model, iter, 
		      4, &goat_key, -1);

  key = g_strdup_printf("%s/%s", goat_key, "hidden");
  gconf_client_set_bool(goats->gconf_client, key, TRUE, NULL);
  g_free(goat_key);
  g_free(key);
}

static void delete(GtkTreeModel *model,
		   GtkTreePath *path,
		   GtkTreeIter *iter,
		   GoatsApplet *goats)
{
  gchar *goat_key, *key;

  gtk_tree_model_get (model, iter, 
		      4, &goat_key, -1);

  key = g_strdup_printf("%s/%s", goat_key, "alive");
  gconf_client_set_bool(goats->gconf_client, key, FALSE, NULL);
  g_free(goat_key);
  g_free(key);
}

static void alarm_cancel(GtkTreeModel *model,
			 GtkTreePath *path,
			 GtkTreeIter *iter,
			 GoatsApplet *goats)
{
  gchar *goat_key, *key;

  gtk_tree_model_get (model, iter, 
		      4, &goat_key, -1);

  key = g_strdup_printf("%s/%s", goat_key, "alarm_active");
  gconf_client_set_bool(goats->gconf_client, key, FALSE, NULL);
  g_free(goat_key);
  g_free(key);
}

static void goats_changed_cb(GConfClient *client, 
			     guint id,
			     GConfEntry *entry, 
			     GoatsApplet *goats)
{
  update(goats);
}

static gint summary_delete_cb(GtkWidget *widget, GdkEvent *event,
			      GoatsApplet *goats)
{
  gtk_widget_hide(widget);

  return TRUE;
}

static void summary_response_cb(GtkWidget *widget, gint arg,
				GoatsApplet *goats)
{
  gtk_widget_hide(widget);
}

static void delete_cb(GtkWidget *widget, GoatsApplet *goats)
{
  GtkWidget *w;
  GtkTreeSelection *sel;
  gboolean confirm;

  if (gconf_client_get_bool(goats->gconf_client, "/apps/goats/settings/paranoid", NULL))
    confirm = goats_confirm(_("Delete this note?"), GTK_STOCK_DELETE);
  else
    confirm = TRUE;

  if (confirm) {
    w = glade_xml_get_widget(goats->summary_xml, "tree");
    sel = gtk_tree_view_get_selection(GTK_TREE_VIEW(w));
    
    gtk_tree_selection_selected_foreach(sel, (GtkTreeSelectionForeachFunc)delete, goats);
  }
}

static void cancel_alarm_cb(GtkWidget *widget, GoatsApplet *goats)
{
  GtkWidget *w;
  GtkTreeSelection *sel;

  w = glade_xml_get_widget(goats->summary_xml, "tree");
  sel = gtk_tree_view_get_selection(GTK_TREE_VIEW(w));

  gtk_tree_selection_selected_foreach(sel, (GtkTreeSelectionForeachFunc)alarm_cancel, goats);
}

static void popup_cb(GtkWidget *widget, GoatsApplet *goats)
{
  GtkWidget *w;
  GtkTreeSelection *sel;

  w = glade_xml_get_widget(goats->summary_xml, "tree");
  sel = gtk_tree_view_get_selection(GTK_TREE_VIEW(w));

  gtk_tree_selection_selected_foreach(sel, (GtkTreeSelectionForeachFunc)popup, goats);
}

static void raise_cb(GtkWidget *widget, GoatsApplet *goats)
{
  GtkWidget *w;
  GtkTreeSelection *sel;

  w = glade_xml_get_widget(goats->summary_xml, "tree");
  sel = gtk_tree_view_get_selection(GTK_TREE_VIEW(w));

  gtk_tree_selection_selected_foreach(sel, (GtkTreeSelectionForeachFunc)raise, goats);
}

static void lower_cb(GtkWidget *widget, GoatsApplet *goats)
{
  GtkWidget *w;
  GtkTreeSelection *sel;

  w = glade_xml_get_widget(goats->summary_xml, "tree");
  sel = gtk_tree_view_get_selection(GTK_TREE_VIEW(w));

  gtk_tree_selection_selected_foreach(sel, (GtkTreeSelectionForeachFunc)lower, goats);
}

static void show_cb(GtkWidget *widget, GoatsApplet *goats)
{
  GtkWidget *w;
  GtkTreeSelection *sel;

  w = glade_xml_get_widget(goats->summary_xml, "tree");
  sel = gtk_tree_view_get_selection(GTK_TREE_VIEW(w));

  gtk_tree_selection_selected_foreach(sel, (GtkTreeSelectionForeachFunc)show, goats);
}

static void hide_cb(GtkWidget *widget, GoatsApplet *goats)
{
  GtkWidget *w;
  GtkTreeSelection *sel;

  w = glade_xml_get_widget(goats->summary_xml, "tree");
  sel = gtk_tree_view_get_selection(GTK_TREE_VIEW(w));

  gtk_tree_selection_selected_foreach(sel, (GtkTreeSelectionForeachFunc)hide, goats);
}

static row_select_cb(GtkTreeSelection *sel, GoatsApplet *goats)
{
  GtkWidget *w;
  GtkTreeModel *model;
  GtkTreeIter iter;
  gboolean selection, hide, show, cancel;
  gchar *goat_key, *key;

  selection = gtk_tree_selection_get_selected(sel, &model, &iter);

  if (selection) {
    gtk_tree_model_get (model, &iter, 
			4, &goat_key, -1);

    key = g_strdup_printf("%s/%s", goat_key, "alarm_active");
    if (gconf_client_get_bool(goats->gconf_client, key, NULL))
      cancel = TRUE;
    else
      cancel = FALSE;
    g_free(key);

    key = g_strdup_printf("%s/%s", goat_key, "hidden");
    if (gconf_client_get_bool(goats->gconf_client, key, NULL)) {
       hide = FALSE;
       show = TRUE;
    }
    else {
      show = FALSE;
      hide = TRUE;
    }
    g_free(key);
    g_free(goat_key);
    
    w = glade_xml_get_widget(goats->summary_menu_xml, "cancel_alarm");
    gtk_widget_set_sensitive(w, cancel); 
    w = glade_xml_get_widget(goats->summary_menu_xml, "show");
    gtk_widget_set_sensitive(w, show); 
    w = glade_xml_get_widget(goats->summary_menu_xml, "hide");
    gtk_widget_set_sensitive(w, hide); 
  }
}

static void pos_menu(GtkMenu *menu, int *x, int *y, gboolean *push_in, GoatsApplet *goats)
{
  GtkWidget *w;

  w = glade_xml_get_widget(goats->summary_xml, "summary");
  gtk_window_get_position(GTK_WINDOW(w), x, y);
  *push_in = TRUE;
}

static void summary_menu_cb(GtkWidget *w, GoatsApplet *goats)
{
  GtkWidget *menu;

  g_signal_stop_emission_by_name (w, "popup-menu");
 
  menu = glade_xml_get_widget(goats->summary_menu_xml, "summary_menu");
  gtk_menu_popup(GTK_MENU(menu), NULL, NULL, 
		 (GtkMenuPositionFunc)pos_menu, goats,
		 3, 0);
}

static gint summary_button_cb(GtkWidget *w, GdkEventButton *event, 
			      GoatsApplet *goats)
{
  GtkWidget *menu;

  if (event->button == 3) {
    menu = glade_xml_get_widget(goats->summary_menu_xml, "summary_menu");
    gtk_menu_popup(GTK_MENU(menu), NULL, NULL, 
		   NULL, NULL, event->button, event->time);
    return TRUE;
  }

  return FALSE;
}

void goats_client_summary_init(GoatsApplet *goats)
{
  GtkCellRenderer *cell_renderer;
  GtkTreeViewColumn *column;
  GtkTreeView *tree_view;
  GtkTreeSelection *sel;
  GtkWidget *w, *menu;

  goats->summary_xml = glade_xml_new(goats->xml_file, 
				     "summary", NULL);
  goats->summary_menu_xml = glade_xml_new(goats->xml_file, "summary_menu", NULL);

  w = glade_xml_get_widget(goats->summary_xml, "summary");
  gtk_window_set_icon(GTK_WINDOW(w), goats->pixbuf_lit);
  gtk_window_set_resizable(GTK_WINDOW(w), TRUE);
  gtk_window_set_default_size(GTK_WINDOW(w), 500, 250); 
  g_signal_connect(G_OBJECT(w), "delete_event",
		   GTK_SIGNAL_FUNC(summary_delete_cb), goats);
  g_signal_connect(G_OBJECT(w), "response",
		   GTK_SIGNAL_FUNC(summary_response_cb), goats);

  w = glade_xml_get_widget(goats->summary_xml, "tree");

  g_signal_connect(G_OBJECT(w), "button_press_event",
		   G_CALLBACK(summary_button_cb), goats);
  g_signal_connect(G_OBJECT(w), "popup_menu", 
		   G_CALLBACK(summary_menu_cb), goats);

  glade_xml_signal_connect_data(goats->summary_menu_xml, "popup_cb", 
				G_CALLBACK(popup_cb), goats);
  glade_xml_signal_connect_data(goats->summary_menu_xml, "cancel_alarm_cb", 
				G_CALLBACK(cancel_alarm_cb), goats);
  glade_xml_signal_connect_data(goats->summary_menu_xml, "raise_cb", 
				G_CALLBACK(raise_cb), goats);
  glade_xml_signal_connect_data(goats->summary_menu_xml, "lower_cb", 
				G_CALLBACK(lower_cb), goats);
  glade_xml_signal_connect_data(goats->summary_menu_xml, "show_cb", 
				G_CALLBACK(show_cb), goats);
  glade_xml_signal_connect_data(goats->summary_menu_xml, "hide_cb", 
				G_CALLBACK(hide_cb), goats);
  glade_xml_signal_connect_data(goats->summary_menu_xml, "delete_cb", 
				G_CALLBACK(delete_cb), goats);

  goats->gconf_herd_notify_id = 
    gconf_client_notify_add(goats->gconf_client, "/apps/goats/herd",
			    (GConfClientNotifyFunc)goats_changed_cb,
			    goats, NULL, NULL);

  tree_view = GTK_TREE_VIEW(glade_xml_get_widget(goats->summary_xml,
						 "tree"));
  goats->summary_tree = gtk_tree_store_new(5,
					   G_TYPE_STRING, 
					   G_TYPE_STRING,
					   G_TYPE_STRING,
					   G_TYPE_STRING,
					   G_TYPE_STRING);
  gtk_tree_view_set_model(tree_view, 
			  GTK_TREE_MODEL(goats->summary_tree));
  
  cell_renderer = gtk_cell_renderer_text_new();

  column = gtk_tree_view_column_new_with_attributes
    (_("Title"), cell_renderer, "text", 0, NULL);
  gtk_tree_view_append_column (tree_view, column);
  column = gtk_tree_view_column_new_with_attributes
    (_("Text..."), cell_renderer, "text", 1, NULL);
  gtk_tree_view_column_set_sizing (column,
				   GTK_TREE_VIEW_COLUMN_GROW_ONLY);
  gtk_tree_view_append_column (tree_view, column);
  column = gtk_tree_view_column_new_with_attributes
    (_("Visible"), cell_renderer, "text", 2, NULL);
  gtk_tree_view_append_column (tree_view, column);
  column = gtk_tree_view_column_new_with_attributes
    (_("Alarm"), cell_renderer, "text", 3, NULL);
  gtk_tree_view_append_column (tree_view, column);

  sel = gtk_tree_view_get_selection(tree_view);

  g_signal_connect(G_OBJECT(sel), "changed",
		   G_CALLBACK(row_select_cb), goats);

  update(goats);
}
