/*
 * MMX optimized minimum/maximum functions.
 * Copyright (C) 2002 Pascal Haakmat <a.haakmat@chello.nl>.
 * 
 * You are free to use this code for any purpose provided that you:
 *
 * 1) Notify the author when you redistribute this code.
 * 2) Mention the use of this code in your software or its
 *    documentation.
 * 3) Share improvements that you made to this code with the 
 *    author.
 *
 * Statistics for compilation options: -O2
 *
 * C:
 *      Runs | Elems | Time
 * -----------------------------
 *     10000 |    64 | 0.006302
 *    100000 |    64 | 0.060498
 *   1000000 |    64 | 0.624079
 *     10000 |  1024 | 0.086681
 *    100000 |  1024 | 0.876180
 *   1000000 |  1024 | 8.699330
 *     10000 |  4096 | 0.342442
 *    100000 |  4096 | 3.425953
 *   1000000 |  4096 | 34.249983
 *
 * MMX:
 *
 *      Runs | Elems | Time
 * -----------------------------
 *     10000 |    64 | 0.001497
 *    100000 |    64 | 0.015307
 *   1000000 |    64 | 0.140745
 *     10000 |  1024 | 0.009910
 *    100000 |  1024 | 0.093061
 *   1000000 |  1024 | 0.965179
 *     10000 |  4096 | 0.034865
 *    100000 |  4096 | 0.354665
 *   1000000 |  4096 | 3.483273
 *
 * MMX w/prefetch + pairing + checking:
 *
 *      Runs | Elems | Time
 * -----------------------------
 *     10000 |  4096 | 0.027310
 *    100000 |  4096 | 0.267258
 *   1000000 |  4096 | 2.674745
 */

#ifndef MINMAX_H
#define MINMAX_H

#include <stdlib.h>
#include <config.h>

int8_t
min_int8_c(int8_t *a,
           int count);
int8_t
max_int8_c(int8_t *a,
           int count);
int8_t
min_int8_mmx2(int8_t *a,
              int count);
int8_t
max_int8_mmx2(int8_t *a,
              int count);
int8_t
min_int8_3dnow(int8_t *a,
              int count);
int8_t
max_int8_3dnow(int8_t *a,
               int count);
int16_t
min_int16_c(int16_t *a,
            int count);
int16_t
max_int16_c(int16_t *a,
            int count);
int16_t
min_int16_mmx2(int16_t *a,
               int count);
int16_t
max_int16_mmx2(int16_t *a,
               int count);
int16_t
min_int16_3dnow(int16_t *a,
                int count);
int16_t
max_int16_3dnow(int16_t *a,
                int count);

#ifndef HAVE_ARCH_X86
#warning "Not compiling MMX/MMX2/3DNow! optimized min/max."
#define min_int8_mmx2 min_int8_c
#define min_int16_mmx2 min_int16_c
#define min_int8_3dnow min_int8_c
#define min_int16_3dnow min_int16_c
#define max_int8_mmx2 max_int8_c
#define max_int16_mmx2 max_int16_c
#define max_int8_3dnow max_int8_c
#define max_int16_3dnow max_int16_c
#endif

#endif /* MINMAX_H */
