/* 
 * Copyright (C) 2002,2003 Pascal Haakmat.
 * Licensed under the GNU GPL.
 * Absolutely no warranty.
 */

#ifndef ITERATOR_H
#define ITERATOR_H

#include <gdk/gdk.h>
#include <config.h>
#include "mem.h"
#include "audiofile.h"

extern int quit_requested;

/*
 * Some macros to iterate over a track in steps of EFFECT_BUF_SIZE.
 */

#define ITERATOR_GENERIC_INIT(frame_offset, frame_count) \
    AFframecount iter_read = 0, \
      iter_written = 0, \
      iter_frame_offset = (frame_offset), \
      iter_frame_count = 0, \
      iter_frames_processed = 0, \
      iter_frame_count_old = iter_frame_count = (frame_count); \
    int iter_escape = 0, \
      iter_is_last_iteration = 0

#define ITERATOR_INIT(frame_offset, frame_count) \
    ITERATOR_GENERIC_INIT(frame_offset, frame_count); \
    int32_t *int32_frame_bits = mem_alloc(EFFECT_BUF_SIZE * sizeof(int32_t))

#define ITERATORF_INIT(frame_offset, frame_count) \
    ITERATOR_GENERIC_INIT(frame_offset, frame_count); \
    float *float_frame_bits = mem_alloc(EFFECT_BUF_SIZE * sizeof(float))

#define ITERATOR_EXIT() \
    if(int32_frame_bits) \
      free(int32_frame_bits); 

#define ITERATORF_EXIT() \
    if(float_frame_bits) \
      free(float_frame_bits); 

#define ITERATOR_ESCAPE() \
    iter_escape = 1;

#define ITERATOR_READER(shl, track) \
    do { \
      iter_read = track_int32_frames_get((track), \
                                         int32_frame_bits, \
                                         iter_frame_offset, \
                                         MIN(EFFECT_BUF_SIZE, \
                                         iter_frame_count)); \
      if(iter_read <= 0) \
        ITERATOR_ESCAPE(); \
      if(iter_read < EFFECT_BUF_SIZE) \
        iter_is_last_iteration = 1; \
      iter_written = iter_read; \
    } while(0)

#define ITERATORF_READER(shl, track) \
    do { \
      iter_read = track_float_frames_get((track), \
                                         float_frame_bits, \
                                         iter_frame_offset, \
                                         MIN(EFFECT_BUF_SIZE, \
                                         iter_frame_count)); \
      if(iter_read <= 0) \
        ITERATOR_ESCAPE(); \
      if(iter_read < EFFECT_BUF_SIZE) \
        iter_is_last_iteration = 1; \
      iter_written = iter_read; \
    } while(0)

#define ITERATOR_CHECKER() \
    if(!int32_frame_bits) { \
      FAIL("failed to allocate iterator buffer\n"); \
      break; \
    }

#define ITERATORF_CHECKER() \
    if(!float_frame_bits) { \
      FAIL("failed to allocate iterator buffer\n"); \
      break; \
    }

/*
 * shl is optional. 
 */

#define ITERATOR_SKEL(shl, track, checker, reader, func) \
    do { \
    checker; \
    if((shl)->module_cancel_requested) \
      break; \
    do { \
      reader; \
      do { \
        func; \
        if((shl)) \
          gtk_progress_bar_set_fraction((shl)->progress,  \
                                        CLAMP((float)iter_frames_processed / \
                                              (float)(iter_frame_count_old), 0, 1)); \
      } while(0); \
      iter_frames_processed += iter_read; \
      iter_frame_offset += iter_written; \
      iter_frame_count -= iter_read; \
      gui_yield(); \
      if((shl) && (shl)->module_cancel_requested) \
        ITERATOR_ESCAPE(); \
    } while(!iter_escape && iter_read > 0 && iter_frame_count); \
    DEBUG("total: %ld\n", iter_frame_count_old); \
    if((shl)) \
      gtk_progress_bar_set_fraction((shl)->progress, 0); \
    } while(0) 

#define ITERATOR(shl, track, func) \
    ITERATOR_SKEL(shl, track, ITERATOR_CHECKER(), ITERATOR_READER(shl, track), func)

#define ITERATORF(shl, track, func) \
    ITERATOR_SKEL(shl, track, ITERATORF_CHECKER(), ITERATORF_READER(shl, track), func)

#endif /* ! ITERATOR_H */

