# GNU Enterprise Forms - GTK UI Driver - label widget
#
# Copyright 2001-2005 Free Software Foundation
#
# This file is part of GNU Enterprise
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# $Id: label.py 6851 2005-01-03 20:59:28Z jcater $

import gtk

from gnue.forms.uidrivers.gtk2.widgets._base import UIHelper


# TODO: fix proper alignment. Aligment doesn't work at the moment, because the
# label haven't a width set (using set_size_request ()). Calling this function
# results in a strange positioning behaviour of the label ??? Currently all
# labels are 'left-aligned'
_alignmentStyle = {
  'left'  : gtk.JUSTIFY_LEFT,
  'center': gtk.JUSTIFY_CENTER,
  'right' : gtk.JUSTIFY_RIGHT,
  'fill'  : gtk.JUSTIFY_FILL
}

# =============================================================================
# This class provides GTK widgets for labels
# =============================================================================

class UILabel (UIHelper):

  # ---------------------------------------------------------------------------
  # Create a GTK widget
  # ---------------------------------------------------------------------------

  def _createWidget (self, event, spacer):
    gfObject = event.object

    newWidget = gtk.Label (self._makeSafe ("%s" % gfObject.text))
    newWidget.set_justify (_alignmentStyle [gfObject.alignment])

    itemX = self.itemX
    if gfObject.alignment in ['center', 'right']:
      diff = self.itemWidth - newWidget.size_request () [0]

      if gfObject.alignment == 'right':
        itemX += diff

      elif gfObject.alignment == 'center':
        itemX += int (diff / 2)

    # Make sure the baseline of labels and widgets are the same
    event.container.put (newWidget, itemX, self.itemY + 4)
    newWidget.show ()

    return newWidget


# -----------------------------------------------------------------------------
# Configuration data
# -----------------------------------------------------------------------------

configuration = {
  'baseClass'  : UILabel,
  'provides'   : 'GFLabel',
  'container'  : 0,
}
