#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2005 Free Software Foundation
#
# FILE:
# GFLayout.py
#
# DESCRIPTION:
"""
Handles the <layout> tag.
"""
# NOTES:
#
# HISTORY:
#

from gnue.common.apps import GDebug
import string
from GFObj import GFObj


class GFLayout(GFObj):
  def __init__(self, parent=None):
    GFObj.__init__(self, parent, "GFLayout")
    self._inits =[self.initialize]
    self._pageList = []
    self.tabbed = 'none'

  def _buildObject(self):

    # TODO: This is temporary until layout management support works
    self.walk(_addxy)

    return GFObj._buildObject(self)

  def initialize(self):
    self._xmlchildnamespaces = self._findNamespaces(self)


  # Find the xml namespace in use by any child objects
  def _findNamespaces(self, object):
    ns = {}
    for child in object._children:
      try:
        if child._xmlnamespaces:
          ns.update(list(child._xmlnamespaces))
        else:
          ns.update(self._findNamespace(child))
      except AttributeError:
        pass
    return ns



# TODO: Temporary until layout mgmt works
def _addxy(object):
  for attr in ('x','y','height','width'):
    try:
      v = int(object.__dict__['Char__%s' % attr])
      object.__dict__['Char__%s' % attr] = v
      # object.__dict__[attr] = v
      object.__dict__['_Layout__%s' % attr] = v
    except KeyError:
      pass

