#include "gnomp3.h"

#ifndef MP3LIST_H
#define MP3LIST_H

typedef struct mp3{
    char   *filename;
    char   *display_name; //points to either 'display_name_from_filename or id3
    char   *album_name;
    char   *display_name_from_filename;
    char   *display_name_from_id3;

    int    play_time;
    time_t file_time;
    int    no_plays;
    int    pref_level;
    time_t cache_expiry;

    /* id3 stuff */
    //char id3_info_avail; /* -1 = NO, 0 = Havent tried, 1 = Yes */  
    char *id3_title;
    char *id3_artist;
    char *id3_album;
    char *id3_year;
    char *id3_comment;
    int   id3_genre;

    /* dynamic app stuff (FLAGS)*/
    int played;
    int from_rule;
    int playing;

    int row_playlist;
    int row_alllist;
    int row_timelist;
    int row_dirlist;
    GtkCTreeNode *row_songlist;

}MP3;

#define MP3_CAST(x) ((MP3 *)(x))
#define MP3_NODE(x) ((MP3 *)x->data)

GList *mp3list;

char *mp3list_build_time(MP3 *mp3);
MP3 *mp3list_build_entry(char *filename);
MP3 *mp3list_build_full_entry(char **tokens);
void mp3list_build_from_file(char *filename);
void mp3list_save_to_file(char *filename);
void mp3list_reload();

GList *mp3list_search(GList *start, char *filename);
GList *mp3list_search_by_file(char *filename);
void mp3list_search_by_name(char *text, void (*found_callback)(MP3 *mp3));

/* from mp3list_add.c */
void mp3list_commit_candidates();
void mp3list_add_songs_from_file(char *song_list_file);
void mp3list_add_dir_songs();
void mp3list_add_songs();

void mp3list_initial_load();

#endif
