/* GNOME DB libary
 * Copyright (C) 1999 Rodrigo Moya
 *
 * This Library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This Library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this Library; see the file COPYING.LIB.  If not,
 * write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __gnome_db_list_h__
#define __gnome_db_list_h__ 1

#include <gtk/gtkvbox.h>
#include <libgnome/gnome-defs.h>
#include <gda-recordset.h>

BEGIN_GNOME_DECLS

#define GNOME_DB_TYPE_LIST            (gnome_db_list_get_type())
#define GNOME_DB_LIST(obj)            GTK_CHECK_CAST(obj, gnome_db_list_get_type(), GnomeDbList)
#define GNOME_DB_LIST_CLASS(klass)    GTK_CHECK_CLASS_CAST(klass, gnome_db_list_get_type(), GnomeDbListClass)
#define GNOME_DB_IS_LIST(obj)         GTK_CHECK_TYPE(obj, gnome_db_list_get_type())
#define GNOME_DB_IS_LIST_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), GNOME_DB_TYPE_LIST))

typedef struct _GnomeDbList      GnomeDbList;
typedef struct _GnomeDbListClass GnomeDbListClass;

struct _GnomeDbList
{
	GtkVBox       vbox;

	GtkWidget*    list;
	GdaRecordset* recset;
	gint          col;
	gint          timeout_handle;
	gint          total_rows;
};

struct _GnomeDbListClass
{
	GtkVBoxClass parent_class;

	void         (*loaded)(GnomeDbList *dblist);
	void         (*select_row)(GnomeDbList *dblist);
	void         (*add_row)(GnomeDbList *dblist, gint row);
};

guint         gnome_db_list_get_type        (void);
GtkWidget*    gnome_db_list_new             (GdaRecordset *recset, gint pos);
void          gnome_db_list_clear           (GnomeDbList *dblist);

gint          gnome_db_list_get_row_count   (GnomeDbList *dblist);
gchar*        gnome_db_list_get_string      (GnomeDbList *dblist);
GdaRecordset* gnome_db_list_get_recordset   (GnomeDbList *dblist);
void          gnome_db_list_set_recordset   (GnomeDbList *dblist,
											 GdaRecordset *recset,
											 gint pos);

GdkPixmap*    gnome_db_list_get_pixmap      (GnomeDbList *dblist, gint row);
void          gnome_db_list_set_pixmap      (GnomeDbList *dblist,
											 gint row,
											 GdkPixmap *pixmap,
											 GdkBitmap *mask);
GdkBitmap*    gnome_db_list_get_pixmap_mask (GnomeDbList *dblist, gint row);

END_GNOME_DECLS

#endif
