/* GNOME DB library
 * Copyright (C) 1999-2000 Rodrigo Moya
 *
 * This Library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This Library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this Library; see the file COPYING.LIB.  If not,
 * write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __gnome_db_label_h__
#define __gnome_db_label_h__ 1

#include <gtk/gtklabel.h>
#include <libgnome/gnome-defs.h>
#include <gda-recordset.h>

BEGIN_GNOME_DECLS

#define GNOME_DB_TYPE_LABEL            (gnome_db_label_get_type())
#define GNOME_DB_LABEL(obj)            GTK_CHECK_CAST(obj, GNOME_DB_TYPE_LABEL, GnomeDbLabel)
#define GNOME_DB_LABEL_CLASS(klass)    GTK_CHECK_CLASS_CAST(klass, GNOME_DB_TYPE_LABEL, GnomeDbLabelClass)
#define GNOME_DB_IS_LABEL(obj)         GTK_CHECK_TYPE(obj, GNOME_DB_TYPE_LABEL)
#define GNOME_DB_IS_LABEL_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GNOME_DB_TYPE_LABEL))

typedef struct _GnomeDbLabel        GnomeDbLabel;
typedef struct _GnomeDbLabelClass   GnomeDbLabelClass;
typedef struct _GnomeDbLabelPrivate GnomeDbLabelPrivate;

struct _GnomeDbLabel {
	GtkLabel             label;
	GnomeDbLabelPrivate* priv;
};

struct _GnomeDbLabelClass {
	GtkLabelClass parent_class;
};

GtkType        gnome_db_label_get_type      (void);
GtkWidget*     gnome_db_label_new           (GdaRecordset *recset, gint col);
GdaRecordset* gnome_db_label_get_recordset (GnomeDbLabel *label);
void           gnome_db_label_set_recordset (GnomeDbLabel *label, GdaRecordset *recset, gint col);
const gchar*   gnome_db_label_get_text      (GnomeDbLabel *label);
void           gnome_db_label_set_text      (GnomeDbLabel *label, const gchar *txt);

END_GNOME_DECLS

#endif
