/* GNOME DB libary
 * Copyright (C) 1999 Rodrigo Moya
 *
 * This Library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This Library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this Library; see the file COPYING.LIB.  If not,
 * write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __gnome_db_combo_h__
#define __gnome_db_combo_h__ 1

#include <gtk/gtkcombo.h>
#include <libgnome/gnome-defs.h>
#include <gda-recordset.h>

BEGIN_GNOME_DECLS

#define GNOME_DB_TYPE_COMBO            (gnome_db_combo_get_type())
#define GNOME_DB_COMBO(obj)            GTK_CHECK_CAST(obj, GNOME_DB_TYPE_COMBO, GnomeDbCombo)
#define GNOME_DB_COMBO_CLASS(klass)    GTK_CHECK_CLASS_CAST(klass, GNOME_DB_TYPE_COMBO, GnomeDbComboClass)
#define GNOME_DB_IS_COMBO(obj)         GTK_CHECK_TYPE(obj, GNOME_DB_TYPE_COMBO)
#define GNOME_DB_IS_COMBO_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GNOME_DB_TYPE_COMBO))

typedef struct _GnomeDbCombo GnomeDbCombo;
typedef struct _GnomeDbComboClass GnomeDbComboClass;

struct _GnomeDbCombo {
	GtkCombo      combo;
	GdaRecordset* recset;
	gint          column;
	gint          total_rows;
	gboolean      editable;
};

struct _GnomeDbComboClass {
	GtkComboClass parent_class;

	void          (*error)            (GnomeDbCombo *dbcombo);
	void          (*selection_changed)(GnomeDbCombo *dbcombo, gchar *sel);
};

guint         gnome_db_combo_get_type      (void);
GtkWidget*    gnome_db_combo_new           (GdaRecordset *recset, gint pos);

gboolean      gnome_db_combo_get_editable  (GnomeDbCombo *dbcombo);
void          gnome_db_combo_set_editable  (GnomeDbCombo *dbcombo, gboolean editable);

void          gnome_db_combo_refresh       (GnomeDbCombo *dbcombo);
gint          gnome_db_combo_get_row_count (GnomeDbCombo *dbcombo);
gchar*        gnome_db_combo_get_string    (GnomeDbCombo *dbcombo);
GdaRecordset* gnome_db_combo_get_recordset (GnomeDbCombo *dbcombo);
void          gnome_db_combo_set_recordset (GnomeDbCombo *dbcombo, GdaRecordset *recset, gint pos);

void          gnome_db_combo_sync          (GnomeDbCombo *dbcombo);

END_GNOME_DECLS

#endif
