/**
 * vim: sw=4 ts=4:
 *
 * Derived GtkDrawingArea, with an expander_size property.
 *
 * 	(C) 2003 Filip Van Raemdonck <mechanix@debian.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 * 	$Id$
 *
 **/

#include "gaptdrawingarea.h"

#ifndef _
#if ENABLE_NLS
#define _(x) gettext(x)
#else
#define _(x) (x)
#endif
#endif

static void gapt_drawing_area_class_init (GAptDrawingAreaClass*);
static void gapt_drawing_area_init (GAptDrawingArea*);

GType
gapt_drawing_area_get_type (void) {
	static GType gda_type = 0;

	if (!gda_type) {
		static const GTypeInfo gda_info = {
			sizeof (GAptDrawingAreaClass), NULL, NULL,
			(GClassInitFunc) gapt_drawing_area_class_init,
			NULL, NULL, sizeof (GAptDrawingArea), 0,
			(GInstanceInitFunc) gapt_drawing_area_init
		};

		gda_type = g_type_register_static (GTK_TYPE_DRAWING_AREA, "GAptDrawingArea", &gda_info, (GTypeFlags) 0);
	}
	return gda_type;
}

enum { DA_SELECTION_CHANGED, DA_LAST_SIGNAL };
static guint gapt_drawing_area_signals[DA_LAST_SIGNAL] = { 0 };

static void
gapt_drawing_area_class_init (GAptDrawingAreaClass* klass) {
	gapt_drawing_area_signals[DA_SELECTION_CHANGED] = g_signal_new (
	      "selection-changed", G_TYPE_FROM_CLASS (klass),
	      G_SIGNAL_RUN_FIRST | G_SIGNAL_ACTION,
	      G_STRUCT_OFFSET (GAptDrawingAreaClass, selection_changed), NULL, NULL,
	      g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);

#define _GAPT_DRAWING_AREA_EXPANDER_SIZE 10
	gtk_widget_class_install_style_property ((GtkWidgetClass*) klass, g_param_spec_int (
	      "expander_size", _("Expander Size"), _("Size of the expander arrow"), 0, G_MAXINT,
	      _GAPT_DRAWING_AREA_EXPANDER_SIZE, G_PARAM_READABLE));
}

static void
gapt_drawing_area_init (GAptDrawingArea* gda) {
	/* Nothing to do */
}

GtkWidget*
gapt_drawing_area_new (void) {
	return GTK_WIDGET (g_object_new (GAPT_DRAWING_AREA_TYPE, NULL));
}
