/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2004 The GFC Development Team.
 *
 *  radiobuttonsignals.cc - Gtk::RadioButton virtual signal handlers
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "radiobutton.hh"
#include "radiobuttonsignals.hh"
#include "private/radiobuttonclass.hh"

using namespace GFC;

/*  Gtk::RadioButtonSignals
 */
 
Gtk::RadioButtonSignals::RadioButtonSignals(RadioButton *radio_button) 
: ToggleButtonSignals(radio_button)
{
	Gtk::RadioButtonClass::init(GTK_RADIO_BUTTON_GET_CLASS(radio_button->gtk_radio_button()));
}

Gtk::RadioButtonSignals::~RadioButtonSignals()
{
}

void
Gtk::RadioButtonSignals::on_group_changed()
{
	GtkRadioButtonClass *g_class = RadioButtonClass::get_parent_class(instance_);
	if (g_class->group_changed)
		g_class->group_changed((GtkRadioButton*)instance_);
}

/*  Gtk::RadioButtonClass
 */

void
Gtk::RadioButtonClass::init(GtkRadioButtonClass *g_class)
{
	g_class->group_changed = &group_changed_proxy;
}

GtkRadioButtonClass*
Gtk::RadioButtonClass::get_parent_class(void *instance)
{
	void *ptr = g_type_class_peek_parent(GTK_RADIO_BUTTON_GET_CLASS(instance));
	return static_cast<GtkRadioButtonClass*>(ptr);
}

GType
Gtk::RadioButtonClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GTK_TYPE_RADIO_BUTTON);
	}
	return type;
}

void*
Gtk::RadioButtonClass::create()
{
	return g_object_new(get_type(), 0);
}

void
Gtk::RadioButtonClass::group_changed_proxy(GtkRadioButton *radio_button)
{
	void *ptr = g_object_get_qdata((GObject*)radio_button, G::ObjectSignals::quark());
	if (ptr)
		static_cast<RadioButtonSignals*>(ptr)->on_group_changed();
	else
	{
		GtkRadioButtonClass *g_class = RadioButtonClass::get_parent_class(radio_button);
		if (g_class->group_changed)
			g_class->group_changed(radio_button);
	}
}

