/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.

** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.

** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * Author : Alexandre Parenteau <aubonbeurre@hotmail.com> --- February 2000
 */

/*
 * 
 */

#ifndef UCVSGRAPH_H
#define UCVSGRAPH_H

#include "uwidget.h"

class CLogNode;
class EntnodeData;

class UCvsGraph : public UWidget
{
	UDECLARE_DYNAMIC(UCvsGraph)
public:
	UCvsGraph(CLogNode *node, const char *dir);
	virtual ~UCvsGraph();

	enum
	{
		kDrawing = EV_COMMAND_START	// 0
	};
protected:
	CLogNode *m_node;
	UStr m_dir;
	UStr m_name;
	EntnodeData *m_data;

	void CalcImageSize(void);

	ev_msg void OnDestroy();
	ev_msg void OnCreate();
	ev_msg void OnDrawing(void *info);

	UDECLARE_MESSAGE_MAP()
};

#endif
