/*
  GNOME Comics Organizer
  Copyright (C) 1999-2001 Maxximum Software
   
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <gnome.h>
#include "comiclist.h"

char *itoa (int i);

GList *get_selected_issue (GtkWidget *generic);
GList *get_selected_title (GtkWidget *generic);

void exp_set_selected_title (GtkWidget *window, TComic *comic_title);
void exp_set_selected_issue (GtkWidget *window, TComic *comic_title, TIssue *comic_issue);

gint gtk_clist_length (GtkCList *clist); 
void clear_clist (GtkCList *clist);
void real_clear_list(GtkWidget *widget);
void clear_text (GtkText *text);
void clear_tree (GtkTree *tree);

void CreateComicsTreeList(GtkTree *comic_titles_tree, GList *clist);
void AppendComicsTreeList(GtkTree *comics_tree, GList *clist);
void CreateIssuesCList(GtkCList *issues_clist, GList *ilist);
void display_selected_comic_title(GtkWidget *widget);
void display_selected_issue_info(TIssue *TempIssue, GtkText *IssuesInfo);

void refresh_comics_list(GtkWidget *add_window);

void gnome_entry_set_history (GnomeEntry *gentry, GList *history_list);

GList *g_list_insert_str_sorted_unique (GList *history_list, GString *string_insert);
GList *g_list_insert_glist_str_sorted_unique (GList *main_history_list, GList *insert_history_list);

void gnome_config_set_glist_str (gchar* path, GList *glist);
GList *gnome_config_get_glist_str (gchar* path);

void save_prefs_and_history ();
void load_prefs_and_history ();
