/* Generated by genstub.  Do not edit. */
/* source: syslib.stub */
#define LIBGAUCHE_BODY
#include <gauche.h>

#include <unistd.h>
#include <sys/types.h>
#include <dirent.h>
#include <locale.h>
#include <stdlib.h>
#include <errno.h>
#include <signal.h>
#include <math.h>
#ifndef __MINGW32__
#include <sys/wait.h>
#include <grp.h>
#include <pwd.h>
#endif /*!__MINGW32__*/
#if TIME_WITH_SYS_TIME
# include <sys/time.h>
# include <time.h>
#else
# if HAVE_SYS_TIME_H
#  include <sys/time.h>
# else
#  include <time.h>
# endif
#endif

static ScmObj syslib_sys_readdir(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj pathname_scm;
  ScmString* pathname;
  SCM_ENTER_SUBR("sys-readdir");
  pathname_scm = SCM_ARGREF(0);
  if (!SCM_STRINGP(pathname_scm)) Scm_Error("string required, but got %S", pathname_scm);
  pathname = SCM_STRING(pathname_scm);
  {
SCM_RETURN(Scm_ReadDirectory(pathname));
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_readdir__NAME, "sys-readdir", 11, 11);
static SCM_DEFINE_SUBR(syslib_sys_readdir__STUB, 1, 0, SCM_OBJ(&syslib_sys_readdir__NAME), syslib_sys_readdir, NULL, NULL);

static ScmObj syslib_sys_glob(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj pattern_scm;
  ScmString* pattern;
  SCM_ENTER_SUBR("sys-glob");
  pattern_scm = SCM_ARGREF(0);
  if (!SCM_STRINGP(pattern_scm)) Scm_Error("string required, but got %S", pattern_scm);
  pattern = SCM_STRING(pattern_scm);
  {
SCM_RETURN(Scm_GlobDirectory(pattern));
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_glob__NAME, "sys-glob", 8, 8);
static SCM_DEFINE_SUBR(syslib_sys_glob__STUB, 1, 0, SCM_OBJ(&syslib_sys_glob__NAME), syslib_sys_glob, NULL, NULL);

static SCM_DEFINE_STRING_CONST(KEYARG_absolute__NAME, "absolute", 8, 8);
static ScmObj KEYARG_absolute = SCM_UNBOUND;
static SCM_DEFINE_STRING_CONST(KEYARG_expand__NAME, "expand", 6, 6);
static ScmObj KEYARG_expand = SCM_UNBOUND;
static SCM_DEFINE_STRING_CONST(KEYARG_canonicalize__NAME, "canonicalize", 12, 12);
static ScmObj KEYARG_canonicalize = SCM_UNBOUND;
static ScmObj syslib_sys_normalize_pathname(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj pathname_scm;
  ScmString* pathname;
  ScmObj absolute_scm;
  ScmObj absolute;
  ScmObj expand_scm;
  ScmObj expand;
  ScmObj canonicalize_scm;
  ScmObj canonicalize;
  ScmObj SCM_OPTARGS = SCM_ARGREF(SCM_ARGCNT-1);
  SCM_ENTER_SUBR("sys-normalize-pathname");
  pathname_scm = SCM_ARGREF(0);
  if (!SCM_STRINGP(pathname_scm)) Scm_Error("string required, but got %S", pathname_scm);
  pathname = SCM_STRING(pathname_scm);
  absolute_scm = Scm_GetKeyword(SCM_OBJ(KEYARG_absolute), SCM_OPTARGS, SCM_FALSE);
  absolute = (absolute_scm);
  expand_scm = Scm_GetKeyword(SCM_OBJ(KEYARG_expand), SCM_OPTARGS, SCM_FALSE);
  expand = (expand_scm);
  canonicalize_scm = Scm_GetKeyword(SCM_OBJ(KEYARG_canonicalize), SCM_OPTARGS, SCM_FALSE);
  canonicalize = (canonicalize_scm);
  {
  int flags = 0;
  if (!SCM_FALSEP(absolute)) flags |= SCM_PATH_ABSOLUTE;
  if (!SCM_FALSEP(expand))   flags |= SCM_PATH_EXPAND;
  if (!SCM_FALSEP(canonicalize)) flags |= SCM_PATH_CANONICALIZE;
  SCM_RETURN(Scm_NormalizePathname(pathname, flags));
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_normalize_pathname__NAME, "sys-normalize-pathname", 22, 22);
static SCM_DEFINE_SUBR(syslib_sys_normalize_pathname__STUB, 1, 1, SCM_OBJ(&syslib_sys_normalize_pathname__NAME), syslib_sys_normalize_pathname, NULL, NULL);

static ScmObj syslib_sys_basename(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj pathname_scm;
  ScmString* pathname;
  SCM_ENTER_SUBR("sys-basename");
  pathname_scm = SCM_ARGREF(0);
  if (!SCM_STRINGP(pathname_scm)) Scm_Error("string required, but got %S", pathname_scm);
  pathname = SCM_STRING(pathname_scm);
  {
SCM_RETURN(Scm_BaseName(pathname));
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_basename__NAME, "sys-basename", 12, 12);
static SCM_DEFINE_SUBR(syslib_sys_basename__STUB, 1, 0, SCM_OBJ(&syslib_sys_basename__NAME), syslib_sys_basename, NULL, NULL);

static ScmObj syslib_sys_dirname(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj pathname_scm;
  ScmString* pathname;
  SCM_ENTER_SUBR("sys-dirname");
  pathname_scm = SCM_ARGREF(0);
  if (!SCM_STRINGP(pathname_scm)) Scm_Error("string required, but got %S", pathname_scm);
  pathname = SCM_STRING(pathname_scm);
  {
SCM_RETURN(Scm_DirName(pathname));
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_dirname__NAME, "sys-dirname", 11, 11);
static SCM_DEFINE_SUBR(syslib_sys_dirname__STUB, 1, 0, SCM_OBJ(&syslib_sys_dirname__NAME), syslib_sys_dirname, NULL, NULL);

static ScmObj syslib_sys_getgrgid(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj gid_scm;
  int gid;
  SCM_ENTER_SUBR("sys-getgrgid");
  gid_scm = SCM_ARGREF(0);
  if (!SCM_EXACTP(gid_scm)) Scm_Error("C integer required, but got %S", gid_scm);
  gid = Scm_GetInteger(gid_scm);
  {
SCM_RETURN(Scm_GetGroupById(gid));
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_getgrgid__NAME, "sys-getgrgid", 12, 12);
static SCM_DEFINE_SUBR(syslib_sys_getgrgid__STUB, 1, 0, SCM_OBJ(&syslib_sys_getgrgid__NAME), syslib_sys_getgrgid, NULL, NULL);

static ScmObj syslib_sys_getgrnam(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj name_scm;
  ScmString* name;
  SCM_ENTER_SUBR("sys-getgrnam");
  name_scm = SCM_ARGREF(0);
  if (!SCM_STRINGP(name_scm)) Scm_Error("string required, but got %S", name_scm);
  name = SCM_STRING(name_scm);
  {
SCM_RETURN(Scm_GetGroupByName(name));
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_getgrnam__NAME, "sys-getgrnam", 12, 12);
static SCM_DEFINE_SUBR(syslib_sys_getgrnam__STUB, 1, 0, SCM_OBJ(&syslib_sys_getgrnam__NAME), syslib_sys_getgrnam, NULL, NULL);

static ScmObj syslib_sys_gid_TOgroup_name(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj gid_scm;
  int gid;
  SCM_ENTER_SUBR("sys-gid->group-name");
  gid_scm = SCM_ARGREF(0);
  if (!SCM_EXACTP(gid_scm)) Scm_Error("C integer required, but got %S", gid_scm);
  gid = Scm_GetInteger(gid_scm);
  {
  struct group *g = getgrgid(gid);
  if (g == NULL) { Scm_SigCheck(Scm_VM()); SCM_RETURN(SCM_FALSE); }
  else SCM_RETURN(SCM_MAKE_STR_COPYING(g->gr_name));
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_gid_TOgroup_name__NAME, "sys-gid->group-name", 19, 19);
static SCM_DEFINE_SUBR(syslib_sys_gid_TOgroup_name__STUB, 1, 0, SCM_OBJ(&syslib_sys_gid_TOgroup_name__NAME), syslib_sys_gid_TOgroup_name, NULL, NULL);

static ScmObj syslib_sys_group_name_TOgid(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj name_scm;
  ScmString* name;
  SCM_ENTER_SUBR("sys-group-name->gid");
  name_scm = SCM_ARGREF(0);
  if (!SCM_STRINGP(name_scm)) Scm_Error("string required, but got %S", name_scm);
  name = SCM_STRING(name_scm);
  {
  struct group *g = getgrnam(Scm_GetStringConst(name));
  if (g == NULL) { Scm_SigCheck(Scm_VM()); SCM_RETURN(SCM_FALSE); }
  else SCM_RETURN(Scm_MakeInteger(g->gr_gid));
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_group_name_TOgid__NAME, "sys-group-name->gid", 19, 19);
static SCM_DEFINE_SUBR(syslib_sys_group_name_TOgid__STUB, 1, 0, SCM_OBJ(&syslib_sys_group_name_TOgid__NAME), syslib_sys_group_name_TOgid, NULL, NULL);

static SCM_DEFINE_STRING_CONST(syslib_LC_ALL__VAR__NAME, "LC_ALL", 6, 6);
static ScmObj syslib_LC_ALL__VAR = SCM_UNBOUND;
static SCM_DEFINE_STRING_CONST(syslib_LC_COLLATE__VAR__NAME, "LC_COLLATE", 10, 10);
static ScmObj syslib_LC_COLLATE__VAR = SCM_UNBOUND;
static SCM_DEFINE_STRING_CONST(syslib_LC_CTYPE__VAR__NAME, "LC_CTYPE", 8, 8);
static ScmObj syslib_LC_CTYPE__VAR = SCM_UNBOUND;
static SCM_DEFINE_STRING_CONST(syslib_LC_MONETARY__VAR__NAME, "LC_MONETARY", 11, 11);
static ScmObj syslib_LC_MONETARY__VAR = SCM_UNBOUND;
static SCM_DEFINE_STRING_CONST(syslib_LC_NUMERIC__VAR__NAME, "LC_NUMERIC", 10, 10);
static ScmObj syslib_LC_NUMERIC__VAR = SCM_UNBOUND;
static SCM_DEFINE_STRING_CONST(syslib_LC_TIME__VAR__NAME, "LC_TIME", 7, 7);
static ScmObj syslib_LC_TIME__VAR = SCM_UNBOUND;
static ScmObj syslib_sys_setlocale(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj category_scm;
  int category;
  ScmObj locale_scm;
  ScmString* locale;
  SCM_ENTER_SUBR("sys-setlocale");
  category_scm = SCM_ARGREF(0);
  if (!SCM_INTP(category_scm)) Scm_Error("small integer required, but got %S", category_scm);
  category = SCM_INT_VALUE(category_scm);
  locale_scm = SCM_ARGREF(1);
  if (!SCM_STRINGP(locale_scm)) Scm_Error("string required, but got %S", locale_scm);
  locale = SCM_STRING(locale_scm);
  {
  char *result = setlocale(category, Scm_GetStringConst(locale));
  if (result) SCM_RETURN(SCM_MAKE_STR_COPYING(result));
  else SCM_RETURN(SCM_FALSE);
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_setlocale__NAME, "sys-setlocale", 13, 13);
static SCM_DEFINE_SUBR(syslib_sys_setlocale__STUB, 2, 0, SCM_OBJ(&syslib_sys_setlocale__NAME), syslib_sys_setlocale, NULL, NULL);

static ScmObj syslib_sys_getpwuid(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj uid_scm;
  int uid;
  SCM_ENTER_SUBR("sys-getpwuid");
  uid_scm = SCM_ARGREF(0);
  if (!SCM_EXACTP(uid_scm)) Scm_Error("C integer required, but got %S", uid_scm);
  uid = Scm_GetInteger(uid_scm);
  {
SCM_RETURN(Scm_GetPasswdById(uid));
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_getpwuid__NAME, "sys-getpwuid", 12, 12);
static SCM_DEFINE_SUBR(syslib_sys_getpwuid__STUB, 1, 0, SCM_OBJ(&syslib_sys_getpwuid__NAME), syslib_sys_getpwuid, NULL, NULL);

static ScmObj syslib_sys_getpwnam(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj name_scm;
  ScmString* name;
  SCM_ENTER_SUBR("sys-getpwnam");
  name_scm = SCM_ARGREF(0);
  if (!SCM_STRINGP(name_scm)) Scm_Error("string required, but got %S", name_scm);
  name = SCM_STRING(name_scm);
  {
SCM_RETURN(Scm_GetPasswdByName(name));
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_getpwnam__NAME, "sys-getpwnam", 12, 12);
static SCM_DEFINE_SUBR(syslib_sys_getpwnam__STUB, 1, 0, SCM_OBJ(&syslib_sys_getpwnam__NAME), syslib_sys_getpwnam, NULL, NULL);

static ScmObj syslib_sys_uid_TOuser_name(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj uid_scm;
  int uid;
  SCM_ENTER_SUBR("sys-uid->user-name");
  uid_scm = SCM_ARGREF(0);
  if (!SCM_EXACTP(uid_scm)) Scm_Error("C integer required, but got %S", uid_scm);
  uid = Scm_GetInteger(uid_scm);
  {
  struct passwd *p = getpwuid(uid);
  if (p == NULL) { Scm_SigCheck(Scm_VM()); SCM_RETURN(SCM_FALSE); }
  else SCM_RETURN(SCM_MAKE_STR_COPYING(p->pw_name));
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_uid_TOuser_name__NAME, "sys-uid->user-name", 18, 18);
static SCM_DEFINE_SUBR(syslib_sys_uid_TOuser_name__STUB, 1, 0, SCM_OBJ(&syslib_sys_uid_TOuser_name__NAME), syslib_sys_uid_TOuser_name, NULL, NULL);

static ScmObj syslib_sys_user_name_TOuid(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj name_scm;
  ScmString* name;
  SCM_ENTER_SUBR("sys-user-name->uid");
  name_scm = SCM_ARGREF(0);
  if (!SCM_STRINGP(name_scm)) Scm_Error("string required, but got %S", name_scm);
  name = SCM_STRING(name_scm);
  {
  struct passwd *p = getpwnam(Scm_GetStringConst(name));
  if (p == NULL) { Scm_SigCheck(Scm_VM()); SCM_RETURN(SCM_FALSE); }
  else SCM_RETURN(Scm_MakeInteger(p->pw_uid));
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_user_name_TOuid__NAME, "sys-user-name->uid", 18, 18);
static SCM_DEFINE_SUBR(syslib_sys_user_name_TOuid__STUB, 1, 0, SCM_OBJ(&syslib_sys_user_name_TOuid__NAME), syslib_sys_user_name_TOuid, NULL, NULL);

static ScmObj syslib_sys_sigset_addX(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj set_scm;
  ScmSysSigset* set;
  ScmObj sigs_scm;
  ScmObj sigs;
  ScmObj SCM_OPTARGS = SCM_ARGREF(SCM_ARGCNT-1);
  SCM_ENTER_SUBR("sys-sigset-add!");
  set_scm = SCM_ARGREF(0);
  if (!SCM_SYS_SIGSET_P(set_scm)) Scm_Error("<sys-sigset> required, but got %S", set_scm);
  set = SCM_SYS_SIGSET(set_scm);
  sigs_scm = SCM_OPTARGS;
  sigs = (sigs_scm);
  {
SCM_RETURN(Scm_SysSigsetOp(set, sigs, FALSE));
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_sigset_addX__NAME, "sys-sigset-add!", 15, 15);
static SCM_DEFINE_SUBR(syslib_sys_sigset_addX__STUB, 1, 1, SCM_OBJ(&syslib_sys_sigset_addX__NAME), syslib_sys_sigset_addX, NULL, NULL);

static ScmObj syslib_sys_sigset_deleteX(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj set_scm;
  ScmSysSigset* set;
  ScmObj sigs_scm;
  ScmObj sigs;
  ScmObj SCM_OPTARGS = SCM_ARGREF(SCM_ARGCNT-1);
  SCM_ENTER_SUBR("sys-sigset-delete!");
  set_scm = SCM_ARGREF(0);
  if (!SCM_SYS_SIGSET_P(set_scm)) Scm_Error("<sys-sigset> required, but got %S", set_scm);
  set = SCM_SYS_SIGSET(set_scm);
  sigs_scm = SCM_OPTARGS;
  sigs = (sigs_scm);
  {
SCM_RETURN(Scm_SysSigsetOp(set, sigs, TRUE));
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_sigset_deleteX__NAME, "sys-sigset-delete!", 18, 18);
static SCM_DEFINE_SUBR(syslib_sys_sigset_deleteX__STUB, 1, 1, SCM_OBJ(&syslib_sys_sigset_deleteX__NAME), syslib_sys_sigset_deleteX, NULL, NULL);

static ScmObj syslib_sys_sigset_fillX(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj set_scm;
  ScmSysSigset* set;
  SCM_ENTER_SUBR("sys-sigset-fill!");
  set_scm = SCM_ARGREF(0);
  if (!SCM_SYS_SIGSET_P(set_scm)) Scm_Error("<sys-sigset> required, but got %S", set_scm);
  set = SCM_SYS_SIGSET(set_scm);
  {
SCM_RETURN(Scm_SysSigsetFill(set, FALSE));
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_sigset_fillX__NAME, "sys-sigset-fill!", 16, 16);
static SCM_DEFINE_SUBR(syslib_sys_sigset_fillX__STUB, 1, 0, SCM_OBJ(&syslib_sys_sigset_fillX__NAME), syslib_sys_sigset_fillX, NULL, NULL);

static ScmObj syslib_sys_sigset_emptyX(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj set_scm;
  ScmSysSigset* set;
  SCM_ENTER_SUBR("sys-sigset-empty!");
  set_scm = SCM_ARGREF(0);
  if (!SCM_SYS_SIGSET_P(set_scm)) Scm_Error("<sys-sigset> required, but got %S", set_scm);
  set = SCM_SYS_SIGSET(set_scm);
  {
SCM_RETURN(Scm_SysSigsetFill(set, TRUE));
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_sigset_emptyX__NAME, "sys-sigset-empty!", 17, 17);
static SCM_DEFINE_SUBR(syslib_sys_sigset_emptyX__STUB, 1, 0, SCM_OBJ(&syslib_sys_sigset_emptyX__NAME), syslib_sys_sigset_emptyX, NULL, NULL);

static ScmObj syslib_sys_signal_name(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj sig_scm;
  int sig;
  SCM_ENTER_SUBR("sys-signal-name");
  sig_scm = SCM_ARGREF(0);
  if (!SCM_INTP(sig_scm)) Scm_Error("small integer required, but got %S", sig_scm);
  sig = SCM_INT_VALUE(sig_scm);
  {
SCM_RETURN(Scm_SignalName(sig));
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_signal_name__NAME, "sys-signal-name", 15, 15);
static SCM_DEFINE_SUBR(syslib_sys_signal_name__STUB, 1, 0, SCM_OBJ(&syslib_sys_signal_name__NAME), syslib_sys_signal_name, NULL, NULL);

static ScmObj syslib_sys_kill(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj pid_scm;
  int pid;
  ScmObj sig_scm;
  int sig;
  SCM_ENTER_SUBR("sys-kill");
  pid_scm = SCM_ARGREF(0);
  if (!SCM_EXACTP(pid_scm)) Scm_Error("C integer required, but got %S", pid_scm);
  pid = Scm_GetInteger(pid_scm);
  sig_scm = SCM_ARGREF(1);
  if (!SCM_INTP(sig_scm)) Scm_Error("small integer required, but got %S", sig_scm);
  sig = SCM_INT_VALUE(sig_scm);
  {
  int r;
  SCM_SYSCALL(r, kill(pid, sig));
  if (r < 0) Scm_SysError("kill failed");
  SCM_RETURN(SCM_UNDEFINED);
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_kill__NAME, "sys-kill", 8, 8);
static SCM_DEFINE_SUBR(syslib_sys_kill__STUB, 2, 0, SCM_OBJ(&syslib_sys_kill__NAME), syslib_sys_kill, NULL, NULL);

static ScmObj syslib_set_signal_handlerX(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj sig_scm;
  ScmObj sig;
  ScmObj proc_scm;
  ScmObj proc;
  SCM_ENTER_SUBR("set-signal-handler!");
  sig_scm = SCM_ARGREF(0);
  sig = (sig_scm);
  proc_scm = SCM_ARGREF(1);
  proc = (proc_scm);
  {
SCM_RETURN(Scm_SetSignalHandler(sig, proc));
  }
}

static SCM_DEFINE_STRING_CONST(syslib_set_signal_handlerX__NAME, "set-signal-handler!", 19, 19);
static SCM_DEFINE_SUBR(syslib_set_signal_handlerX__STUB, 2, 0, SCM_OBJ(&syslib_set_signal_handlerX__NAME), syslib_set_signal_handlerX, NULL, NULL);

static ScmObj syslib_get_signal_handler(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj sig_scm;
  int sig;
  SCM_ENTER_SUBR("get-signal-handler");
  sig_scm = SCM_ARGREF(0);
  if (!SCM_INTP(sig_scm)) Scm_Error("small integer required, but got %S", sig_scm);
  sig = SCM_INT_VALUE(sig_scm);
  {
SCM_RETURN(Scm_GetSignalHandler(sig));
  }
}

static SCM_DEFINE_STRING_CONST(syslib_get_signal_handler__NAME, "get-signal-handler", 18, 18);
static SCM_DEFINE_SUBR(syslib_get_signal_handler__STUB, 1, 0, SCM_OBJ(&syslib_get_signal_handler__NAME), syslib_get_signal_handler, NULL, NULL);

static ScmObj syslib_get_signal_handlers(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  SCM_ENTER_SUBR("get-signal-handlers");
  {
SCM_RETURN(Scm_GetSignalHandlers());
  }
}

static SCM_DEFINE_STRING_CONST(syslib_get_signal_handlers__NAME, "get-signal-handlers", 19, 19);
static SCM_DEFINE_SUBR(syslib_get_signal_handlers__STUB, 0, 0, SCM_OBJ(&syslib_get_signal_handlers__NAME), syslib_get_signal_handlers, NULL, NULL);

static SCM_DEFINE_STRING_CONST(syslib_SIG_SETMASK__VAR__NAME, "SIG_SETMASK", 11, 11);
static ScmObj syslib_SIG_SETMASK__VAR = SCM_UNBOUND;
static SCM_DEFINE_STRING_CONST(syslib_SIG_BLOCK__VAR__NAME, "SIG_BLOCK", 9, 9);
static ScmObj syslib_SIG_BLOCK__VAR = SCM_UNBOUND;
static SCM_DEFINE_STRING_CONST(syslib_SIG_UNBLOCK__VAR__NAME, "SIG_UNBLOCK", 11, 11);
static ScmObj syslib_SIG_UNBLOCK__VAR = SCM_UNBOUND;
static ScmObj syslib_sys_sigmask(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj how_scm;
  int how;
  ScmObj mask_scm;
  ScmSysSigset* mask;
  SCM_ENTER_SUBR("sys-sigmask");
  how_scm = SCM_ARGREF(0);
  if (!SCM_INTP(how_scm)) Scm_Error("small integer required, but got %S", how_scm);
  how = SCM_INT_VALUE(how_scm);
  mask_scm = SCM_ARGREF(1);
  if (!SCM_SYS_SIGSET_P(mask_scm)) Scm_Error("<sys-sigset> required, but got %S", mask_scm);
  mask = SCM_SYS_SIGSET(mask_scm);
  {
SCM_RETURN(Scm_SysSigmask(how, mask));
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_sigmask__NAME, "sys-sigmask", 11, 11);
static SCM_DEFINE_SUBR(syslib_sys_sigmask__STUB, 2, 0, SCM_OBJ(&syslib_sys_sigmask__NAME), syslib_sys_sigmask, NULL, NULL);

static ScmObj syslib_sys_sigsuspend(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj mask_scm;
  ScmSysSigset* mask;
  SCM_ENTER_SUBR("sys-sigsuspend");
  mask_scm = SCM_ARGREF(0);
  if (!SCM_SYS_SIGSET_P(mask_scm)) Scm_Error("<sys-sigset> required, but got %S", mask_scm);
  mask = SCM_SYS_SIGSET(mask_scm);
  {
SCM_RETURN(Scm_SigSuspend(mask));
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_sigsuspend__NAME, "sys-sigsuspend", 14, 14);
static SCM_DEFINE_SUBR(syslib_sys_sigsuspend__STUB, 1, 0, SCM_OBJ(&syslib_sys_sigsuspend__NAME), syslib_sys_sigsuspend, NULL, NULL);

static ScmObj syslib_sys_remove(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj filename_scm;
  ScmString* filename;
  SCM_ENTER_SUBR("sys-remove");
  filename_scm = SCM_ARGREF(0);
  if (!SCM_STRINGP(filename_scm)) Scm_Error("string required, but got %S", filename_scm);
  filename = SCM_STRING(filename_scm);
  {
  int r;
  SCM_SYSCALL(r, remove(Scm_GetStringConst(filename)));
  if (r < 0) Scm_SysError("removing %S failed", filename);
  SCM_RETURN(SCM_TRUE);
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_remove__NAME, "sys-remove", 10, 10);
static SCM_DEFINE_SUBR(syslib_sys_remove__STUB, 1, 0, SCM_OBJ(&syslib_sys_remove__NAME), syslib_sys_remove, NULL, NULL);

static ScmObj syslib_sys_rename(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj old_scm;
  ScmString* old;
  ScmObj new_scm;
  ScmString* new;
  SCM_ENTER_SUBR("sys-rename");
  old_scm = SCM_ARGREF(0);
  if (!SCM_STRINGP(old_scm)) Scm_Error("string required, but got %S", old_scm);
  old = SCM_STRING(old_scm);
  new_scm = SCM_ARGREF(1);
  if (!SCM_STRINGP(new_scm)) Scm_Error("string required, but got %S", new_scm);
  new = SCM_STRING(new_scm);
  {
  int r;
  SCM_SYSCALL(r, rename(Scm_GetStringConst(old), Scm_GetStringConst(new)));
  if (r < 0) Scm_SysError("renaming %S to %S failed", old, new);
  SCM_RETURN(SCM_TRUE);
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_rename__NAME, "sys-rename", 10, 10);
static SCM_DEFINE_SUBR(syslib_sys_rename__STUB, 2, 0, SCM_OBJ(&syslib_sys_rename__NAME), syslib_sys_rename, NULL, NULL);

static ScmObj syslib_sys_tmpnam(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  SCM_ENTER_SUBR("sys-tmpnam");
  {

#ifdef HAVE_MKSTEMP
  char nam[] = "/tmp/fileXXXXXX";
  int fd;
  SCM_SYSCALL(fd, mkstemp(nam));
  if (fd < 0) Scm_SysError("mkstemp failed");
  close(fd);
  unlink(nam);
  SCM_RETURN(SCM_MAKE_STR_COPYING(nam));
#else
  char *s = tmpnam(NULL);
  SCM_RETURN(SCM_MAKE_STR_COPYING(s));
#endif
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_tmpnam__NAME, "sys-tmpnam", 10, 10);
static SCM_DEFINE_SUBR(syslib_sys_tmpnam__STUB, 0, 0, SCM_OBJ(&syslib_sys_tmpnam__NAME), syslib_sys_tmpnam, NULL, NULL);

static ScmObj syslib_sys_mkstemp(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj template_scm;
  ScmString* template;
  SCM_ENTER_SUBR("sys-mkstemp");
  template_scm = SCM_ARGREF(0);
  if (!SCM_STRINGP(template_scm)) Scm_Error("string required, but got %S", template_scm);
  template = SCM_STRING(template_scm);
  {
SCM_RETURN(Scm_SysMkstemp(template));
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_mkstemp__NAME, "sys-mkstemp", 11, 11);
static SCM_DEFINE_SUBR(syslib_sys_mkstemp__STUB, 1, 0, SCM_OBJ(&syslib_sys_mkstemp__NAME), syslib_sys_mkstemp, NULL, NULL);

static ScmObj syslib_sys_exit(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj code_scm;
  int code;
  SCM_ENTER_SUBR("sys-exit");
  code_scm = SCM_ARGREF(0);
  if (!SCM_INTP(code_scm)) Scm_Error("small integer required, but got %S", code_scm);
  code = SCM_INT_VALUE(code_scm);
  {
_exit(code); SCM_RETURN(SCM_UNDEFINED);
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_exit__NAME, "sys-exit", 8, 8);
static SCM_DEFINE_SUBR(syslib_sys_exit__STUB, 1, 0, SCM_OBJ(&syslib_sys_exit__NAME), syslib_sys_exit, NULL, NULL);

static ScmObj syslib_sys_getenv(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj name_scm;
  ScmString* name;
  SCM_ENTER_SUBR("sys-getenv");
  name_scm = SCM_ARGREF(0);
  if (!SCM_STRINGP(name_scm)) Scm_Error("string required, but got %S", name_scm);
  name = SCM_STRING(name_scm);
  {
  const char *p = getenv(Scm_GetStringConst(name));
  if (p == NULL) {
    SCM_RETURN(SCM_FALSE);
  } else {
    SCM_RETURN(SCM_MAKE_STR_COPYING(p));
  }
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_getenv__NAME, "sys-getenv", 10, 10);
static SCM_DEFINE_SUBR(syslib_sys_getenv__STUB, 1, 0, SCM_OBJ(&syslib_sys_getenv__NAME), syslib_sys_getenv, NULL, NULL);

static ScmObj syslib_sys_system(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj command_scm;
  ScmString* command;
  SCM_ENTER_SUBR("sys-system");
  command_scm = SCM_ARGREF(0);
  if (!SCM_STRINGP(command_scm)) Scm_Error("string required, but got %S", command_scm);
  command = SCM_STRING(command_scm);
  {
  int r;
  SCM_SYSCALL(r, system(Scm_GetStringConst(command)));
  SCM_RETURN(Scm_MakeInteger(r));
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_system__NAME, "sys-system", 10, 10);
static SCM_DEFINE_SUBR(syslib_sys_system__STUB, 1, 0, SCM_OBJ(&syslib_sys_system__NAME), syslib_sys_system, NULL, NULL);

static ScmObj syslib_sys_random(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  SCM_ENTER_SUBR("sys-random");
  {
#if defined(HAVE_RANDOM) && defined(HAVE_SRANDOM)
  SCM_RETURN(Scm_MakeInteger(random()));
#elif defined(LRAND48) && defined(SRAND48)
  SCM_RETURN(Scm_MakeInteger(lrand48()));
#else
  /* fallback - we don't want to use rand(), for it is not very good RNG.
     replace it when we have time. */
  SCM_RETURN(Scm_MakeInteger(rand()));
#endif
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_random__NAME, "sys-random", 10, 10);
static SCM_DEFINE_SUBR(syslib_sys_random__STUB, 0, 0, SCM_OBJ(&syslib_sys_random__NAME), syslib_sys_random, NULL, NULL);

static ScmObj syslib_sys_srandom(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj seed_scm;
  ScmObj seed;
  SCM_ENTER_SUBR("sys-srandom");
  seed_scm = SCM_ARGREF(0);
  seed = (seed_scm);
  {
  if (!SCM_EXACTP(seed)) Scm_Error("exact integer required: %S", seed);
#if defined(HAVE_RANDOM) && defined(HAVE_SRANDOM)
  srandom(Scm_GetUInteger(seed));
#elif defined(LRAND48) && defined(SRAND48)
  srand48(Scm_GetUInteger(seed));
#else
  /* fallback - we don't want to use rand(), for it is not very good RNG.
     replace it when we have time. */
  srand(Scm_GetUInteger(seed));
#endif
  SCM_RETURN(SCM_UNDEFINED);
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_srandom__NAME, "sys-srandom", 11, 11);
static SCM_DEFINE_SUBR(syslib_sys_srandom__STUB, 1, 0, SCM_OBJ(&syslib_sys_srandom__NAME), syslib_sys_srandom, NULL, NULL);

static SCM_DEFINE_STRING_CONST(syslib_RAND_MAX__VAR__NAME, "RAND_MAX", 8, 8);
static ScmObj syslib_RAND_MAX__VAR = SCM_UNBOUND;
static ScmObj syslib_sys_stat(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj path_scm;
  ScmString* path;
  SCM_ENTER_SUBR("sys-stat");
  path_scm = SCM_ARGREF(0);
  if (!SCM_STRINGP(path_scm)) Scm_Error("string required, but got %S", path_scm);
  path = SCM_STRING(path_scm);
  {
  ScmSysStat *s = SCM_SYS_STAT(Scm_MakeSysStat());
  int r;
  SCM_SYSCALL(r, stat(Scm_GetStringConst(path), &s->statrec));
  if (r < 0) Scm_SysError("stat failed for %S", path);
  SCM_RETURN(SCM_OBJ(s));
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_stat__NAME, "sys-stat", 8, 8);
static SCM_DEFINE_SUBR(syslib_sys_stat__STUB, 1, 0, SCM_OBJ(&syslib_sys_stat__NAME), syslib_sys_stat, NULL, NULL);

#if !defined(__MINGW32__)
static ScmObj syslib_sys_lstat(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj path_scm;
  ScmString* path;
  SCM_ENTER_SUBR("sys-lstat");
  path_scm = SCM_ARGREF(0);
  if (!SCM_STRINGP(path_scm)) Scm_Error("string required, but got %S", path_scm);
  path = SCM_STRING(path_scm);
  {
  ScmSysStat *s = SCM_SYS_STAT(Scm_MakeSysStat());
  int r;
  SCM_SYSCALL(r, lstat(Scm_GetStringConst(path), &s->statrec));
  if (r < 0) Scm_SysError("lstat failed for %S", path);
  SCM_RETURN(SCM_OBJ(s));
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_lstat__NAME, "sys-lstat", 9, 9);
static SCM_DEFINE_SUBR(syslib_sys_lstat__STUB, 1, 0, SCM_OBJ(&syslib_sys_lstat__NAME), syslib_sys_lstat, NULL, NULL);

#endif /*!defined(__MINGW32__)*/
static ScmObj syslib_sys_fstat(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj port_or_fd_scm;
  ScmObj port_or_fd;
  SCM_ENTER_SUBR("sys-fstat");
  port_or_fd_scm = SCM_ARGREF(0);
  port_or_fd = (port_or_fd_scm);
  {
  ScmSysStat *s = SCM_SYS_STAT(Scm_MakeSysStat());
  int fd = Scm_GetPortFd(port_or_fd, FALSE), r;
  if (fd < 0) SCM_RETURN(SCM_FALSE);
  SCM_SYSCALL(r, fstat(fd, &s->statrec));
  if (r < 0) Scm_SysError("fstat failed for %d", fd);
  SCM_RETURN(SCM_OBJ(s));
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_fstat__NAME, "sys-fstat", 9, 9);
static SCM_DEFINE_SUBR(syslib_sys_fstat__STUB, 1, 0, SCM_OBJ(&syslib_sys_fstat__NAME), syslib_sys_fstat, NULL, NULL);

#if !defined(__MINGW32__)
static ScmObj syslib_sys_wait(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  SCM_ENTER_SUBR("sys-wait");
  {
  int status;
  pid_t r = wait(&status);
  if (r < 0) {
    if (errno == EINTR) Scm_SigCheck(Scm_VM());
    Scm_SysError("wait() failed");
  }
  SCM_RETURN(Scm_Values2(Scm_MakeInteger(r), Scm_MakeInteger(status)));
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_wait__NAME, "sys-wait", 8, 8);
static SCM_DEFINE_SUBR(syslib_sys_wait__STUB, 0, 0, SCM_OBJ(&syslib_sys_wait__NAME), syslib_sys_wait, NULL, NULL);

#endif /*!defined(__MINGW32__)*/
#if !defined(__MINGW32__)
#if !defined(__MINGW32__)
static SCM_DEFINE_STRING_CONST(KEYARG_nohang__NAME, "nohang", 6, 6);
static ScmObj KEYARG_nohang = SCM_UNBOUND;
#endif /*!defined(__MINGW32__)*/
#if !defined(__MINGW32__)
static SCM_DEFINE_STRING_CONST(KEYARG_untraced__NAME, "untraced", 8, 8);
static ScmObj KEYARG_untraced = SCM_UNBOUND;
#endif /*!defined(__MINGW32__)*/
static ScmObj syslib_sys_waitpid(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj pid_scm;
  int pid;
  ScmObj nohang_scm;
  ScmObj nohang;
  ScmObj untraced_scm;
  ScmObj untraced;
  ScmObj SCM_OPTARGS = SCM_ARGREF(SCM_ARGCNT-1);
  SCM_ENTER_SUBR("sys-waitpid");
  pid_scm = SCM_ARGREF(0);
  if (!SCM_EXACTP(pid_scm)) Scm_Error("C integer required, but got %S", pid_scm);
  pid = Scm_GetInteger(pid_scm);
  nohang_scm = Scm_GetKeyword(SCM_OBJ(KEYARG_nohang), SCM_OPTARGS, SCM_FALSE);
  nohang = (nohang_scm);
  untraced_scm = Scm_GetKeyword(SCM_OBJ(KEYARG_untraced), SCM_OPTARGS, SCM_FALSE);
  untraced = (untraced_scm);
  {
  int status, options = 0;  pid_t r;
  if (!SCM_FALSEP(nohang))   options |= WNOHANG;
  if (!SCM_FALSEP(untraced)) options |= WUNTRACED;
  r = waitpid(pid, &status, options);
  if (r < 0) {
    if (errno == EINTR) Scm_SigCheck(Scm_VM());
    Scm_SysError("waitpid() failed");
  }
  SCM_RETURN(Scm_Values2(Scm_MakeInteger(r), Scm_MakeInteger(status)));
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_waitpid__NAME, "sys-waitpid", 11, 11);
static SCM_DEFINE_SUBR(syslib_sys_waitpid__STUB, 1, 1, SCM_OBJ(&syslib_sys_waitpid__NAME), syslib_sys_waitpid, NULL, NULL);

#endif /*!defined(__MINGW32__)*/
#if !defined(__MINGW32__)
static ScmObj syslib_sys_wait_exitedP(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj status_scm;
  int status;
  SCM_ENTER_SUBR("sys-wait-exited?");
  status_scm = SCM_ARGREF(0);
  if (!SCM_EXACTP(status_scm)) Scm_Error("C integer required, but got %S", status_scm);
  status = Scm_GetInteger(status_scm);
  {
SCM_RETURN(SCM_MAKE_BOOL(WIFEXITED(status)));
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_wait_exitedP__NAME, "sys-wait-exited?", 16, 16);
static SCM_DEFINE_SUBR(syslib_sys_wait_exitedP__STUB, 1, 0, SCM_OBJ(&syslib_sys_wait_exitedP__NAME), syslib_sys_wait_exitedP, NULL, NULL);

#endif /*!defined(__MINGW32__)*/
#if !defined(__MINGW32__)
static ScmObj syslib_sys_wait_exit_status(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj status_scm;
  int status;
  SCM_ENTER_SUBR("sys-wait-exit-status");
  status_scm = SCM_ARGREF(0);
  if (!SCM_EXACTP(status_scm)) Scm_Error("C integer required, but got %S", status_scm);
  status = Scm_GetInteger(status_scm);
  {
SCM_RETURN(Scm_MakeInteger(WEXITSTATUS(status)));
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_wait_exit_status__NAME, "sys-wait-exit-status", 20, 20);
static SCM_DEFINE_SUBR(syslib_sys_wait_exit_status__STUB, 1, 0, SCM_OBJ(&syslib_sys_wait_exit_status__NAME), syslib_sys_wait_exit_status, NULL, NULL);

#endif /*!defined(__MINGW32__)*/
#if !defined(__MINGW32__)
static ScmObj syslib_sys_wait_signaledP(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj status_scm;
  int status;
  SCM_ENTER_SUBR("sys-wait-signaled?");
  status_scm = SCM_ARGREF(0);
  if (!SCM_EXACTP(status_scm)) Scm_Error("C integer required, but got %S", status_scm);
  status = Scm_GetInteger(status_scm);
  {
SCM_RETURN(SCM_MAKE_BOOL(WIFSIGNALED(status)));
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_wait_signaledP__NAME, "sys-wait-signaled?", 18, 18);
static SCM_DEFINE_SUBR(syslib_sys_wait_signaledP__STUB, 1, 0, SCM_OBJ(&syslib_sys_wait_signaledP__NAME), syslib_sys_wait_signaledP, NULL, NULL);

#endif /*!defined(__MINGW32__)*/
#if !defined(__MINGW32__)
static ScmObj syslib_sys_wait_termsig(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj status_scm;
  int status;
  SCM_ENTER_SUBR("sys-wait-termsig");
  status_scm = SCM_ARGREF(0);
  if (!SCM_EXACTP(status_scm)) Scm_Error("C integer required, but got %S", status_scm);
  status = Scm_GetInteger(status_scm);
  {
SCM_RETURN(Scm_MakeInteger(WTERMSIG(status)));
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_wait_termsig__NAME, "sys-wait-termsig", 16, 16);
static SCM_DEFINE_SUBR(syslib_sys_wait_termsig__STUB, 1, 0, SCM_OBJ(&syslib_sys_wait_termsig__NAME), syslib_sys_wait_termsig, NULL, NULL);

#endif /*!defined(__MINGW32__)*/
#if !defined(__MINGW32__)
static ScmObj syslib_sys_wait_stoppedP(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj status_scm;
  int status;
  SCM_ENTER_SUBR("sys-wait-stopped?");
  status_scm = SCM_ARGREF(0);
  if (!SCM_EXACTP(status_scm)) Scm_Error("C integer required, but got %S", status_scm);
  status = Scm_GetInteger(status_scm);
  {
SCM_RETURN(SCM_MAKE_BOOL(WIFSTOPPED(status)));
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_wait_stoppedP__NAME, "sys-wait-stopped?", 17, 17);
static SCM_DEFINE_SUBR(syslib_sys_wait_stoppedP__STUB, 1, 0, SCM_OBJ(&syslib_sys_wait_stoppedP__NAME), syslib_sys_wait_stoppedP, NULL, NULL);

#endif /*!defined(__MINGW32__)*/
#if !defined(__MINGW32__)
static ScmObj syslib_sys_wait_stopsig(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj status_scm;
  int status;
  SCM_ENTER_SUBR("sys-wait-stopsig");
  status_scm = SCM_ARGREF(0);
  if (!SCM_EXACTP(status_scm)) Scm_Error("C integer required, but got %S", status_scm);
  status = Scm_GetInteger(status_scm);
  {
SCM_RETURN(Scm_MakeInteger(WSTOPSIG(status)));
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_wait_stopsig__NAME, "sys-wait-stopsig", 16, 16);
static SCM_DEFINE_SUBR(syslib_sys_wait_stopsig__STUB, 1, 0, SCM_OBJ(&syslib_sys_wait_stopsig__NAME), syslib_sys_wait_stopsig, NULL, NULL);

#endif /*!defined(__MINGW32__)*/
static ScmObj syslib_sys_time(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  SCM_ENTER_SUBR("sys-time");
  {
SCM_RETURN(Scm_MakeSysTime(time(NULL)));
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_time__NAME, "sys-time", 8, 8);
static SCM_DEFINE_SUBR(syslib_sys_time__STUB, 0, 0, SCM_OBJ(&syslib_sys_time__NAME), syslib_sys_time, NULL, NULL);

static ScmObj syslib_current_time(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  SCM_ENTER_SUBR("current-time");
  {
SCM_RETURN(Scm_CurrentTime());
  }
}

static SCM_DEFINE_STRING_CONST(syslib_current_time__NAME, "current-time", 12, 12);
static SCM_DEFINE_SUBR(syslib_current_time__STUB, 0, 0, SCM_OBJ(&syslib_current_time__NAME), syslib_current_time, NULL, NULL);

static ScmObj syslib_timeP(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj obj_scm;
  ScmObj obj;
  SCM_ENTER_SUBR("time?");
  obj_scm = SCM_ARGREF(0);
  obj = (obj_scm);
  {
SCM_RETURN(SCM_MAKE_BOOL(SCM_TIMEP(obj)));
  }
}

static SCM_DEFINE_STRING_CONST(syslib_timeP__NAME, "time?", 5, 5);
static SCM_DEFINE_SUBR(syslib_timeP__STUB, 1, 0, SCM_OBJ(&syslib_timeP__NAME), syslib_timeP, NULL, NULL);

static ScmObj syslib_time_TOseconds(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj t_scm;
  ScmTime* t;
  SCM_ENTER_SUBR("time->seconds");
  t_scm = SCM_ARGREF(0);
  if (!SCM_TIMEP(t_scm)) Scm_Error("<time> required, but got %S", t_scm);
  t = SCM_TIME(t_scm);
  {
SCM_RETURN(Scm_TimeToSeconds(t));
  }
}

static SCM_DEFINE_STRING_CONST(syslib_time_TOseconds__NAME, "time->seconds", 13, 13);
static SCM_DEFINE_SUBR(syslib_time_TOseconds__STUB, 1, 0, SCM_OBJ(&syslib_time_TOseconds__NAME), syslib_time_TOseconds, NULL, NULL);

static ScmObj syslib_seconds_TOtime(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj t_scm;
  double t;
  SCM_ENTER_SUBR("seconds->time");
  t_scm = SCM_ARGREF(0);
  if (!SCM_REALP(t_scm)) Scm_Error("real number required, but got %S", t_scm);
  t = Scm_GetDouble(t_scm);
  {
SCM_RETURN(Scm_RealSecondsToTime(t));
  }
}

static SCM_DEFINE_STRING_CONST(syslib_seconds_TOtime__NAME, "seconds->time", 13, 13);
static SCM_DEFINE_SUBR(syslib_seconds_TOtime__STUB, 1, 0, SCM_OBJ(&syslib_seconds_TOtime__NAME), syslib_seconds_TOtime, NULL, NULL);

static ScmObj syslib_sys_asctime(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj tm_scm;
  ScmSysTm* tm;
  SCM_ENTER_SUBR("sys-asctime");
  tm_scm = SCM_ARGREF(0);
  if (!SCM_SYS_TM_P(tm_scm)) Scm_Error("<sys-tm> required, but got %S", tm_scm);
  tm = SCM_SYS_TM(tm_scm);
  {
  SCM_RETURN(SCM_MAKE_STR_COPYING(asctime(&SCM_SYS_TM_TM(tm))));
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_asctime__NAME, "sys-asctime", 11, 11);
static SCM_DEFINE_SUBR(syslib_sys_asctime__STUB, 1, 0, SCM_OBJ(&syslib_sys_asctime__NAME), syslib_sys_asctime, NULL, NULL);

static ScmObj syslib_sys_ctime(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj time_scm;
  ScmObj time;
  SCM_ENTER_SUBR("sys-ctime");
  time_scm = SCM_ARGREF(0);
  time = (time_scm);
  {
time_t tim = Scm_GetSysTime(time);
  SCM_RETURN(SCM_MAKE_STR_COPYING(ctime(&tim)));
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_ctime__NAME, "sys-ctime", 9, 9);
static SCM_DEFINE_SUBR(syslib_sys_ctime__STUB, 1, 0, SCM_OBJ(&syslib_sys_ctime__NAME), syslib_sys_ctime, NULL, NULL);

static ScmObj syslib_sys_difftime(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj time1_scm;
  ScmObj time1;
  ScmObj time0_scm;
  ScmObj time0;
  SCM_ENTER_SUBR("sys-difftime");
  time1_scm = SCM_ARGREF(0);
  time1 = (time1_scm);
  time0_scm = SCM_ARGREF(1);
  time0 = (time0_scm);
  {
SCM_RETURN(Scm_MakeFlonum(difftime(Scm_GetSysTime(time1),
                                      Scm_GetSysTime(time0))));
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_difftime__NAME, "sys-difftime", 12, 12);
static SCM_DEFINE_SUBR(syslib_sys_difftime__STUB, 2, 0, SCM_OBJ(&syslib_sys_difftime__NAME), syslib_sys_difftime, NULL, NULL);

static ScmObj syslib_sys_strftime(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj format_scm;
  ScmString* format;
  ScmObj tm_scm;
  ScmSysTm* tm;
  SCM_ENTER_SUBR("sys-strftime");
  format_scm = SCM_ARGREF(0);
  if (!SCM_STRINGP(format_scm)) Scm_Error("string required, but got %S", format_scm);
  format = SCM_STRING(format_scm);
  tm_scm = SCM_ARGREF(1);
  if (!SCM_SYS_TM_P(tm_scm)) Scm_Error("<sys-tm> required, but got %S", tm_scm);
  tm = SCM_SYS_TM(tm_scm);
  {
  char tmpbuf[256];
  strftime(tmpbuf, sizeof(tmpbuf),
           Scm_GetStringConst(format), &SCM_SYS_TM_TM(tm));
  SCM_RETURN(SCM_MAKE_STR_COPYING(tmpbuf));
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_strftime__NAME, "sys-strftime", 12, 12);
static SCM_DEFINE_SUBR(syslib_sys_strftime__STUB, 2, 0, SCM_OBJ(&syslib_sys_strftime__NAME), syslib_sys_strftime, NULL, NULL);

static ScmObj syslib_sys_gmtime(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj time_scm;
  ScmObj time;
  SCM_ENTER_SUBR("sys-gmtime");
  time_scm = SCM_ARGREF(0);
  time = (time_scm);
  {
time_t tim = Scm_GetSysTime(time);
  SCM_RETURN(Scm_MakeSysTm(gmtime(&tim)));
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_gmtime__NAME, "sys-gmtime", 10, 10);
static SCM_DEFINE_SUBR(syslib_sys_gmtime__STUB, 1, 0, SCM_OBJ(&syslib_sys_gmtime__NAME), syslib_sys_gmtime, NULL, NULL);

static ScmObj syslib_sys_localtime(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj time_scm;
  ScmObj time;
  SCM_ENTER_SUBR("sys-localtime");
  time_scm = SCM_ARGREF(0);
  time = (time_scm);
  {
time_t tim = Scm_GetSysTime(time);
  SCM_RETURN(Scm_MakeSysTm(localtime(&tim)));
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_localtime__NAME, "sys-localtime", 13, 13);
static SCM_DEFINE_SUBR(syslib_sys_localtime__STUB, 1, 0, SCM_OBJ(&syslib_sys_localtime__NAME), syslib_sys_localtime, NULL, NULL);

static ScmObj syslib_sys_mktime(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj tm_scm;
  ScmSysTm* tm;
  SCM_ENTER_SUBR("sys-mktime");
  tm_scm = SCM_ARGREF(0);
  if (!SCM_SYS_TM_P(tm_scm)) Scm_Error("<sys-tm> required, but got %S", tm_scm);
  tm = SCM_SYS_TM(tm_scm);
  {
  SCM_RETURN(Scm_MakeSysTime(mktime(&SCM_SYS_TM_TM(tm))));
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_mktime__NAME, "sys-mktime", 10, 10);
static SCM_DEFINE_SUBR(syslib_sys_mktime__STUB, 1, 0, SCM_OBJ(&syslib_sys_mktime__NAME), syslib_sys_mktime, NULL, NULL);

static SCM_DEFINE_STRING_CONST(syslib_R_OK__VAR__NAME, "R_OK", 4, 4);
static ScmObj syslib_R_OK__VAR = SCM_UNBOUND;
static SCM_DEFINE_STRING_CONST(syslib_W_OK__VAR__NAME, "W_OK", 4, 4);
static ScmObj syslib_W_OK__VAR = SCM_UNBOUND;
static SCM_DEFINE_STRING_CONST(syslib_X_OK__VAR__NAME, "X_OK", 4, 4);
static ScmObj syslib_X_OK__VAR = SCM_UNBOUND;
static SCM_DEFINE_STRING_CONST(syslib_F_OK__VAR__NAME, "F_OK", 4, 4);
static ScmObj syslib_F_OK__VAR = SCM_UNBOUND;
static ScmObj syslib_sys_access(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj pathname_scm;
  ScmString* pathname;
  ScmObj amode_scm;
  int amode;
  SCM_ENTER_SUBR("sys-access");
  pathname_scm = SCM_ARGREF(0);
  if (!SCM_STRINGP(pathname_scm)) Scm_Error("string required, but got %S", pathname_scm);
  pathname = SCM_STRING(pathname_scm);
  amode_scm = SCM_ARGREF(1);
  if (!SCM_EXACTP(amode_scm)) Scm_Error("C integer required, but got %S", amode_scm);
  amode = Scm_GetInteger(amode_scm);
  {
int r;
  if (Scm_IsSugid()) {
    Scm_Error("cannot use sys-access in suid/sgid program.");
  }
  SCM_SYSCALL(r, access(Scm_GetStringConst(pathname), amode));
  SCM_RETURN((r == 0)? SCM_TRUE : SCM_FALSE);
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_access__NAME, "sys-access", 10, 10);
static SCM_DEFINE_SUBR(syslib_sys_access__STUB, 2, 0, SCM_OBJ(&syslib_sys_access__NAME), syslib_sys_access, NULL, NULL);

static ScmObj syslib_sys_chdir(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj pathname_scm;
  ScmString* pathname;
  SCM_ENTER_SUBR("sys-chdir");
  pathname_scm = SCM_ARGREF(0);
  if (!SCM_STRINGP(pathname_scm)) Scm_Error("string required, but got %S", pathname_scm);
  pathname = SCM_STRING(pathname_scm);
  {
 int r;
  SCM_SYSCALL(r, chdir(Scm_GetStringConst(pathname)));
  if (r < 0) Scm_SysError("chdir failed");
  SCM_RETURN(SCM_TRUE);
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_chdir__NAME, "sys-chdir", 9, 9);
static SCM_DEFINE_SUBR(syslib_sys_chdir__STUB, 1, 0, SCM_OBJ(&syslib_sys_chdir__NAME), syslib_sys_chdir, NULL, NULL);

static ScmObj syslib_sys_chmod(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj pathname_scm;
  ScmString* pathname;
  ScmObj mode_scm;
  int mode;
  SCM_ENTER_SUBR("sys-chmod");
  pathname_scm = SCM_ARGREF(0);
  if (!SCM_STRINGP(pathname_scm)) Scm_Error("string required, but got %S", pathname_scm);
  pathname = SCM_STRING(pathname_scm);
  mode_scm = SCM_ARGREF(1);
  if (!SCM_EXACTP(mode_scm)) Scm_Error("C integer required, but got %S", mode_scm);
  mode = Scm_GetInteger(mode_scm);
  {
 int r;
  SCM_SYSCALL(r, chmod(Scm_GetStringConst(pathname), mode));
  if (r < 0) Scm_SysError("chmod failed");
  SCM_RETURN(SCM_TRUE);
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_chmod__NAME, "sys-chmod", 9, 9);
static SCM_DEFINE_SUBR(syslib_sys_chmod__STUB, 2, 0, SCM_OBJ(&syslib_sys_chmod__NAME), syslib_sys_chmod, NULL, NULL);

static ScmObj syslib_sys_fork(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  SCM_ENTER_SUBR("sys-fork");
  {
  int pid;
  SCM_SYSCALL(pid, fork());
  if (pid < 0) Scm_SysError("fork failed");
  SCM_RETURN(Scm_MakeInteger(pid));
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_fork__NAME, "sys-fork", 8, 8);
static SCM_DEFINE_SUBR(syslib_sys_fork__STUB, 0, 0, SCM_OBJ(&syslib_sys_fork__NAME), syslib_sys_fork, NULL, NULL);

static ScmObj syslib_sys_exec(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj command_scm;
  ScmString* command;
  ScmObj args_scm;
  ScmObj args;
  ScmObj iomap_scm;
  ScmObj iomap;
  ScmObj SCM_OPTARGS = SCM_ARGREF(SCM_ARGCNT-1);
  SCM_ENTER_SUBR("sys-exec");
  if (Scm_Length(SCM_OPTARGS) > 1)
    Scm_Error("too many arguments: up to 1 is expected, %d given.", Scm_Length(SCM_OPTARGS));
  command_scm = SCM_ARGREF(0);
  if (!SCM_STRINGP(command_scm)) Scm_Error("string required, but got %S", command_scm);
  command = SCM_STRING(command_scm);
  args_scm = SCM_ARGREF(1);
  if (!SCM_LISTP(args_scm)) Scm_Error("list required, but got %S", args_scm);
  args = (args_scm);
  if (SCM_NULLP(SCM_OPTARGS)) iomap_scm = SCM_UNBOUND;
  else {
    iomap_scm = SCM_CAR(SCM_OPTARGS);
    SCM_OPTARGS = SCM_CDR(SCM_OPTARGS);
  }
  iomap = (iomap_scm);
  {
  Scm_SysExec(command, args, iomap, FALSE);
  SCM_RETURN(SCM_UNDEFINED); /* dummy */
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_exec__NAME, "sys-exec", 8, 8);
static SCM_DEFINE_SUBR(syslib_sys_exec__STUB, 2, 1, SCM_OBJ(&syslib_sys_exec__NAME), syslib_sys_exec, NULL, NULL);

static ScmObj syslib_sys_fork_and_exec(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj command_scm;
  ScmString* command;
  ScmObj args_scm;
  ScmObj args;
  ScmObj iomap_scm;
  ScmObj iomap;
  ScmObj SCM_OPTARGS = SCM_ARGREF(SCM_ARGCNT-1);
  SCM_ENTER_SUBR("sys-fork-and-exec");
  if (Scm_Length(SCM_OPTARGS) > 1)
    Scm_Error("too many arguments: up to 1 is expected, %d given.", Scm_Length(SCM_OPTARGS));
  command_scm = SCM_ARGREF(0);
  if (!SCM_STRINGP(command_scm)) Scm_Error("string required, but got %S", command_scm);
  command = SCM_STRING(command_scm);
  args_scm = SCM_ARGREF(1);
  if (!SCM_LISTP(args_scm)) Scm_Error("list required, but got %S", args_scm);
  args = (args_scm);
  if (SCM_NULLP(SCM_OPTARGS)) iomap_scm = SCM_UNBOUND;
  else {
    iomap_scm = SCM_CAR(SCM_OPTARGS);
    SCM_OPTARGS = SCM_CDR(SCM_OPTARGS);
  }
  iomap = (iomap_scm);
  {
SCM_RETURN(Scm_SysExec(command, args, iomap, TRUE));
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_fork_and_exec__NAME, "sys-fork-and-exec", 17, 17);
static SCM_DEFINE_SUBR(syslib_sys_fork_and_exec__STUB, 2, 1, SCM_OBJ(&syslib_sys_fork_and_exec__NAME), syslib_sys_fork_and_exec, NULL, NULL);

static ScmObj syslib_sys_getcwd(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  SCM_ENTER_SUBR("sys-getcwd");
  {
#define GETCWD_PATH_MAX 1024  /* TODO: needs to be configured */
  char p[GETCWD_PATH_MAX]; ScmObj s;
  if (getcwd(p, GETCWD_PATH_MAX-1) == NULL) Scm_SysError("getcwd failed");
  s = SCM_MAKE_STR_COPYING(p);
  SCM_RETURN(s);
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_getcwd__NAME, "sys-getcwd", 10, 10);
static SCM_DEFINE_SUBR(syslib_sys_getcwd__STUB, 0, 0, SCM_OBJ(&syslib_sys_getcwd__NAME), syslib_sys_getcwd, NULL, NULL);

static ScmObj syslib_sys_getegid(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  SCM_ENTER_SUBR("sys-getegid");
  {
SCM_RETURN(Scm_MakeInteger(getegid()));
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_getegid__NAME, "sys-getegid", 11, 11);
static SCM_DEFINE_SUBR(syslib_sys_getegid__STUB, 0, 0, SCM_OBJ(&syslib_sys_getegid__NAME), syslib_sys_getegid, NULL, NULL);

static ScmObj syslib_sys_getgid(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  SCM_ENTER_SUBR("sys-getgid");
  {
SCM_RETURN(Scm_MakeInteger(getgid()));
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_getgid__NAME, "sys-getgid", 10, 10);
static SCM_DEFINE_SUBR(syslib_sys_getgid__STUB, 0, 0, SCM_OBJ(&syslib_sys_getgid__NAME), syslib_sys_getgid, NULL, NULL);

static ScmObj syslib_sys_geteuid(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  SCM_ENTER_SUBR("sys-geteuid");
  {
SCM_RETURN(Scm_MakeInteger(geteuid()));
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_geteuid__NAME, "sys-geteuid", 11, 11);
static SCM_DEFINE_SUBR(syslib_sys_geteuid__STUB, 0, 0, SCM_OBJ(&syslib_sys_geteuid__NAME), syslib_sys_geteuid, NULL, NULL);

static ScmObj syslib_sys_getuid(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  SCM_ENTER_SUBR("sys-getuid");
  {
SCM_RETURN(Scm_MakeInteger(getuid()));
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_getuid__NAME, "sys-getuid", 10, 10);
static SCM_DEFINE_SUBR(syslib_sys_getuid__STUB, 0, 0, SCM_OBJ(&syslib_sys_getuid__NAME), syslib_sys_getuid, NULL, NULL);

static ScmObj syslib_sys_getpid(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  SCM_ENTER_SUBR("sys-getpid");
  {
SCM_RETURN(Scm_MakeInteger(getpid()));
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_getpid__NAME, "sys-getpid", 10, 10);
static SCM_DEFINE_SUBR(syslib_sys_getpid__STUB, 0, 0, SCM_OBJ(&syslib_sys_getpid__NAME), syslib_sys_getpid, NULL, NULL);

static ScmObj syslib_sys_getppid(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  SCM_ENTER_SUBR("sys-getppid");
  {
SCM_RETURN(Scm_MakeInteger(getppid()));
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_getppid__NAME, "sys-getppid", 11, 11);
static SCM_DEFINE_SUBR(syslib_sys_getppid__STUB, 0, 0, SCM_OBJ(&syslib_sys_getppid__NAME), syslib_sys_getppid, NULL, NULL);

static ScmObj syslib_sys_link(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj existing_scm;
  ScmString* existing;
  ScmObj newpath_scm;
  ScmString* newpath;
  SCM_ENTER_SUBR("sys-link");
  existing_scm = SCM_ARGREF(0);
  if (!SCM_STRINGP(existing_scm)) Scm_Error("string required, but got %S", existing_scm);
  existing = SCM_STRING(existing_scm);
  newpath_scm = SCM_ARGREF(1);
  if (!SCM_STRINGP(newpath_scm)) Scm_Error("string required, but got %S", newpath_scm);
  newpath = SCM_STRING(newpath_scm);
  {
 int r;
  SCM_SYSCALL(r, link(Scm_GetStringConst(existing), Scm_GetStringConst(newpath)));
  if (r < 0) Scm_SysError("link failed");
  SCM_RETURN(SCM_TRUE);
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_link__NAME, "sys-link", 8, 8);
static SCM_DEFINE_SUBR(syslib_sys_link__STUB, 2, 0, SCM_OBJ(&syslib_sys_link__NAME), syslib_sys_link, NULL, NULL);

static ScmObj syslib_sys_pause(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  SCM_ENTER_SUBR("sys-pause");
  {
SCM_RETURN(Scm_Pause());
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_pause__NAME, "sys-pause", 9, 9);
static SCM_DEFINE_SUBR(syslib_sys_pause__STUB, 0, 0, SCM_OBJ(&syslib_sys_pause__NAME), syslib_sys_pause, NULL, NULL);

static ScmObj syslib_sys_alarm(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj seconds_scm;
  int seconds;
  SCM_ENTER_SUBR("sys-alarm");
  seconds_scm = SCM_ARGREF(0);
  if (!SCM_INTP(seconds_scm)) Scm_Error("small integer required, but got %S", seconds_scm);
  seconds = SCM_INT_VALUE(seconds_scm);
  {
  int r;
  SCM_SYSCALL(r, alarm(seconds));
  SCM_RETURN(Scm_MakeInteger(r));
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_alarm__NAME, "sys-alarm", 9, 9);
static SCM_DEFINE_SUBR(syslib_sys_alarm__STUB, 1, 0, SCM_OBJ(&syslib_sys_alarm__NAME), syslib_sys_alarm, NULL, NULL);

static SCM_DEFINE_STRING_CONST(KEYARG_name__NAME, "name", 4, 4);
static ScmObj KEYARG_name = SCM_UNBOUND;
static SCM_DEFINE_STRING_CONST(KEYARG_buffering__NAME, "buffering", 9, 9);
static ScmObj KEYARG_buffering = SCM_UNBOUND;
static SCM_DEFINE_STRING_CONST(KEYARG_bufferedP__NAME, "buffered?", 9, 9);
static ScmObj KEYARG_bufferedP = SCM_UNBOUND;
static ScmObj syslib_sys_pipe(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj name_scm;
  ScmObj name;
  ScmObj buffering_scm;
  ScmObj buffering;
  ScmObj bufferedP_scm;
  ScmObj bufferedP;
  ScmObj SCM_OPTARGS = SCM_ARGREF(SCM_ARGCNT-1);
  SCM_ENTER_SUBR("sys-pipe");
  name_scm = Scm_GetKeyword(SCM_OBJ(KEYARG_name), SCM_OPTARGS, SCM_MAKE_STR("(pipe)"));
  name = (name_scm);
  buffering_scm = Scm_GetKeyword(SCM_OBJ(KEYARG_buffering), SCM_OPTARGS, SCM_FALSE);
  buffering = (buffering_scm);
  bufferedP_scm = Scm_GetKeyword(SCM_OBJ(KEYARG_bufferedP), SCM_OPTARGS, SCM_FALSE);
  bufferedP = (bufferedP_scm);
  {
  int fds[2], r, bufmode; ScmObj rend, wend;
  SCM_SYSCALL(r, pipe(fds));
  if (r < 0) Scm_SysError("pipe failed");
  if (SCM_TRUEP(bufferedP)) {
    bufmode = SCM_PORT_BUFFER_FULL; /* for backward compatibility */
  } else {
    bufmode = Scm_BufferingMode(buffering, -1, SCM_PORT_BUFFER_LINE);
  }
  rend = Scm_MakePortWithFd(name, SCM_PORT_INPUT, fds[0], bufmode, TRUE);
  wend = Scm_MakePortWithFd(name, SCM_PORT_OUTPUT, fds[1], bufmode, TRUE);
  SCM_RETURN(Scm_Values2(rend, wend));
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_pipe__NAME, "sys-pipe", 8, 8);
static SCM_DEFINE_SUBR(syslib_sys_pipe__STUB, 0, 1, SCM_OBJ(&syslib_sys_pipe__NAME), syslib_sys_pipe, NULL, NULL);

static ScmObj syslib_sys_mkdir(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj pathname_scm;
  ScmString* pathname;
  ScmObj mode_scm;
  int mode;
  SCM_ENTER_SUBR("sys-mkdir");
  pathname_scm = SCM_ARGREF(0);
  if (!SCM_STRINGP(pathname_scm)) Scm_Error("string required, but got %S", pathname_scm);
  pathname = SCM_STRING(pathname_scm);
  mode_scm = SCM_ARGREF(1);
  if (!SCM_EXACTP(mode_scm)) Scm_Error("C integer required, but got %S", mode_scm);
  mode = Scm_GetInteger(mode_scm);
  {
 int r;
#ifndef __MINGW32__
  SCM_SYSCALL(r, mkdir(Scm_GetStringConst(pathname), mode));
#else
  SCM_SYSCALL(r, mkdir(Scm_GetStringConst(pathname)));
#endif /*__MINGW32__*/
  if (r < 0) Scm_SysError("mkdir failed");
  SCM_RETURN(SCM_TRUE);
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_mkdir__NAME, "sys-mkdir", 9, 9);
static SCM_DEFINE_SUBR(syslib_sys_mkdir__STUB, 2, 0, SCM_OBJ(&syslib_sys_mkdir__NAME), syslib_sys_mkdir, NULL, NULL);

static ScmObj syslib_sys_rmdir(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj pathname_scm;
  ScmString* pathname;
  SCM_ENTER_SUBR("sys-rmdir");
  pathname_scm = SCM_ARGREF(0);
  if (!SCM_STRINGP(pathname_scm)) Scm_Error("string required, but got %S", pathname_scm);
  pathname = SCM_STRING(pathname_scm);
  {
 int r;
  SCM_SYSCALL(r, rmdir(Scm_GetStringConst(pathname)));
  if (r < 0) Scm_SysError("rmdir failed");
  SCM_RETURN(SCM_TRUE);
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_rmdir__NAME, "sys-rmdir", 9, 9);
static SCM_DEFINE_SUBR(syslib_sys_rmdir__STUB, 1, 0, SCM_OBJ(&syslib_sys_rmdir__NAME), syslib_sys_rmdir, NULL, NULL);

static ScmObj syslib_sys_umask(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj mode_scm;
  int mode;
  SCM_ENTER_SUBR("sys-umask");
  mode_scm = SCM_ARGREF(0);
  if (!SCM_INTP(mode_scm)) Scm_Error("small integer required, but got %S", mode_scm);
  mode = SCM_INT_VALUE(mode_scm);
  {
SCM_RETURN(Scm_MakeInteger(umask(mode)));
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_umask__NAME, "sys-umask", 9, 9);
static SCM_DEFINE_SUBR(syslib_sys_umask__STUB, 1, 0, SCM_OBJ(&syslib_sys_umask__NAME), syslib_sys_umask, NULL, NULL);

static ScmObj syslib_sys_sleep(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj seconds_scm;
  int seconds;
  SCM_ENTER_SUBR("sys-sleep");
  seconds_scm = SCM_ARGREF(0);
  if (!SCM_INTP(seconds_scm)) Scm_Error("small integer required, but got %S", seconds_scm);
  seconds = SCM_INT_VALUE(seconds_scm);
  {
SCM_RETURN(Scm_MakeInteger(sleep(seconds)));
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_sleep__NAME, "sys-sleep", 9, 9);
static SCM_DEFINE_SUBR(syslib_sys_sleep__STUB, 1, 0, SCM_OBJ(&syslib_sys_sleep__NAME), syslib_sys_sleep, NULL, NULL);

#if defined(HAVE_NANOSLEEP)
static ScmObj syslib_sys_nanosleep(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj nanoseconds_scm;
  ScmObj nanoseconds;
  SCM_ENTER_SUBR("sys-nanosleep");
  nanoseconds_scm = SCM_ARGREF(0);
  nanoseconds = (nanoseconds_scm);
  {
struct timespec spec, rem;
       if (SCM_TIMEP(nanoseconds)) {
           spec.tv_sec = SCM_TIME(nanoseconds)->sec;
           spec.tv_nsec = SCM_TIME(nanoseconds)->nsec;
       } else if (!SCM_REALP(nanoseconds)) {
           Scm_Error("bad timeout spec: <time> object or real number is required, but got %S", nanoseconds);
       } else {
           double v = Scm_GetDouble(nanoseconds);
           if (v < 0) Scm_Error("bad timeout spec: positive number required, but got %S", nanoseconds);
           spec.tv_sec = (unsigned long)floor(v/1.0e9);
           spec.tv_nsec = (unsigned long)fmod(v, 1.0e9);
           while (spec.tv_nsec >= 1000000000) {
               spec.tv_nsec -= 1000000000;
               spec.tv_sec += 1;
           }
       }
       rem.tv_sec = rem.tv_nsec = 0;
       nanosleep(&spec, &rem);
       if (rem.tv_sec == 0 && rem.tv_nsec == 0) SCM_RETURN(SCM_FALSE);
       else SCM_RETURN(Scm_MakeTime(SCM_FALSE, rem.tv_sec, rem.tv_nsec));
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_nanosleep__NAME, "sys-nanosleep", 13, 13);
static SCM_DEFINE_SUBR(syslib_sys_nanosleep__STUB, 1, 0, SCM_OBJ(&syslib_sys_nanosleep__NAME), syslib_sys_nanosleep, NULL, NULL);

#endif /*defined(HAVE_NANOSLEEP)*/
static ScmObj syslib_sys_unlink(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj pathname_scm;
  ScmString* pathname;
  SCM_ENTER_SUBR("sys-unlink");
  pathname_scm = SCM_ARGREF(0);
  if (!SCM_STRINGP(pathname_scm)) Scm_Error("string required, but got %S", pathname_scm);
  pathname = SCM_STRING(pathname_scm);
  {
  int r;
  SCM_SYSCALL(r, unlink(Scm_GetStringConst(pathname)));
  if (r < 0) {
     if (errno == ENOENT) { SCM_RETURN(SCM_FALSE); }
     else Scm_SysError("unlink failed");
  }
  SCM_RETURN(SCM_TRUE);
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_unlink__NAME, "sys-unlink", 10, 10);
static SCM_DEFINE_SUBR(syslib_sys_unlink__STUB, 1, 0, SCM_OBJ(&syslib_sys_unlink__NAME), syslib_sys_unlink, NULL, NULL);

static ScmObj syslib_sys_isatty(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj port_or_fd_scm;
  ScmObj port_or_fd;
  SCM_ENTER_SUBR("sys-isatty");
  port_or_fd_scm = SCM_ARGREF(0);
  port_or_fd = (port_or_fd_scm);
  {
  int fd = Scm_GetPortFd(port_or_fd, FALSE);
  SCM_RETURN(SCM_MAKE_BOOL(fd >= 0 && isatty(fd)));
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_isatty__NAME, "sys-isatty", 10, 10);
static SCM_DEFINE_SUBR(syslib_sys_isatty__STUB, 1, 0, SCM_OBJ(&syslib_sys_isatty__NAME), syslib_sys_isatty, NULL, NULL);

static ScmObj syslib_sys_ttyname(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj port_or_fd_scm;
  ScmObj port_or_fd;
  SCM_ENTER_SUBR("sys-ttyname");
  port_or_fd_scm = SCM_ARGREF(0);
  port_or_fd = (port_or_fd_scm);
  {
  int fd = Scm_GetPortFd(port_or_fd, FALSE); const char *name;
  if (fd < 0) SCM_RETURN(SCM_FALSE);
  name = ttyname(fd);
  if (name) SCM_RETURN(SCM_MAKE_STR_COPYING(name));
  else SCM_RETURN(SCM_FALSE);
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_ttyname__NAME, "sys-ttyname", 11, 11);
static SCM_DEFINE_SUBR(syslib_sys_ttyname__STUB, 1, 0, SCM_OBJ(&syslib_sys_ttyname__NAME), syslib_sys_ttyname, NULL, NULL);

static ScmObj syslib_sys_truncate(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj path_scm;
  ScmString* path;
  ScmObj length_scm;
  ScmObj length;
  SCM_ENTER_SUBR("sys-truncate");
  path_scm = SCM_ARGREF(0);
  if (!SCM_STRINGP(path_scm)) Scm_Error("string required, but got %S", path_scm);
  path = SCM_STRING(path_scm);
  length_scm = SCM_ARGREF(1);
  if (!SCM_EXACTP(length_scm)) Scm_Error("exact integer required, but got %S", length_scm);
  length = (length_scm);
  {
int r;
  SCM_SYSCALL(r, truncate(Scm_GetStringConst(path), Scm_IntegerToOffset(length)));
  if (r < 0) Scm_SysError("truncate failed");
  SCM_RETURN(SCM_TRUE);
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_truncate__NAME, "sys-truncate", 12, 12);
static SCM_DEFINE_SUBR(syslib_sys_truncate__STUB, 2, 0, SCM_OBJ(&syslib_sys_truncate__NAME), syslib_sys_truncate, NULL, NULL);

static ScmObj syslib_sys_ftruncate(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj port_or_fd_scm;
  ScmObj port_or_fd;
  ScmObj length_scm;
  ScmObj length;
  SCM_ENTER_SUBR("sys-ftruncate");
  port_or_fd_scm = SCM_ARGREF(0);
  port_or_fd = (port_or_fd_scm);
  length_scm = SCM_ARGREF(1);
  if (!SCM_EXACTP(length_scm)) Scm_Error("exact integer required, but got %S", length_scm);
  length = (length_scm);
  {
int r;
  int fd = Scm_GetPortFd(port_or_fd, TRUE);
  SCM_SYSCALL(r, ftruncate(fd, Scm_IntegerToOffset(length)));
  if (r < 0) Scm_SysError("ftruncate failed");
  SCM_RETURN(SCM_TRUE);
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_ftruncate__NAME, "sys-ftruncate", 13, 13);
static SCM_DEFINE_SUBR(syslib_sys_ftruncate__STUB, 2, 0, SCM_OBJ(&syslib_sys_ftruncate__NAME), syslib_sys_ftruncate, NULL, NULL);

#if defined(HAVE_CRYPT)
static ScmObj syslib_sys_crypt(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj key_scm;
  ScmString* key;
  ScmObj salt_scm;
  ScmString* salt;
  SCM_ENTER_SUBR("sys-crypt");
  key_scm = SCM_ARGREF(0);
  if (!SCM_STRINGP(key_scm)) Scm_Error("string required, but got %S", key_scm);
  key = SCM_STRING(key_scm);
  salt_scm = SCM_ARGREF(1);
  if (!SCM_STRINGP(salt_scm)) Scm_Error("string required, but got %S", salt_scm);
  salt = SCM_STRING(salt_scm);
  {

  SCM_RETURN(SCM_MAKE_STR_COPYING((const char *)crypt(Scm_GetStringConst(key),
                                                      Scm_GetStringConst(salt))));
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_crypt__NAME, "sys-crypt", 9, 9);
static SCM_DEFINE_SUBR(syslib_sys_crypt__STUB, 2, 0, SCM_OBJ(&syslib_sys_crypt__NAME), syslib_sys_crypt, NULL, NULL);

#endif /*defined(HAVE_CRYPT)*/
#if defined(HAVE_SYMLINK)
static ScmObj syslib_sys_symlink(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj existing_scm;
  ScmString* existing;
  ScmObj new_scm;
  ScmString* new;
  SCM_ENTER_SUBR("sys-symlink");
  existing_scm = SCM_ARGREF(0);
  if (!SCM_STRINGP(existing_scm)) Scm_Error("string required, but got %S", existing_scm);
  existing = SCM_STRING(existing_scm);
  new_scm = SCM_ARGREF(1);
  if (!SCM_STRINGP(new_scm)) Scm_Error("string required, but got %S", new_scm);
  new = SCM_STRING(new_scm);
  {

#ifdef HAVE_SYMLINK
  int r;
  SCM_SYSCALL(r, symlink(Scm_GetStringConst(existing), Scm_GetStringConst(new)));
  if (r < 0) Scm_SysError("link failed");
  SCM_RETURN(SCM_TRUE);
#else
  Scm_Error("the system doesn't support symbolic links");
  SCM_RETURN(SCM_FALSE);
#endif

  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_symlink__NAME, "sys-symlink", 11, 11);
static SCM_DEFINE_SUBR(syslib_sys_symlink__STUB, 2, 0, SCM_OBJ(&syslib_sys_symlink__NAME), syslib_sys_symlink, NULL, NULL);

#endif /*defined(HAVE_SYMLINK)*/
#if defined(HAVE_READLINK)
static ScmObj syslib_sys_readlink(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj path_scm;
  ScmString* path;
  SCM_ENTER_SUBR("sys-readlink");
  path_scm = SCM_ARGREF(0);
  if (!SCM_STRINGP(path_scm)) Scm_Error("string required, but got %S", path_scm);
  path = SCM_STRING(path_scm);
  {
#define READLINK_PATH_MAX 1024  /* TODO: needs to be configured */
  char buf[READLINK_PATH_MAX];
  int n;
  SCM_SYSCALL(n, readlink(Scm_GetStringConst(path), buf, READLINK_PATH_MAX));
  if (n < 0) Scm_SysError("readlink failed");
  if (n == READLINK_PATH_MAX) Scm_Error("readlink result too long");
  return Scm_MakeString(buf, n, -1, SCM_MAKSTR_COPYING);
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_readlink__NAME, "sys-readlink", 12, 12);
static SCM_DEFINE_SUBR(syslib_sys_readlink__STUB, 1, 0, SCM_OBJ(&syslib_sys_readlink__NAME), syslib_sys_readlink, NULL, NULL);

#endif /*defined(HAVE_READLINK)*/
#if defined(HAVE_SELECT)
static ScmObj syslib_sys_fdset_ref(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj fdset_scm;
  ScmSysFdset* fdset;
  ScmObj pf_scm;
  ScmObj pf;
  SCM_ENTER_SUBR("sys-fdset-ref");
  fdset_scm = SCM_ARGREF(0);
  if (!SCM_SYS_FDSET_P(fdset_scm)) Scm_Error("<sys-fdset> required, but got %S", fdset_scm);
  fdset = SCM_SYS_FDSET(fdset_scm);
  pf_scm = SCM_ARGREF(1);
  pf = (pf_scm);
  {
int fd = Scm_GetPortFd(pf, FALSE);
  if (fd < 0) SCM_RETURN(SCM_TRUE);
  else SCM_RETURN(SCM_MAKE_BOOL(FD_ISSET(fd, &fdset->fdset)));
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_fdset_ref__NAME, "sys-fdset-ref", 13, 13);
static SCM_DEFINE_SUBR(syslib_sys_fdset_ref__STUB, 2, 0, SCM_OBJ(&syslib_sys_fdset_ref__NAME), syslib_sys_fdset_ref, NULL, NULL);

#endif /*defined(HAVE_SELECT)*/
#if defined(HAVE_SELECT)
static ScmObj syslib_sys_fdset_setX(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj fdset_scm;
  ScmSysFdset* fdset;
  ScmObj pf_scm;
  ScmObj pf;
  ScmObj flag_scm;
  int flag;
  SCM_ENTER_SUBR("sys-fdset-set!");
  fdset_scm = SCM_ARGREF(0);
  if (!SCM_SYS_FDSET_P(fdset_scm)) Scm_Error("<sys-fdset> required, but got %S", fdset_scm);
  fdset = SCM_SYS_FDSET(fdset_scm);
  pf_scm = SCM_ARGREF(1);
  pf = (pf_scm);
  flag_scm = SCM_ARGREF(2);
  if (!SCM_BOOLP(flag_scm)) Scm_Error("boolean required, but got %S", flag_scm);
  flag = SCM_BOOL_VALUE(flag_scm);
  {
int fd = Scm_GetPortFd(pf, FALSE);
  if (fd >= 0) {
    if (flag) {
      FD_SET(fd, &fdset->fdset);
      if (fdset->maxfd < fd) fdset->maxfd = fd;
    } else {
      FD_CLR(fd, &fdset->fdset);
      if (fdset->maxfd == fd) {
        int i;
        for (i=fdset->maxfd-1; i>=0; i--) {
          if (FD_ISSET(i, &fdset->fdset)) break;
        }
        fdset->maxfd = i;
      }
    }
  }
  SCM_RETURN(SCM_UNDEFINED);
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_fdset_setX__NAME, "sys-fdset-set!", 14, 14);
static SCM_DEFINE_SUBR(syslib_sys_fdset_setX__STUB, 3, 0, SCM_OBJ(&syslib_sys_fdset_setX__NAME), syslib_sys_fdset_setX, NULL, NULL);

#endif /*defined(HAVE_SELECT)*/
#if defined(HAVE_SELECT)
static ScmObj syslib_sys_fdset_max_fd(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj fdset_scm;
  ScmSysFdset* fdset;
  SCM_ENTER_SUBR("sys-fdset-max-fd");
  fdset_scm = SCM_ARGREF(0);
  if (!SCM_SYS_FDSET_P(fdset_scm)) Scm_Error("<sys-fdset> required, but got %S", fdset_scm);
  fdset = SCM_SYS_FDSET(fdset_scm);
  {
  SCM_RETURN(Scm_MakeInteger(fdset->maxfd));
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_fdset_max_fd__NAME, "sys-fdset-max-fd", 16, 16);
static SCM_DEFINE_SUBR(syslib_sys_fdset_max_fd__STUB, 1, 0, SCM_OBJ(&syslib_sys_fdset_max_fd__NAME), syslib_sys_fdset_max_fd, NULL, NULL);

#endif /*defined(HAVE_SELECT)*/
#if defined(HAVE_SELECT)
static ScmObj syslib_sys_select(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj rfds_scm;
  ScmObj rfds;
  ScmObj wfds_scm;
  ScmObj wfds;
  ScmObj efds_scm;
  ScmObj efds;
  ScmObj timeout_scm;
  ScmObj timeout;
  ScmObj SCM_OPTARGS = SCM_ARGREF(SCM_ARGCNT-1);
  SCM_ENTER_SUBR("sys-select");
  if (Scm_Length(SCM_OPTARGS) > 1)
    Scm_Error("too many arguments: up to 1 is expected, %d given.", Scm_Length(SCM_OPTARGS));
  rfds_scm = SCM_ARGREF(0);
  rfds = (rfds_scm);
  wfds_scm = SCM_ARGREF(1);
  wfds = (wfds_scm);
  efds_scm = SCM_ARGREF(2);
  efds = (efds_scm);
  if (SCM_NULLP(SCM_OPTARGS)) timeout_scm = SCM_FALSE;
  else {
    timeout_scm = SCM_CAR(SCM_OPTARGS);
    SCM_OPTARGS = SCM_CDR(SCM_OPTARGS);
  }
  timeout = (timeout_scm);
  {
SCM_RETURN(Scm_SysSelect(rfds, wfds, efds, timeout));
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_select__NAME, "sys-select", 10, 10);
static SCM_DEFINE_SUBR(syslib_sys_select__STUB, 3, 1, SCM_OBJ(&syslib_sys_select__NAME), syslib_sys_select, NULL, NULL);

#endif /*defined(HAVE_SELECT)*/
#if defined(HAVE_SELECT)
static ScmObj syslib_sys_selectX(ScmObj *SCM_FP, int SCM_ARGCNT, void *data_)
{
  ScmObj rfds_scm;
  ScmObj rfds;
  ScmObj wfds_scm;
  ScmObj wfds;
  ScmObj efds_scm;
  ScmObj efds;
  ScmObj timeout_scm;
  ScmObj timeout;
  ScmObj SCM_OPTARGS = SCM_ARGREF(SCM_ARGCNT-1);
  SCM_ENTER_SUBR("sys-select!");
  if (Scm_Length(SCM_OPTARGS) > 1)
    Scm_Error("too many arguments: up to 1 is expected, %d given.", Scm_Length(SCM_OPTARGS));
  rfds_scm = SCM_ARGREF(0);
  rfds = (rfds_scm);
  wfds_scm = SCM_ARGREF(1);
  wfds = (wfds_scm);
  efds_scm = SCM_ARGREF(2);
  efds = (efds_scm);
  if (SCM_NULLP(SCM_OPTARGS)) timeout_scm = SCM_FALSE;
  else {
    timeout_scm = SCM_CAR(SCM_OPTARGS);
    SCM_OPTARGS = SCM_CDR(SCM_OPTARGS);
  }
  timeout = (timeout_scm);
  {
SCM_RETURN(Scm_SysSelectX(rfds, wfds, efds, timeout));
  }
}

static SCM_DEFINE_STRING_CONST(syslib_sys_selectX__NAME, "sys-select!", 11, 11);
static SCM_DEFINE_SUBR(syslib_sys_selectX__STUB, 3, 1, SCM_OBJ(&syslib_sys_selectX__NAME), syslib_sys_selectX, NULL, NULL);

#endif /*defined(HAVE_SELECT)*/
void Scm_Init_syslib(ScmModule *module)
{
#if defined(HAVE_SELECT)
  SCM_DEFINE(module, "sys-select!", SCM_OBJ(&syslib_sys_selectX__STUB));
#endif /*defined(HAVE_SELECT)*/
#if defined(HAVE_SELECT)
  SCM_DEFINE(module, "sys-select", SCM_OBJ(&syslib_sys_select__STUB));
#endif /*defined(HAVE_SELECT)*/
#if defined(HAVE_SELECT)
  SCM_DEFINE(module, "sys-fdset-max-fd", SCM_OBJ(&syslib_sys_fdset_max_fd__STUB));
#endif /*defined(HAVE_SELECT)*/
#if defined(HAVE_SELECT)
  SCM_DEFINE(module, "sys-fdset-set!", SCM_OBJ(&syslib_sys_fdset_setX__STUB));
#endif /*defined(HAVE_SELECT)*/
#if defined(HAVE_SELECT)
  SCM_DEFINE(module, "sys-fdset-ref", SCM_OBJ(&syslib_sys_fdset_ref__STUB));
  Scm_SetterSet(SCM_PROCEDURE(&syslib_sys_fdset_ref__STUB), SCM_PROCEDURE(&syslib_sys_fdset_setX__STUB), TRUE);
#endif /*defined(HAVE_SELECT)*/
#if defined(HAVE_READLINK)
  SCM_DEFINE(module, "sys-readlink", SCM_OBJ(&syslib_sys_readlink__STUB));
#endif /*defined(HAVE_READLINK)*/
#if defined(HAVE_SYMLINK)
  SCM_DEFINE(module, "sys-symlink", SCM_OBJ(&syslib_sys_symlink__STUB));
#endif /*defined(HAVE_SYMLINK)*/
#if defined(HAVE_CRYPT)
  SCM_DEFINE(module, "sys-crypt", SCM_OBJ(&syslib_sys_crypt__STUB));
#endif /*defined(HAVE_CRYPT)*/
  SCM_DEFINE(module, "sys-ftruncate", SCM_OBJ(&syslib_sys_ftruncate__STUB));
  SCM_DEFINE(module, "sys-truncate", SCM_OBJ(&syslib_sys_truncate__STUB));
  SCM_DEFINE(module, "sys-ttyname", SCM_OBJ(&syslib_sys_ttyname__STUB));
  SCM_DEFINE(module, "sys-isatty", SCM_OBJ(&syslib_sys_isatty__STUB));
  SCM_DEFINE(module, "sys-unlink", SCM_OBJ(&syslib_sys_unlink__STUB));
#if defined(HAVE_NANOSLEEP)
  SCM_DEFINE(module, "sys-nanosleep", SCM_OBJ(&syslib_sys_nanosleep__STUB));
#endif /*defined(HAVE_NANOSLEEP)*/
  SCM_DEFINE(module, "sys-sleep", SCM_OBJ(&syslib_sys_sleep__STUB));
  SCM_DEFINE(module, "sys-umask", SCM_OBJ(&syslib_sys_umask__STUB));
  SCM_DEFINE(module, "sys-rmdir", SCM_OBJ(&syslib_sys_rmdir__STUB));
  SCM_DEFINE(module, "sys-mkdir", SCM_OBJ(&syslib_sys_mkdir__STUB));
  KEYARG_bufferedP = Scm_MakeKeyword(&KEYARG_bufferedP__NAME);
  KEYARG_buffering = Scm_MakeKeyword(&KEYARG_buffering__NAME);
  KEYARG_name = Scm_MakeKeyword(&KEYARG_name__NAME);
  SCM_DEFINE(module, "sys-pipe", SCM_OBJ(&syslib_sys_pipe__STUB));
  SCM_DEFINE(module, "sys-alarm", SCM_OBJ(&syslib_sys_alarm__STUB));
  SCM_DEFINE(module, "sys-pause", SCM_OBJ(&syslib_sys_pause__STUB));
  SCM_DEFINE(module, "sys-link", SCM_OBJ(&syslib_sys_link__STUB));
  SCM_DEFINE(module, "sys-getppid", SCM_OBJ(&syslib_sys_getppid__STUB));
  SCM_DEFINE(module, "sys-getpid", SCM_OBJ(&syslib_sys_getpid__STUB));
  SCM_DEFINE(module, "sys-getuid", SCM_OBJ(&syslib_sys_getuid__STUB));
  SCM_DEFINE(module, "sys-geteuid", SCM_OBJ(&syslib_sys_geteuid__STUB));
  SCM_DEFINE(module, "sys-getgid", SCM_OBJ(&syslib_sys_getgid__STUB));
  SCM_DEFINE(module, "sys-getegid", SCM_OBJ(&syslib_sys_getegid__STUB));
  SCM_DEFINE(module, "sys-getcwd", SCM_OBJ(&syslib_sys_getcwd__STUB));
  SCM_DEFINE(module, "sys-fork-and-exec", SCM_OBJ(&syslib_sys_fork_and_exec__STUB));
  SCM_DEFINE(module, "sys-exec", SCM_OBJ(&syslib_sys_exec__STUB));
  SCM_DEFINE(module, "sys-fork", SCM_OBJ(&syslib_sys_fork__STUB));
  SCM_DEFINE(module, "sys-chmod", SCM_OBJ(&syslib_sys_chmod__STUB));
  SCM_DEFINE(module, "sys-chdir", SCM_OBJ(&syslib_sys_chdir__STUB));
  SCM_DEFINE(module, "sys-access", SCM_OBJ(&syslib_sys_access__STUB));
  syslib_F_OK__VAR = Scm_Intern(&syslib_F_OK__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_F_OK__VAR)), SCM_OBJ(Scm_MakeInteger(F_OK)));
  syslib_X_OK__VAR = Scm_Intern(&syslib_X_OK__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_X_OK__VAR)), SCM_OBJ(Scm_MakeInteger(X_OK)));
  syslib_W_OK__VAR = Scm_Intern(&syslib_W_OK__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_W_OK__VAR)), SCM_OBJ(Scm_MakeInteger(W_OK)));
  syslib_R_OK__VAR = Scm_Intern(&syslib_R_OK__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_R_OK__VAR)), SCM_OBJ(Scm_MakeInteger(R_OK)));
  SCM_DEFINE(module, "sys-mktime", SCM_OBJ(&syslib_sys_mktime__STUB));
  SCM_DEFINE(module, "sys-localtime", SCM_OBJ(&syslib_sys_localtime__STUB));
  SCM_DEFINE(module, "sys-gmtime", SCM_OBJ(&syslib_sys_gmtime__STUB));
  SCM_DEFINE(module, "sys-strftime", SCM_OBJ(&syslib_sys_strftime__STUB));
  SCM_DEFINE(module, "sys-difftime", SCM_OBJ(&syslib_sys_difftime__STUB));
  SCM_DEFINE(module, "sys-ctime", SCM_OBJ(&syslib_sys_ctime__STUB));
  SCM_DEFINE(module, "sys-asctime", SCM_OBJ(&syslib_sys_asctime__STUB));
  SCM_DEFINE(module, "seconds->time", SCM_OBJ(&syslib_seconds_TOtime__STUB));
  SCM_DEFINE(module, "time->seconds", SCM_OBJ(&syslib_time_TOseconds__STUB));
  SCM_DEFINE(module, "time?", SCM_OBJ(&syslib_timeP__STUB));
  SCM_DEFINE(module, "current-time", SCM_OBJ(&syslib_current_time__STUB));
  SCM_DEFINE(module, "sys-time", SCM_OBJ(&syslib_sys_time__STUB));
#if !defined(__MINGW32__)
  SCM_DEFINE(module, "sys-wait-stopsig", SCM_OBJ(&syslib_sys_wait_stopsig__STUB));
#endif /*!defined(__MINGW32__)*/
#if !defined(__MINGW32__)
  SCM_DEFINE(module, "sys-wait-stopped?", SCM_OBJ(&syslib_sys_wait_stoppedP__STUB));
#endif /*!defined(__MINGW32__)*/
#if !defined(__MINGW32__)
  SCM_DEFINE(module, "sys-wait-termsig", SCM_OBJ(&syslib_sys_wait_termsig__STUB));
#endif /*!defined(__MINGW32__)*/
#if !defined(__MINGW32__)
  SCM_DEFINE(module, "sys-wait-signaled?", SCM_OBJ(&syslib_sys_wait_signaledP__STUB));
#endif /*!defined(__MINGW32__)*/
#if !defined(__MINGW32__)
  SCM_DEFINE(module, "sys-wait-exit-status", SCM_OBJ(&syslib_sys_wait_exit_status__STUB));
#endif /*!defined(__MINGW32__)*/
#if !defined(__MINGW32__)
  SCM_DEFINE(module, "sys-wait-exited?", SCM_OBJ(&syslib_sys_wait_exitedP__STUB));
#endif /*!defined(__MINGW32__)*/
#if !defined(__MINGW32__)
  KEYARG_untraced = Scm_MakeKeyword(&KEYARG_untraced__NAME);
#endif /*!defined(__MINGW32__)*/
#if !defined(__MINGW32__)
  KEYARG_nohang = Scm_MakeKeyword(&KEYARG_nohang__NAME);
#endif /*!defined(__MINGW32__)*/
#if !defined(__MINGW32__)
  SCM_DEFINE(module, "sys-waitpid", SCM_OBJ(&syslib_sys_waitpid__STUB));
#endif /*!defined(__MINGW32__)*/
#if !defined(__MINGW32__)
  SCM_DEFINE(module, "sys-wait", SCM_OBJ(&syslib_sys_wait__STUB));
#endif /*!defined(__MINGW32__)*/
  SCM_DEFINE(module, "sys-fstat", SCM_OBJ(&syslib_sys_fstat__STUB));
#if !defined(__MINGW32__)
  SCM_DEFINE(module, "sys-lstat", SCM_OBJ(&syslib_sys_lstat__STUB));
#endif /*!defined(__MINGW32__)*/
  SCM_DEFINE(module, "sys-stat", SCM_OBJ(&syslib_sys_stat__STUB));
  syslib_RAND_MAX__VAR = Scm_Intern(&syslib_RAND_MAX__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_RAND_MAX__VAR)), SCM_OBJ(Scm_MakeIntegerFromUI(RAND_MAX)));
  SCM_DEFINE(module, "sys-srandom", SCM_OBJ(&syslib_sys_srandom__STUB));
  SCM_DEFINE(module, "sys-random", SCM_OBJ(&syslib_sys_random__STUB));
  SCM_DEFINE(module, "sys-system", SCM_OBJ(&syslib_sys_system__STUB));
  SCM_DEFINE(module, "sys-getenv", SCM_OBJ(&syslib_sys_getenv__STUB));
  SCM_DEFINE(module, "sys-exit", SCM_OBJ(&syslib_sys_exit__STUB));
  SCM_DEFINE(module, "sys-mkstemp", SCM_OBJ(&syslib_sys_mkstemp__STUB));
  SCM_DEFINE(module, "sys-tmpnam", SCM_OBJ(&syslib_sys_tmpnam__STUB));
  SCM_DEFINE(module, "sys-rename", SCM_OBJ(&syslib_sys_rename__STUB));
  SCM_DEFINE(module, "sys-remove", SCM_OBJ(&syslib_sys_remove__STUB));
  SCM_DEFINE(module, "sys-sigsuspend", SCM_OBJ(&syslib_sys_sigsuspend__STUB));
  SCM_DEFINE(module, "sys-sigmask", SCM_OBJ(&syslib_sys_sigmask__STUB));
  syslib_SIG_UNBLOCK__VAR = Scm_Intern(&syslib_SIG_UNBLOCK__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_SIG_UNBLOCK__VAR)), SCM_OBJ(Scm_MakeInteger(SIG_UNBLOCK)));
  syslib_SIG_BLOCK__VAR = Scm_Intern(&syslib_SIG_BLOCK__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_SIG_BLOCK__VAR)), SCM_OBJ(Scm_MakeInteger(SIG_BLOCK)));
  syslib_SIG_SETMASK__VAR = Scm_Intern(&syslib_SIG_SETMASK__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_SIG_SETMASK__VAR)), SCM_OBJ(Scm_MakeInteger(SIG_SETMASK)));
  SCM_DEFINE(module, "get-signal-handlers", SCM_OBJ(&syslib_get_signal_handlers__STUB));
  SCM_DEFINE(module, "get-signal-handler", SCM_OBJ(&syslib_get_signal_handler__STUB));
  SCM_DEFINE(module, "set-signal-handler!", SCM_OBJ(&syslib_set_signal_handlerX__STUB));
  SCM_DEFINE(module, "sys-kill", SCM_OBJ(&syslib_sys_kill__STUB));
  SCM_DEFINE(module, "sys-signal-name", SCM_OBJ(&syslib_sys_signal_name__STUB));
  SCM_DEFINE(module, "sys-sigset-empty!", SCM_OBJ(&syslib_sys_sigset_emptyX__STUB));
  SCM_DEFINE(module, "sys-sigset-fill!", SCM_OBJ(&syslib_sys_sigset_fillX__STUB));
  SCM_DEFINE(module, "sys-sigset-delete!", SCM_OBJ(&syslib_sys_sigset_deleteX__STUB));
  SCM_DEFINE(module, "sys-sigset-add!", SCM_OBJ(&syslib_sys_sigset_addX__STUB));
  SCM_DEFINE(module, "sys-user-name->uid", SCM_OBJ(&syslib_sys_user_name_TOuid__STUB));
  SCM_DEFINE(module, "sys-uid->user-name", SCM_OBJ(&syslib_sys_uid_TOuser_name__STUB));
  SCM_DEFINE(module, "sys-getpwnam", SCM_OBJ(&syslib_sys_getpwnam__STUB));
  SCM_DEFINE(module, "sys-getpwuid", SCM_OBJ(&syslib_sys_getpwuid__STUB));
  SCM_DEFINE(module, "sys-setlocale", SCM_OBJ(&syslib_sys_setlocale__STUB));
  syslib_LC_TIME__VAR = Scm_Intern(&syslib_LC_TIME__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_LC_TIME__VAR)), SCM_OBJ(Scm_MakeInteger(LC_TIME)));
  syslib_LC_NUMERIC__VAR = Scm_Intern(&syslib_LC_NUMERIC__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_LC_NUMERIC__VAR)), SCM_OBJ(Scm_MakeInteger(LC_NUMERIC)));
  syslib_LC_MONETARY__VAR = Scm_Intern(&syslib_LC_MONETARY__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_LC_MONETARY__VAR)), SCM_OBJ(Scm_MakeInteger(LC_MONETARY)));
  syslib_LC_CTYPE__VAR = Scm_Intern(&syslib_LC_CTYPE__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_LC_CTYPE__VAR)), SCM_OBJ(Scm_MakeInteger(LC_CTYPE)));
  syslib_LC_COLLATE__VAR = Scm_Intern(&syslib_LC_COLLATE__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_LC_COLLATE__VAR)), SCM_OBJ(Scm_MakeInteger(LC_COLLATE)));
  syslib_LC_ALL__VAR = Scm_Intern(&syslib_LC_ALL__VAR__NAME);
  Scm_DefineConst(module, SCM_SYMBOL(SCM_OBJ(syslib_LC_ALL__VAR)), SCM_OBJ(Scm_MakeInteger(LC_ALL)));
  SCM_DEFINE(module, "sys-group-name->gid", SCM_OBJ(&syslib_sys_group_name_TOgid__STUB));
  SCM_DEFINE(module, "sys-gid->group-name", SCM_OBJ(&syslib_sys_gid_TOgroup_name__STUB));
  SCM_DEFINE(module, "sys-getgrnam", SCM_OBJ(&syslib_sys_getgrnam__STUB));
  SCM_DEFINE(module, "sys-getgrgid", SCM_OBJ(&syslib_sys_getgrgid__STUB));
  SCM_DEFINE(module, "sys-dirname", SCM_OBJ(&syslib_sys_dirname__STUB));
  SCM_DEFINE(module, "sys-basename", SCM_OBJ(&syslib_sys_basename__STUB));
  KEYARG_canonicalize = Scm_MakeKeyword(&KEYARG_canonicalize__NAME);
  KEYARG_expand = Scm_MakeKeyword(&KEYARG_expand__NAME);
  KEYARG_absolute = Scm_MakeKeyword(&KEYARG_absolute__NAME);
  SCM_DEFINE(module, "sys-normalize-pathname", SCM_OBJ(&syslib_sys_normalize_pathname__STUB));
  SCM_DEFINE(module, "sys-glob", SCM_OBJ(&syslib_sys_glob__STUB));
  SCM_DEFINE(module, "sys-readdir", SCM_OBJ(&syslib_sys_readdir__STUB));
}
