/* 

                          Firewall Builder

                 Copyright (C) 2003 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@fwbuilder.org

  $Id: DialogFactory.cpp,v 1.7 2004/08/22 02:52:42 vkurland Exp $

  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/



#include "config.h"
#include "global.h"
#include "utils.h"

#include "DialogFactory.h"

#include "LibraryDialog.h"
#include "AddressRangeDialog.h"
#include "IPv4Dialog.h"
#include "PhysicalAddressDialog.h"
#include "NetworkDialog.h"
#include "CustomServiceDialog.h"
#include "ICMPServiceDialog.h"
#include "IPServiceDialog.h"
#include "TCPServiceDialog.h"
#include "UDPServiceDialog.h"
#include "GroupObjectDialog.h"
#include "HostDialog.h"
#include "FirewallDialog.h"
#include "InterfaceDialog.h"
#include "TimeDialog.h"

#include "iptAdvancedDialog.h"
#include "ipfAdvancedDialog.h"
#include "ipfwAdvancedDialog.h"
#include "pfAdvancedDialog.h"
#include "pixAdvancedDialog.h"

#include "pixosAdvancedDialog.h"
#include "linux24AdvancedDialog.h"
#include "linksysAdvancedDialog.h"
#include "freebsdAdvancedDialog.h"
#include "openbsdAdvancedDialog.h"
#include "solarisAdvancedDialog.h"
#include "macosxAdvancedDialog.h"

#include "RuleOptionsDialog.h"


#include "fwbuilder/Library.h"
#include "fwbuilder/Firewall.h"
#include "fwbuilder/Host.h"
#include "fwbuilder/Network.h"
#include "fwbuilder/IPv4.h"
#include "fwbuilder/AddressRange.h"
#include "fwbuilder/ObjectGroup.h"
#include "fwbuilder/Interface.h"
#include "fwbuilder/CustomService.h"
#include "fwbuilder/IPService.h"
#include "fwbuilder/ICMPService.h"
#include "fwbuilder/TCPService.h"
#include "fwbuilder/UDPService.h"
#include "fwbuilder/ServiceGroup.h"
#include "fwbuilder/Interval.h"
#include "fwbuilder/IntervalGroup.h"
#include "fwbuilder/Rule.h"

#include <iostream>

using namespace std;
using namespace libfwbuilder;

QWidget *DialogFactory::createDialog(QWidget *parent,const QString &objType)
{

    if (objType==Library::TYPENAME)       return new LibraryDialog(parent);

    if (objType==IPv4::TYPENAME)          return new IPv4Dialog(parent);

    if (objType==physAddress::TYPENAME)   return new PhysicalAddressDialog(parent);

    if (objType==AddressRange::TYPENAME)  return new AddressRangeDialog(parent);

    if (objType==Firewall::TYPENAME)      return new FirewallDialog(parent);

    if (objType==Host::TYPENAME)          return new HostDialog(parent);

    if (objType==Interface::TYPENAME)     return new InterfaceDialog(parent);

    if (objType==Network::TYPENAME)       return new NetworkDialog(parent);

    if (objType==CustomService::TYPENAME) return new CustomServiceDialog(parent);

    if (objType==IPService::TYPENAME)     return new IPServiceDialog(parent);

    if (objType==ICMPService::TYPENAME)   return new ICMPServiceDialog(parent);

    if (objType==TCPService::TYPENAME)    return new TCPServiceDialog(parent);

    if (objType==UDPService::TYPENAME)    return new UDPServiceDialog(parent);

    if (objType==ObjectGroup::TYPENAME)   return new GroupObjectDialog(parent);

    if (objType==ServiceGroup::TYPENAME)  return new GroupObjectDialog(parent);

    if (objType==IntervalGroup::TYPENAME) return new GroupObjectDialog(parent);

    if (objType==Interval::TYPENAME)      return new TimeDialog(parent);

    if (objType==Rule::TYPENAME)          return new RuleOptionsDialog(parent);
    if (objType==PolicyRule::TYPENAME)    return new RuleOptionsDialog(parent);
    if (objType==NATRule::TYPENAME)       return new RuleOptionsDialog(parent);

    return NULL;
}


QWidget *DialogFactory::createFWDialog(QWidget *parent,FWObject *o)
{
    string pl=o->getStr("platform");
    if (pl=="iptables") return new iptAdvancedDialog(parent,o);
    if (pl=="ipf")      return new ipfAdvancedDialog(parent,o);
    if (pl=="ipfw")     return new ipfwAdvancedDialog(parent,o);
    if (pl=="pf")       return new pfAdvancedDialog(parent,o);
    if (pl=="pix")      return new pixAdvancedDialog(parent,o);

    cerr << "Firewall settings dialog for " << o->getStr("platform") << " is not implemented" << endl;
    return NULL;
}


QWidget *DialogFactory::createOSDialog(QWidget *parent,FWObject *o)
{
    string os=o->getStr("host_OS");
    if (os=="pix_os")    return new pixosAdvancedDialog(parent,o);
    if (os=="linux24")   return new linux24AdvancedDialog(parent,o);
    if (os=="linksys")   return new linksysAdvancedDialog(parent,o);
    if (os=="freebsd")   return new freebsdAdvancedDialog(parent,o);
    if (os=="openbsd")   return new openbsdAdvancedDialog(parent,o);
    if (os=="solaris")   return new solarisAdvancedDialog(parent,o);
    if (os=="macosx")    return new macosxAdvancedDialog(parent,o);

    cerr << "OS settings dialog for " << o->getStr("host_OS") << " is not implemented" << endl;
    return NULL;
}


