#include <entity.h>
#include <gnome.h>
#include <rendgnome.h>


void
rendcanvas_group_parent (ENode * parent_node, ENode * child_node)
{
  GnomeCanvas *canvas;
  GtkWidget *child_widget;
  GnomeCanvasGroup *group;
  GtkArg *args;
  EBuf * buf;

  EDEBUG (("canvas", "parenting a node to a canvas.."));

  canvas = enode_get_kv (parent_node, "top-widget");
  group = enode_get_kv (parent_node, "rendcanvas-group");

  /* three cases to handle:
     1. canvas item. must be created here.
     2. gtk widgets. widget canvas item must be created and added here.
     3. anything else. ignore it.
  */

  child_widget = enode_get_kv (child_node, "top-widget");
  if (child_widget != NULL) {    /* gtk widget */
    double x, y;
    GnomeCanvasItem *wrapper;

    EDEBUG(("canvas", "have gtk widget."));

    x = 0;
    y = 0;

    buf = enode_attrib (child_node, "x", NULL);
    if (buf != NULL) 
      x = erend_get_float(buf);

    buf = enode_attrib (child_node, "y", NULL);
    if (buf != NULL) 
      y = erend_get_float(buf);    
    

    EDEBUG(("canvas", "adding item .."));
    wrapper = gnome_canvas_item_new (group, GNOME_TYPE_CANVAS_WIDGET,
				     "widget", child_widget,
				     "x", x,
				     "y", y,
				     NULL);

    gtk_widget_show_all (GTK_WIDGET(child_widget));
    EDEBUG(("canvas", "item added."));
    enode_set_kv (child_node, "rendcanvas-item", wrapper);
  }


  args = enode_get_kv (child_node, "rendcanvas-args");
  if (args != NULL) {    /* is canvas item. */
    int num_args;
    GtkType type;

    EDEBUG(("canvas", "have canvas item"));
    
    /* todo: yes, i know this is shit casting */
    num_args = (int)enode_get_kv (child_node, "rendcanvas-num-args");
    type = (GtkType)enode_get_kv (child_node, "rendcanvas-type");

    EDEBUG(("canvas", "it has %d args", num_args));

    child_widget = (GtkWidget*)gnome_canvas_item_newv (group, type, 
						       num_args, args);

    gtk_signal_connect (GTK_OBJECT(child_widget), "event",
			GTK_SIGNAL_FUNC (rendcanvas_item_event),
			child_node);

    enode_set_kv (child_node, "rendcanvas-item", child_widget);
  }

    EDEBUG(("canvas", "done parenting."));
}

static void
rendcanvas_group_render (ENode * node)
{
  GtkArg *args;
  double x, y;
  EBuf *buf;

  x = 0;
  y = 0;

  buf = enode_attrib (node, "x", NULL);
  if (buf != NULL) {
    x = strtod (buf->str, NULL);
  }
  
  buf = enode_attrib (node, "y", NULL);
  if (buf != NULL) {
    y = strtod (buf->str, NULL);
  }


  args = (GtkArg*)malloc(2 * sizeof(GtkArg));
  
  args[0].name = "x";
  args[0].type = GTK_TYPE_DOUBLE;
  args[0].d.double_data = x;

  args[1].name = "y";
  args[1].type = GTK_TYPE_DOUBLE;
  args[1].d.double_data = y;

  enode_set_kv (node, "rendcanvas-num-args", 2);
  enode_set_kv (node, "rendcanvas-args", args);
  enode_set_kv (node, "rendcanvas-type", gnome_canvas_group_get_type());  

  enode_attribs_sync (node);
}

void
rendcanvas_group_init (RendererFlags flags)
{
  Element *element;
  ElementAttr *e_attr;

  if (!flags & RENDERER_REGISTER)
    return;

  element = g_new0 (Element, 1);
  element->tag = "canvas-group";
  element->render_func = rendcanvas_group_render;
  element->destroy_func = rendcanvas_item_destroy;
  element->parent_func = rendcanvas_group_parent;
  element_register (element);

  rendcanvas_register_pos_attrs (element);
}
