/*
                          Endeavour Archive Object

	For objects within archives.
 */

#ifndef EDVARCHOBJ_H
#define EDVARCHOBJ_H

#include <sys/stat.h>
#include <glib.h>
#include "edvtypes.h"

/*
 *	Archive Object:
 */
typedef struct {

	edv_object_type	type;

	gchar		*name;
	gchar		*full_path;	/* This is not always an absolute
					 * path, because paths stored in
					 * the archive are not always
					 * absolute paths */

	gchar		*link_value;	/* Only for EDV_OBJECT_TYPE_LINK */

	edv_permission_flags	permissions;	/* Any of EDV_PERMISSION_* */

	gulong		access_time,	/* In systime seconds */
			modify_time,
			change_time;

	gchar		*owner_name;
	gchar		*group_name;

	gulong		size,		/* In bytes */
			compressed_size;

	gint		device_type;	/* Device major and minor numbers
					 * (used only if object type is one
					 * of EDV_OBJECT_TYPE_DEVICE_*
					 *
					 * Use EDVGetDeviceNumbers() to parse
					 * this value casted as a dev_t */

	gboolean	encrypted;

	gfloat		compression_ratio;	/* 0.0 = not compressed
						 * 1.0 = total compression */

	gchar		*method;	/* Method of storage */
	gchar		*crc;		/* CRC checksum */

} edv_archive_object_struct;
#define EDV_ARCHIVE_OBJECT(p)	((edv_archive_object_struct *)(p))


extern edv_archive_object_struct *EDVArchObjectNew(void);
extern edv_archive_object_struct *EDVArchObjectCopy(
	const edv_archive_object_struct *obj
);
extern void EDVArchObjectDelete(edv_archive_object_struct *obj);


#endif	/* EDVARCHOBJ_H */
