

#include "ProdElemList.h"
#include "err.h"
#include "obstack.h"

typedef struct {
  Obstack space;
  void *baseptr;
} Dyn, *DynP;

static DynP ProdElemListSpace = (DynP)0;

#if defined(__STDC__) || defined(__cplusplus)
void FinlProdElemList (void)
#else
void FinlProdElemList ()
#endif
{
    if (ProdElemListSpace != (DynP)0)
    {  obstack_free(&(ProdElemListSpace->space), ProdElemListSpace->baseptr);
       ProdElemListSpace->baseptr = obstack_alloc(&(ProdElemListSpace->space), 0);
    }
}/* FinlProdElemList */

#if defined(__STDC__) || defined(__cplusplus)
ProdElemList ConsProdElemList (ProdElem e, ProdElemList l)
#else
ProdElemList ConsProdElemList (e, l)
        ProdElem        e;
        ProdElemList    l;
#endif
{
    ProdElemList        h;

    if (ProdElemListSpace == (DynP)0)
    {   ProdElemListSpace = (DynP) malloc (sizeof(Dyn));
        if (ProdElemListSpace == (DynP)0)
        {  message (DEADLY, "no space for ProdElemList", 0, (POSITION*)0);
           exit (1);
        }
        obstack_init(&(ProdElemListSpace->space));
        ProdElemListSpace->baseptr =
                obstack_alloc(&(ProdElemListSpace->space), 0);
    }

    h = (ProdElemList)obstack_alloc(&(ProdElemListSpace->space),
                                  sizeof (struct _ProdElemLE));
    h->head = e;
    h->tail= l;
    return (h);
}/* ConsProdElemList */

#if defined(__STDC__) || defined(__cplusplus)
ProdElem HeadProdElemList (ProdElemList l)
#else
ProdElem HeadProdElemList (l)
        ProdElemList    l;
#endif
{
    if (l == NULLProdElemList)
    {
        message (DEADLY, "HeadProdElemList: empty list", 0, (POSITION*)0);
        /* return ((ProdElem)0); */
    } /* if */
    return (l->head);
}/* HeadProdElemList */

#if defined(__STDC__) || defined(__cplusplus)
ProdElemList TailProdElemList (ProdElemList l)
#else
ProdElemList TailProdElemList (l)
        ProdElemList    l;
#endif
{
    return ((l==NULLProdElemList) ? NULLProdElemList : l->tail);
}/* TailProdElemList */

#if defined(__STDC__) || defined(__cplusplus)
int LengthProdElemList (ProdElemList l)
#else
int LengthProdElemList (l)
        ProdElemList    l;
#endif
{
    int res = 0;

    for (; l; l = l->tail)
        res++;
    return (res);
}/* LengthProdElemList */

#if defined(__STDC__) || defined(__cplusplus)
ProdElem IthElemProdElemList (ProdElemList l, int i)
#else
ProdElem IthElemProdElemList (l, i)
        ProdElemList    l;
        int     i;
#endif
{
    while ((i>1) && l)
    {
        i--;
        l = l->tail;
    }

    if ((i<=0) || (l==NULLProdElemList))
        message (DEADLY, "IthElemProdElemList: no such element",
                 0, (POSITION*)0);
    return (l->head);
}/* IthProdElemList */


#if defined(__STDC__) || defined(__cplusplus)
ProdElemList CopyProdElemList (ProdElemList l, ProdElemMapFct cp)
#else
ProdElemList CopyProdElemList (l, cp)
        ProdElemList l;
        ProdElemMapFct  cp;
#endif
{
    ProdElemList NewList=NULLProdElemList, *addr = &NewList;

    while (l)
    {
        (*addr) = ConsProdElemList (cp (l->head), NULLProdElemList);
        addr = &((*addr)->tail);
        l = l->tail;
    }
    return (NewList);
}/* CopyProdElemList */

#if defined(__STDC__) || defined(__cplusplus)
ProdElemList AppProdElemList (ProdElemList l1, ProdElemList l2)
#else
ProdElemList AppProdElemList (l1, l2)
        ProdElemList    l1, l2;
#endif
{
    ProdElemList        NewList;
    ProdElemList        *addr = &NewList;

    if (!l1) return (l2);
    if (!l2) return (l1);

    while (l1) {
        (*addr) = ConsProdElemList (l1->head, NULLProdElemList);
        addr = &((*addr)->tail);
        l1 = l1->tail;
    }
    (*addr) = l2;

    return (NewList);
}/* AppProdElemList */

#if defined(__STDC__) || defined(__cplusplus)
ProdElemList AppElProdElemList (ProdElemList l, ProdElem e)
#else
ProdElemList AppElProdElemList (l, e)
        ProdElemList    l;
        ProdElem        e;
#endif
{
    ProdElemList        res = l;
    if (!l)
        return (ConsProdElemList (e, NULLProdElemList));

    while (l->tail)
        l = l->tail;
    l->tail = ConsProdElemList (e, NULLProdElemList);

    return (res);
} /* AppElProdElemList */


#if defined(__STDC__) || defined(__cplusplus)
void InsertAfterProdElemList (ProdElemList l, ProdElem e)
#else
void InsertAfterProdElemList (l, e)
        ProdElemList    l;
        ProdElem        e;
#endif
{
    if (!l)
        message (DEADLY, "InserAfterProdElemList: null list", 0, (POSITION*)0);
    else
        l->tail = ConsProdElemList (e, l->tail);
}/* InsertAfterProdElemList */

#if defined(__STDC__) || defined(__cplusplus)
ProdElemList OrderedInsertProdElemList (ProdElemList l, ProdElem e, ProdElemCmpFctType fcmp)
#else
ProdElemList OrderedInsertProdElemList (l, e, fcmp)
        ProdElemList    l;
        ProdElem        e;
        ProdElemCmpFctType fcmp;
#endif
{
    ProdElemList        p;
    if (!l)
        return (ConsProdElemList (e, NULLProdElemList));
    if (fcmp (e, l->head) <= 0)
        return (ConsProdElemList (e, l));
    p = l;
    while (p->tail && (fcmp (e, p->tail->head) > 0))
        p = p->tail;
    p->tail = ConsProdElemList (e, p->tail);
    return (l);
}/* OrderedInsertProdElemList */

#if defined(__STDC__) || defined(__cplusplus)
ProdElemListPtr RefEndConsProdElemList (ProdElemListPtr addr, ProdElem e)
#else
ProdElemListPtr RefEndConsProdElemList (addr, e)
        ProdElemListPtr addr;
        ProdElem                e;
#endif
{
    if (!addr)
    {
        message (DEADLY, "RefEndConsProdElemList: no ProdElemList ref",
                 0, (POSITION*)0);
        return (addr);
    }
    (*addr) = ConsProdElemList (e, NULLProdElemList);
    return (&((*addr)->tail));
}/* RefEndConsProdElemList */

#if defined(__STDC__) || defined(__cplusplus)
ProdElemListPtr RefEndAppProdElemList (ProdElemListPtr addr, ProdElemList l)
#else
ProdElemListPtr RefEndAppProdElemList (addr, l)
        ProdElemListPtr addr;
        ProdElemList            l;
#endif
{
    if (!addr) {
        message (DEADLY, "RefEndAppProdElemList: no ProdElemList ref",
                 0, (POSITION*)0);
        return (addr);
    }
    if (!l)
        return addr;

    (*addr) = l;

    while (l->tail)
        l = l->tail;
    return (&(l->tail));
}/* RefEndAppProdElemList */

#if defined(__STDC__) || defined(__cplusplus)
int ElemInProdElemList (ProdElem e, ProdElemList l, ProdElemCmpFctType fcmp)
#else
int ElemInProdElemList (e, l, fcmp)
        ProdElem        e;
        ProdElemList    l;
        ProdElemCmpFctType      fcmp;
#endif
{
    while (l != NULLProdElemList) {
        if (fcmp (e, l->head) == 0)
            return (1);
        l = l->tail;
    }
    return (0);
}/* ElemInProdElemList */

#if defined(__STDC__) || defined(__cplusplus)
ProdElemList AddToSetProdElemList (ProdElem e, ProdElemList l, ProdElemCmpFctType fcmp)
#else
ProdElemList AddToSetProdElemList (e, l, fcmp)
        ProdElem        e;
        ProdElemList    l;
        ProdElemCmpFctType      fcmp;
#endif
{
    if (ElemInProdElemList (e, l, fcmp))
        return (l);
    else
        return (ConsProdElemList (e, l));
}/* AddToSetProdElemList */


#if defined(__STDC__) || defined(__cplusplus)
ProdElemList AddToOrderedSetProdElemList (ProdElem e, ProdElemList l, ProdElemCmpFctType fcmp)
#else
ProdElemList AddToOrderedSetProdElemList (e, l, fcmp)
        ProdElem  e;
        ProdElemList      l;
        ProdElemCmpFctType fcmp;
#endif
{   int test;
    ProdElemList  p;
    if (!l)
        return (ConsProdElemList (e, NULLProdElemList));
    if ((test = fcmp (e, l->head)) < 0)
        return (ConsProdElemList (e, l));
    if (test == 0) return l;
    p = l;
    while (p->tail && ((test = fcmp (e, p->tail->head)) > 0))
        p = p->tail;
    if (test) p->tail = ConsProdElemList (e, p->tail);
    return (l);
}/* AddToOrderedSetProdElemList */

#if defined(__STDC__) || defined(__cplusplus)
ProdElemList MapProdElemList (ProdElemList l, ProdElemMapFct f)
#else
ProdElemList MapProdElemList (l, f)
        ProdElemList    l;
        ProdElemMapFct f;
#endif
{
    ProdElemList NewList = NULLProdElemList;
    ProdElemList last = NULLProdElemList;

    while (l)
    {
        if (!NewList) {
            NewList = ConsProdElemList ((f (l->head)), NULLProdElemList);
            last = NewList;
        }
        else
        {
            last->tail = ConsProdElemList ((f (l->head)), NULLProdElemList);
            last = last->tail;
        }
        l = l->tail;
    }
    return (NewList);
}/* MapProdElemList */

#if defined(__STDC__) || defined(__cplusplus)
int CompProdElemList (ProdElemList l1, ProdElemList l2, ProdElemCmpFctType fcmp)
#else
int CompProdElemList (l1, l2, fcmp)
        ProdElemList    l1, l2;
        ProdElemCmpFctType fcmp;
#endif
{
    int res = 0;
    while (l1 && l2 && (res == 0)) {
        res = (fcmp (l1->head, l2->head));
        l1 = l1->tail;
        l2 = l2->tail;
    }
    if (l1 && !l2)
        return (1);
    if (!l1 && l2)
        return (-1);
    return (res);
}/* CompProdElemList */

#if defined(__STDC__) || defined(__cplusplus)
ProdElem SumProdElemList (ProdElemList l, ProdElemSumFct f, ProdElem a)
#else
ProdElem SumProdElemList (l, f, a)
        ProdElemList    l;
        ProdElem ((*f) ());
        ProdElem        a;
#endif
{
    while (l) {
        a = (f (a, l->head));
        l = l->tail;
    }
    return (a);
}/* SumProdElemList */
