/*
 *  ---------
 * |.**> <**.|  CardContact
 * |*       *|  Software & System Consulting
 * |*       *|  Minden, Germany
 * |**> <**|  Copyright (c) 1999. All rights reserved
 *  --------- 
 *
 * See file LICENSE for details on licensing
 *
 * Abstract :       Defines tools/types for T=0 protocol handling
 *
 * Author :         Frank Thater (FTH)
 *
 * Last modified:   02/16/2000
 *
 *****************************************************************************/

#include "ecoT0.h"
#include "defines.h"
#include <string.h>



int SendBytes(struct eco5000_t *ctx, unsigned char length, unsigned char *b)

{
    if (iccWrite(ctx->fh, ctx->Indirect, b, length) != length)
        return FALSE;
    
    if (!ctx->disableRX_ON)
        if(iccRead(ctx->fh, ctx->Indirect, b, length) != length)
            return FALSE;
    
    return TRUE;
}



int BuildCommandAPDU (struct cAPDU_t *cAPDU,
               unsigned int lc,
               unsigned char *cmd)

{
    int i;

    cAPDU->CLA = cmd[0];
    cAPDU->INS = cmd[1];
    cAPDU->P1 = cmd[2];
    cAPDU->P2 = cmd[3];
  
    if (lc <= 4) {   /* Case 1 Command */
        cAPDU->P3 = 0x00;
        cAPDU->cmdType = CASE1;
    }
    
    if (lc == 5) {   /* Case 2 Command , Le */
        cAPDU->P3 = cmd[4];
        cAPDU->cmdType = CASE2;
    }
    
    if (lc > 5) {   /* Case 3,4 Command */
        cAPDU->P3 = cmd[4];
        for (i=0;i < cAPDU->P3;i++)
            cAPDU->Data[i] = cmd[5+i];
        cAPDU->cmdType = CASE3;
        if (lc > 5+cAPDU->P3)
            cAPDU->cmdType = CASE4;
    }
    
    return OK;
}



int SendHeader (struct eco5000_t *ctx,
                struct cAPDU_t *cAPDU)

{
    unsigned char bytes[5];

    bytes[0] = cAPDU->CLA;
    bytes[1] = cAPDU->INS;
    bytes[2] = cAPDU->P1;
    bytes[3] = cAPDU->P2;
    bytes[4] = cAPDU->P3;
  
    if (SendBytes(ctx, 5, bytes) <= 0)
        return ERR_CT;
    
    return OK;
}



int SendCommandData (struct eco5000_t *ctx,struct cAPDU_t *cAPDU, 
                     unsigned char PByte,
                     unsigned int *lr, unsigned char *rsp)

{
    HANDLE localhandle;
    unsigned int BytesSend = 0;
    unsigned char ProcedureByte;
    unsigned int cACK, cACK_XOR;
    int rc = 0;

    localhandle = ctx->fh;
  
    ProcedureByte = PByte;

    cACK = cAPDU->INS;
    cACK_XOR = cACK^0xff;

    while (TRUE) {

        if (ProcedureByte == 0x60) {        /* Wait for card */
            rc = iccRead(localhandle, ctx->Indirect, &ProcedureByte, 1);
            if (rc <= 0)
                return ERR_CT;
        } 
        else if (ProcedureByte == cACK) {   /* Send all remaining data bytes */
            if (SendBytes(ctx, cAPDU->P3 - BytesSend, cAPDU->Data + BytesSend) == FALSE)
                return ERR_CT;
                
            rc = iccRead(localhandle, ctx->Indirect, &ProcedureByte, 1);
            if (rc <= 0)   
                return ERR_CT;
            
        }
        else if (ProcedureByte == cACK_XOR) { /* just send one Byte */
            if (SendBytes(ctx, 1, cAPDU->Data + BytesSend) == FALSE)
                return ERR_CT;
            rc = iccRead(localhandle, ctx->Indirect, &ProcedureByte, 1);
            if (rc <= 0)
                return ERR_CT;
            BytesSend++;
        }
        else if (((ProcedureByte & 0xF0) == 0x60) ||  /* SW1, get SW2 */ 
                 ((ProcedureByte & 0xF0) == 0x90)) {
            rsp[0] = ProcedureByte;
            rc = iccRead(localhandle, ctx->Indirect, &ProcedureByte, 1);
            if (rc <= 0)
                return ERR_CT;
            rsp[1] = ProcedureByte;
            *lr = 2;
            BytesSend = cAPDU->P3;
	    break;
        }  else {
            rc = ERR_TRANS;
            break;
        }
    }
    
    return rc;
}   



int ecoT0Init (struct eco5000_t *ctx)

{
    int rc = OK;
    unsigned char cmd;
    
    ctx->Data.t0 = malloc(sizeof(struct ecoT0_t));
 

    /* cast to right type */
    ctx->CTModFunc = (CTModFunc_t) ecoT0Process;


    /* T=0 error detection implemented in firmware 223
       does not work relieable and has therefore been disabled ! */

#if 0
    if ((strcmp(ctx->Firmware, ECO_V223) >= 0) && !ctx->Indirect) {
#ifdef DEBUG
        printf("\n[ecoT0Init] Setting new error detection!\n");
#endif
        cmd = 0x83;
        rc = ecoCommand(ctx, SET_T0_NEW, 1, (unsigned char *)&cmd, 0, NULL);
        if (rc < 0)
            return rc;

        ctx->disableRX_ON = TRUE;
        
    }
#endif 

    return OK;
}

 
 
int ecoT0Process (struct eco5000_t *ctx,
                   unsigned int  lc, 
                   unsigned char *cmd, 
                   unsigned int  *lr,
                   unsigned char *rsp)

{
    struct cAPDU_t cAPDU;   /* Command APDU */
    unsigned int i;
    unsigned char ProcByte;
    unsigned char temp;
    unsigned char grcmd[5];
    unsigned int llr = 0;
    unsigned char lrsp[258];
    int rc = 0;

    llr = *lr;

    rc = ecoCommand(ctx, RX_ON, 0, NULL, 0, NULL);
    
    if (rc < 0)
        return rc;

    rc = rs232Mode(ctx->fh, -1, -1, -1, -1, 100 * ctx->T0_WI);
    
    if (rc < 0)
        return rc;
    
    BuildCommandAPDU(&cAPDU, lc, cmd);

#ifdef DEBUG
    printf("\necoTOProcess called...\n");
    printf("CLA : %02x\n", cAPDU.CLA);
    printf("INS : %02x\n", cAPDU.INS);
    printf("P1  : %02x\n", cAPDU.P1);
    printf("P2  : %02x\n", cAPDU.P2);
    printf("P3  : %02x\n", cAPDU.P3);   
    printf("CASE: %02x\n", cAPDU.cmdType);
#endif
    
    if (SendHeader(ctx, &cAPDU) < 0)  {
        return ERR_CT;
    }
    

    do  {    
        rc = iccRead(ctx->fh, ctx->Indirect, &ProcByte, 1);
        if (rc <= 0)   /* Read in Procedure Byte */
                return ERR_CT;
    } while (ProcByte == 0x60);

    
    if (cAPDU.cmdType == CASE1) {
        lrsp[0] = ProcByte;
        rc = iccRead(ctx->fh, ctx->Indirect, lrsp + 1, 1);
        if (rc <= 0)
            return ERR_CT;
        llr = 2;
    }
  
    if ((cAPDU.cmdType == CASE3) || (cAPDU.cmdType == CASE4)) {
        /* CASE 3,4 send data to card !! */
        rc = SendCommandData(ctx, &cAPDU, ProcByte, &llr, lrsp);
        if (rc < 0)
            return rc;
    }

    if ((cAPDU.cmdType == CASE2)) {
        /* CASE 2 commands recieve bytes from card */
        if (ProcByte != cAPDU.INS)  {
            lrsp[0] = ProcByte;
            if ((rc = iccRead(ctx->fh, ctx->Indirect, lrsp + 1, 1) == 0))
                return ERR_CT;
            llr = 2;
        }  else {
            i = 0;
            llr = 0;
            while ((i < cAPDU.P3 + 2) && (iccRead(ctx->fh, ctx->Indirect, &temp, 1) > 0)) {    /* are bytes available ? */
                lrsp[i++] = temp;
            }
            llr = i;
        }
    }
    
    if ((llr == 2) && ((lrsp[0] == 0x9F) || (lrsp[0] == 0x61))) {
        grcmd[0] = cAPDU.CLA;
        grcmd[1] = 0xC0;
        grcmd[2] = 0x00;
        grcmd[3] = 0x00;
        grcmd[4] = lrsp[1];
      
#ifdef DEBUG
        printf("\nGetting Response...\n");
        printf("CLA : %02x\n", grcmd[0]);
        printf("INS : %02x\n", grcmd[1]);
        printf("P1  : %02x\n", grcmd[2]);
        printf("P2  : %02x\n", grcmd[3]);
        printf("P3  : %02x\n", grcmd[4]);   
#endif

        llr = *lr;
        // Rekursion
        rc = ecoT0Process(ctx, 5, grcmd, &llr, lrsp);
        if (rc < 0)
            return rc;
        // return OK;
    }

    /* Copy temp buffer to response buffer */
    
    if (*lr < llr) {
        memset(rsp, 0, sizeof(rsp));
        *lr = 0;
        return ERR_MEMORY;
    }
    else {
        memcpy(rsp, lrsp, llr);
        *lr = llr;
        return OK; 
    }

}
 


int ecoT0Term (struct eco5000_t *ctx)

{
    free(ctx->Data.t0);
    ctx->Data.t0 = NULL;
    ctx->CTModFunc = NULL;
    return OK;
}














