<?xml version='1.0'?>
<!-- vim: sw=2 sta et
-->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:doc="http://nwalsh.com/xsl/documentation/1.0"
                exclude-result-prefixes="doc"
                version='1.0'
                xml:lang="en">

<!-- ********************************************************************
     $Id: docbook.xsl,v 1.5 2003/06/15 21:39:55 stevecheng Exp $
     ********************************************************************

     &copy; 2000-2001 Steve Cheng <stevecheng@users.sourceforge.net>

     Part of docbook2X, DocBook to man page conversion.

     ******************************************************************** -->

<!-- ==================================================================== -->

<!-- i18n templates -->
<xsl:include href="../common/l10n.xsl" />
<xsl:include href="../common/gentext.xsl" />
<xsl:include href="../common/messages.xsl" />

<!-- Common DocBook stuff -->
<xsl:include href="../common/cmdsynopsis.xsl" />
<xsl:include href="../common/lists.xsl" />
<xsl:include href="../common/person.xsl" />
<xsl:include href="../common/titles.xsl" />
<xsl:include href="../common/whitespace.xsl" />

<!-- Default parameters  -->
<xsl:include href="param.xsl"/>

<!-- Sectioning -->
<xsl:include href="manpage.xsl" />
<xsl:include href="refentry.xsl" />
<xsl:include href="sectioning.xsl" />
<xsl:include href="sections.xsl" />

<!-- Block objects -->
<xsl:include href="admon.xsl"/>
<xsl:include href="block.xsl"/>
<xsl:include href="caption.xsl"/>
<xsl:include href="formal.xsl"/>
<xsl:include href="synop.xsl"/>
<xsl:include href="table.xsl"/>
<xsl:include href="verbatim.xsl"/>

<!-- Inline objects -->
<xsl:include href="inline.xsl"/>

<!-- Cross references -->
<xsl:include href="xref.xsl"/>

<!-- Lists -->
<xsl:include href="glossary.xsl"/>
<xsl:include href="lists.xsl"/>

<!-- Metadata -->
<xsl:include href="index.xsl"/>
<xsl:include href="info.xsl"/>
<xsl:include href="keywords.xsl"/>
<xsl:include href="toc.xsl"/>

<!-- Page layout -->
<xsl:include href="beginpage.xsl" />

<!-- Processing instructions -->
<xsl:include href="pi.xsl"/>

<!-- ==================================================================== -->

<xsl:output method="xml" encoding="utf-8"/>

<!-- ==================================================================== -->

<xsl:template match="*">
  <xsl:call-template name="user-message">
    <xsl:with-param name="key">Element not matched by any template</xsl:with-param>
  </xsl:call-template>

  <xsl:comment>
    <xsl:call-template name="gentext-rendering">
      <xsl:with-param name="key" select="'element-not-matched'" />
      <xsl:with-param name="content" select="name(.)" />
    </xsl:call-template>
  </xsl:comment>

  <xsl:apply-templates />
</xsl:template>

<xsl:template match="/">
  <manpageset>
    <xsl:apply-templates select="descendant-or-self::refentry" />
  </manpageset>
</xsl:template>

<xsl:template match="text()">
  <xsl:value-of select="."/> 
</xsl:template>

</xsl:stylesheet>
