/*
 * DiaSCE is a code editor for C and C++.
 * Copyright (C) 2000  Ander Lozano Prez
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Ander Lozano Prez
 * c/Juan de Gardeazabal 4, 1 D
 * 48004 Bilbao
 * Vizcaya
 * Spain
 *
 * ander1@wanadoo.es
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

#include "callbacks.h"
#include "main.h"


void
on_ok_boton_seleccion_archivos_clicked (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *widget, *ventana;
	gchar **seleccion;
	gchar *archivo;
	guint cont;
	int ret;
	
	widget=gtk_widget_get_toplevel(GTK_WIDGET(button));
	ventana_seleccion_proyecto=widget;
	seleccion=gtk_file_selection_get_selections(GTK_FILE_SELECTION(widget));
	archivo=seleccion[0];
	if (archivo[0]==0) {
		g_strfreev(seleccion);
		return;
	}
	for (cont=0;archivo[cont]!=0;cont++);
	if (archivo[cont-1]=='/') {
		g_strfreev(seleccion);
		return;
	}
	switch (estado_archivos_ventana) {
		case PROYECTO_ABRIR:
			if (edit_comprobar_perdida_datos()) {
				ventana = gen_create_perdidas_ventana();
				ret = gnome_dialog_run_and_close (GNOME_DIALOG(ventana));
				switch (ret) {
					case 0: //Boton "si"
						g_free(pro_proyecto_cargar);
						pro_proyecto_cargar=g_strdup(archivo);
						ventana=gtk_widget_get_toplevel(GTK_WIDGET(button));
						gtk_widget_destroy(ventana);
						if (proyecto.xml != NULL) {
							gchar *nombre_proyecto_locale;
							gsize read, written;
							GError *error;
					
							//save the status of open tabs and line positions in the project file
							pro_update_open_tabs();
							nombre_proyecto_locale = g_locale_from_utf8(proyecto.archivo, -1, &read, &written, &error);
							xmlSaveFile(nombre_proyecto_locale, proyecto.xml);
							g_free(nombre_proyecto_locale);
						}
						gen_abrir_proyecto(pro_proyecto_cargar);
						break;
					case 1: //Boton "no"
						break;
					default:	//El usuario ha cerrado la ventana desde el gestor de ventanas
						break;
				}
				//Creo que no hace falta
				//gtk_widget_hide(ventana); 
			} else {
				ventana=gtk_widget_get_toplevel(GTK_WIDGET(button));
				gtk_widget_destroy(ventana);
				if (proyecto.xml != NULL) {
					gchar *nombre_proyecto_locale;
					gsize read, written;
					GError *error;
			
					//save the status of open tabs and line positions in the project file
					pro_update_open_tabs();
					nombre_proyecto_locale = g_locale_from_utf8(proyecto.archivo, -1, &read, &written, &error);
					xmlSaveFile(nombre_proyecto_locale, proyecto.xml);
					g_free(nombre_proyecto_locale);
				}
				gen_abrir_proyecto(archivo);
			}
			break;
		case PROYECTO_ANADIR:
			gen_anadir_a_lista(widget);
			gtk_widget_destroy(widget);
			break;
		case EXTERNOS_ABRIR:
			ext_abrir(seleccion);
			gtk_widget_destroy(widget);
			break;
	};
	g_strfreev(seleccion);
}


void
on_cancel_boton_seleccion_archivos_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *ventana;
	
	ventana=gtk_widget_get_toplevel(GTK_WIDGET(button));
	gtk_widget_destroy(ventana);
}


void
on_nombre_entrada_project_changed              (GtkEditable     *editable,
                                        gpointer         user_data)
{
	GtkEntry *ejecutable;
	gchar *texto;
	gchar *directorio;
	GtkWidget *ventana,*boton;

	ventana=gtk_widget_get_toplevel(GTK_WIDGET(editable));
	ejecutable=GTK_ENTRY(glade_xml_get_widget(proyecto_ventana,"ejecutable_entrada"));
	texto=gtk_editable_get_chars(editable,0,-1);
	boton=glade_xml_get_widget(proyecto_ventana,"ok_boton_proyecto");
	if (texto[0]!=0) {
		gtk_widget_set_sensitive(boton,TRUE);
	} else {
		gtk_widget_set_sensitive(boton,FALSE);
	}
	gtk_entry_set_text(ejecutable,texto);
	ejecutable=GTK_ENTRY(glade_xml_get_widget(proyecto_ventana,"proyecto_entrada"));
	directorio=g_strdup_printf("%s%s",preferencias.directorio,texto);
	gtk_entry_set_text(ejecutable,directorio);
	g_free(directorio);
	ejecutable=GTK_ENTRY(glade_xml_get_widget(proyecto_ventana,"glade_entrada"));
	directorio=g_strdup_printf("%s.glade",texto);
	gtk_entry_set_text(ejecutable,directorio);
	g_free(directorio);
	g_free(texto);
}


void
on_glade_proyecto_boton_toggled        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	GtkWidget *widget;
	GtkWidget *ventana;
	
	ventana=gtk_widget_get_toplevel(GTK_WIDGET(togglebutton));
	widget=glade_xml_get_widget(proyecto_ventana,"glade_fileentry");
	if (gtk_toggle_button_get_active(togglebutton)) {
		gtk_widget_set_sensitive(widget,TRUE);
	} else {
		gtk_widget_set_sensitive(widget,FALSE);
	}
}


void
on_x11_libs_boton_toggled              (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if (!pro_forzando_librerias) {
		pro_actualizar_librerias_lincado(GTK_WIDGET(togglebutton));
		pro_modificar_dependencias_librerias(LX11);
		pro_mostrar_librerias_lincado(GTK_WIDGET(togglebutton));
	}
}


void
on_gettext_libs_boton_toggled          (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	GtkWidget *widget;
	
	widget=glade_xml_get_widget(proyecto_ventana,"gettext_entry");
	gtk_widget_set_sensitive(widget,gtk_toggle_button_get_active(togglebutton));
}


void
on_audiofile_libs_boton_toggled        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if (!pro_forzando_librerias) {
		pro_actualizar_librerias_lincado(GTK_WIDGET(togglebutton));
		pro_modificar_dependencias_librerias(LAUDIOFILE);
		pro_mostrar_librerias_lincado(GTK_WIDGET(togglebutton));
	}
}


void
on_esd_libs_boton_toggled              (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if (!pro_forzando_librerias) {
		pro_actualizar_librerias_lincado(GTK_WIDGET(togglebutton));
		pro_modificar_dependencias_librerias(LESD);
		pro_mostrar_librerias_lincado(GTK_WIDGET(togglebutton));
	}
}


void
on_imlib_libs_boton_toggled            (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if (!pro_forzando_librerias) {
		pro_actualizar_librerias_lincado(GTK_WIDGET(togglebutton));
		pro_modificar_dependencias_librerias(LIMLIB);
		pro_mostrar_librerias_lincado(GTK_WIDGET(togglebutton));
	}
}


void
on_ok_boton_proyecto_clicked           (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *ventana;
	int ret;
	
	switch (estado_proyecto_ventana) {
		case NUEVO:
			if (edit_comprobar_perdida_datos()) {
				ventana = gen_create_perdidas_ventana();
				ret = gnome_dialog_run_and_close (GNOME_DIALOG(ventana));
				switch (ret) {
					case 0: //Boton "si"
						ventana_propiedades_proyecto=GTK_WIDGET(button);
						gen_crear_proyecto(ventana_propiedades_proyecto);
						gen_cerrar_ventana(ventana_propiedades_proyecto);
						break;
					case 1: //Boton "no"
						break;
					default:	//El usuario ha cerrado la ventana desde el gestor de ventanas
						break;
				}
				//Creo que no hace falta
				//gtk_widget_hide(ventana); 
			} else {
				gen_crear_proyecto(GTK_WIDGET(button));
				gen_cerrar_ventana(GTK_WIDGET(button));
			}
			break;
		case PROPIEDADES:
			pro_actualizar(GTK_WIDGET(button));
			gen_cerrar_ventana(GTK_WIDGET(button));
			break;
	};
}


void
on_cancel_boton_proyecto_clicked       (GtkButton       *button,
                                        gpointer         user_data)
{
	if (proyecto.xml_viejo!=NULL) {
		proyecto.xml=proyecto.xml_viejo;
		proyecto.xml_viejo=NULL;
	}
	gen_cerrar_ventana(GTK_WIDGET(button));
}


void
on_auto_indentacion_boton_toggled      (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	GtkWidget *ventana;
	GtkToggleButton *boton;
	
	ventana=gtk_widget_get_toplevel(GTK_WIDGET(togglebutton));
	if (!gtk_toggle_button_get_active(togglebutton)) {
		boton=GTK_TOGGLE_BUTTON(glade_xml_get_widget(preferencias_ventana,"super_indentacion_boton"));
		gtk_toggle_button_set_active(boton,FALSE);
	}
}


void
on_super_indentacion_boton_toggled     (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	GtkWidget *ventana;
	GtkToggleButton *boton;
	
	ventana=gtk_widget_get_toplevel(GTK_WIDGET(togglebutton));
	if (gtk_toggle_button_get_active(togglebutton)) {
		boton=GTK_TOGGLE_BUTTON(glade_xml_get_widget(preferencias_ventana,"auto_indentacion_boton"));
		gtk_toggle_button_set_active(boton,TRUE);
	} else {
		boton=GTK_TOGGLE_BUTTON(glade_xml_get_widget(preferencias_ventana,"cerrar_llaves_boton"));
		gtk_toggle_button_set_active(boton,FALSE);
	}
}


void
on_cerrar_llaves_boton_toggled         (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	GtkWidget *ventana;
	GtkToggleButton *boton;
	
	ventana=gtk_widget_get_toplevel(GTK_WIDGET(togglebutton));
	boton=GTK_TOGGLE_BUTTON(glade_xml_get_widget(preferencias_ventana,"super_indentacion_boton"));
	if (gtk_toggle_button_get_active(togglebutton)) {
		gtk_toggle_button_set_active(boton,TRUE);
	}
}


void
on_defecto_boton_preferencias_clicked  (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *fuente;
	GtkWidget *widget;

	c_fondo.red=65535;
	c_fondo.green=65535;
	c_fondo.blue=65535;

	c_nada.red=0;
	c_nada.green=0;
	c_nada.blue=0;

	c_comentario.red=40000;
	c_comentario.green=40000;
	c_comentario.blue=40000;

	c_directiva.red=1000;
	c_directiva.green=45000;
	c_directiva.blue=1000;

	c_cadena_cs.red=65535;
	c_cadena_cs.green=40000;
	c_cadena_cs.blue=0;

	c_cadena_cd.red=65535;
	c_cadena_cd.green=20000;
	c_cadena_cd.blue=0;

	c_etiqueta.red=1000;
	c_etiqueta.green=1000;
	c_etiqueta.blue=50000;

	c_entero.red=50000;
	c_entero.green=1000;
	c_entero.blue=1000;

	c_real.red=40000;
	c_real.green=50000;
	c_real.blue=0;

	c_hexadecimal.red=60000;
	c_hexadecimal.green=0;
	c_hexadecimal.blue=60000;

	c_octal.red=50000;
	c_octal.green=40000;
	c_octal.blue=30000;

	widget=gtk_widget_get_toplevel(GTK_WIDGET(button));
	
	fuente=glade_xml_get_widget(preferencias_ventana,"texto_color");
	gnome_color_picker_set_i16(GNOME_COLOR_PICKER(fuente),c_nada.red,c_nada.green,c_nada.blue,0);
	fuente=glade_xml_get_widget(preferencias_ventana,"texto_bold");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),FALSE);
	fuente=glade_xml_get_widget(preferencias_ventana,"texto_italic");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),FALSE);
	fuente=glade_xml_get_widget(preferencias_ventana,"defines_color");
	gnome_color_picker_set_i16(GNOME_COLOR_PICKER(fuente),c_directiva.red,c_directiva.green,c_directiva.blue,0);
	fuente=glade_xml_get_widget(preferencias_ventana,"defines_bold");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),FALSE);
	fuente=glade_xml_get_widget(preferencias_ventana,"defines_italic");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),FALSE);
	fuente=glade_xml_get_widget(preferencias_ventana,"reservadas_color");
	gnome_color_picker_set_i16(GNOME_COLOR_PICKER(fuente),c_etiqueta.red,c_etiqueta.green,c_etiqueta.blue,0);
	fuente=glade_xml_get_widget(preferencias_ventana,"reservadas_bold");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),FALSE);
	fuente=glade_xml_get_widget(preferencias_ventana,"reservadas_italic");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),FALSE);
	fuente=glade_xml_get_widget(preferencias_ventana,"comentarios_color");
	gnome_color_picker_set_i16(GNOME_COLOR_PICKER(fuente),c_comentario.red,c_comentario.green,c_comentario.blue,0);
	fuente=glade_xml_get_widget(preferencias_ventana,"comentarios_bold");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),FALSE);
	fuente=glade_xml_get_widget(preferencias_ventana,"comentarios_italic");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),FALSE);
	fuente=glade_xml_get_widget(preferencias_ventana,"cadenas_color");
	gnome_color_picker_set_i16(GNOME_COLOR_PICKER(fuente),c_cadena_cd.red,c_cadena_cd.green,c_cadena_cd.blue,0);
	fuente=glade_xml_get_widget(preferencias_ventana,"cadenas_bold");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),FALSE);
	fuente=glade_xml_get_widget(preferencias_ventana,"cadenas_italic");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),FALSE);
	fuente=glade_xml_get_widget(preferencias_ventana,"caracteres_color");
	gnome_color_picker_set_i16(GNOME_COLOR_PICKER(fuente),c_cadena_cs.red,c_cadena_cs.green,c_cadena_cs.blue,0);
	fuente=glade_xml_get_widget(preferencias_ventana,"caracteres_bold");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),FALSE);
	fuente=glade_xml_get_widget(preferencias_ventana,"caracteres_italic");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),FALSE);
	fuente=glade_xml_get_widget(preferencias_ventana,"naturales_color");
	gnome_color_picker_set_i16(GNOME_COLOR_PICKER(fuente),c_entero.red,c_entero.green,c_entero.blue,0);
	fuente=glade_xml_get_widget(preferencias_ventana,"naturales_bold");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),FALSE);
	fuente=glade_xml_get_widget(preferencias_ventana,"naturales_italic");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),FALSE);
	fuente=glade_xml_get_widget(preferencias_ventana,"reales_color");
	gnome_color_picker_set_i16(GNOME_COLOR_PICKER(fuente),c_real.red,c_real.green,c_real.blue,0);
	fuente=glade_xml_get_widget(preferencias_ventana,"reales_bold");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),FALSE);
	fuente=glade_xml_get_widget(preferencias_ventana,"reales_italic");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),FALSE);
	fuente=glade_xml_get_widget(preferencias_ventana,"hexadecimales_color");
	gnome_color_picker_set_i16(GNOME_COLOR_PICKER(fuente),c_hexadecimal.red,c_hexadecimal.green,c_hexadecimal.blue,0);
	fuente=glade_xml_get_widget(preferencias_ventana,"hexadecimales_bold");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),FALSE);
	fuente=glade_xml_get_widget(preferencias_ventana,"hexadecimales_italic");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),FALSE);
	fuente=glade_xml_get_widget(preferencias_ventana,"octales_color");
	gnome_color_picker_set_i16(GNOME_COLOR_PICKER(fuente),c_octal.red,c_octal.green,c_octal.blue,0);
	fuente=glade_xml_get_widget(preferencias_ventana,"octales_bold");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),FALSE);
	fuente=glade_xml_get_widget(preferencias_ventana,"octales_italic");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),FALSE);
	fuente=glade_xml_get_widget(preferencias_ventana,"fondo_color");
	gnome_color_picker_set_i16(GNOME_COLOR_PICKER(fuente),c_fondo.red,c_fondo.green,c_fondo.blue,0);
}


void
on_ok_boton_preferencias_clicked       (GtkButton       *button,
                                        gpointer         user_data)
{
	pref_actualizar(GTK_WIDGET(button));
	gen_cerrar_ventana(GTK_WIDGET(button));
	pref_aplicar();
}


void
on_cancel_boton_preferencias_clicked   (GtkButton       *button,
                                        gpointer         user_data)
{
	gen_cerrar_ventana(GTK_WIDGET(button));
}


void
on_nuevo2_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	GtkWidget *boton;
	
	//Simulamos una pulsacion en el boton de la barra de herramientas
	boton=glade_xml_get_widget(david_ventana,"nuevo_boton");
	gtk_signal_emit_by_name(GTK_OBJECT(boton),"clicked");
}


void
on_anadir1_activate                    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	gen_add_files_ventana();
}


void
on_eliminar_del_proyecto1_activate     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	gen_eliminar();
}


void
on_eliminar_del_disco1_activate        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	gint result;
	gchar *archivo;
	
	result=gen_ventana_confirmacion(_("Are you sure you want to delete the current file?"),GTK_BUTTONS_YES_NO);
	if (result) {
		archivo=pro_nombre_completo_archivo(edit_actual->nombre,FALSE, LOCALE);
		gen_eliminar();
		if (!pro_autoaddremove_cvs()) {
			remove(archivo);
		}
		g_free(archivo);
	}
}


void
on_cortar1_activate                    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	edit_cortar_seleccion();
}


void
on_copiar1_activate                    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	edit_copiar_seleccion();
}


void
on_pegar1_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	edit_pegar_seleccion();
}


void
on_borrar1_activate                    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	edit_borrar_seleccion();
}


void
on_buscar2_activate                    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	buscar_buscar();
}


void
on_anadir_tabulacion1_activate         (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	edit_anadir_tabulacion();
}


void
on_eliminar_tabulacion1_activate       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	edit_eliminar_tabulacion();
}


void
on_mover_a_pestana_nueva1_activate     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	GtkNotebook *notebook;
	GtkWidget *etiqueta;
	GtkWidget *editor_texto;
	GtkWidget *scrolledwindow;	
	gint offset;	
	GtkTextMark *cursor_mark;	
	GtkTextIter cursor_iter;
	
	DEBUG_MSG(->on_mover_a_pestana_nueva1_activate);
	if (edit_actual==NULL || edit_actual->pestana!=0) {
		DEBUG_MSG(<-on_mover_a_pestana_nueva1_activate 1);
		return;
	}
	cursor_mark = gtk_text_buffer_get_insert(GTK_TEXT_BUFFER(edit_actual->datos));	
	gtk_text_buffer_get_iter_at_mark (GTK_TEXT_BUFFER(edit_actual->datos), &cursor_iter, cursor_mark);	
	offset = gtk_text_iter_get_offset (&cursor_iter);	
	edit_total_pestanas++;
	notebook=GTK_NOTEBOOK(glade_xml_get_widget(david_ventana,"archivos_notebook"));
	etiqueta=gtk_label_new(edit_actual->nombre);
	editor_texto=editor_texto_new(NULL,NULL,NULL,0,0);
	g_signal_connect (G_OBJECT (editor_texto), "enter_notify_event",G_CALLBACK(on_editor_texto_enter_notify_event),NULL);
	g_signal_connect (G_OBJECT (editor_texto), "button_press_event",G_CALLBACK(on_editor_texto_button_press_event),NULL);
	g_signal_connect (G_OBJECT (editor_texto), "key_press_event",G_CALLBACK(on_editor_texto_key_press_event),NULL);
	g_signal_connect_after (G_OBJECT (editor_texto), "key_press_event",G_CALLBACK(on_editor_texto_key_press_event_despues),NULL);
	scrolledwindow=gtk_scrolled_window_new(NULL,NULL);
	gtk_container_add(GTK_CONTAINER(scrolledwindow),editor_texto);
	gtk_source_view_set_tab_stop(GTK_SOURCE_VIEW(editor_texto),preferencias.tabulador);
	gtk_widget_show(editor_texto);
	gtk_widget_show(scrolledwindow);
	gtk_notebook_append_page(notebook,scrolledwindow,etiqueta);

	edit_actualizar();

	edit_actual->editor=GTK_SOURCE_VIEW(editor_texto);
	edit_actual->pestana=-1;
	edit_ver(edit_actual->nombre);
	edit_actual->pestana=edit_total_pestanas;
	gtk_notebook_set_page(notebook,edit_total_pestanas);	
	gtk_text_buffer_get_iter_at_offset (GTK_TEXT_BUFFER(edit_actual->datos), &cursor_iter, offset);	
	gtk_text_buffer_move_mark_by_name(GTK_TEXT_BUFFER(edit_actual->datos), "insert", &cursor_iter);	
	cursor_mark = gtk_text_buffer_get_insert (GTK_TEXT_BUFFER(edit_actual->datos));		
	gtk_text_view_scroll_to_mark(GTK_TEXT_VIEW(edit_actual->editor), cursor_mark, 0, TRUE, 1, 0.5);
	gtk_text_view_set_buffer(GTK_TEXT_VIEW(edit_editor),GTK_TEXT_BUFFER(empty_buffer));
	gtk_text_view_set_editable(GTK_TEXT_VIEW(edit_editor),FALSE);
	etiqueta=glade_xml_get_widget(david_ventana,"editor_etiqueta");
	gtk_label_set(GTK_LABEL(etiqueta),_("Files"));
	DEBUG_MSG(<-on_mover_a_pestana_nueva1_activate);
}


void
on_eliminar_esta_pestana1_activate     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	gint pestana_actual;
	GtkWidget *notebook;
	
	DEBUG_MSG(->on_eliminar_esta_pestana1_activate);
	if (edit_actual!=NULL && edit_actual->pestana>1) {
		pestana_actual=edit_actual->pestana;
		notebook=glade_xml_get_widget(david_ventana,"archivos_notebook");
		if (gtk_text_buffer_get_modified(GTK_TEXT_BUFFER(edit_actual->datos))) {
			edit_actualizar();
			if (!edit_actual->analizado) {
				cefv_analizar_archivo(edit_actual->nombre);
				edit_actual->analizado=TRUE;
			}
		}
		edit_actual->editor=NULL;
		edit_actual->pestana=-1;
		gtk_notebook_set_page(GTK_NOTEBOOK(notebook),0);
		gtk_notebook_remove_page(GTK_NOTEBOOK(notebook),pestana_actual);
		edit_total_pestanas--;
		edit_actual=raiz_lista_archivos;
		while (edit_actual!=NULL) {
			if (edit_actual->pestana>pestana_actual) {
				edit_actual->pestana--;
			}
			edit_actual=edit_actual->siguiente;
		}
		edit_actual=raiz_lista_archivos;
		while (edit_actual!=NULL && edit_actual->pestana!=0) {
			edit_actual=edit_actual->siguiente;
		}
	}
	DEBUG_MSG(<-on_eliminar_esta_pestana1_activate);
}


void
on_mostrar_funcion1_activate           (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	gint tipo;
	GtkTextIter inicio,fin;
	GtkTextIter pos;
	GtkSourceBuffer *datos;
	gchar *funcion;
	gunichar caracter;
	gboolean sin_limite;
	gunichar limite1,limite2,limite3,limite4,limite5,limite6,caracter1;
	
	DEBUG_MSG(->on_mostrar_funcion1_activate);
	if (edit_actual==NULL) return;
	if (lista_cefv==NULL) return;
	
	limite1=g_utf8_get_char("a");
	limite2=g_utf8_get_char("z");
	limite3=g_utf8_get_char("A");
	limite4=g_utf8_get_char("Z");
	limite5=g_utf8_get_char("0");
	limite6=g_utf8_get_char("9");
	caracter1=g_utf8_get_char("_");
	//mostramos funciones solo si el archivo actual es un archivo de fuentes o de cabeceras
	tipo=gen_tipo_archivo(edit_actual->nombre);
	if ((tipo==1) || (tipo==2)) {
		edit_actualizar();
		gtk_text_buffer_get_iter_at_mark(GTK_TEXT_BUFFER(edit_actual->datos),&pos,gtk_text_buffer_get_insert(GTK_TEXT_BUFFER(edit_actual->datos)));
		datos=edit_actual->datos;
		// con estos dos do localizamos el nombre completo de la funcion en el archivo
		inicio=pos;
		do {
			caracter=gtk_text_iter_get_char(&inicio);
			if (((caracter>=limite1) && (caracter<=limite2)) || ((caracter>=limite3) && (caracter<=limite4)) || (caracter==caracter1) || ((caracter>=limite5) && (caracter<=limite6))) {
				sin_limite=gtk_text_iter_backward_char(&inicio);
			} else {
				gtk_text_iter_forward_char(&inicio);
				sin_limite=FALSE;
			}
		} while (sin_limite);
		fin=pos;
		do {
			caracter=gtk_text_iter_get_char(&fin);
			if (((caracter>=limite1) && (caracter<=limite2)) || ((caracter>=limite3) && (caracter<=limite4)) || (caracter==caracter1) || ((caracter>=limite5) && (caracter<=limite6))) {
				sin_limite=gtk_text_iter_forward_char(&fin);
			} else {
				sin_limite=FALSE;
			}
		} while (sin_limite);
		
		//El cursor debia estar en una funcion, luego inicio debe ser < que fin siempre
		//si es >= significa que el cursor no estaba sobre una funcion asi que nos salimos
		if (gtk_text_iter_get_offset(&inicio)<gtk_text_iter_get_offset(&fin)) {
			// hacemos una copia del nombre de la funcion para mostrarla
			funcion=gtk_text_iter_get_text(&inicio,&fin);
			edit_ver_funcion(funcion, TRUE);
			g_free(funcion);
		} 
	}
	DEBUG_MSG(<-on_mostrar_funcion1_activate);
}


gboolean
on_buscar_ventana_delete_event         (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
	edit_mensaje("");
	buscar_buscando=FALSE;
	gen_cerrar_ventana(widget);
  	return TRUE;
}


void
on_reemplazar_boton_clicked            (GtkButton       *button,
                                        gpointer         user_data)
{
	buscar_reemplazar(GTK_WIDGET(button));
}


void
on_reemplazar_todo_boton_clicked       (GtkButton       *button,
                                        gpointer         user_data)
{
	buscar_reemplazar_todo(GTK_WIDGET(button));
}


void
on_buscar_boton_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *buscar_ventana_widget;
	GtkEntry *entrada;
	gchar *texto;
	
	//Comprobamos si se trata de una busqueda o un reemplazo
	buscar_ventana_widget = gtk_widget_get_toplevel(GTK_WIDGET(button));
	entrada = GTK_ENTRY(glade_xml_get_widget(buscar_ventana,"reemplazar_entrada"));
	texto = gtk_editable_get_chars(GTK_EDITABLE(entrada),0,-1);
	if (!strcmp(texto,"")) {       //Se trata de una busqueda
		buscar_busqueda(buscar_ventana_widget);	
	} else {      //Se trata de una sustitucion
		buscar_siguiente(buscar_ventana_widget);
		if (buscar_terminado) {
			edit_mensaje(_("No more maches."));
		}
	}
	g_free(texto);
}


void
on_boton_buscar_current_file_toggled   (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	GtkWidget *widget;
	
	//Escondemos o mostramos las opciones de la ventana de busqueda
	//segun corresponda
	widget = glade_xml_get_widget(buscar_ventana, "caja_opciones_current");
	if (gtk_toggle_button_get_active(togglebutton)) {
		gtk_widget_set_sensitive (widget, TRUE);
		widget=glade_xml_get_widget(buscar_ventana,"reemplazar_entrada");
		gtk_widget_set_sensitive(widget,TRUE);
		widget=glade_xml_get_widget(buscar_ventana,"reemplazar_boton");
		gtk_widget_set_sensitive(widget,TRUE);
		widget=glade_xml_get_widget(buscar_ventana,"reemplazar_todo_boton");
		gtk_widget_set_sensitive(widget,TRUE);
	} else {
		gtk_widget_set_sensitive (widget, FALSE);
		widget=glade_xml_get_widget(buscar_ventana,"reemplazar_entrada");
		gtk_widget_set_sensitive(widget,FALSE);
		widget=glade_xml_get_widget(buscar_ventana,"reemplazar_boton");
		gtk_widget_set_sensitive(widget,FALSE);
		widget=glade_xml_get_widget(buscar_ventana,"reemplazar_todo_boton");
		gtk_widget_set_sensitive(widget,FALSE);
	}
}


void
on_boton_buscar_multiple_files_toggled (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	GtkWidget *widget;
	
	//Escondemos o mostramos las opciones de la ventana de busqueda
	//segun corresponda
	widget = glade_xml_get_widget(buscar_ventana, "caja_opciones_multiple");
	if (gtk_toggle_button_get_active(togglebutton)) {
		gtk_widget_set_sensitive (widget, TRUE);
		widget=glade_xml_get_widget(buscar_ventana,"reemplazar_entrada");
		gtk_widget_set_sensitive(widget,FALSE);
		widget=glade_xml_get_widget(buscar_ventana,"reemplazar_boton");
		gtk_widget_set_sensitive(widget,FALSE);
		widget=glade_xml_get_widget(buscar_ventana,"reemplazar_todo_boton");
		gtk_widget_set_sensitive(widget,FALSE);
	} else {
		gtk_widget_set_sensitive (widget, FALSE);
		widget=glade_xml_get_widget(buscar_ventana,"reemplazar_entrada");
		gtk_widget_set_sensitive(widget,TRUE);
		widget=glade_xml_get_widget(buscar_ventana,"reemplazar_boton");
		gtk_widget_set_sensitive(widget,TRUE);
		widget=glade_xml_get_widget(buscar_ventana,"reemplazar_todo_boton");
		gtk_widget_set_sensitive(widget,TRUE);
	}

}


void
on_cancel_boton_buscar_clicked         (GtkButton       *button,
                                        gpointer         user_data)
{
	gen_cerrar_ventana(GTK_WIDGET(button));
	edit_mensaje("");
	buscar_buscando=FALSE;
}


void
on_ok_boton_nuevo_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
	DEBUG_MSG(->on_ok_boton_nuevo_clicked);
	gen_nuevo(GTK_WIDGET(button));
	DEBUG_MSG(<-on_ok_boton_nuevo_clicked);
}


void
on_cancel_boton_nuevo_clicked          (GtkButton       *button,
                                        gpointer         user_data)
{
	gen_cerrar_ventana(GTK_WIDGET(button));
}


gboolean
on_david_ventana_delete_event          (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
	GtkWidget *ventana;
	int ret;
	
	if (edit_comprobar_perdida_datos()) {
		ventana = gen_create_perdidas_ventana();
		ret = gnome_dialog_run_and_close (GNOME_DIALOG(ventana));
		switch (ret) {
			case 0: //Boton "si"
				gen_salir();
				break;
			case 1: //Boton "no"
				break;
			default:	//El usuario ha cerrado la ventana desde el gestor de ventanas
				break;
		}
		//creo que no es necesario
		//gtk_widget_destroy(ventana); 
		gtk_signal_emit_stop_by_name(GTK_OBJECT(widget),"delete_event");
	} else {
		gen_salir();
	}
	return TRUE;
}


void
on_nuevo1_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	GtkWidget *ventana,*boton;
	
	ventana=glade_xml_get_widget(proyecto_ventana,"proyecto_ventana");
	boton=glade_xml_get_widget(proyecto_ventana,"ok_boton_proyecto");
	gtk_widget_set_sensitive(boton,FALSE);
	estado_proyecto_ventana=NUEVO;
	proyecto.xml_viejo=proyecto.xml;
	pro_crear();
	pro_mostrar(ventana);
	gtk_widget_show(ventana);
}


void
on_new_file1_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	GtkWidget *boton;
	
	//Simulamos una pulsacion en el boton de la barra de herramientas
	boton=glade_xml_get_widget(david_ventana,"nuevo_boton");
	gtk_signal_emit_by_name(GTK_OBJECT(boton),"clicked");
}


void
on_project1_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	GtkWidget *boton;
	
	//Simulamos una pulsacion en el boton de la barra de herramientas
	boton = glade_xml_get_widget(david_ventana,"abrir_boton");
	gtk_signal_emit_by_name (GTK_OBJECT(boton),"clicked");
}


void
on_save1_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	edit_guardar();
}


void
on_guardar_todo1_activate              (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	edit_guardar_todo();
}


void
on_imprimir1_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	GtkWidget *boton;
	
	//Simulamos una pulsacion en el boton de la barra de herramientas
	boton = glade_xml_get_widget(david_ventana,"imprimir_boton");
	gtk_signal_emit_by_name (GTK_OBJECT(boton),"clicked");
}


void
on_exit1_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	GtkWidget *widget;
	int ret;
	
	if (edit_comprobar_perdida_datos()) {
		widget = gen_create_perdidas_ventana();
		ret = gnome_dialog_run_and_close (GNOME_DIALOG(widget));
		switch (ret) {
			case 0: //Boton "si"
				gen_salir();
				break;
			case 1: //Boton "no"
				break;
			default:	//El usuario ha cerrado la ventana desde el gestor de ventanas
				break;
		}
		//Creo que no es necesario
		//gtk_widget_hide(widget); 
	} else {
		gen_salir();
	}
}


void
on_deshacer2_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	if (edit_actual!=NULL) {
		if ((edit_actual->pestana!=-1) && (edit_actual->pestana!=1)) {
			if (gtk_source_buffer_can_undo(edit_actual->datos)) {
				gtk_source_buffer_undo(edit_actual->datos);
			}
		}
	}
}


void
on_rehacer1_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	if (edit_actual!=NULL) {
		if ((edit_actual->pestana!=-1) && (edit_actual->pestana!=1)) {
			if (gtk_source_buffer_can_redo(edit_actual->datos)) {
				gtk_source_buffer_redo(edit_actual->datos);
			}
		}
	}
}


void
on_cut1_activate                       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	edit_cortar_seleccion();
}


void
on_copy1_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	edit_copiar_seleccion();
}


void
on_paste1_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	edit_pegar_seleccion();
}


void
on_clear1_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	edit_borrar_seleccion();
}


void
on_buscar1_activate                    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	buscar_buscar();
}


void
on_show_message_box1_activate          (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	GtkWidget *boton;
	GtkWidget *ventana;
	
	ventana = glade_xml_get_widget(david_ventana, "david_ventana");
	//Simulamos una pulsacion en el boton de la barra de herramientas
	if (ventana != NULL) {
		boton = glade_xml_get_widget(david_ventana, "mensajes_togglebutton");
		if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(boton))) 
			gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(boton), FALSE);
		else
			gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(boton),TRUE);
	}
}


void
on_show_file_box1_activate             (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	GtkWidget *boton;
	GtkWidget *ventana;
	
	ventana = glade_xml_get_widget(david_ventana, "david_ventana");
	//Simulamos una pulsacion en el boton de la barra de herramientas
	if (ventana != NULL) {
		boton = glade_xml_get_widget(david_ventana, "arboles_togglebutton");
		if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(boton))) 
			gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(boton), FALSE);
		else
			gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(boton),TRUE);
	}

}


void
on_clean1_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	gchar *comando, *temp;
	
	if (proyecto.xml != NULL) {
		comando = g_strdup("make clean 1>/dev/null 2>/dev/stdout");
		//nos situamos en el directorio raiz del proyecto
		temp = pro_nombre_completo_archivo(proyecto.archivo, TRUE, UTF8);
		gen_comando (comando,"---------------------------- Cleaning project ----------------------------\n");
		g_print("Done.\n");
		g_free(comando);
		g_free(temp);
	}
}


void
on_compile1_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	GtkWidget *boton;
	
	//Simulamos una pulsacion en el boton de la barra de herramientas
	boton = glade_xml_get_widget(david_ventana,"compilar_boton");
	gtk_signal_emit_by_name (GTK_OBJECT(boton),"clicked");
}


void
on_make1_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	GtkWidget *boton;
	
	//Simulamos una pulsacion en el boton de la barra de herramientas
	boton = glade_xml_get_widget(david_ventana,"make_boton");
	gtk_signal_emit_by_name (GTK_OBJECT(boton),"clicked");
}


void
on_run1_activate                       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	GtkWidget *boton;
	
	//Simulamos una pulsacion en el boton de la barra de herramientas
	boton = glade_xml_get_widget(david_ventana,"ejecutar_boton");
	gtk_signal_emit_by_name (GTK_OBJECT(boton),"clicked");
}


void
on_anadir_archivo_existente1_activate  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	gen_add_files_ventana();
}


void
on_propiedades1_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	GtkWidget *boton;
	
	//Simulamos una pulsacion en el boton de la barra de herramientas
	boton = glade_xml_get_widget(david_ventana,"properties_button");
	gtk_signal_emit_by_name (GTK_OBJECT(boton),"clicked");
}


void
on_preferences1_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	GtkWidget *ventana;
	
	ventana=glade_xml_get_widget(preferencias_ventana,"preferencias_ventana");
	pref_mostrar(ventana);
	gtk_widget_show(ventana);
}


void
on_glade1_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	gla_ejecutar();
}


void
on_ddd1_activate                       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	GtkWidget *boton;
	
	//Simulamos una pulsacion en el boton de la barra de herramientas
	boton = glade_xml_get_widget(david_ventana,"ddd_button");
	gtk_signal_emit_by_name (GTK_OBJECT(boton),"clicked");
}


void
on_memprof2_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	GtkWidget *boton;
	
	//Simulamos una pulsacion en el boton de la barra de herramientas
	boton = glade_xml_get_widget(david_ventana,"memprof_boton");
	gtk_signal_emit_by_name (GTK_OBJECT(boton),"clicked");
}


void
on_ayuda_gtk1_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	gen_ayuda(GTK);
}


void
on_ayuda_xml1_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	gen_ayuda(XML);
}


void
on_ayuda_glib1_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	gen_ayuda(GLIB);
}


void
on_ayuda_orbit1_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	gen_ayuda(ORBIT);
}


void
on_ayuda_gnome1_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	gen_ayuda(GNOME);
}


void
on_ayuda_gnomeui1_activate             (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	gen_ayuda(GNOMEUI);
}


void
on_ayuda_gnorba1_activate              (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	gen_ayuda(GNORBA);
}


void
on_about1_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	GtkWidget *acercade_widget;
	
	acercade_ventana = glade_xml_new(GLADE_PROJECT,"acercade_ventana",NULL);
	glade_xml_signal_autoconnect(acercade_ventana);
	acercade_widget = glade_xml_get_widget(acercade_ventana, "acercade_ventana");
	gtk_widget_show(acercade_widget);
}


void
on_nuevo_boton_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *ventana,*boton_cvs;

	if (proyecto.xml==NULL) return;
	ventana=glade_xml_get_widget(nuevo_ventana,"nuevo_ventana");
	boton_cvs=glade_xml_get_widget(nuevo_ventana,"add_nuevo_checkbutton");

	gtk_widget_set_sensitive(boton_cvs,pro_cvs_activo());
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(boton_cvs),pro_autoaddremove_cvs());
	gtk_widget_show(ventana);
}


void
on_abrir_boton_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *ventana;

	chdir(preferencias.directorio);
	archivos_ventana = glade_xml_new(GLADE_PROJECT,"archivos_ventana",NULL);
	glade_xml_signal_autoconnect(archivos_ventana);
	ventana=glade_xml_get_widget(archivos_ventana,"archivos_ventana");
	gtk_file_selection_hide_fileop_buttons(GTK_FILE_SELECTION(ventana));
	estado_archivos_ventana=PROYECTO_ABRIR;
	gtk_widget_show(ventana);
}


void
on_guardar_boton_clicked               (GtkButton       *button,
                                        gpointer         user_data)
{
	edit_guardar();
}


void
on_guardar_todo_boton_clicked          (GtkButton       *button,
                                        gpointer         user_data)
{
	edit_guardar_todo();
}


void
on_recargar_boton_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *ventana;
	int ret;
	
	if (edit_comprobar_perdida_datos()) {
		ventana = gen_create_perdidas_ventana();
		ret = gnome_dialog_run_and_close (GNOME_DIALOG(ventana));
		switch (ret) {
			case 0: //Boton "si"
				gen_recargar();
				break;
			case 1: //Boton "no"
				break;
			default:	//El usuario ha cerrado la ventana desde el gestor de ventanas
				break;
		}
		//Creo que no hace falta
		//gtk_widget_hide(ventana); 
	} else {
		gen_recargar();
	}
}


void
on_imprimir_boton_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
	gchar *archivo;
	gchar *comando;
	
	if (edit_actual!=NULL) {
		edit_guardar();
		archivo=pro_nombre_completo_archivo(edit_actual->nombre,FALSE, LOCALE);
		comando=g_strdup_printf("lpr %s\n",archivo);
		gen_comando(comando,NULL);
		g_free(comando);
		g_free(archivo);
	}
}


void
on_buscar_boton_barra_clicked          (GtkButton       *button,
                                        gpointer         user_data)
{
	buscar_buscar();
}


void
on_compilar_boton_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *widget;
	if (proyecto.archivo!=NULL) {
		widget=glade_xml_get_widget(david_ventana,"mensajes_togglebutton");
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget),TRUE);
		comp_compilar_actual();
	}
}


void
on_make_boton_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *widget;

	if (proyecto.archivo!=NULL) {
		if ((edit_actual!=NULL) && (edit_marcador!=0)) {
			gtk_source_buffer_line_remove_marker(edit_actual->datos,edit_marcador,"marcador");
			edit_marcador=0;
		}
		//Los mensajes que aparezcan no seran parte de una busqueda
		if (texto_busqueda_actual != NULL) {
			g_free(texto_busqueda_actual);
			texto_busqueda_actual =  NULL;
		}
		widget=glade_xml_get_widget(david_ventana,"mensajes_togglebutton");
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget),TRUE);
		comp_update_pot_file();
		comp_run_make();
	}
}


void
on_ejecutar_boton_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *widget;
	gchar *prodir,*srcdir,*ejecutable,*nombre;
	pid_t pid;
	gchar *argumentos[4];
	
	if (proyecto.xml==NULL) return;
	if ((edit_actual!=NULL) && (edit_marcador!=0)) {
		gtk_source_buffer_line_remove_marker(edit_actual->datos,edit_marcador,"marcador");
		edit_marcador=0;
	}
	widget=glade_xml_get_widget(david_ventana,"mensajes_togglebutton");
	comp_update_pot_file();
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget),TRUE);
	if (comp_run_make()) return;
	if ((pid=fork())==0) {
		prodir=pro_prodir(LOCALE);
		srcdir=pro_srcdir(LOCALE);
		ejecutable=pro_ejecutable(LOCALE);
		nombre=pro_nombre(LOCALE);
		argumentos[0]=g_strdup("gnome-terminal");
		argumentos[1]=g_strdup_printf("-e %s/%s/%s",prodir,srcdir,ejecutable);
		argumentos[2]=g_strdup_printf("-t %s",nombre);
		argumentos[3]=NULL;
		execvp("gnome-terminal",argumentos);
		g_free(prodir);
		g_free(srcdir);
		g_free(ejecutable);
		g_free(nombre);
	}
}


void
on_glade_boton_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
	gla_ejecutar();
}


void
on_ddd_button_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
	gchar *ejecutable;
	pid_t pid;
	gchar *argumentos[3];
	
	if (proyecto.xml==NULL) return;
	if ((pid=fork())==0) {
		ejecutable=pro_nombre_completo_archivo("ejecutable.c",TRUE, LOCALE);
		g_free(ejecutable);
		ejecutable=pro_ejecutable(LOCALE);
		
		argumentos[0]=g_strdup("ddd");
		argumentos[1]=ejecutable;
		argumentos[2]=NULL;
		execvp("ddd",argumentos);
	}
}


void
on_memprof_boton_clicked               (GtkButton       *button,
                                        gpointer         user_data)
{
	gchar *ejecutable,*tmp;
	pid_t pid;
	gchar *argumentos[3];
	
	if (proyecto.xml==NULL) return;
	if ((pid=fork())==0) {
		tmp=pro_nombre_completo_archivo("ejecutable.c",TRUE, LOCALE);
		g_free(tmp);
		tmp=pro_ejecutable(LOCALE);
		ejecutable=g_strdup_printf("./%s",tmp);
		g_free(tmp);
		
		argumentos[0]=g_strdup("memprof");
		argumentos[1]=ejecutable;
		argumentos[2]=NULL;
		execvp("memprof",argumentos);
	}
}


void
on_arboles_togglebutton_toggled        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	GtkWidget *widget;
	static gint posicion;
	
	widget=glade_xml_get_widget(david_ventana,"arboles_notebook");
	if (gtk_toggle_button_get_active(togglebutton))
	{
		gtk_widget_show(widget);

		//Bloqueamos la callback del menuitem que vamos a cambiar de estado
		//para que no haya una recursividad de callbacks.
		widget = glade_xml_get_widget(david_ventana,"show_file_box1");		
		g_signal_handlers_block_by_func(G_OBJECT(widget),on_show_file_box1_activate,NULL);
		//cambiamos el estado del menuitem
		gtk_check_menu_item_set_state(GTK_CHECK_MENU_ITEM(widget),TRUE);
		g_signal_handlers_unblock_by_func(G_OBJECT(widget),on_show_file_box1_activate,NULL);

		widget=glade_xml_get_widget(david_ventana,"arboles_hpaned");
		gtk_paned_set_gutter_size(GTK_PANED(widget),10);
		gtk_paned_set_position(GTK_PANED(widget),posicion);
	} else {
		gtk_widget_hide(widget);

		//Bloqueamos la callback del menuitem que vamos a cambiar de estado
		//para que no haya una recursividad de callbacks.
		widget = glade_xml_get_widget(david_ventana,"show_file_box1");
		g_signal_handlers_block_by_func(G_OBJECT(widget),on_show_file_box1_activate,NULL);
		//cambiamos el estado del menuitem
		gtk_check_menu_item_set_state(GTK_CHECK_MENU_ITEM(widget),FALSE);
		g_signal_handlers_unblock_by_func(G_OBJECT(widget),on_show_file_box1_activate,NULL);

		widget=glade_xml_get_widget(david_ventana,"arboles_hpaned");
		posicion=gtk_paned_get_position(GTK_PANED(widget));
		gtk_paned_set_position(GTK_PANED(widget),GTK_PANED(widget)->min_position);
		gtk_paned_set_gutter_size(GTK_PANED(widget),0);
	}
}


void
on_mensajes_togglebutton_toggled       (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	GtkWidget *widget;
	static gint posicion;
	
	widget=glade_xml_get_widget(david_ventana,"mensajes_scrolledwindow");
	if (gtk_toggle_button_get_active(togglebutton))
	{
		gtk_widget_show(widget);

		//Bloqueamos la callback del menuitem que vamos a cambiar de estado
		//para que no haya una recursividad de callbacks.
		widget = glade_xml_get_widget(david_ventana,"show_message_box1");
		g_signal_handlers_block_by_func(G_OBJECT(widget),on_show_message_box1_activate,NULL);
		//cambiamos el estado del menuitem
		gtk_check_menu_item_set_state(GTK_CHECK_MENU_ITEM(widget),TRUE);
		g_signal_handlers_unblock_by_func(G_OBJECT(widget),on_show_message_box1_activate,NULL);

		widget=glade_xml_get_widget(david_ventana,"mensajes_vpaned");
		gtk_paned_set_gutter_size(GTK_PANED(widget),10);
		gtk_paned_set_position(GTK_PANED(widget),posicion);
	} else {
		gtk_widget_hide(widget);

		//Bloqueamos la callback del menuitem que vamos a cambiar de estado
		//para que no haya una recursividad de callbacks.
		widget = glade_xml_get_widget(david_ventana,"show_message_box1");
		g_signal_handlers_block_by_func(G_OBJECT(widget),on_show_message_box1_activate,NULL);
		//cambiamos el estado del menuitem
		gtk_check_menu_item_set_state(GTK_CHECK_MENU_ITEM(widget),FALSE);
		g_signal_handlers_unblock_by_func(G_OBJECT(widget),on_show_message_box1_activate,NULL);

		widget=glade_xml_get_widget(david_ventana,"mensajes_vpaned");
		posicion=gtk_paned_get_position(GTK_PANED(widget));
		gtk_paned_set_position(GTK_PANED(widget),GTK_PANED(widget)->max_position);
		gtk_paned_set_gutter_size(GTK_PANED(widget),0);
	}
}


void
on_cefv_arbol_tree_select_row          (GtkTreeSelection        *selection,
                                        gpointer         user_data)
{
	struct s_lista_cefv *nodo,*hijos;
	struct s_lista_archivos *archivos;
	GtkTreeView *arbol;
	GtkTreeIter iter;
	GtkTreeModel *model;
	GtkTextIter comienzo,fin;
	gchar *rama;
	gint tipo;
	GtkTreePath *path;
	
	DEBUG_MSG(->on_cefv_arbol_tree_select_row);
	
	if (gtk_tree_selection_get_selected(selection,&model,&iter)) {
		gtk_tree_model_get(model,&iter,COL_NOMBRE,&rama,-1);
		nodo=lista_cefv;
		while ((nodo!=NULL) && (g_strcasecmp(nodo->rama,rama))) {
			if (nodo->hijos!=NULL) {
				hijos=nodo->hijos;
				while ((hijos!=NULL) && (g_strcasecmp(hijos->rama,rama))) {
					hijos=hijos->siguiente;
				}
				if (hijos==NULL) {
					nodo=nodo->siguiente;
				} else {
					nodo=hijos;
				}
			} else {
				nodo=nodo->siguiente;
			}
		}
		if (nodo!=NULL) {
			archivos=edit_conseguir_nodo(nodo->archivo);
			
			if (buscar_cadena_forward(GTK_TEXT_BUFFER(archivos->datos),NULL,NULL,nodo->definicion,&comienzo,&fin,0)) {
				DEBUG_MSG(->mark_cefv_cb<-);
				archivos->posicion=gtk_text_buffer_create_mark(GTK_TEXT_BUFFER(archivos->datos),NULL,&comienzo,TRUE);
			}
			
			tipo=gen_tipo_archivo(archivos->nombre);
			arbol=GTK_TREE_VIEW(glade_xml_get_widget(david_ventana,"archivos_arbol"));
			path=gtk_tree_model_get_path(GTK_TREE_MODEL(arch_store),&arch_raiz);
			gtk_tree_view_expand_row(arbol,path,FALSE);
			gtk_tree_path_free(path);
			if (tipo==1) {
				path=gtk_tree_model_get_path(GTK_TREE_MODEL(arch_store),&arch_fuentes);
			}
			if (tipo==2) {
				path=gtk_tree_model_get_path(GTK_TREE_MODEL(arch_store),&arch_cabeceras);
			}
			gtk_tree_view_expand_row(arbol,path,TRUE);
			selection=gtk_tree_view_get_selection(arbol);
			gtk_tree_selection_unselect_all(selection);
			gtk_tree_selection_select_iter(selection,&(archivos->nodo_arbol));
			gtk_tree_path_free(path);
		}
	}
	DEBUG_MSG(<-on_cefv_arbol_tree_select_row);
}


void
on_archivos_arbol_tree_select_row      (GtkTreeSelection        *selection,
                                        gpointer         user_data)
{
	GtkTreeIter iter;
	GtkTreeModel *model;
	gchar *nombre;
	GtkWidget *widget;
	
	DEBUG_MSG(->on_archivos_arbol_tree_select_row);
	if (gtk_tree_selection_get_selected(selection,&model,&iter)) {
		gtk_tree_model_get(model,&iter,COL_NOMBRE,&nombre,-1);
		if (pro_existe_archivo(nombre)) {
			edit_ver(nombre);
			widget=glade_xml_get_widget(david_ventana,"archivos_notebook");
			gtk_notebook_set_page(GTK_NOTEBOOK(widget),edit_actual->pestana);
		}
		g_free(nombre);
	}
	DEBUG_MSG(<-on_archivos_arbol_tree_select_row);
}


gboolean
on_archivos_arbol_button_press_event   (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
	GtkMenu *menu;
	if ((event->button)==3) {
		menu=GTK_MENU(glade_xml_get_widget(archivos_arbol_menu,"archivos_arbol_menu"));
		gtk_menu_popup(menu,NULL,NULL,NULL,NULL,event->button,event->time);
	}
  return FALSE;
}


void
on_archivos_notebook_switch_page       (GtkNotebook     *notebook,
                                        GtkNotebookPage *page,
                                        gint             page_num,
                                        gpointer         user_data)
{
	GtkWidget *entrada;
	gchar *funcion;
	
	if (proyecto.xml==NULL) return;
	if ((edit_actual!=NULL) && (edit_marcador!=0)) {
		gtk_source_buffer_line_remove_marker(edit_actual->datos,edit_marcador,"marcador");
		edit_marcador=0;
	}
	if (page_num==1) {
		entrada=glade_xml_get_widget(david_ventana,"historico_funciones_entry");
		funcion=gtk_editable_get_chars(GTK_EDITABLE(entrada),0,-1);
		edit_ver_funcion(funcion,FALSE);
		g_free(funcion);
		return;
	}
	edit_actual=raiz_lista_archivos;
	while (edit_actual!=NULL && edit_actual->pestana!=page_num) {
		edit_actual=edit_actual->siguiente;
	}
	edit_actualizar_fila();
}

// This is the function that creates the GtkSourceView widget. Now that it is used in the external files window too, 
// the for parameter of the function will be used to modify some of the properties of the widget.
// The fist gint parametir will indicate where the widget will be use.
// 0 - The code editor
// 1 - The external files window
// The other parameters may be used in the future, and should be set to:
// string1	NULL
// string2	NULL
// int2		0
GtkWidget*
editor_texto_new (gchar *widget_name, gchar *string1, gchar *string2,
                gint int1, gint int2)
{
	GtkWidget *editor;
	PangoFontDescription *pfd;

	editor=gtk_source_view_new();
	gtk_widget_modify_base(editor,GTK_STATE_NORMAL,&c_fondo);
	gtk_widget_modify_text(editor,GTK_STATE_NORMAL,&c_nada);
	pfd=NULL;
	if (preferencias.fuente!=NULL) {
		pfd=pango_font_description_from_string(preferencias.fuente);
	}
	if (pfd!=NULL) {
		gtk_widget_modify_font(editor,pfd);
	}
	pango_font_description_free(pfd);
	gtk_source_view_set_show_line_numbers(GTK_SOURCE_VIEW(editor),preferencias.numeros);
	switch (int1) {
		case 0:
			gtk_source_view_set_show_line_pixmaps(GTK_SOURCE_VIEW(editor),TRUE);
			gtk_source_view_add_pixbuf(GTK_SOURCE_VIEW(editor),"marcador",pix_marcador,FALSE);
			break;
		case 1:
			gtk_source_view_set_show_line_pixmaps(GTK_SOURCE_VIEW(editor),FALSE);
			break;
	}
	gtk_text_view_set_cursor_visible(GTK_TEXT_VIEW(editor),TRUE);
	gtk_text_view_set_editable(GTK_TEXT_VIEW(editor),FALSE);
	gtk_text_view_set_buffer(GTK_TEXT_VIEW(editor),GTK_TEXT_BUFFER(empty_buffer));
	gtk_widget_show(editor);
		
	return editor;
}


gboolean
on_mensajes_texto_button_press_event   (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
	DEBUG_MSG(->on_mensajes_texto_button_press_event);
	mensajes_button_pressed = TRUE;
	DEBUG_MSG(<-on_mensajes_texto_button_press_event);
  	return FALSE;
}



gboolean
on_editor_texto_enter_notify_event     (GtkWidget       *widget,
                                        GdkEventCrossing *event,
                                        gpointer         user_data)
{
	gtk_widget_grab_focus(widget);
	return FALSE;
}


gboolean
on_editor_texto_button_press_event     (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
	GtkMenu *menu;
/*	gunichar limite1,limite2,limite3,limite4,limite5,limite6,caracter1;
	GtkTextIter inicio,fin;
	GtkTextIter pos;
	GtkSourceBuffer *datos;
	gunichar caracter;
	gboolean sin_limite;
	
	if (((event->button) == 1) && ((event->type) == GDK_2BUTTON_PRESS)) {
		g_print ("double-click\n");
		//left-button double-click. Highlight current word
		if (edit_actual==NULL) return FALSE;
		if (lista_cefv==NULL) return FALSE;
		
		//valid characters in a word (variable, function... etc)
		limite1=g_utf8_get_char("a");
		limite2=g_utf8_get_char("z");
		limite3=g_utf8_get_char("A");
		limite4=g_utf8_get_char("Z");
		limite5=g_utf8_get_char("0");
		limite6=g_utf8_get_char("9");
		caracter1=g_utf8_get_char("_");
		gtk_text_buffer_get_iter_at_mark(GTK_TEXT_BUFFER(edit_actual->datos),&pos,gtk_text_buffer_get_insert(GTK_TEXT_BUFFER(edit_actual->datos)));
		datos=edit_actual->datos;
		//first locate the leftmost limit of the word
		inicio=pos;
		do {
			caracter=gtk_text_iter_get_char(&inicio);
			if (((caracter>=limite1) && (caracter<=limite2)) || ((caracter>=limite3) && (caracter<=limite4)) || (caracter==caracter1) || ((caracter>=limite5) && (caracter<=limite6))) {
				sin_limite=gtk_text_iter_backward_char(&inicio);
			} else {
				gtk_text_iter_forward_char(&inicio);
				sin_limite=FALSE;
			}
		} while (sin_limite);
		//then the rightmost limit of the word
		fin=pos;
		do {
			caracter=gtk_text_iter_get_char(&fin);
			if (((caracter>=limite1) && (caracter<=limite2)) || ((caracter>=limite3) && (caracter<=limite4)) || (caracter==caracter1) || ((caracter>=limite5) && (caracter<=limite6))) {
				sin_limite=gtk_text_iter_forward_char(&fin);
			} else {
				sin_limite=FALSE;
			}
		} while (sin_limite);
		
		if (gtk_text_iter_get_offset(&fin) > gtk_text_iter_get_offset(&inicio)) {
			//correct word selected. Highlight it
			gtk_text_buffer_move_mark_by_name(GTK_TEXT_BUFFER(datos), "insert", &fin);
			gtk_text_buffer_move_mark_by_name(GTK_TEXT_BUFFER(datos), "selection_bound", &inicio);
			//g_signal_stop_emission_by_name(G_OBJECT(widget), "button_press_event");
			//g_signal_stop_emission_by_name(G_OBJECT(widget), "button_release_event");
			//g_signal_stop_emission_by_name(G_OBJECT(datos), "mark_set");
			return TRUE;
		} 
	}
*/	
	if ((event->button)==3) {
		//right-button single-click. Popup editor menu
		menu=GTK_MENU(glade_xml_get_widget(editor_menu,"editor_menu"));
		gtk_menu_popup(menu,NULL,NULL,NULL,NULL,event->button,event->time);
		gtk_signal_emit_stop_by_name(GTK_OBJECT(widget),"button_press_event");
	}
	return FALSE;
}


gboolean
on_editor_texto_key_press_event        (GtkWidget       *widget,
                                        GdkEventKey     *event,
                                        gpointer         user_data)
{
	gboolean control;
	gboolean shift;
	GtkTextIter inicio,fin;
	gchar *cadena;
	GtkEntry *entry;
	GtkTextMark *cursor_position_mark,*selection_mark;
	GtkTextIter cursor_position_iter;
	gboolean text_found;
	
	control=event->state & GDK_CONTROL_MASK;
	shift=event->state & GDK_SHIFT_MASK;

	switch (event->keyval) {
		case GDK_Tab:
			if (edit_actual!=NULL) {
				if (gtk_text_buffer_get_selection_bounds(GTK_TEXT_BUFFER(edit_actual->datos),NULL,NULL)) {
					if (control) {
						edit_eliminar_tabulacion();
					} else {
						edit_anadir_tabulacion();
					}
					return TRUE;
				}
			}
			break;
		case GDK_F3:
			if (edit_actual!=NULL) {
				if (control) {
					if (gtk_text_buffer_get_selection_bounds(GTK_TEXT_BUFFER(edit_actual->datos),&inicio,&fin)) {
						cadena=gtk_text_buffer_get_text(GTK_TEXT_BUFFER(edit_actual->datos),&inicio,&fin,TRUE);
						entry=GTK_ENTRY(glade_xml_get_widget(david_ventana,"busqueda_barra_entrada"));
						gtk_entry_set_text(entry,cadena);
						g_free(cadena);
					}
				}
				cursor_position_mark = gtk_text_buffer_get_insert (GTK_TEXT_BUFFER(edit_actual->datos));
				gtk_text_buffer_get_iter_at_mark(GTK_TEXT_BUFFER(edit_actual->datos), &cursor_position_iter, cursor_position_mark);
				entry=GTK_ENTRY(glade_xml_get_widget(david_ventana,"busqueda_barra_entrada"));
				cadena=gtk_editable_get_chars(GTK_EDITABLE(entry),0,-1);
				if ((cadena==NULL) || (cadena[0]==0)) {
					return TRUE;
				}
				text_found=FALSE;
				if (shift) {
					text_found=buscar_cadena_backward(GTK_TEXT_BUFFER(edit_actual->datos),NULL,&cursor_position_iter,cadena,&inicio,&fin,0);
					if (!text_found) {
						text_found=buscar_cadena_backward(GTK_TEXT_BUFFER(edit_actual->datos),NULL,NULL,cadena,&inicio,&fin,0);
					}
				} else {
					text_found=buscar_cadena_forward(GTK_TEXT_BUFFER(edit_actual->datos),&cursor_position_iter,NULL,cadena,&inicio,&fin,0);
					if (!text_found) {
						text_found=buscar_cadena_forward(GTK_TEXT_BUFFER(edit_actual->datos),NULL,NULL,cadena,&inicio,&fin,0);
					}
				}
				g_free(cadena);
				if (text_found) {
					gtk_text_buffer_place_cursor(GTK_TEXT_BUFFER(edit_actual->datos),&fin);
					selection_mark = gtk_text_buffer_get_selection_bound(GTK_TEXT_BUFFER(edit_actual->datos));
					gtk_text_buffer_move_mark(GTK_TEXT_BUFFER(edit_actual->datos), selection_mark, &inicio);
					gtk_text_view_scroll_to_mark(GTK_TEXT_VIEW(edit_actual->editor), selection_mark, 0, TRUE, 1,0.5);
				}
			}
			return TRUE;
			break;
	}
	return FALSE;
}

gboolean
on_editor_texto_key_press_event_despues        (GtkWidget       *widget,
                                        GdkEventKey     *event,
                                        gpointer         user_data)
{
	switch (event->keyval) {
		case GDK_Left:
		case GDK_Right:
		case GDK_Up:
		case GDK_Down:

		case GDK_Tab:
			
		case GDK_Shift_L:
		case GDK_Shift_R:
			
			return TRUE;
		break;
	}
	
	if (event->state & GDK_SHIFT_MASK) {
		return TRUE;
	}
	
	return FALSE;
}


void
on_editor_texto_insert_text            (GtkTextBuffer *textbuffer,
									GtkTextIter *pos,
									const gchar *text,
									gint length)
{
	DEBUG_MSG(->on_editor_texto_insert_text);
	if (edit_actual!=NULL) {
		g_signal_handlers_block_by_func(G_OBJECT(textbuffer),on_editor_texto_insert_text,NULL);
		edit_auto_formato(textbuffer,text,length,pos);
		g_signal_handlers_unblock_by_func(G_OBJECT(textbuffer),on_editor_texto_insert_text,NULL);
	}
	DEBUG_MSG(<-on_editor_texto_insert_text);
}


void
on_gtk2_libs_boton_toggled             (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if (!pro_forzando_librerias) {
		pro_actualizar_librerias_lincado(GTK_WIDGET(togglebutton));
		pro_modificar_dependencias_librerias(LGTK2);
		pro_mostrar_librerias_lincado(GTK_WIDGET(togglebutton));
	}
}


void
on_gobject2_libs_boton_toggled         (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if (!pro_forzando_librerias) {
		pro_actualizar_librerias_lincado(GTK_WIDGET(togglebutton));
		pro_modificar_dependencias_librerias(LGOBJECT2);
		pro_mostrar_librerias_lincado(GTK_WIDGET(togglebutton));
	}
}


void
on_glib2_libs_boton_toggled            (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if (!pro_forzando_librerias) {
		pro_actualizar_librerias_lincado(GTK_WIDGET(togglebutton));
		pro_modificar_dependencias_librerias(LGLIB2);
		pro_mostrar_librerias_lincado(GTK_WIDGET(togglebutton));
	}
}


void
on_gnome_vfs_module2_libs_boton_toggled
                                        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if (!pro_forzando_librerias) {
		pro_actualizar_librerias_lincado(GTK_WIDGET(togglebutton));
		pro_modificar_dependencias_librerias(LGNOME_VFS_MODULE2);
		pro_mostrar_librerias_lincado(GTK_WIDGET(togglebutton));
	}
}


void
on_pangoxft_libs_boton_toggled         (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if (!pro_forzando_librerias) {
		pro_actualizar_librerias_lincado(GTK_WIDGET(togglebutton));
		pro_modificar_dependencias_librerias(LPANGOXFT);
		pro_mostrar_librerias_lincado(GTK_WIDGET(togglebutton));
	}
}


void
on_pango_libs_boton_toggled            (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if (!pro_forzando_librerias) {
		pro_actualizar_librerias_lincado(GTK_WIDGET(togglebutton));
		pro_modificar_dependencias_librerias(LPANGO);
		pro_mostrar_librerias_lincado(GTK_WIDGET(togglebutton));
	}
}


void
on_gnomeprintui2_libs_boton_toggled    (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if (!pro_forzando_librerias) {
		pro_actualizar_librerias_lincado(GTK_WIDGET(togglebutton));
		pro_modificar_dependencias_librerias(LGNOMEPRINTUI2);
		pro_mostrar_librerias_lincado(GTK_WIDGET(togglebutton));
	}
}


void
on_gnomeprint2_libs_boton_toggled      (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if (!pro_forzando_librerias) {
		pro_actualizar_librerias_lincado(GTK_WIDGET(togglebutton));
		pro_modificar_dependencias_librerias(LGNOMEPRINT2);
		pro_mostrar_librerias_lincado(GTK_WIDGET(togglebutton));
	}
}


void
on_bonoboui2_libs_boton_toggled        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if (!pro_forzando_librerias) {
		pro_actualizar_librerias_lincado(GTK_WIDGET(togglebutton));
		pro_modificar_dependencias_librerias(LBONOBOUI2);
		pro_mostrar_librerias_lincado(GTK_WIDGET(togglebutton));
	}
}


void
on_bonobo2_libs_boton_toggled          (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if (!pro_forzando_librerias) {
		pro_actualizar_librerias_lincado(GTK_WIDGET(togglebutton));
		pro_modificar_dependencias_librerias(LBONOBO2);
		pro_mostrar_librerias_lincado(GTK_WIDGET(togglebutton));
	}
}


void
on_gnomeui2_libs_boton_toggled         (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if (!pro_forzando_librerias) {
		pro_actualizar_librerias_lincado(GTK_WIDGET(togglebutton));
		pro_modificar_dependencias_librerias(LGNOMEUI2);
		pro_mostrar_librerias_lincado(GTK_WIDGET(togglebutton));
	}
}


void
on_xml2_libs_boton_toggled             (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if (!pro_forzando_librerias) {
		pro_actualizar_librerias_lincado(GTK_WIDGET(togglebutton));
		pro_modificar_dependencias_librerias(LXML2);
		pro_mostrar_librerias_lincado(GTK_WIDGET(togglebutton));
	}
}


void
on_gmodule2_libs_boton_toggled         (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if (!pro_forzando_librerias) {
		pro_actualizar_librerias_lincado(GTK_WIDGET(togglebutton));
		pro_modificar_dependencias_librerias(LGMODULE2);
		pro_mostrar_librerias_lincado(GTK_WIDGET(togglebutton));
	}
}


void
on_gnome_mime_data2_libs_boton_toggled (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if (!pro_forzando_librerias) {
		pro_actualizar_librerias_lincado(GTK_WIDGET(togglebutton));
		pro_modificar_dependencias_librerias(LGNOME_MIME_DATA2);
		pro_mostrar_librerias_lincado(GTK_WIDGET(togglebutton));
	}
}


void
on_gdk_pixbuf_xlib2_libs_boton_toggled (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if (!pro_forzando_librerias) {
		pro_actualizar_librerias_lincado(GTK_WIDGET(togglebutton));
		pro_modificar_dependencias_librerias(LGDK_PIXBUF_XLIB2);
		pro_mostrar_librerias_lincado(GTK_WIDGET(togglebutton));
	}
}


void
on_imlibgdk_libs_boton_toggled         (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if (!pro_forzando_librerias) {
		pro_actualizar_librerias_lincado(GTK_WIDGET(togglebutton));
		pro_modificar_dependencias_librerias(LIMLIBGDK);
		pro_mostrar_librerias_lincado(GTK_WIDGET(togglebutton));
	}
}


void
on_gconf2_libs_boton_toggled           (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if (!pro_forzando_librerias) {
		pro_actualizar_librerias_lincado(GTK_WIDGET(togglebutton));
		pro_modificar_dependencias_librerias(LGCONF2);
		pro_mostrar_librerias_lincado(GTK_WIDGET(togglebutton));
	}
}


void
on_atk_libs_boton_toggled              (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if (!pro_forzando_librerias) {
		pro_actualizar_librerias_lincado(GTK_WIDGET(togglebutton));
		pro_modificar_dependencias_librerias(LATK);
		pro_mostrar_librerias_lincado(GTK_WIDGET(togglebutton));
	}
}


void
on_gdk_x11_2_libs_boton_toggled        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if (!pro_forzando_librerias) {
		pro_actualizar_librerias_lincado(GTK_WIDGET(togglebutton));
		pro_modificar_dependencias_librerias(LX11);
		pro_mostrar_librerias_lincado(GTK_WIDGET(togglebutton));
	}
}


void
on_gdk2_libs_boton_toggled             (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if (!pro_forzando_librerias) {
		pro_actualizar_librerias_lincado(GTK_WIDGET(togglebutton));
		pro_modificar_dependencias_librerias(LGDK2);
		pro_mostrar_librerias_lincado(GTK_WIDGET(togglebutton));
	}
}


void
on_linc_libs_boton_toggled             (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if (!pro_forzando_librerias) {
		pro_actualizar_librerias_lincado(GTK_WIDGET(togglebutton));
		pro_modificar_dependencias_librerias(LLINC);
		pro_mostrar_librerias_lincado(GTK_WIDGET(togglebutton));
	}
}


void
on_orbit_cosnaming2_libs_boton_toggled (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if (!pro_forzando_librerias) {
		pro_actualizar_librerias_lincado(GTK_WIDGET(togglebutton));
		pro_modificar_dependencias_librerias(LORBIT_COSNAMING2);
		pro_mostrar_librerias_lincado(GTK_WIDGET(togglebutton));
	}
}


void
on_orbit2_libs_boton_toggled           (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if (!pro_forzando_librerias) {
		pro_actualizar_librerias_lincado(GTK_WIDGET(togglebutton));
		pro_modificar_dependencias_librerias(LORBIT2);
		pro_mostrar_librerias_lincado(GTK_WIDGET(togglebutton));
	}
}


void
on_gnome_vfs2_libs_boton_toggled       (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if (!pro_forzando_librerias) {
		pro_actualizar_librerias_lincado(GTK_WIDGET(togglebutton));
		pro_modificar_dependencias_librerias(LGNOME_VFS2);
		pro_mostrar_librerias_lincado(GTK_WIDGET(togglebutton));
	}
}


void
on_pangoft2_libs_boton_toggled         (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if (!pro_forzando_librerias) {
		pro_actualizar_librerias_lincado(GTK_WIDGET(togglebutton));
		pro_modificar_dependencias_librerias(LPANGOFT2);
		pro_mostrar_librerias_lincado(GTK_WIDGET(togglebutton));
	}
}


void
on_gnome2_libs_boton_toggled           (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if (!pro_forzando_librerias) {
		pro_actualizar_librerias_lincado(GTK_WIDGET(togglebutton));
		pro_modificar_dependencias_librerias(LGNOME2);
		pro_mostrar_librerias_lincado(GTK_WIDGET(togglebutton));
	}
}


void
on_gthread2_libs_boton_toggled         (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if (!pro_forzando_librerias) {
		pro_actualizar_librerias_lincado(GTK_WIDGET(togglebutton));
		pro_modificar_dependencias_librerias(LGTHREAD2);
		pro_mostrar_librerias_lincado(GTK_WIDGET(togglebutton));
	}
}


void
on_bonobo_activation2_libs_boton_toggled
                                        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if (!pro_forzando_librerias) {
		pro_actualizar_librerias_lincado(GTK_WIDGET(togglebutton));
		pro_modificar_dependencias_librerias(LBONOBO_ACTIVATION2);
		pro_mostrar_librerias_lincado(GTK_WIDGET(togglebutton));
	}
}


void
on_gdk_pixbuf2_libs_boton_toggled      (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if (!pro_forzando_librerias) {
		pro_actualizar_librerias_lincado(GTK_WIDGET(togglebutton));
		pro_modificar_dependencias_librerias(LGDK_PIXBUF2);
		pro_mostrar_librerias_lincado(GTK_WIDGET(togglebutton));
	}
}


void
on_gnomecanvas2_libs_boton_toggled     (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if (!pro_forzando_librerias) {
		pro_actualizar_librerias_lincado(GTK_WIDGET(togglebutton));
		pro_modificar_dependencias_librerias(LGNOMECANVAS2);
		pro_mostrar_librerias_lincado(GTK_WIDGET(togglebutton));
	}
}


void
on_libart2_libs_boton_toggled          (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if (!pro_forzando_librerias) {
		pro_actualizar_librerias_lincado(GTK_WIDGET(togglebutton));
		pro_modificar_dependencias_librerias(LLIBART2);
		pro_mostrar_librerias_lincado(GTK_WIDGET(togglebutton));
	}
}


void
on_libglade2_libs_boton_toggled        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if (!pro_forzando_librerias) {
		pro_actualizar_librerias_lincado(GTK_WIDGET(togglebutton));
		pro_modificar_dependencias_librerias(LLIBGLADE2);
		pro_mostrar_librerias_lincado(GTK_WIDGET(togglebutton));
	}
}


void
on_gtk_2_libs_boton_toggled            (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if (!pro_forzando_librerias) {
		pro_actualizar_librerias_lincado(GTK_WIDGET(togglebutton));
		pro_modificar_dependencias_librerias(LGTK2);
		pro_mostrar_librerias_lincado(GTK_WIDGET(togglebutton));
	}
}


void
on_gtk_x11_2_libs_boton_toggled        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if (!pro_forzando_librerias) {
		pro_actualizar_librerias_lincado(GTK_WIDGET(togglebutton));
		pro_modificar_dependencias_librerias(LGTK_X112);
		pro_mostrar_librerias_lincado(GTK_WIDGET(togglebutton));
	}
}


void
on_pangox_libs_boton_toggled           (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if (!pro_forzando_librerias) {
		pro_actualizar_librerias_lincado(GTK_WIDGET(togglebutton));
		pro_modificar_dependencias_librerias(LPANGOX);
		pro_mostrar_librerias_lincado(GTK_WIDGET(togglebutton));
	}
}


void
on_source_buffer_mark_set			(GtkTextBuffer *buffer, GtkTextIter *cursoriter, GtkTextMark *mark, gpointer data)
{
	GtkLabel *etiqueta;
	gchar *texto;
	guint fila,columna;

	//DEBUG_MSG(->on_source_buffer_mark_set);
	if (edit_actual==NULL) return;
	if (buffer!=GTK_TEXT_BUFFER(edit_actual->datos)) return;
	if (mark != gtk_text_buffer_get_insert (gtk_text_iter_get_buffer (cursoriter))) return;
	
	etiqueta=GTK_LABEL(glade_xml_get_widget(david_ventana,"fila_etiqueta"));
	fila=gtk_text_iter_get_line(cursoriter);
	columna=gtk_text_iter_get_line_offset(cursoriter);
	texto=g_strdup_printf(_("Row: %u  Colum: %u"),fila+1,columna+1);
	gtk_label_set(etiqueta,texto);
	g_free(texto);	
	//DEBUG_MSG(<-on_source_buffer_mark_set);
}


void
on_funciones_combo_list_selection_changed	(GtkList *list)
{
	gchar *funcion;
	struct s_lista_cefv *nodo;
	gboolean encontrado;
	GtkWidget *entry;
	GtkTreeView *arbol;
	GtkTreeSelection *selection;
	GtkTreePath *path;

	DEBUG_MSG(->on_funciones_combo_list_selection_changed);
	if (cefv_congelar_lista_combo) return;
	entry = glade_xml_get_widget(david_ventana, "funciones_entry");	
	funcion = gtk_editable_get_chars (GTK_EDITABLE(entry), 0, -1);	
	if ((funcion==NULL) || (funcion[0]==0)) {
		g_free(funcion);
		return;
	}
	nodo=lista_cefv;
	encontrado=FALSE;
	while ((nodo!=NULL) && (!encontrado)) {
		if (!strcmp(nodo->rama,funcion)) {
			encontrado=TRUE;
		} else {
			nodo=nodo->siguiente;
		}
	}
	if (nodo==NULL) {
		g_free(funcion);
		return;
	}
	arbol=GTK_TREE_VIEW(glade_xml_get_widget(david_ventana,"cefv_arbol"));
	path=gtk_tree_model_get_path(GTK_TREE_MODEL(cefv_store),&cefv_funciones);
	gtk_tree_view_expand_row(arbol,path,TRUE);
	gtk_tree_path_free(path);
	selection=gtk_tree_view_get_selection(arbol);
	gtk_tree_selection_unselect_all(selection);
	gtk_tree_selection_select_iter(selection,&(nodo->nodo));

	g_free(funcion);
	DEBUG_MSG(<-on_funciones_combo_list_selection_changed);
}


void
on_historico_funciones_combo_list_selection_changed	(GtkList *list)
{
	gchar *funcion;	
	GtkWidget *entry;

	if (edit_congelar_historico) return;	
	DEBUG_MSG(->on_historico_funciones_combo_list_selection_changed);
	entry = glade_xml_get_widget(david_ventana, "historico_funciones_entry");	
	funcion = gtk_editable_get_chars (GTK_EDITABLE(entry), 0, -1);	
	if ((funcion==NULL) || (funcion[0]==0)) {
		g_free(funcion);
		return;
	}
	edit_ver_funcion(funcion, FALSE);
	g_free(funcion);
	DEBUG_MSG(<-on_historico_funciones_combo_list_selection_changed);
}

void
on_mensajes_texto_buffer_mark_set			(GtkTextBuffer *buffer, GtkTextIter *cursoriter, GtkTextMark *mark, gpointer data)
{
	GtkTextIter posicion,fin, cursor_position_iter, selection_start, selection_end;
	GtkTextMark *cursor_position_mark;
	gchar *mensajes;
	guint cont,cont1,cont2,cont3;
	gchar *archivo, *archivo_tmp;
	gboolean seleccion;
	gchar *fila_c;
	guint fila;
	struct s_lista_archivos *archivos;
	GtkTreeView *arbol;
	GtkTreeSelection *selection;
	//extern texto_busqueda_actual;
	
	if (mensajes_button_pressed) {
		//Disable the callback to avoid recursion
		g_signal_handlers_block_by_func(G_OBJECT(buffer),on_mensajes_texto_buffer_mark_set,NULL);

		gtk_text_buffer_get_iter_at_mark(buffer,&posicion,gtk_text_buffer_get_insert(buffer));
		fila=gtk_text_iter_get_line(&posicion);
		gtk_text_iter_set_line(&posicion,fila);
		memcpy(&fin,&posicion,sizeof(GtkTextIter));
		if (gtk_text_iter_forward_line(&fin)) {
			gtk_text_iter_backward_char(&fin);
		}
		mensajes=gtk_text_buffer_get_text(buffer,&posicion,&fin,FALSE);
		//nos situamos la principio de la linea
		cont1=0;
		//si es una linea de error, deberia tener el formato fichero:linea:error, asi que lo buscamos
		//y deshechamos la lineas si no lo tiene
		for (cont2=cont1;(mensajes[cont2]!=':') && (mensajes[cont2]!='\n') && (mensajes[cont2]!=0);cont2++);
		//Si hemos llegado a un '\n', eso quiere decir que no era un mensaje de error, asi que nos salimos
		//idem si hemos llegado al final del texto
		if ((mensajes[cont2]!=0) && (mensajes[cont2]!='\n')) {
			cont3=cont2+1;
			for (;(mensajes[cont3]!=':') && (mensajes[cont3]!='\n') && (mensajes[cont3]!=0);cont3++);
			//Solo nos interesa el caso en que SI haya encontrado los ":"
			if (mensajes[cont3]!=':'){
				g_free(mensajes);
				//enable the callback again
				g_signal_handlers_unblock_by_func(G_OBJECT(buffer),on_mensajes_texto_buffer_mark_set,NULL);
				return;
			}
		} else {
			g_free(mensajes);
			//enable the callback again
			g_signal_handlers_unblock_by_func(G_OBJECT(buffer),on_mensajes_texto_buffer_mark_set,NULL);
			return;
			//cont3=cont2;
		}
		archivo=g_strndup(mensajes,cont2-cont1);
		//Lo siguiente es solo para mensajes de Make
		//Le quitamos el tabulador que tiene delante al nombre de archivo
		if (texto_busqueda_actual == NULL) {
			if (archivo[0]=='\t') {
				archivo_tmp = g_strdup (archivo);
				g_free(archivo);
				archivo = g_strdup (archivo_tmp+1);
								g_free (archivo_tmp);
			}
		}
		//Si el nombre de archivo tiene una ruta completa, nos quedamos solo con el nombre
		if (archivo[0] == '/') {
			for (cont=0;(archivo[cont]!='\0');cont++);
			for (;archivo[cont]!='/';cont--);
			cont++;
			archivo_tmp = g_strdup (archivo);
			g_free(archivo);
			archivo = g_strdup (archivo_tmp+cont);
			g_free(archivo_tmp);
		}
		//si el nombre no tenia path completo cont = 0, si tenia path completo cont sera el numero de
		//posiciones a avanzar hasta llegar al nombre de archivo.
		if (pro_existe_archivo(archivo)) {
			fila_c=g_strndup(mensajes+cont2+1,cont3-cont2-1);
						fila=atoi(fila_c);
			if (fila) {
				archivos=raiz_lista_archivos;
				while (strcmp(archivos->nombre,archivo)) {
					archivos=archivos->siguiente;
				}
				arbol=GTK_TREE_VIEW(glade_xml_get_widget(david_ventana,"archivos_arbol"));
				selection=gtk_tree_view_get_selection(arbol);
				gtk_tree_selection_select_iter(selection,&(archivos->nodo_arbol));
				edit_ir_a_fila(fila,&posicion);
				//En caso de estar en una busqueda, resaltamos la cadena buscada si no ponemos un pixmap que seale la fila
				if (texto_busqueda_actual != NULL) {
					cursor_position_mark = gtk_text_buffer_get_insert (GTK_TEXT_BUFFER(edit_actual->datos));
					gtk_text_buffer_get_iter_at_mark(GTK_TEXT_BUFFER(edit_actual->datos), &cursor_position_iter, cursor_position_mark);
					if (estado_botones.sensitive) {
						seleccion=buscar_cadena_forward (GTK_TEXT_BUFFER(edit_actual->datos), &cursor_position_iter, NULL, texto_busqueda_actual, &selection_start, &selection_end, SENSIBLE_MAYUSCULAS);
					} else {
						seleccion=buscar_cadena_forward (GTK_TEXT_BUFFER(edit_actual->datos), &cursor_position_iter, NULL, texto_busqueda_actual, &selection_start, &selection_end, 0);
					}
					if (seleccion == TRUE) {
						//the selected text is between selection_start and selection_end iters
						gtk_text_buffer_place_cursor(GTK_TEXT_BUFFER(edit_actual->datos), &selection_start);
						gtk_text_buffer_move_mark_by_name(GTK_TEXT_BUFFER(edit_actual->datos), "selection_bound", &selection_end);
					} //fin de (seleccion != NULL)
				} else {
					if (edit_marcador!=0) {
						gtk_source_buffer_line_remove_marker(edit_actual->datos,edit_marcador,"marcador");
					}
					gtk_source_buffer_line_set_marker(edit_actual->datos,fila,"marcador");
					edit_marcador=fila;
				} //fin de (texto_busqueda_actual != NULL)
			}
		}
		//enable the callback again
		g_signal_handlers_unblock_by_func(G_OBJECT(buffer),on_mensajes_texto_buffer_mark_set,NULL);
		mensajes_button_pressed = FALSE;
		g_free(archivo);
		g_free(mensajes);
	}
}

void
on_properties_button_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *ventana;

	if (proyecto.xml!=NULL) {	
		ventana=glade_xml_get_widget(proyecto_ventana,"proyecto_ventana");
		estado_proyecto_ventana=PROPIEDADES;
		pro_mostrar(ventana);
		gtk_widget_show(ventana);
	}	
}

gboolean
on_david_ventana_window_state_event	(GtkWidget *widget,
                                            GdkEvent *event,
                                            gpointer user_data)
{
	if (event->window_state.new_window_state==GDK_WINDOW_STATE_MAXIMIZED) {
		david_ventana_maximizada=TRUE;
	}
	return FALSE;
}

void
on_make_dist1_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	gchar *comando, *temp;
	
	if (proyecto.xml != NULL) {
		comando = g_strdup("make dist 1>/dev/null 2>/dev/stdout");
		//nos situamos en el directorio raiz del proyecto
		temp = pro_nombre_completo_archivo(proyecto.archivo, TRUE, UTF8);
		comp_update_pot_file();
		gen_comando (comando,"---------------------------- Creating distribution package ----------------------------\n");
		g_print(_("\nDone.\n"));
		g_free(comando);
		g_free(temp);
	}
}

void
on_gui_treeview_select_row      (GtkTreeSelection        *selection,
                                        gpointer         user_data)
{
	GtkTreeIter iter;
	GtkTreeModel *model;
	gchar *nombre;
	gchar *glade_file_name, *temp_name;
	GladeXML *glade_window;
	GtkWidget *glade_window_widget,*window_widget, *widget, *window, *menu_bar, *menu_item;
	struct s_glade_project_window *list_node;
	struct s_glade_widget *widget_list_node;	
	struct s_glade_widget_property *property_list_node;
	GtkTooltips *widget_name_tooltips;
	
	DEBUG_MSG(->on_gui_treeview_select_row);
	if (gtk_tree_selection_get_selected(selection,&model,&iter)) {
		gtk_tree_model_get(model,&iter,COL_NOMBRE,&nombre,-1);
		if (strcmp(nombre, _("GUI Window List")) == 0)
			return;
		list_node = glade_window_list;
		while ((list_node != NULL) && (strcmp(list_node->window_name, nombre) != 0)) {
			list_node = list_node->next;	
		}
		if (list_node == NULL) {
			g_free(nombre);
			return;
		}
		if (list_node->window_widget == NULL) {
			temp_name = pro_glade_file(UTF8);
			glade_file_name = pro_nombre_completo_archivo(temp_name, FALSE, LOCALE);
			glade_window = glade_xml_new (glade_file_name, nombre, NULL);
			//we are going to put a tooltip on every widget
			widget_name_tooltips = gtk_tooltips_new();
			widget_list_node = list_node->widgets;
			//connect a button_press_event callback to all widgets,put the "sensitive" property of all widgets to TRUE
			//and put a tooltip with the widget name on every widget
			while (widget_list_node != NULL) {
				property_list_node = widget_list_node->properties;
				while (property_list_node != NULL) {
					if (!strcmp(property_list_node->property_name, "sensitive")) {
						if (!strcmp(property_list_node->value, "False")) {
							widget = glade_xml_get_widget(glade_window, widget_list_node->widget_name);
							gtk_widget_set_sensitive(widget, TRUE);
						}
					}
					property_list_node = property_list_node->next;
				}
				widget = glade_xml_get_widget(glade_window, widget_list_node->widget_name);
				//put a tooltip with the widget name to all the widgets
				gtk_tooltips_set_tip(GTK_TOOLTIPS(widget_name_tooltips), widget,widget_list_node->widget_name, NULL);
				//and connect the callback
				if ((!strcmp(widget_list_node->class, "GtkMenuItem")) || (!strcmp(widget_list_node->class, "GtkImageMenuItem")) ||
					(!strcmp(widget_list_node->class, "GtkCheckMenuItem")) || (!strcmp(widget_list_node->class, "GtkRadioMenuItem")) ||
					(!strcmp(widget_list_node->class, "GtkSeparatorMenuItem")) || (!strcmp(widget_list_node->class, "GtkTearoffMenuItem"))) {
						g_signal_connect(G_OBJECT(widget), "button_press_event",G_CALLBACK(on_gui_window_button_press_event), widget);
				} else {
					g_signal_connect(G_OBJECT(widget), "button_press_event",G_CALLBACK(on_gui_window_button_press_event), NULL);
				}
				widget_list_node = widget_list_node->next;
			}
			glade_window_widget = glade_xml_get_widget(glade_window, nombre);
			//Menu widgets must be put inside a menu bar
			if (!strcmp(list_node->window_class, "GtkMenu")) {
				//create a new window, a menubar and put the menu inside the menubar
				window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
				gtk_window_set_title(GTK_WINDOW(window), nombre);
				menu_bar = gtk_menu_bar_new();
				gtk_container_add(GTK_CONTAINER(window), menu_bar);
				gtk_widget_show(menu_bar);
				menu_item = gtk_menu_item_new_with_label(nombre);
				gtk_widget_show(menu_item);
				gtk_menu_item_set_submenu(GTK_MENU_ITEM(menu_item),glade_window_widget);
				gtk_menu_shell_append(GTK_MENU_SHELL(menu_bar), menu_item);
				
				gtk_window_unmaximize(GTK_WINDOW(window));
				gtk_window_resize(GTK_WINDOW(window), 150, 20);
				gtk_window_set_resizable(GTK_WINDOW(window), FALSE);
				window_widget = window;
			} else {
				window_widget = glade_window_widget;
			} 
			gtk_window_set_modal (GTK_WINDOW(window_widget), FALSE);
			g_signal_connect (G_OBJECT(window_widget), "delete_event", G_CALLBACK(on_gui_window_delete_event), NULL);
			//store the widget
			list_node->window_widget = window_widget;
			if (current_glade_gui_window != NULL) {
					gtk_widget_hide(current_glade_gui_window->window_widget);
					current_glade_gui_window = NULL;
			}
			current_glade_gui_window = list_node;
			gtk_widget_show(window_widget);
			g_free(temp_name);
			g_free(glade_file_name);
		} else {
			if (current_glade_gui_window != NULL) {
				gtk_widget_hide(current_glade_gui_window->window_widget);
				current_glade_gui_window = NULL;
			}
			current_glade_gui_window = list_node;
			gtk_widget_show(list_node->window_widget);	
		}
		g_free(nombre);
	}
	DEBUG_MSG(<-on_gui_treeview_select_row);
	
	return;
}

gboolean
on_gui_treeview_button_press_event   (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
	DEBUG_MSG(->on_gui_treeview_button_press_event);
	DEBUG_MSG(<-on_gui_treeview_button_press_event);

	return FALSE;
}

gboolean
on_gui_window_button_press_event    (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
	GtkWidget *menu;
	GtkWidget *menu_item;
	struct s_glade_widget *glade_widget;
	struct s_glade_signal *glade_signal;
	const gchar *widget_name;
	gchar *name;
	gint signal_count = 0;
	struct s_lista_cefv *nodo;
	gboolean encontrado;
	GtkTreeView *arbol;
	GtkTreeSelection *selection;
	GtkTreePath *path;
	GtkWidget *gui_treeview;
	GtkTreeSelection *gui_selection;

	if (((event->button) == 1) && ((event->type) == GDK_2BUTTON_PRESS)) {
		//left button double_click. If the widget has only one callback, jump to it. If it has more, popup a menu
		widget_name = glade_get_widget_name(widget);
		glade_widget = current_glade_gui_window->widgets;
		while (glade_widget != NULL) {
			if (!strcmp(glade_widget->widget_name, widget_name))
				break;
			glade_widget = glade_widget->next;
		}
		glade_signal = glade_widget->signals;
		if (glade_signal != NULL) {
			//count signal number
			while (glade_signal != NULL) {
				signal_count++;
				glade_signal = glade_signal->next;
			}
			if (signal_count == 1) {
				//just 1 signal, jump to callback
				glade_signal = glade_widget->signals;
				nodo=lista_cefv;
				encontrado=FALSE;
				while ((nodo!=NULL) && (!encontrado)) {
					if (!strcmp(nodo->rama,glade_signal->handler_function)) {
						encontrado=TRUE;
					} else {
						nodo=nodo->siguiente;
					}
				}
				if (nodo==NULL) {
					return FALSE;
				}
				arbol=GTK_TREE_VIEW(glade_xml_get_widget(david_ventana,"cefv_arbol"));
				path=gtk_tree_model_get_path(GTK_TREE_MODEL(cefv_store),&cefv_funciones);
				gtk_tree_view_expand_row(arbol,path,TRUE);
				gtk_tree_path_free(path);
				selection=gtk_tree_view_get_selection(arbol);
				gtk_tree_selection_unselect_all(selection);
				if ((GtkWidget *) user_data != NULL) {
					//menu item widgets pass themselves as user_data, to use it to close the menu
					GtkWidget *menu_widget;
					
					menu_widget = gtk_widget_get_ancestor((GtkWidget *) user_data, GTK_TYPE_MENU);
					gtk_menu_popdown(GTK_MENU(menu_widget));
				}
				gtk_widget_hide(current_glade_gui_window->window_widget);
				current_glade_gui_window = NULL;
				//deselect the selected item in the GUI tab
				gui_treeview = glade_xml_get_widget (david_ventana, "gui_treeview");
				gui_selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(gui_treeview));
				gtk_tree_selection_unselect_all (gui_selection);
				//and jump to the callback body
				gtk_tree_selection_select_iter(selection,&(nodo->nodo));
			} else {
				//more than 1 signal, popup a menu
				glade_signal = glade_widget->signals;
				menu = gtk_menu_new();
				while (glade_signal != NULL) {
					name = g_strconcat("\"", glade_signal->signal_name, "\"", "\t", glade_signal->handler_function, NULL);
					menu_item = gtk_menu_item_new_with_label(name);
					gtk_menu_shell_append(GTK_MENU_SHELL(menu), menu_item);
					g_signal_connect(G_OBJECT(menu_item),"button_press_event", G_CALLBACK(on_gui_signal_name_button_press_event), user_data); 
					g_free(name);
					glade_signal = glade_signal->next;
					gtk_widget_show(menu_item);
				}
			gtk_menu_popup(GTK_MENU(menu),NULL,NULL,NULL,NULL,event->button,event->time);
			return TRUE;
			}
		} else {
			//popup a GtkMessageDialog saying "No signals"
			g_print("no signals\n");
			return TRUE;
		}
	} // end of "if (((event->button) == 1) && ((event->type) == GDK_2BUTTON_PRESS))"

	if ((event->button)==3) {
		//right button click. Popup a menu
		menu = gtk_menu_new();
		
		widget_name = glade_get_widget_name(widget);
		glade_widget = current_glade_gui_window->widgets;
		while (glade_widget != NULL) {
			if (!strcmp(glade_widget->widget_name, widget_name))
				break;
			glade_widget = glade_widget->next;
		}
		//add widget name
		menu_item = gtk_menu_item_new_with_label(glade_widget->widget_name);
		gtk_menu_shell_append(GTK_MENU_SHELL(menu), menu_item);
		gtk_widget_set_sensitive(menu_item, FALSE);
		gtk_widget_show(menu_item);
		menu_item = gtk_separator_menu_item_new();
		gtk_menu_shell_append(GTK_MENU_SHELL(menu), menu_item);
		gtk_widget_show(menu_item);
		//add signal name items
		glade_signal = glade_widget->signals;
		if (glade_signal != NULL) {
			while (glade_signal != NULL) {
				name = g_strconcat("\"", glade_signal->signal_name, "\"", "\t", glade_signal->handler_function, NULL);
				menu_item = gtk_menu_item_new_with_label(name);
				gtk_menu_shell_append(GTK_MENU_SHELL(menu), menu_item);
				g_signal_connect(G_OBJECT(menu_item),"button_press_event", G_CALLBACK(on_gui_signal_name_button_press_event), user_data); 
				g_free(name);
				glade_signal = glade_signal->next;
				gtk_widget_show(menu_item);
			}
		} else {
				menu_item = gtk_menu_item_new_with_label("No signals");
				gtk_menu_shell_append(GTK_MENU_SHELL(menu), menu_item);
				gtk_widget_show(menu_item);
		}
		//Add close window item
		menu_item = gtk_separator_menu_item_new();
		gtk_menu_shell_append(GTK_MENU_SHELL(menu), menu_item);
		gtk_widget_show(menu_item);
		menu_item = gtk_menu_item_new_with_label("Close Window");
		gtk_menu_shell_append(GTK_MENU_SHELL(menu), menu_item);
		g_signal_connect(G_OBJECT(menu_item),"button_press_event", G_CALLBACK(on_gui_window_close_button_press_event), user_data);
		gtk_widget_show(menu_item);
		gtk_menu_popup(GTK_MENU(menu),NULL,NULL,NULL,NULL,event->button,event->time);
		return TRUE;
	}
	
	return FALSE;
}

gboolean 
on_gui_window_delete_event( GtkWidget *widget,
								GdkEvent  *event,
								gpointer		user_data)
{
	GtkWidget *gui_treeview;
	GtkTreeSelection *gui_selection;

	DEBUG_MSG(->on_gui_window_delete_event);
	current_glade_gui_window = NULL;
	gtk_widget_hide(widget);

	//and deselect the selected item in the GUI tab
	gui_treeview = glade_xml_get_widget (david_ventana, "gui_treeview");
	gui_selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(gui_treeview));
	gtk_tree_selection_unselect_all (gui_selection);
	DEBUG_MSG(<-on_gui_window_delete_event);
	
	return TRUE;
}

gboolean
on_gui_signal_name_button_press_event    (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
	gchar **parametros;
	struct s_lista_cefv *nodo;
	gboolean encontrado;
	GtkTreeView *arbol;
	GtkTreeSelection *selection;
	GtkTreePath *path;
	GtkWidget *gui_treeview;
	GtkTreeSelection *gui_selection;
	
	//get the label
	if (GTK_BIN(widget)->child) {
		GtkWidget *child = GTK_BIN(widget)->child;
		if (GTK_IS_LABEL(child)) {
			const gchar *text;
			gchar *text_line;
			
			text=gtk_label_get_text(GTK_LABEL(child));
			text_line = g_strdup (text);
			//split the label
			parametros = g_strsplit(text_line,"\t", 0);
			g_free(text_line);
			//select the function in the cefv tree
			nodo=lista_cefv;
			encontrado=FALSE;
			while ((nodo!=NULL) && (!encontrado)) {
				if (!strcmp(nodo->rama,parametros[1])) {
					encontrado=TRUE;
				} else {
					nodo=nodo->siguiente;
				}
			}
			if (nodo==NULL) {
				g_strfreev(parametros);
				return FALSE;
			}
			arbol=GTK_TREE_VIEW(glade_xml_get_widget(david_ventana,"cefv_arbol"));
			path=gtk_tree_model_get_path(GTK_TREE_MODEL(cefv_store),&cefv_funciones);
			gtk_tree_view_expand_row(arbol,path,TRUE);
			gtk_tree_path_free(path);
			selection=gtk_tree_view_get_selection(arbol);
			gtk_tree_selection_unselect_all(selection);
			if ((GtkWidget *) user_data != NULL) {
				//menu item widgets pass themselves as user_data, to use it to close the menu
				GtkWidget *menu_widget;
				
				menu_widget = gtk_widget_get_ancestor((GtkWidget *) user_data, GTK_TYPE_MENU);
				gtk_menu_popdown(GTK_MENU(menu_widget));
			}
			gtk_widget_hide(current_glade_gui_window->window_widget);
			current_glade_gui_window = NULL;
			//deselect the selected item in the GUI tab
			gui_treeview = glade_xml_get_widget (david_ventana, "gui_treeview");
			gui_selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(gui_treeview));
			gtk_tree_selection_unselect_all (gui_selection);
			//and jump to the callback
			gtk_tree_selection_select_iter(selection,&(nodo->nodo));
		
			g_strfreev(parametros);		
		}
	}
	return FALSE;
}

gboolean
on_gui_window_close_button_press_event    (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
	GtkWidget *gui_treeview;
	GtkTreeSelection *gui_selection;
	
	if ((GtkWidget *) user_data != NULL) {
		//menu item widgets pass themselves as user_data, to use it to close the menu
		GtkWidget *menu_widget;
		
		menu_widget = gtk_widget_get_ancestor((GtkWidget *) user_data, GTK_TYPE_MENU);
		gtk_menu_popdown(GTK_MENU(menu_widget));
	}
	gtk_widget_hide(current_glade_gui_window->window_widget);
	current_glade_gui_window = NULL;
	//and deselect the selected item in the GUI tab
	gui_treeview = glade_xml_get_widget (david_ventana, "gui_treeview");
	gui_selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(gui_treeview));
	gtk_tree_selection_unselect_all (gui_selection);
	
	return FALSE;
}

void
on_source_buffer_changed (GtkTextBuffer *textbuffer,
                                            gpointer user_data)
{
	GtkLabel *etiqueta;
	gchar *texto;
	guint fila,columna;
	GtkTextIter cursoriter;
	GtkTextMark *cursormark;

	if (edit_actual==NULL) return;
	if (textbuffer!=GTK_TEXT_BUFFER(edit_actual->datos)) return;
	
	etiqueta=GTK_LABEL(glade_xml_get_widget(david_ventana,"fila_etiqueta"));
	cursormark=gtk_text_buffer_get_insert(textbuffer);
	gtk_text_buffer_get_iter_at_mark(textbuffer,&cursoriter,cursormark);
	fila=gtk_text_iter_get_line(&cursoriter);
	columna=gtk_text_iter_get_line_offset(&cursoriter);
	texto=g_strdup_printf(_("Row: %u  Colum: %u"),fila+1,columna+1);
		gtk_label_set(etiqueta,texto);
	g_free(texto);	
}

gboolean
on_busqueda_barra_entrada_key_press_event        (GtkWidget       *widget,
                                        GdkEventKey     *event,
                                        gpointer         user_data)
{
	if ((event->keyval==GDK_Return) || (event->keyval==GDK_F3)) {
		if (edit_actual!=NULL) {
			event->keyval=GDK_F3;
			on_editor_texto_key_press_event(GTK_WIDGET(edit_actual->datos),event,NULL);
			return TRUE;
		}
	}
	return FALSE;
}

void
on_file2_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	GtkWidget *ventana;
	
	chdir(preferencias.directorio);
	archivos_ventana = glade_xml_new(GLADE_PROJECT,"archivos_ventana",NULL);
	glade_xml_signal_autoconnect(archivos_ventana);
	ventana=glade_xml_get_widget(archivos_ventana,"archivos_ventana");
	gtk_file_selection_hide_fileop_buttons(GTK_FILE_SELECTION(ventana));
	gtk_file_selection_set_select_multiple(GTK_FILE_SELECTION(ventana),TRUE);
	estado_archivos_ventana=EXTERNOS_ABRIR;
	gtk_widget_show(ventana);
}

void
on_create_project_from_glade_project1_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	gen_ventana_mensaje(_("This druid is not 100%% implemented because of a bug in a library, so it has been deactivated."),GTK_MESSAGE_INFO);
		
	// uncoment the next to lines when the libglade bug is fixed
//	druida_glade_ventana = glade_xml_new(GLADE_PROJECT,"create_project_from_glade_window",NULL);
//	glade_xml_signal_autoconnect(druida_glade_ventana);
}


void
on_cvs_checkbutton_toggled          (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	GtkWidget *widget;
	gboolean estado;
	
	estado=gtk_toggle_button_get_active(togglebutton);
	
	if ((estado) && (!ejecutables.cvs)) {
		gtk_toggle_button_set_active(togglebutton,FALSE);
		return;
	}
	widget=glade_xml_get_widget(proyecto_ventana,"cvsroot_entry");
	gtk_widget_set_sensitive(widget,estado);
	widget=glade_xml_get_widget(proyecto_ventana,"modul_entry");
	gtk_widget_set_sensitive(widget,estado);
	widget=glade_xml_get_widget(proyecto_ventana,"compresion_spinbutton");
	gtk_widget_set_sensitive(widget,estado);
	widget=glade_xml_get_widget(proyecto_ventana,"autoupdate_checkbutton");
	gtk_widget_set_sensitive(widget,estado);
	widget=glade_xml_get_widget(proyecto_ventana,"autoaddremove_checkbutton");
	gtk_widget_set_sensitive(widget,estado);
}

void
on_update1_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	if ((proyecto.xml!=NULL) && (ejecutables.cvs)) {
		edit_guardar_todo();
		cvs_update();
	}
}

void
on_commit1_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	gchar *log;
	
	if ((proyecto.xml!=NULL) && (ejecutables.cvs)) {
		edit_guardar_todo();
		if (recordar_log==NULL) {
			log_ventana = glade_xml_new(GLADE_PROJECT,"log_window",NULL);
			glade_xml_signal_autoconnect(log_ventana);
		} else {
			log=recordar_log;
			recordar_log=NULL;
			cvs_commit(log);
			g_free(log);
		}
	}
}

void
on_add1_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	if (edit_actual!=NULL) {
		cvs_add(edit_actual->nombre,SOURCE);
	}
}

void
on_remove1_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	if (edit_actual!=NULL) {
		cvs_remove(edit_actual->nombre,SOURCE);
	}
}

void
on_ok_log_button_clicked (GtkButton       *button,
                                        gpointer         user_data)
{
	gchar *log;
	GtkWidget *textview;
	GtkTextBuffer *buffer;
	GtkTextIter start,end;
	
	textview=glade_xml_get_widget(log_ventana,"log_textview");
	buffer=gtk_text_view_get_buffer(GTK_TEXT_VIEW(textview));
	gtk_text_buffer_get_bounds(buffer,&start,&end);
	log=gtk_text_buffer_get_text(buffer,&start,&end,FALSE);
	
	gtk_widget_destroy(gtk_widget_get_toplevel(GTK_WIDGET(button)));
	
	if ((log==NULL) || (log[0]==0)) {
		g_free(log);
		log=g_strdup(_("*** empty log message ***"));
	}
	cvs_commit(log);
	
	g_free(log);
}

void
on_cancel_log_button_clicked (GtkButton       *button,
                                        gpointer         user_data)
{
	gtk_widget_destroy(gtk_widget_get_toplevel(GTK_WIDGET(button)));
}

void
on_glade_project_druid_cancel                       (GnomeDruid	*gnomedruid,
                                        gpointer	 user_data)
{
	
}

gboolean
on_project_selection_page_next                (GnomeDruidPage  *gnomedruidpage,
                                        GtkWidget	*widget,
                                        gpointer	 user_data)
{
	gla_leer_proyecto_druid();
	gla_mostrar_datos_druid();
	return FALSE;
}

gboolean
on_project_data_page_next                (GnomeDruidPage  *gnomedruidpage,
                                        GtkWidget	*widget,
                                        gpointer	 user_data)
{
	return FALSE;
}

gboolean
on_glade_druid_end_page_finish                (GnomeDruidPage  *gnomedruidpage,
                                        GtkWidget	*widget,
                                        gpointer	 user_data)
{
	return FALSE;
}

void
on_add_source_button_clicked (GtkButton       *button,
                                        gpointer         user_data)
{
	gen_anadir(ADD_SOURCE);
}

void
on_add_pixmaps_button_clicked (GtkButton       *button,
                                        gpointer         user_data)
{
	gen_anadir(ADD_PIXMAP);
}

void
on_add_data_button_clicked (GtkButton       *button,
                                        gpointer         user_data)
{
	gen_anadir(ADD_DATA);
}

void
on_add_docs_button_clicked (GtkButton       *button,
                                        gpointer         user_data)
{
	gen_anadir(ADD_DOC);
}

void
on_add_files_button_clicked (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *ventana;

	if (proyecto.xml!=NULL) {	
		archivos_ventana = glade_xml_new(GLADE_PROJECT,"archivos_ventana",NULL);
		glade_xml_signal_autoconnect(archivos_ventana);
		ventana=glade_xml_get_widget(archivos_ventana,"archivos_ventana");
		gtk_file_selection_hide_fileop_buttons(GTK_FILE_SELECTION(ventana));
		gtk_file_selection_set_select_multiple(GTK_FILE_SELECTION(ventana),TRUE);
		estado_archivos_ventana=PROYECTO_ANADIR;
		gtk_widget_show(ventana);
	}
}

void
on_delete_button_clicked (GtkButton       *button,
                                        gpointer         user_data)
{
	gchar *dir_destino;
	gchar *archivo,*archivo_locale,*archivo_destino;
	gchar *prodir,*srcdir,*pixdir,*datadir,*docdir;
	GtkTreeIter iter,iter_copia;
	GtkTreeView *tree_view;
	GtkTreeModel *tree_model;
	GtkTreeSelection *tree_selection;
	GtkListStore *list_store;
	gboolean fin_lista;
	gsize read, written;
	GError *error;
	gchar *comando;
	gint tipo;
	GtkWidget *boton_cvs;
	gboolean remove_cvs;
	gint destino_cvs;
	gboolean quedan_listas;
	gboolean proyecto_modificado;
	gboolean eliminado;
	
	prodir=pro_prodir(LOCALE);
	srcdir=pro_srcdir(LOCALE);
	pixdir=pro_pixdir(LOCALE);
	datadir=pro_datadir(LOCALE);
	docdir=pro_docdir(LOCALE);
	
	proyecto_modificado=FALSE;

	boton_cvs=glade_xml_get_widget(add_files_ventana,"addremove_cvs_checkbutton");
	remove_cvs=gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(boton_cvs));

	quedan_listas=TRUE;
	
	destino_cvs=SOURCE;
	dir_destino=NULL;
	tree_view=NULL;
	while (quedan_listas) {
		switch (destino_cvs) {
			case SOURCE:
				dir_destino=g_strdup_printf("%s/%s",prodir,srcdir);
				tree_view=GTK_TREE_VIEW(glade_xml_get_widget(add_files_ventana,"sources_treeview"));
				break;
			case PIXMAP:
				dir_destino=g_strdup_printf("%s/%s",prodir,pixdir);
				tree_view=GTK_TREE_VIEW(glade_xml_get_widget(add_files_ventana,"pixmaps_treeview"));
				break;
			case DATA:
				dir_destino=g_strdup_printf("%s/%s",prodir,datadir);
				tree_view=GTK_TREE_VIEW(glade_xml_get_widget(add_files_ventana,"data_treeview"));
				break;
			case DOC:
				dir_destino=g_strdup_printf("%s/%s",prodir,docdir);
				tree_view=GTK_TREE_VIEW(glade_xml_get_widget(add_files_ventana,"docs_treeview"));
				break;
		}
		tree_model=gtk_tree_view_get_model(tree_view);
		list_store=GTK_LIST_STORE(tree_model);
		tree_selection=gtk_tree_view_get_selection(tree_view);

		if (gtk_tree_model_get_iter_first(tree_model,&iter)) {
			fin_lista=FALSE;
			while (!fin_lista) {
				eliminado=FALSE;
				if (gtk_tree_selection_iter_is_selected(tree_selection,&iter)) {
					gtk_tree_model_get(tree_model,&iter,0,&archivo,-1);
					archivo_locale=g_locale_from_utf8(archivo,-1,&read,&written,&error);
					archivo_destino=g_strdup_printf("%s/%s",dir_destino,archivo_locale);
					
					if (remove_cvs) {
						cvs_remove(archivo,destino_cvs);
					}  else {
						comando=g_strdup_printf("rm %s 2> /dev/stdout\n",archivo_destino);
						gen_comando(comando,NULL);
						g_free(comando);
						eliminado=TRUE;
						iter_copia=iter;
						fin_lista=!gtk_tree_model_iter_next(tree_model,&iter);
						gtk_list_store_remove(list_store,&iter_copia);
					}
					
					// si se trata de un archivo de codigo hay que quitarlo del proyecto
					if (destino_cvs==SOURCE) {
						tipo=gen_tipo_archivo(archivo_locale);
						if ((tipo==1) || (tipo==2)) {
							arch_eliminar(archivo);
							pro_eliminar(archivo);
							cefv_eliminar_archivo(archivo);
							edit_eliminar(archivo);
							proyecto_modificado=TRUE;
						}
					}
					g_free(archivo);
					g_free(archivo_locale);
					g_free(archivo_destino);
				}
				
				if (!eliminado) {
					fin_lista=!gtk_tree_model_iter_next(tree_model,&iter);
				}
			}
			if (proyecto_modificado) {
				pro_guardar();
				proyecto_modificado=FALSE;
			}
		}
		g_free(dir_destino);
		if (destino_cvs==SOURCE) {
			destino_cvs=PIXMAP;
		} else {
			if (destino_cvs==PIXMAP) {
				destino_cvs=DATA;
			} else {
				if (destino_cvs==DATA) {
					destino_cvs=DOC;
				} else {
					if (destino_cvs==DOC) {
						quedan_listas=FALSE;
					}
				}
			}
		}
	}

	g_free(prodir);
	g_free(srcdir);
	g_free(pixdir);
	g_free(datadir);
	g_free(docdir);

}

void
on_close_button_clicked (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *ventana;
	
	ventana=gtk_widget_get_toplevel(GTK_WIDGET(button));
	gtk_widget_destroy(ventana);
}

void
on_logout1_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	if ((proyecto.xml!=NULL) && (ejecutables.cvs)) {
		cvs_logout();
	}
}

void
on_login1_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	if ((proyecto.xml!=NULL) && (ejecutables.cvs)) {
		cvs_password_ventana=glade_xml_new(GLADE_PROJECT,"cvs_password_ventana",NULL);
		glade_xml_signal_autoconnect(cvs_password_ventana);
	}
}

void
on_password_ok_button_clicked (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *fuente;
	GtkWidget *ventana;
	gchar *texto;
	
	fuente=glade_xml_get_widget(cvs_password_ventana,"cvs_password_entry");
	texto=gtk_editable_get_chars(GTK_EDITABLE(fuente),0,-1);
	cvs_login(texto);
	g_free(texto);

	ventana=gtk_widget_get_toplevel(GTK_WIDGET(button));
	gtk_widget_destroy(ventana);

	if (cvs_comando & CVS_LOGIN) {
		cvs_comando=cvs_comando ^ CVS_LOGIN;
		on_login1_activate(NULL,NULL);
	} else {
		if (cvs_comando & CVS_UPDATE) {
			cvs_comando=cvs_comando ^ CVS_UPDATE;
			cvs_update();
		} else {
			if (cvs_comando & CVS_COMMIT) {
				cvs_comando=cvs_comando ^ CVS_COMMIT;
				on_commit1_activate(NULL,NULL);
			}
		}
	}
}

void
on_password_cancel_button_clicked (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *ventana;
	
	ventana=gtk_widget_get_toplevel(GTK_WIDGET(button));
	gtk_widget_destroy(ventana);
	
	cvs_comando=CVS_NINGUNO;
	g_free(recordar_log);
	recordar_log=NULL;
}

gboolean
on_cvs_password_ventana_delete_event          (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
	cvs_comando=CVS_NINGUNO;
	g_free(recordar_log);
	recordar_log=NULL;
	return FALSE;
}

void
on_manual1_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	GError *error;
	gchar *archivo;
	
	error=NULL;
	
	archivo=g_strdup_printf("%s/html/en/index.html",PACKAGE_DOC_DIR);
	gnome_help_display_uri(archivo,&error);
	if (error!=NULL) {
		g_printerr("%s\n",error->message);
		g_error_free(error);
	}
}

void
on_fuente_selector_font_set						(GnomeFontPicker *gfp,
								const gchar *font_name)
{
	GtkWidget *widget;
	
	widget=glade_xml_get_widget(preferencias_ventana,"texto_bold");
	if (strstr(font_name," Bold")!=NULL) {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget),TRUE);
	} else {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget),FALSE);
	}
	widget=glade_xml_get_widget(preferencias_ventana,"texto_italic");
	if (strstr(font_name," Italic")!=NULL) {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget),TRUE);
	} else {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget),FALSE);
	}
}
