Update dcl_config Set dcl_config_varchar = '0.9.3' Where dcl_config_name = 'DCL_VERSION';
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) values ('DCL_GATEWAY_WO_AUTORESPOND', 'dcl_config_varchar', 'N');
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) values ('DCL_GATEWAY_WO_AUTORESPONSE_EMAIL', 'dcl_config_varchar', 'nobody@localhost');
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) values ('DCL_GATEWAY_WO_ENABLED', 'dcl_config_varchar', 'N');
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) values ('DCL_GATEWAY_WO_FILE_PATH', 'dcl_config_varchar', '/tmp');
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_int) values ('DCL_GATEWAY_WO_PRIORITY', 'dcl_config_int', 0);
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) values ('DCL_GATEWAY_WO_REPLY', 'dcl_config_varchar', 'N');
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_int) values ('DCL_GATEWAY_WO_SEVERITY', 'dcl_config_int', 0);
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_int) values ('DCL_GATEWAY_WO_STATUS', 'dcl_config_int', 0);
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) values ('DCL_WO_SECONDARY_ACCOUNTS_ENABLED', 'dcl_config_varchar', 'N');
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_datetime) values ('LAST_CONFIG_UPDATE', 'dcl_config_datetime', now());
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_int) values ('DCL_SESSION_TIMEOUT', 'dcl_config_int', 20);
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) values ('DCL_WIKI_ENABLED', 'dcl_config_varchar', 'N');
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_int) values ('DCL_WIKI_VIEW', 'dcl_config_int', 4);
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_int) values ('DCL_WIKI_EDIT', 'dcl_config_int', 5);

Create Table dcl_wo_account (
	wo_id int(11) not null,
	seq int(11) not null,
	account_id int(11) not null,
	primary key(wo_id, seq, account_id)
);

Insert Into dcl_wo_account Select jcn, seq, account From workorders where account is not null and account > 0;

Alter Table workorders Drop Column account;

Create Table dcl_wo_type (
	wo_type_id int(11) auto_increment not null primary key,
	type_name varchar(50) not null,
	active char(1) not null
);

Alter Table workorders Add Column wo_type_id int(11) null;

Insert Into dcl_wo_type (type_name, active) values ('Issue', 'Y');
Update workorders set wo_type_id = 1;

Create Table dcl_session (
	dcl_session_id varchar(32) not null primary key,
	personnel_id int(11) not null,
	create_date timestamp(14) not null,
	update_date timestamp(14) not null,
	session_data text
);

Create Table dcl_preferences (
	personnel_id int(11) not null primary key,
	preferences_data text
);
create unique index uc_accounts_short on accounts(short);
create unique index uc_accounts_name on accounts(name);

Create Table dcl_wiki (
	dcl_entity_type_id int(11) not null,
	dcl_entity_id int(11) not null,
	dcl_entity_id2 int(11) not null,
	page_name varchar(255) not null,
	page_text text null,
	page_date timestamp(14) null,
	page_ip varchar(255) null,
	primary key (dcl_entity_type_id, dcl_entity_id, dcl_entity_id2, page_name)
);
