<?php
/*
 * $Id: pgsql.php,v 1.4.2.1.2.17 2003/12/27 17:11:29 mdean Exp $
 *
 * Double Choco Latte - Source Configuration Management System
 * Copyright (C) 1999  Michael L. Dean & Tim R. Norman
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Select License Info from the Help menu to view the terms and conditions of this license.
 */

if (!IsSet($GLOBALS['PGSQL_PHP_INCLUDED']))
{
	$GLOBALS['PGSQL_PHP_INCLUDED'] = 1;

	include_once(DCL_ROOT . 'datetime.php');

	class dclDB
	{
		var $conn;
		var $res;
		var $oid;
		var $cur;
		var $fieldArray;
		var $foreignKeys;
		var $cache;
		var $cacheEnabled;
		var $schemaVersion = '3';
		var $objTimestamp;
		var $objDate;
		var $emptyTimestamp;
		var $Record;
		var $JoinKeyword;

		function dclDB()
		{
			$this->conn = 0;
			$this->res = 0;
			$this->oid = 0;
			$this->cur = -1;

			$this->objTimestamp = new DCLTimestamp;
			$this->objDate = new DCLDate;

			$this->emptyTimestamp = 'null';
			$this->Record = array();
			$this->JoinKeyword = 'JOIN';
		}

		function Connect($conn = '')
		{
			global $dcl_domain_info, $dcl_domain;

			if ($conn == '')
			{
				if (!IsSet($GLOBALS['__DB_CONN__']))
				{
					$this->conn = pg_connect(sprintf('dbname=%s port=%s host=%s user=%s password=%s',
								$dcl_domain_info[$dcl_domain]['dbName'],
								$dcl_domain_info[$dcl_domain]['dbPort'],
								$dcl_domain_info[$dcl_domain]['dbHost'],
								$dcl_domain_info[$dcl_domain]['dbUser'],
								$dcl_domain_info[$dcl_domain]['dbPassword']));

					$GLOBALS['__DB_CONN__'] = $this->conn;
				}
				else
					$this->conn = $GLOBALS['__DB_CONN__'];
			}
			else
				$this->conn = $conn;

			return $this->conn;
		}

		function CanConnectServer()
		{
			global $dcl_domain_info, $dcl_domain;

			$conn = pg_connect(sprintf('dbname=template1 port=%s host=%s user=%s password=%s',
						$dcl_domain_info[$dcl_domain]['dbPort'],
						$dcl_domain_info[$dcl_domain]['dbHost'],
						$dcl_domain_info[$dcl_domain]['dbUser'],
						$dcl_domain_info[$dcl_domain]['dbPassword']));

			$bConnect = ($conn > 0);
			pg_close($conn);

			return $bConnect;
		}

		function CanConnectDatabase()
		{
			global $dcl_domain_info, $dcl_domain;

			$conn = pg_connect(sprintf('dbname=%s port=%s host=%s user=%s password=%s',
								$dcl_domain_info[$dcl_domain]['dbName'],
								$dcl_domain_info[$dcl_domain]['dbPort'],
								$dcl_domain_info[$dcl_domain]['dbHost'],
								$dcl_domain_info[$dcl_domain]['dbUser'],
								$dcl_domain_info[$dcl_domain]['dbPassword']));

			if ($conn > 0)
			{
				pg_close($conn);

				return true;
			}

			return false;
		}

		function CreateDatabase()
		{
			global $dcl_domain_info, $dcl_domain;

			$conn = pg_connect(sprintf('port=%s host=%s user=%s password=%s',
						$dcl_domain_info[$dcl_domain]['dbPort'],
						$dcl_domain_info[$dcl_domain]['dbHost'],
						$dcl_domain_info[$dcl_domain]['dbUser'],
						$dcl_domain_info[$dcl_domain]['dbPassword']));

			$query = sprintf('Create Database %s', $dcl_domain_info[$dcl_domain]['dbName']);

			return (pg_exec($conn, $query) > 0);
		}

		function TableExists($sTableName)
		{
			return ($this->ExecuteScalar("select count(*) from pg_class where relname='$sTableName' and relkind='r'") > 0);
		}

		function Query($query)
		{
			$this->res = 0;
			$this->oid = 0;
			$this->cur = -1;
			$this->Record = array();

			if ($this->conn)
			{
				@$this->res = pg_Exec($this->conn, $query);
				if ($this->res)
				{
					$this->cur = 0;
					return $this->res;
				}
				else
				{
					print("<br>Error executing query!<br>$query<br>");
					print(pg_ErrorMessage());
					return -1;
				}
			}
			else
				return -1;

			return 1;
		}

		function LimitQuery($query, $offset, $rows)
		{
			$this->res = 0;
			$this->oid = 0;
			$this->cur = -1;
			$this->Record = array();

			if ($this->conn)
			{
				@$this->res = pg_Exec($this->conn, $query . ' LIMIT ' . $rows . ' OFFSET ' . $offset);
				if ($this->res)
				{
					$this->cur = 0;
					return $this->res;
				}
				else
				{
					print("<br>Error executing query!<br>$query<br>");
					print(pg_ErrorMessage());
					return -1;
				}
			}
			else
				return -1;
		}

		function Execute($query)
		{
			$this->res = 0;
			$this->oid = 0;
			$this->cur = -1;
			$this->Record = array();

			if ($this->conn)
			{
				if (!pg_Exec($this->conn, $query))
				{
					print(pg_errormessage($this->conn));
					die("Could not execute query: $query");
				}
				return 1;
			}
			else
				return -1;
		}

		// Execute row returning query and return first row, first field
		function ExecuteScalar($sql)
		{
			$retVal = null;

			if (!$this->conn)
				$this->Connect();

			$res = pg_Exec($this->conn, $sql);
			if ($res)
			{
				$Record = @pg_fetch_array($res, 0);
				$retVal = $Record[0];
				pg_freeresult($res);
			}

			return $retVal;
		}

		function Insert($query)
		{
			$this->res = 0;
			$this->oid = 0;
			$this->cur = -1;
			$this->Record = array();

			if ($this->conn)
			{
				$this->res = pg_Exec($this->conn, $query);
				if ($this->res)
					return $this->oid = pg_GetLastOid($this->res);
				else
				{
					print(pg_errormessage($this->conn));
					print("<br>Error executing insert!<br>$query");
					return -1;
				}
			}
			else
			{
				print('<br>No connection!');
				return -1;
			}
		}

		function FreeResult()
		{
			$this->Record = array();
			if ($this->res != 0)
				@pg_freeresult($this->res);

			$this->res = 0;
		}

		function BeginTransaction()
		{
			return $this->Execute('BEGIN');
		}

		function EndTransaction()
		{
			return $this->Execute('COMMIT');
		}

		function RollbackTransaction()
		{
			return $this->Execute('ROLLBACK');
		}

		function NumRows()
		{
			if ($this->res)
				return pg_NumRows($this->res);
			else
				return -1;
		}

		function NumFields()
		{
			if ($this->res)
				return pg_NumFields($this->res);
			else
				return -1;
		}

		// from phpGW/phpLib db classes - sort of
		function next_record()
		{
			// bump up if just ran query
			if ($this->cur == -1)
				$this->cur = 0;

			$this->Record = @pg_fetch_array($this->res, $this->cur++);

			//$this->Error = pg_ErrorMessage($this->Link_ID);
			//$this->Errno = ($this->Error == '') ? 0 : 1;

			$stat = is_array($this->Record);
			if (!$stat)
				$this->FreeResult();

			return $stat;
		}

		// from phpGW/phpLib db classes - sort of
		function f($sName)
		{
			return $this->Record[$sName];
		}

		function GetFieldName($fieldIndex)
		{
			if ($this->res)
				return pg_fieldname($this->res, $fieldIndex);

			return '';
		}

		function IsFieldNull($thisField)
		{
			if ($this->res)
			{
				if (count($this->Record) > 0)
					return $this->Record[$thisField] == NULL;

				return pg_FieldIsNULL($this->res, $this->cur, $thisField);
			}
			else
				return -1;
		}

		function FetchAllRows()
		{
			$retVal = array();
			$i = 0;
			// bump up if just ran query
			if ($this->cur == -1)
				$this->cur = 0;

			while ($a = @pg_fetch_row($this->res, $this->cur++))
				$retVal[$i++] = $a;

			return $retVal;
		}

		function InitFromArray($aSource)
		{
			reset($this->fieldArray);
			while (list($key, $field) = each($this->fieldArray))
			{
				if (IsSet($aSource[$field]))
					$this->$field = $aSource[$field];
			}
		}

		function InitFromGlobals()
		{
			reset($this->fieldArray);
			while (list($key, $field) = each($this->fieldArray))
			{
				if (IsSet($GLOBALS[$field])) 
				{
					$this->$field = $this->GPCStripSlashes($GLOBALS[$field]);
				}
			}
		}

		// php/eGW compatible function
		function db_addslashes($thisString)
		{
			return $this->DBAddSlashes($thisString);
		}

		function DBAddSlashes($thisString)
		{
			if (!IsSet($thisString) || $thisString == '')
				return '';

			return AddSlashes($thisString);
		}

		function GPCStripSlashes($thisString)
		{
			if (get_magic_quotes_gpc() == 0)
				return $thisString;

			return stripslashes($thisString);
		}

		function CacheRow($key)
		{
			if (!$this->cacheEnabled || IsSet($this->cache[$key]))
				return -1;

			reset($this->fieldArray);
			while (list($dummykey, $field) = each($this->fieldArray))
			{
				if (IsSet($this->$field)) 
					$this->cache[$key][$field] = $this->$field;
			}

			return 0;
		}

		function LoadCache($key)
		{
			if (!$this->cacheEnabled || !IsSet($this->cache[$key]))
				return -1;

			reset($this->fieldArray);
			while (list($dummykey, $field) = each($this->fieldArray))
			{
				if (IsSet($this->cache[$key][$field])) 
					$this->$field = $this->cache[$key][$field];
			}

			return 0;
		}

		function GetNewIDSQLForTable($tableName)
		{
			return "nextval('seq_" . $tableName . "')";
		}

		function GetSeqSQL($jcn)
		{
			return 'next_seq(' . $jcn . ')';
		}

		function GetDateSQL()
		{
            // From Urmet Janes for MSSQL support
			return 'now()';
		}

		function GetRTrimSQL($text)
		{
			return "trim(trailing ' ' from $text)";
		}

		function DisplayToSQL($thisDate)
		{
			global $dcl_info;

			$eregStr = str_replace('m', '([0-9]{2})', $dcl_info['DCL_DATE_FORMAT']);
			$eregStr = str_replace('d', '([0-9]{2})', $eregStr);
			$eregStr = str_replace('Y', '([0-9]{4})', $eregStr);
			if(ereg('^' . $eregStr . ' ([0-9]{2}).([0-9]{2}).([0-9]{2})$', $thisDate))
				return "'" . $this->ArrangeTimeStampForInsert($thisDate) . "'";
			else
				return "'" . $this->ArrangeDateForInsert($thisDate) . "'";
		}

		function ArrangeDateForInsert($thisDate)
		{
			$this->objDate->SetFromDisplay($thisDate);
			return $this->objDate->ToDB();
		}

		function ArrangeTimeStampForInsert($thisStamp)
		{
			global $dcl_domain_info, $dcl_domain;

			if ($dcl_domain_info[$dcl_domain]['dbVersionMjr'] < 7)
				return $thisStamp;

			$this->objTimestamp->SetFromDisplay($thisStamp);
			return $this->objTimestamp->ToDB();
		}

		function FormatDateForDisplay($thisDate)
		{
			if ($thisDate == '')
				return '';

			$this->objDate->SetFromDB($thisDate);
			return $this->objDate->ToDisplay();
		}

		function FormatTimeStampForDisplay($thisStamp)
		{
			global $dcl_domain_info, $dcl_domain;

			if ($thisStamp == '')
				return '';

			if ($dcl_domain_info[$dcl_domain]['dbVersionMjr'] < 7)
				return $thisStamp;

			$this->objTimestamp->SetFromDB($thisStamp);
			return $this->objTimestamp->ToDisplay();
		}

		function GetUpperSQL($text)
		{
			return sprintf('upper(%s)', $text);
		}

		function GetLastInsertID($sTable)
		{
			@$res = pg_Exec($this->conn, "select currval('seq_$sTable')");
			if ($res)
			{
				$Record = @pg_fetch_array($res, 0);
				@pg_FreeResult($res);
				return $Record[0];
			}

			print("<br>Error getting last insert ID for table $sTable!");
			print(pg_ErrorMessage());
			return -1;
		}

		function HasFKRef($id)
		{
			$bHasRef = false;
			$oKey = new dclDB; // Don't really need anything fancy, 'spose...
			while ((list($sTable, $sField) = each($this->foreignKeys)) && !$bHasRef)
			{
				if (is_array($sField)) // More than one field in here references this key
				{
					while ((list($sDummyKey, $sOneField) = each($sField)) && !$bHasRef)
					{
						$oKey->Query("SELECT $sOneField FROM $sTable WHERE $sOneField=$id");
						if ($oKey->next_record())
							$bHasRef = true;
					}
				}
				else
				{
					$oKey->Query("SELECT $sField FROM $sTable WHERE $sField=$id");
					if ($oKey->next_record())
						$bHasRef = true;
				}
			}

			return $bHasRef;
		}

		function ConvertDate($sExpression, $sField)
		{
			if ($sExpression == $sField)
				return $sField;

			return "$sExpression AS $sField";
		}

		function ConvertTimestamp($sExpression, $sField)
		{
			if ($sExpression == $sField)
				return $sField;

			return "$sExpression AS $sField";
		}

		function IsDate($vField)
		{
			return ($this->res > 0 && pg_fieldtype($this->res, $vField) == 'date');
		}

		function IsTimestamp($vField)
		{
			// substr because it could be timestamp or timestamptz
			return ($this->res > 0 && substr(pg_fieldtype($this->res, $vField), 0, 9) == 'timestamp');
		}

		function index_names()
		{
			global $dcl_domain, $dcl_domain_info;

			$this->query("SELECT relname FROM pg_class WHERE NOT relname ~ 'pg_.*' AND relkind ='i' ORDER BY relname");
			$i = 0;
			$return = array();
			while ($this->next_record())
			{
				$return[$i] = array();
				$return[$i]['index_name']		= $this->f(0);
				$return[$i]['tablespace_name']	= $dcl_domain_info[$dcl_domain]['dbName'];
				$return[$i++]['database']		= $dcl_domain_info[$dcl_domain]['dbName'];
			}

			return $return;
		}

		function FieldExists($sTable, $sField)
		{
			return ($this->ExecuteScalar("select count(*) from pg_attribute a join pg_class b on a.attrelid = b.oid where b.relname = '$sTable' and a.attname = '$sField'") == 1);
		}

		function GetMinutesElapsedSQL($sBeginDateSQL, $sEndDateSQL, $sAsField)
		{
			$sRetVal = "extract(epoch from age($sEndDateSQL, $sBeginDateSQL)) / 60";

			if ($sAsField == '')
				return $sRetVal;

			return "$sRetVal AS $sAsField";
		}
	}
}
?>
