<?php
/*
 * $Id: class.dbSession.inc.php,v 1.2.2.6 2003/10/22 03:47:55 mdean Exp $
 *
 * Double Choco Latte - Source Configuration Management System
 * Copyright (C) 1999  Michael L. Dean & Tim R. Norman
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Select License Info from the Help menu to view the terms and conditions of this license.
 */

//LoadStringResource('db');
class dbSession extends dclDB
{
	var $dcl_session_id;
	var $personnel_id;
	var $create_date;
	var $update_date;
	var $session_data;

	var $m_IsValidSession;

	function dbSession()
	{
		// Table Fields
		$this->fieldArray = array('dcl_session_id', 'personnel_id', 'create_date', 'update_date', 'session_data');

		// Foreign Keys
		$this->foreignKeys = array();

		$this->cache = array();
		$this->cacheEnabled = false;

		$this->dclDB();

		$this->session_data = array();
		$this->m_IsValidSession = false;
	}

	function Add()
	{
		global $dcl_info;

		srand((double)microtime() * 1000000);
		$this->dcl_session_id = md5(uniqid(rand()));

		$query = 'INSERT INTO dcl_session (dcl_session_id, personnel_id, create_date, update_date, session_data) Values (';
		$query .= '\'' . $this->dcl_session_id . '\',';
		$query .= $this->personnel_id . ',';
		$query .= $this->GetDateSQL() . ',';
		$query .= $this->GetDateSQL() . ',';
		$query .= '\'' . $this->DBAddSlashes(serialize($this->session_data)) . '\')';

		if ($this->Insert($query) == -1)
		{
			echo '<BR>' . sprintf('Could not start session! %s', $query) . '<BR>';
			exit;
		}

		$this->m_IsValidSession = true;
	}

	function Edit()
	{
		global $dcl_info;

		$query = 'UPDATE dcl_session SET ';
		$query .= 'update_date = ' . $this->GetDateSQL() . ',';
		$query .= 'session_data = \'' . $this->DBAddSlashes(serialize($this->session_data)) . '\'';
		$query .= ' WHERE dcl_session_id=\'' . $this->dcl_session_id . '\'';

		$this->Execute($query);
	}

	function Delete()
	{
		$query = 'DELETE FROM dcl_session WHERE dcl_session_id=\'' . $this->dcl_session_id . '\'';
		return $this->Execute($query);
	}

	function GetRow()
	{
		if (!$this->res)
			return -1;

		if (count($this->Record) > 0)
		{
			$this->dcl_session_id = $this->f('dcl_session_id');
			$this->personnel_id = $this->f('personnel_id');
			$this->create_date = $this->f('create_date');
			$this->update_date = $this->f('update_date');
			$this->session_data = $this->f('session_data');
		}
		else
			$this->Clear();
	}

	function Load($id)
	{
		global $dcl_info, $dcl_domain, $dcl_domain_info;

		$this->Clear();

		if ($this->conn == 0)
		{
			if (!$this->Connect())
				return -1;
		}

		$sql = 'SELECT dcl_session_id, personnel_id, ';
		$sql .= $this->ConvertTimestamp('create_date', 'create_date');
		$sql .= ', ' . $this->ConvertTimestamp('update_date', 'update_date');
		$sql .= ', session_data, ';
		$sql .= $this->GetMinutesElapsedSQL('update_date', $this->GetDateSQL(), 'minutes_elapsed');
		$sql .= " FROM dcl_session WHERE dcl_session_id='$id'";
		if ($this->Query($sql) == -1 || !$this->next_record())
		{
			return -1;
		}

		$retVal = ($this->GetRow() != -1);
		$iMinutesElapsed = $this->f('minutes_elapsed');
		$this->FreeResult();

		$this->session_data = unserialize($this->session_data);

		$this->GlobalValue('DCLID');
		$this->GlobalValue('SEC');
		$this->GlobalValue('DCLNAME');
		$this->GlobalValue('USEREMAIL');
		$this->GlobalValue('LANG');
		$this->GlobalValue('DCLUI');
		$this->GlobalValue('dcl_info');
		$this->GlobalValue('dcl_preferences');

		// Did session expire?
		if ($iMinutesElapsed > $dcl_info['DCL_SESSION_TIMEOUT'])
			return -2;

		// Check for config refresh
		global $dcl_info;
		$o = CreateObject('dcl.dbConfig');
		$o->Connect();
		if (!isset($dcl_info) || !is_array($dcl_info) || !isset($dcl_info['LAST_CONFIG_UPDATE']) || $o->Value('LAST_CONFIG_UPDATE') != $dcl_info['LAST_CONFIG_UPDATE'])
		{
			$o->Load();
			$this->Register('dcl_info', $dcl_info);
			$this->Edit();
		}

		$query = 'UPDATE dcl_session SET ';
		$query .= 'update_date = ' . $this->GetDateSQL();
		$query .= ' WHERE dcl_session_id=\'' . $this->dcl_session_id . '\'';

		srand((double)microtime() * 1000000);
		$pct = rand(1, 100);
		if ($pct <= 20)
		{
			// 20% chance to call session purge - called after this session has updated timestamp
			// Purging on every request is too much traffic and unnecessary since this is really
			// doing housekeeping
			$this->Purge();
		}

		$this->m_IsValidSession = $retVal && ($this->Execute($query) != -1);

		return $this->m_IsValidSession;
	}

	function Register($sName, $sValue)
	{
		$this->session_data[$sName] = $sValue;
	}

	function Unregister($sName)
	{
		if (isset($this->session_data[$sName]))
			unset($this->session_data[$sName]);
	}

	function Value($sName)
	{
		if (isset($this->session_data[$sName]))
			return $this->session_data[$sName];

		return null;
	}

	function GlobalValue($sName)
	{
		$GLOBALS[$sName] = $this->Value($sName);
	}

	function Purge()
	{
		global $dcl_info;

		$query = sprintf('DELETE FROM dcl_session WHERE (%s) > %s',
						$this->GetMinutesElapsedSQL('update_date', $this->GetDateSQL(), ''),
						$dcl_info['DCL_SESSION_TIMEOUT']);

		return $this->Execute($query);
	}

	function IsValidSession()
	{
		return $this->m_IsValidSession;
	}

	function Clear()
	{
		$this->dcl_session_id = '';
		$this->personnel_id = 0;
		$this->create_date = '';
		$this->update_date = '';
		$this->session_data = array();
	}
}
?>
