#include <string>

#include <util/PlatformUtils.hpp>
#include <parsers/SAXParser.hpp>
#include <sax/HandlerBase.hpp>

#include <ace/Synch.h>
#include <ace/Log_Msg.h>

#include "DBBalancerConfig.hh"


// WARNING: This class is not thread-safe. There shouldn't be any problem as it's only called during object
// inicialization (which is single-threaded) but maybe in a future could be desirable that feature.

class DBHostConfig;
class DBBalancerXMLConfig: public virtual DBBalancerConfig, public HandlerBase {

public:
  
  DBBalancerXMLConfig(string xmlFile);
  ~DBBalancerXMLConfig();

  // DBBalancerConfig interface methods *****************************************

  // <daemon>
  unsigned int getDaemonReaderPort() { return _readerPort; };
  unsigned int getDaemonWriterPort() { return _writerPort; };

  unsigned int getDaemonInitThreads() { return _initThreads; };
  unsigned int getDaemonMaxThreads() { return _maxThreads; };
  unsigned int getDaemonMinThreads() { return _minThreads; };

  unsigned int getInitDbConnections() { return _initDbConnections; };
  unsigned int getMinDbConnections() { return _minDbConnections; };
  unsigned int getMaxDbConnections() { return _maxDbConnections; };

  unsigned int getDaemonReaperDelay() { return _reaperDelay; };
  string getDaemonUser() { return _daemonUser; };
  string getDaemonPassword() { return _daemonPassword; };
  string getDaemonAuthMethod() { return _daemonAuthMethod; };
  
  // <machine> 1..n
  vector<DBHostConfig *> getHosts();

  // HandlerBase (DocumentHandler) methods ***************************************
  void startDocument();
  void startElement(const XMLCh * name, class AttributeList &attributes);
  void characters(const XMLCh * chars, unsigned int length);
  void endElement(const XMLCh * name);
  void endDocument();

private:

  string _currentElement;
 
  unsigned int _readerPort;
  unsigned int _writerPort;
  unsigned int _initThreads;
  unsigned int _minThreads;
  unsigned int _maxThreads;

  unsigned int _initDbConnections;
  unsigned int _minDbConnections;
  unsigned int _maxDbConnections;

  string _daemonUser;
  string _daemonPassword;
  string _daemonAuthMethod;

  unsigned int _reaperDelay;

  vector <DBHostConfig *> _hosts; 

};

