#!/usr/bin/env perl

# Some tests for 'darcs pull' 

use Test::More qw/no_plan/;
use strict;
use vars qw/$DARCS/;

die 'darcs not found' unless $ENV{DARCS} || (-x "$ENV{PWD}/../darcs");
$DARCS = $ENV{DARCS} || "$ENV{PWD}/../darcs";

`rm -rf temp1 temp2`;
`mkdir -p temp1 temp2/one/two`;
chdir 'temp1';
`$DARCS init`;
chdir '../temp2';
`$DARCS init`;
chdir 'one/two';

###

my $test_name = 'darcs pull should work relative to the current directory';
my $pull_out = `$DARCS pull -a ../../../temp1 2>&1`;
like($pull_out, qr/No remote changes to pull in/i, $test_name);

###

my $test_name = 'darcs pull should pull into repo specified with --repo';
chdir '../../';  # now in temp2
`$DARCS add one`;
`$DARCS record --patch-name 'uno' --all --author foo\@bar`;
chdir '../';     # now outside of any repo
like(`$DARCS pull --repodir temp1 --all ../temp2`, # temp2 is relative to temp1
	qr/Finished pulling./i, $test_name);

SELF_PULL: {
    chdir './temp1'; 

    my $default_repo_pre_test = 'Before trying to pull from self, defaultrepo is something else';
    open(DEFAULT_REPO,'<./_darcs/prefs/defaultrepo') || die "Couldn't open defaultrepo";
    my $default_repo = (<DEFAULT_REPO>);
    close(DEFAULT_REPO);

    unlike($default_repo,qr/temp1/,$default_repo_pre_test);

    my $test_name = 'return special message when you try to pull from yourself';
    like(`$DARCS pull -a \`pwd\` 2>&1`, qr/Can't pull from current repo!/i, $test_name);

    my $set_default_repo_test = "and don't update the default repo to be the current dir";
    open(DEFAULT_REPO,'<./_darcs/prefs/defaultrepo') || die "Couldn't open defaultrepo";
    my $default_repo = (<DEFAULT_REPO>);
    close(DEFAULT_REPO);

    unlike($default_repo,qr/temp1/,$set_default_repo_test);

    chdir '../';     # now outside of any repo
}


ok(-d 'temp1', "temp1 exists here");
`rm -rf temp1`;
ok((!-d 'temp1'), 'temp1 directory was deleted');

ok(-d 'temp2', "temp1 exists here");
`rm -rf temp2`;
ok((!-d 'temp2'), 'temp1 directory was deleted');




