/* trivial.h */

#ifndef TRIVIAL_H
#define TRIVIAL_H

#include <stdio.h>

#include "config.h"

/* defined in main.c */
extern int opt_debug;
extern char *	opt_outfile;

/*
 * our errors, or the user's
 */
#define printe(...)	do{\
					fprintf(stderr, "%s: ", __func__);\
					fflush(stderr);\
					fprintf(stderr, __VA_ARGS__);\
					fflush(stderr);\
				}while(0)

void usage(void);
int _printsys(char *fmt, ...);
#define printsys(...) fprintf(stderr, "%s:%d: ", __FILE__, __LINE__);\
			fflush(stderr);\
			_printsys(__VA_ARGS__)
#ifdef DEBUG
#define printd(...) do{\
			if(!opt_debug){\
				break;\
			}\
			printf("%s: ", __func__);\
			fflush(stdout);\
			printf(__VA_ARGS__);\
			fflush(stdout);\
		}while(0)
#else
#define printd(...)
#endif	/* DEBUG */

/* FIXME: check for gcc version (someday) */
#define gcc_unused __attribute__ ((unused))

int printw(char *fmt, ...);
int printout(char *fmt, ...);
int print_prog_bar(int perc);

#endif /* TRIVIAL_H */
