/*-------------------------------------------------------------------------
Compiler Generator Coco/R,
Copyright (c) 1990, 2004 Hanspeter Moessenboeck, University of Linz
extended by M. Loeberbauer & A. Woess, Univ. of Linz
ported from C# to Java by Wolfgang Ahorner
with improvements by Pat Terry, Rhodes University

This program is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 2, or (at your option) any
later version.

This program is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

As an exception, it is allowed to write an extension of Coco/R that is
used as a plugin in non-free software.

If not otherwise stated, any source code generated by Coco/R (other than
Coco/R itself) does not fall under the GNU General Public License.
-------------------------------------------------------------------------*/
/*-------------------------------------------------------------------------
  Trace output options
  0 | A: prints the states of the scanner automaton
  1 | F: prints the First and Follow sets of all nonterminals
  2 | G: prints the syntax graph of the productions
  3 | I: traces the computation of the First sets
  4 | J: prints the sets associated with ANYs and synchronisation sets
  6 | S: prints the symbol table (terminals, nonterminals, pragmas)
  7 | X: prints a cross reference list of all syntax symbols
  8 | P: prints statistics about the Coco run

  Trace output can be switched on by the pragma
    $ { digit | letter }
  in the attributed grammar or as a command-line option
  -------------------------------------------------------------------------*/

package Coco;

public class Coco {

	public static void main (String[] arg) {
		System.out.println("Coco/R (March 16, 2005)");
		String ATGName = null;
		for (int i = 0; i < arg.length; i++) {
			if (arg[i].compareTo("-package") == 0 && i < arg.length - 1) Tab.nsName = arg[++i];
			else if (arg[i].compareTo("-frames") == 0 && i < arg.length - 1) Tab.frameDir = arg[++i];
			else if (arg[i].compareTo("-trace") == 0 && i < arg.length - 1) Tab.SetDDT(arg[++i]);
			else ATGName = arg[i];
		}
		if (arg.length > 0 && ATGName != null) {
			int pos = ATGName.lastIndexOf('/');
			if (pos < 0) pos = ATGName.lastIndexOf('\\');
			String file = ATGName;
			String dir = ATGName.substring(0, pos+1);

			Scanner.Init(file);
			Trace.Init(dir);
			Tab.Init();
			DFA.Init(file, dir);
			ParserGen.Init(file, dir);

			Parser.Parse();

			Trace.Close();
			System.out.println(Errors.count + " errors detected");
		} else {
			System.out.println(
				"Usage: Coco Grammar.ATG {Option}\n" +
				"Options:\n" +
				"  -package <packageName>\n" +
				"  -frames  <frameFilesDirectory>\n" +
				"  -trace   <traceString>\n" +
				"Valid characters in the trace string:\n" +
				"  A  trace automaton\n" +
				"  F  list first/follow sets\n" +
				"  G  print syntax graph\n" +
				"  I  trace computation of first sets\n" +
				"  J  list ANY and SYNC sets\n" +
				"  P  print statistics\n" +
				"  S  list symbol table\n" +
				"  X  list cross reference table\n" +
				"Scanner.frame and Parser.frame files needed in ATG directory\n" +
				"or in a directory specified in the -frames option.\n"
			);
		}
	}

} // end Coco