
(use-package :gl)

;;; This program is trivial, but it works!
;;; Richard Mann
;;; 18 May 1998

(defvar window)
(defvar size 0.0)
(defvar ds 0.01)

(ff:defun-c-callable visible-callback ((vis :fixnum))
 (format t "Callback VISIBLE. VIS:~s~%" vis)
 (cond ((= vis GLUT_VISIBLE)
	(glutIdleFunc idle-callback))
       (t
	(glutIdleFunc 0))))

(ff:defun-c-callable idle-callback ()
 (format t "Callback IDLE.~%")
 (incf size ds)
 (if (> size 1.0) (setf size 0.0))
 (if (< size 0.0) (setf size 1.0))
 (glutPostRedisplay))

(ff:defun-c-callable draw-callback ()
 (format t "Callback DRAW.~%")
 (glClearColor 0.0 0.0 0.0 0.0)
 (glClear GL_COLOR_BUFFER_BIT)
 (glColor3f 1.0 1.0 1.0)
 (glMatrixMode GL_PROJECTION)
 (glLoadIdentity)
 (glOrtho -1d0 1d0 -1d0 1d0 -1d0 1d0)
 (glMatrixMode GL_MODELVIEW)
 (glBegin GL_POLYGON)
 (glVertex3f (- size) (- size) 0.0)
 (glVertex3f (- size) size 0.0)
 (glVertex3f size size 0.0)
 (glVertex3f size (- size) 0.0)
 (glEnd)
 (glFlush)
 (glutSwapBuffers))

(ff:defun-c-callable key-callback ((k :fixnum) (x :fixnum) (y :fixnum))
 (format t "Callback KEY.  K:~s, X:~s, Y:~s~%" k x y)
 (case (character k)
   (#\r
    (setf ds (- ds)))
   (#\Escape
    (glutDestroyWindow window)
    (break))))

(setq draw-callback (ff:register-function 'draw-callback))
(setq idle-callback (ff:register-function 'idle-callback))
(setq key-callback (ff:register-function 'key-callback))
(setq visible-callback (ff:register-function 'visible-callback))

(defun main ()
 (glutInitDisplayMode (+ GLUT_RGB GLUT_DOUBLE))
 (glutInitWindowPosition 0 0)
 (glutInitWindowSize 500 500)
 (setq window (glutCreateWindow "simple"))
 
 (glutDisplayFunc draw-callback)
 (glutIdleFunc idle-callback)
 (glutKeyboardFunc key-callback)
 (glutVisibilityFunc visible-callback)
 
 (glutMainLoop))
