
;;;
;;; Attempt to use GLUT timers to synchronize motion of object.
;;; In this case, rotating a random field of dots at 24Hz...
;;;
;;; Richard Mann
;;; 18 May 1998
;;;

(use-package :gl)

(defvar *angle*)
(defvar *angle-step*)
(defvar *frame-interval*)
(defvar *frame*)
(defvar *list1*)
(defvar *points*)
(defvar *window*)

(defmacro x (v) `(aref ,v 0))
(defmacro y (v) `(aref ,v 1))
(defmacro z (v) `(aref ,v 2))

(defmacro degrees->radians (d) `(* (/ ,d 180.0) pi))

(defvar display-callback)
(ff:defun-c-callable display-callback ()
 ;; Called each time screen is redisplayed
 ;;(format t "Drawing frame:~a~%" *frame*)
 (let ((begin-time (glutGet GLUT_ELAPSED_TIME))
       (end-time nil)
       (elapsed-time nil))
  (glClear GL_COLOR_BUFFER_BIT)
  (glColor3f 1.0 1.0 1.0)
  (glLoadIdentity)
  (glRotatef (coerce *angle* 'single-float) 0.0 1.0 0.0) 
  (glScalef 2.0 2.0 2.0)
  (glTranslatef -0.5 -0.5 -0.5)
  (glCallList *list1*)
  (glutSwapBuffers)
  (incf *frame*)
  (incf *angle* *angle-step*)
  (when (> *angle* 360.0) (decf *angle* 360.0))
  (setq end-time (glutGet GLUT_ELAPSED_TIME))
  (setq elapsed-time (- end-time begin-time))
  ;;(format t "Begin-time:~a, Elapsed-time:~a~%" begin-time elapsed-time)
  (cond
    ((> elapsed-time *frame-interval*)
     (format t "Lagging at frame ~a by ~a ms.~%"
	     *frame* (- elapsed-time *frame-interval*))
     (glutTimerFunc 0 timer-callback *frame*))
    (t
     (glutTimerFunc (- *frame-interval* elapsed-time)
		    timer-callback *frame*)))))
(setq display-callback (ff:register-function 'display-callback))

(defun make-points (n)
 (let ((points (make-array n)))
  (dotimes (i n)
   (setf (aref points i) (vector (random 1.0) (random 1.0) (random 1.0))))
  (coerce points 'list)))

(defun myinit ()
 ;; Initialize geometry and/or viewing paramaters.
 (setq *angle* 0.0)
 (setq *frame* 0)
 (setq *angle-step* 2.0)
 (setq *frame-interval* 41) ; milliseconds =~ 24fps
 (glShadeModel GL_FLAT)
 (glPointSize 10.0)
 (glEnable GL_POINT_SMOOTH)
 (setq *list1* (glGenLists 1))
 (glNewList *list1* GL_COMPILE)
 (setq *points* (make-points 10))
 (glBegin GL_POINTS)
 (dolist (p *points*)
  (glVertex3f (x p) (y p) (z p)))
 (glEnd)
 (glEndList))

(defvar keyboard-callback)
(ff:defun-c-callable keyboard-callback
    ((k :unsigned-byte) (x :fixnum) (y :fixnum))
 ;; Called after any keypress
 ;(format t "Callback KEYBOARD.  K:~a, X:~a, Y:~a~%" k x y)
 (case (character k)
   (#\Escape
    (glutTimerFunc 0 0 0) ; try to turn off timer func
    (glutDestroyWindow *window*)
    (break))))
(setq keyboard-callback (ff:register-function 'keyboard-callback))

(defvar reshape-callback)
(ff:defun-c-callable reshape-callback ((w :fixnum) (h :fixnum))
 ;; Called after reshape/expose event (also called when window first
 ;; created?)
 ;(format t "Callback RESHAPE.  W:~a, H:~a~%" w h)
 (reshape w h))
(setq reshape-callback (ff:register-function 'reshape-callback))

(defun reshape (w h)
 (glViewport 0 0 w h)
 (glMatrixMode GL_PROJECTION)
 (glLoadIdentity)
 ;; Note: all arguments must be double.
 ;(gluPerspective 60d0 (coerce (/ w h) 'double-float) 1d0 20d0)
 (glFrustum -1d0 1d0 -1d0 1d0 2d0 20d0)
 (gluLookAt 0d0 0d0 5d0 0d0 0d0 0d0 0d0 1d0 0d0)
 (glMatrixMode GL_MODELVIEW))

(defvar timer-callback)
(ff:defun-c-callable timer-callback ((value :fixnum))
 ;;(format t "Callback TIMER. VALUE:~a~%" value)
 (cond ((> value *frame*)
	(format t "Ignoring event:~a~%" value))
       (t
	(glutPostRedisplay))))
(setq timer-callback (ff:register-function 'timer-callback))

(defun main ()
 (glutInitDisplayMode (+ GLUT_DOUBLE  GLUT_RGB))
 (glutInitWindowPosition 0 0)
 (glutInitWindowSize 400 400)
 (setq *window* (glutCreateWindow "points"))
 (myinit)

 (glutReshapeFunc reshape-callback)
 (glutDisplayFunc display-callback)
 (glutKeyboardFunc keyboard-callback)

 (glutMainLoop))
