#define GLUT_DISABLE_ATEXIT_HACK

#include <windows.h>
#include <GL/gl.h>
#include <GL/glu.h>
#include <GL/glut.h>


///////////////////////////////////////////////////////////////////////////////////////////
// DLL Interface functions


extern "C" _declspec(dllexport)
void glclearcolor (float f1, float f2, float f3, float f4)
{
	glClearColor(f1, f2, f3, f4);
}

extern "C" _declspec(dllexport)
void glclear (int n)
{
	glClear(n);
}

extern "C" _declspec(dllexport)
void glmatrixmode (int n)
{
	glMatrixMode(n);
}

extern "C" _declspec(dllexport)
void glloadidentity ()
{
	glLoadIdentity();
}

extern "C" _declspec(dllexport)
void glortho (double d1, double d2, double d3, double d4, double d5, double d6)
{
	glOrtho(d1, d2, d3, d4, d5, d6);
}

extern "C" _declspec(dllexport)
void glbegin (int n)
{
	glBegin(n);
}

extern "C" _declspec(dllexport)
void glend ()
{
	glEnd();
}

extern "C" _declspec(dllexport)
void glflush ()
{
	glFlush();
}

extern "C" _declspec(dllexport)
void glpopmatrix ()
{
	glPopMatrix();
}


extern "C" _declspec(dllexport)
void glviewport (int n1, int n2, int n3, int n4)
{
	glViewport(n1, n2, n3, n4);
}

extern "C" _declspec(dllexport)
void glpushmatrix ()
{
	glPushMatrix();
}


extern "C" _declspec(dllexport)
void glcleardepth (double d1)
{
	glClearDepth(d1);
}

extern "C" _declspec(dllexport)
void glenable (int n)
{
	glEnable(n);
}

//This is not part of OpenGL, but for debugging array-passing.
extern "C" _declspec(dllexport)
void print_array (int n, float* pf)
{
	int decimal, sign;
	float f = 0.1234f;
	char* foo = _fcvt(f, 2, &decimal, &sign);
	MessageBox(NULL, foo, "test", MB_OK);

	for (int i=0; i < n; i++) {
		char* c1 = _fcvt(pf[i], 2, &decimal, &sign);
		MessageBox(NULL, c1, "0", MB_OK);
	}

}

//This is not part of OpenGL, but for debugging array-passing.
extern "C" _declspec(dllexport)
int reverse_array (int n, float* x)
{
	print_array(n, x);

	float f;
	for (int i=0; i < n/2; i++) {
		f = x[i];
		x[i] = x[n-1-i];
		x[n-1-i] = f;
	}
	return n;
}



extern "C" _declspec(dllexport)
void glclearindex (float f)
{
	glClearIndex(f);
}


extern "C" _declspec(dllexport)
void glindexmask (int x1)
{
	glIndexMask(x1);
}

extern "C" _declspec(dllexport)
void glcolormask (int  x1)
{
	glcolormask (x1);
}

extern "C" _declspec(dllexport)
void glalphafunc (int n, float f)
{
	glAlphaFunc(n, f);
}


extern "C" _declspec(dllexport)
void glblendfunc (int n1, int n2)
{
	glBlendFunc(n1, n2);
}

extern "C" _declspec(dllexport)
void gllogicop (int n)
{
	glLogicOp(n);
}

extern "C" _declspec(dllexport)
VOID glpolygonmode (int n1, int n2)
{
	glpolygonmode(n1, n2);
}

extern "C" _declspec(dllexport)
void glcullface (int n) 
{
	glCullFace(n);
}

extern "C" _declspec(dllexport)
void glfrontface (int n) 
{
	glFrontFace(n);
}

extern "C" _declspec(dllexport)
void glpointsize (float f) 
{
	glPointSize(f);
}

extern "C" _declspec(dllexport)
void gllinewidth (float f) 
{
	glLineWidth(f);
}

extern "C" _declspec(dllexport)
void gllinestipple (int n, unsigned short s)
{
	glLineStipple(n, s);
}

extern "C" _declspec(dllexport)
void glpolygonstipple (unsigned char* mask)
{
	glPolygonStipple(mask);
}

extern "C" _declspec(dllexport)
void glgetpolygonstipple (unsigned char* mask)
{
	glGetPolygonStipple(mask);
}

extern "C" _declspec(dllexport)
void gledgeflag (unsigned char c)
{
	glEdgeFlag(c);
}

extern "C" _declspec(dllexport)
void gledgeflagv (unsigned char* p)
{
	glEdgeFlagv(p);
}

extern "C" _declspec(dllexport)
void glscissor (int n1, int n2, int n3, int n4)
{
	glScissor(n1, n2, n3, n4);
}

extern "C" _declspec(dllexport)
void glclipplane (int n, double* p)
{
	glClipPlane(n, p);
}

extern "C" _declspec(dllexport)
void glgetclipplane (int n, double* p)
{
	glGetClipPlane(n, p);
}

extern "C" _declspec(dllexport)
void gldrawbuffer (int n) 
{
	glDrawBuffer(n);
}

extern "C" _declspec(dllexport)
void glreadbuffer (int n) 
{
	glReadBuffer(n);
}


extern "C" _declspec(dllexport)
void gldisable (int n)
{
	glDisable(n);
}


extern "C" _declspec(dllexport)
unsigned char glisenabled (int n)
{
	return glIsEnabled(n);
}

extern "C" _declspec(dllexport)
void glgetbooleanv (int n, unsigned char* p)
{
	glGetBooleanv(n, p);
}

extern "C" _declspec(dllexport)
void glgetdoublev (int n, double* p)
{
	glGetDoublev(n, p);
}

extern "C" _declspec(dllexport)
void glgetfloatv (int n, float* p)
{
	glGetFloatv(n, p);
}

extern "C" _declspec(dllexport)
void glgetintegerv (int n, int* p)
{
	glGetIntegerv(n, p);
}

extern "C" _declspec(dllexport)
void glpushattrib (int n) 
{
	glPushAttrib(n);
}

extern "C" _declspec(dllexport)
void glpopattrib () 
{
	glPopAttrib();
}

extern "C" _declspec(dllexport)
int glrendermode (int n) 
{
	return glRenderMode(n);
}

extern "C" _declspec(dllexport)
int glgeterror ()
{
	return glGetError();
}

extern "C" _declspec(dllexport)
const unsigned char* glgetstring (int n)
{
	return glGetString(n);
}

extern "C" _declspec(dllexport)
void glfinish () 
{
	glFinish();
}


extern "C" _declspec(dllexport)
void glhint (int n1, int n2)
{	
	glHint(n1, n2);
}


extern "C" _declspec(dllexport)
void gldepthfunc (int n) 
{
	glDepthFunc(n);
}

extern "C" _declspec(dllexport)
void gldepthmask (unsigned char c)
{
	glDepthMask(c);
}

extern "C" _declspec(dllexport)
void gldepthrange (double d1, double d2)
{	
	glDepthRange(d1, d2);
}

extern "C" _declspec(dllexport)
void glclearaccum (float f1, float f2, float f3, float f4)
{	
	glClearAccum(f1, f2, f3, f4);
}

extern "C" _declspec(dllexport)
void glaccum (int n, float f)
{
	glAccum(n, f);
}



extern "C" _declspec(dllexport)
void glfrustum (double d1, double d2, double d3, double d4, double d5, double d6) 
{
	glFrustum(d1, d2, d3, d4, d5, d6);
}

extern "C" _declspec(dllexport)
void glloadmatrixd (double* p) 
{
	glLoadMatrixd(p);
}

extern "C" _declspec(dllexport)
void glloadmatrixf (float* p) 
{
	glLoadMatrixf(p) ;
}

extern "C" _declspec(dllexport)
void glmultmatrixd (double* p) 
{
	glMultMatrixd(p);
}

extern "C" _declspec(dllexport)
void glmultmatrixf (float* p) 
{
	glMultMatrixf(p) ;
}

extern "C" _declspec(dllexport)
void glrotated (double d1, double d2, double d3, double d4) 
{
	glRotated(d1, d2, d3, d4);
}

extern "C" _declspec(dllexport)
void glrotatef (float f1, float f2, float f3, float f4) 
{
	glRotatef(f1, f2, f3, f4);
}
	
extern "C" _declspec(dllexport)
void glscaled (double d1, double d2, double d3) 
{
	glScaled(d1, d2, d3);
}


extern "C" _declspec(dllexport)
void glscalef (float f1, float f2, float f3) 
{
	glScalef(f1, f2, f3) ;
}

extern "C" _declspec(dllexport)
void gltranslated (double d1, double d2, double d3) 
{
	glTranslated(d1, d2, d3);
}

extern "C" _declspec(dllexport)
void gltranslatef (float f1, float f2, float f3) 
{
	glTranslatef(f1, f2, f3) ;
}

extern "C" _declspec(dllexport)
unsigned char glislist (unsigned int u)
{
	return glIsList(u);
}
extern "C" _declspec(dllexport)
void gldeletelists (unsigned int u, int n) 
{
	glDeleteLists(u, n);
}

extern "C" _declspec(dllexport)
unsigned int function (int n)
{
	return glGenLists(n);
}

extern "C" _declspec(dllexport)
void glnewlist (unsigned int u,  int n) 
{
	glNewList(u, n);
}

extern "C" _declspec(dllexport)
void glendlist () 
{
	glEndList();
}

extern "C" _declspec(dllexport)
void glcalllist (unsigned int u) 
{
	glCallList(u);
}

extern "C" _declspec(dllexport)
void glcalllists (int n1, int n2, void* p) 
{
	glCallLists(n1, n2, p);
}


extern "C" _declspec(dllexport)
void gllistbase (unsigned int u) 
{
	glListBase(u);
}





extern "C" _declspec(dllexport)
void glvertex2d (double d1, double d2) 
{
	glVertex2d(d1, d2);
}

extern "C" _declspec(dllexport)
void glvertex2f (float f1, float f2) 
{
	glVertex2f(f1, f2);
}

extern "C" _declspec(dllexport)
void glvertex2i (int n1, int n2) 
{
	glVertex2i(n1, n2);
}

extern "C" _declspec(dllexport)
void glvertex2s (short s1, short s2) 
{
	glVertex2s(s1, s2);
}

extern "C" _declspec(dllexport)
void glvertex3d (double d1, double d2, double d3) 
{
	glVertex3d(d1, d2, d3);
}

extern "C" _declspec(dllexport)
void glvertex3f (float f1, float f2, float f3) 
{
	glVertex3f(f1, f2, f3);
}

extern "C" _declspec(dllexport)
void glvertex3i (int n1, int n2, int n3) 
{
	glVertex3i(n1, n2, n3);
}

extern "C" _declspec(dllexport)
void glvertex3s (short s1, short s2, short s3) 
{
	glVertex3s(s1, s2, s3);
}

extern "C" _declspec(dllexport)
void glvertex4d (double d1, double d2, double d3, double d4) 
{
	glVertex4d(d1, d2, d3, d4);
}

extern "C" _declspec(dllexport)
void glvertex4f (float f1, float f2, float f3, float f4) 
{
	glVertex4f(f1, f2, f3, f4);
}

extern "C" _declspec(dllexport)
void glvertex4i (int n1, int n2, int n3, int n4) 
{
	glVertex4i(n1, n2, n3, n4);
}

extern "C" _declspec(dllexport)
void glvertex4s (short s1, short s2, short s3, short s4) 
{
	glVertex4s(s1, s2, s3, s4);
}

extern "C" _declspec(dllexport)
void glvertex2dv (double* p) 
{
	glVertex2dv(p);
}

extern "C" _declspec(dllexport)
void glvertex2fv (float* p) 
{
	glVertex2fv(p);
}

extern "C" _declspec(dllexport)
void glvertex2iv (int* p) 
{
	glVertex2iv(p);
}

extern "C" _declspec(dllexport)
void glvertex2sv (short* p) 
{
	glVertex2sv(p);
}

extern "C" _declspec(dllexport)
void glvertex3dv (double* p) 
{
	glVertex3dv(p);
}

extern "C" _declspec(dllexport)
void glvertex3fv (float* p) 
{
	glVertex3fv(p);
}

extern "C" _declspec(dllexport)
void glvertex3iv (int* p) 
{
	glVertex3iv(p);
}

extern "C" _declspec(dllexport)
void glvertex3sv (short* p) 
{
	glVertex3sv(p);
}

extern "C" _declspec(dllexport)
void glvertex4dv (double* p) 
{
	glVertex4dv(p);
}

extern "C" _declspec(dllexport)
void glvertex4fv (float* p) 
{
	glVertex4fv(p);
}

extern "C" _declspec(dllexport)
void glvertex4iv (int* p) 
{
	glVertex4iv(p);
}

extern "C" _declspec(dllexport)
void glvertex4sv (short* p) 
{
	glVertex4sv(p);
}


extern "C" _declspec(dllexport)
void glnormal3b (signed char c1, signed char c2, signed char c3) 
{
	glNormal3b(c1, c2, c3);
}

extern "C" _declspec(dllexport)
void glnormal3d (double d1, double d2, double d3) 
{
	glNormal3d(d1, d2, d3);
}

extern "C" _declspec(dllexport)
void glnormal3f (float f1, float f2, float f3) 
{
	glNormal3f(f1, f2, f3);
}

extern "C" _declspec(dllexport)
void glnormal3i (int n1, int n2, int n3) 
{
	glNormal3i(n1, n2, n3);
}

extern "C" _declspec(dllexport)
void glnormal3s (short s1, short s2, short s3) 
{
	glNormal3s(s1, s2, s3);
}

extern "C" _declspec(dllexport)
void glnormal3bv (signed char* p) 
{
	glNormal3bv(p);
}

extern "C" _declspec(dllexport)
void glnormal3dv (double* p) 
{
	glNormal3dv(p);
}

extern "C" _declspec(dllexport)
void glnormal3fv (float* p) 
{
	glNormal3fv(p);
}

extern "C" _declspec(dllexport)
void glnormal3iv (int* p) 
{
	glNormal3iv(p);
}

extern "C" _declspec(dllexport)
void glnormal3sv (short* p) 
{
	glNormal3sv(p);
}

extern "C" _declspec(dllexport)
void glindexd (double d) 
{
	glIndexd(d);
}

extern "C" _declspec(dllexport)
void glindexf (float f) 
{
	glIndexf(f);
}

extern "C" _declspec(dllexport)
void glindexi (int n) 
{
	glIndexi(n);
}

extern "C" _declspec(dllexport)
void glindexs (short s) 
{
	glIndexs(s);
}

extern "C" _declspec(dllexport)
void glindexdv (double* p) 
{
	glIndexdv(p);
}

extern "C" _declspec(dllexport)
void glindexfv (float* p) 
{
	glIndexfv(p);
}

extern "C" _declspec(dllexport)
void glindexiv (int* p) 
{
	glIndexiv(p);
}

extern "C" _declspec(dllexport)
void glindexsv (short* p) 
{
	glIndexsv(p);
}

extern "C" _declspec(dllexport)
void glcolor3b (signed char c1, signed char c2, signed char c3) 
{
	glColor3b(c1, c2, c3);
}

extern "C" _declspec(dllexport)
void glcolor3d (double d1, double d2, double d3) 
{
	glColor3d(d1, d2, d3);
}

extern "C" _declspec(dllexport)
void glcolor3f (float f1, float f2, float f3) 
{
	glColor3f(f1, f2, f3);
}

extern "C" _declspec(dllexport)
void glcolor3i (int n1, int n2, int n3) 
{
	glColor3i(n1, n2, n3);
}

extern "C" _declspec(dllexport)
void glcolor3s (short s1, short s2, short s3) 
{
	glColor3s(s1, s2, s3);
}

extern "C" _declspec(dllexport)
void glcolor3ub (unsigned char u1, unsigned char u2, unsigned char u3) 
{
	glColor3ub(u1, u2, u3);
}

extern "C" _declspec(dllexport)
void glcolor3ui (unsigned int n1, unsigned int n2, unsigned int n3) 
{
	glColor3ui(n1, n2, n3);
}

extern "C" _declspec(dllexport)
void glcolor3us (unsigned short s1, unsigned short s2, unsigned short s3) 
{
	glColor3us(s1, s2, s3);
}

extern "C" _declspec(dllexport)
void glcolor4b (signed char c1, signed char c2, signed char c3, signed char c4) 
{
	glColor4b(c1, c2, c3, c4);
}

extern "C" _declspec(dllexport)
void glcolor4d (double d1, double d2, double d3, double d4) 
{
	glColor4d(d1, d2, d3, d4);
}

extern "C" _declspec(dllexport)
void glcolor4f (float f1, float f2, float f3, float f4) 
{
	glColor4f(f1, f2, f3, f4);
}

extern "C" _declspec(dllexport)
void glcolor4i (int n1, int n2, int n3, int n4) 
{
	glColor4i(n1, n2, n3, n4);
}

extern "C" _declspec(dllexport)
void glcolor4s (short s1, short s2, short s3, short s4) 
{
	glColor4s(s1, s2, s3, s4);
}

extern "C" _declspec(dllexport)
void glcolor4ub (unsigned char c1, unsigned char c2, unsigned char c3, unsigned char c4) 
{
	glColor4ub(c1, c2, c3, c4);
}

extern "C" _declspec(dllexport)
void glcolor4ui (unsigned int n1, unsigned int n2, unsigned int n3, unsigned int n4) 
{
	glColor4ui(n1, n2, n3, n4);
}

extern "C" _declspec(dllexport)
void glcolor4us (unsigned short s1, unsigned short s2, unsigned short s3, unsigned short s4) 
{
	glColor4us(s1, s2, s3, s4);
}

extern "C" _declspec(dllexport)
void glcolor3bv (signed char* p) 
{
	glColor3bv(p);
}

extern "C" _declspec(dllexport)
void glcolor3dv (double* p) 
{
	glColor3dv(p);
}

extern "C" _declspec(dllexport)
void glcolor3fv (float* p) 
{
	glColor3fv(p);
}

extern "C" _declspec(dllexport)
void glcolor3iv (int* p) 
{
	glColor3iv(p);
}

extern "C" _declspec(dllexport)
void glcolor3sv (short* p) 
{
	glColor3sv(p);
}

extern "C" _declspec(dllexport)
void glcolor3ubv (unsigned char* p) 
{
	glColor3ubv(p);
}

extern "C" _declspec(dllexport)
void glcolor3uiv (unsigned int* p) 
{
	glColor3uiv(p);
}

extern "C" _declspec(dllexport)
void glcolor3usv (unsigned short* p) 
{
	glColor3usv(p);
}

extern "C" _declspec(dllexport)
void glcolor4bv (signed char* p) 
{
	glColor4bv(p);
}

extern "C" _declspec(dllexport)
void glcolor4dv (double* p) 
{
	glColor4dv(p);
}

extern "C" _declspec(dllexport)
void glcolor4fv (float* p) 
{
	glColor4fv(p);
}

extern "C" _declspec(dllexport)
void glcolor4iv (int* p) 
{
	glColor4iv(p);
}

extern "C" _declspec(dllexport)
void glcolor4sv (short* p) 
{
	glColor4sv(p);
}

extern "C" _declspec(dllexport)
void glcolor4ubv (unsigned char* p) 
{
	glColor4ubv(p);
}

extern "C" _declspec(dllexport)
void glcolor4uiv (unsigned int* p) 
{
	glColor4uiv(p);
}

extern "C" _declspec(dllexport)
void glcolor4usv (unsigned short* p) 
{
	glColor4usv(p);
}

extern "C" _declspec(dllexport)
void gltexcoord1d (double d) 
{
	glTexCoord1d(d);
}


extern "C" _declspec(dllexport)
void gltexcoord1f (float f) 
{
	glTexCoord1f(f);
}

extern "C" _declspec(dllexport)
void gltexcoord1i (int n) 
{
	glTexCoord1i(n);
}

extern "C" _declspec(dllexport)
void gltexcoord1s (short s) 
{
	glTexCoord1s(s);
}

extern "C" _declspec(dllexport)
void gltexcoord2d (double d1, double d2) 
{
	glTexCoord2d(d1, d2);
}

extern "C" _declspec(dllexport)
void gltexcoord2f (float f1, float f2) 
{
	glTexCoord2f(f1, f2);
}

extern "C" _declspec(dllexport)
void gltexcoord2i (int n1, int n2) 
{
	glTexCoord2i(n1, n2);
}

extern "C" _declspec(dllexport)
void gltexcoord2s (short s1, short s2) 
{
	glTexCoord2s(s1, s2);
}

extern "C" _declspec(dllexport)
void gltexcoord3d (double d1, double d2, double d3) 
{
	glTexCoord3d(d1, d2, d3);
}

extern "C" _declspec(dllexport)
void gltexcoord3f (float f1, float f2, float f3) 
{
	glTexCoord3f(f1, f2, f3);
}

extern "C" _declspec(dllexport)
void gltexcoord3i (int n1, int n2, int n3) 
{
	glTexCoord3i(n1, n2, n3);
}

extern "C" _declspec(dllexport)
void gltexcoord3s (short s1, short s2, short s3) 
{
	glTexCoord3s(s1, s2, s3);
}

extern "C" _declspec(dllexport)
void gltexcoord4d (double d1, double d2, double d3, double d4) 
{
	glTexCoord4d(d1, d2, d3, d4);
}

extern "C" _declspec(dllexport)
void gltexcoord4f (float f1, float f2, float f3, float f4) 
{
	glTexCoord4f(f1, f2, f3, f4);
}

extern "C" _declspec(dllexport)
void gltexcoord4i (int n1, int n2, int n3, int n4) 
{
	glTexCoord4i(n1, n2, n3, n4);
}

extern "C" _declspec(dllexport)
void gltexcoord4s (short s1, short s2, short s3, short s4) 
{
	glTexCoord4s(s1, s2, s3, s4);
}

extern "C" _declspec(dllexport)
void gltexcoord1dv (double* p) 
{
	glTexCoord1dv(p);
}

extern "C" _declspec(dllexport)
void gltexcoord1fv (float* p) 
{
	glTexCoord1fv(p);
}

extern "C" _declspec(dllexport)
void gltexcoord1iv (int* p) 
{
	glTexCoord1iv(p);
}

extern "C" _declspec(dllexport)
void gltexcoord1sv (short* p) 
{
	glTexCoord1sv(p);
}

extern "C" _declspec(dllexport)
void gltexcoord2dv (double* p) 
{
	glTexCoord2dv(p);
}

extern "C" _declspec(dllexport)
void gltexcoord2fv (float* p) 
{
	glTexCoord2fv(p);
}

extern "C" _declspec(dllexport)
void gltexcoord2iv (int* p) 
{
	glTexCoord2iv(p);
}

extern "C" _declspec(dllexport)
void gltexcoord2sv (short* p) 
{
	glTexCoord2sv(p);
}

extern "C" _declspec(dllexport)
void gltexcoord3dv (double* p) 
{
	glTexCoord3dv(p);
}

extern "C" _declspec(dllexport)
void gltexcoord3fv (float* p) 
{
	glTexCoord3fv(p);
}

extern "C" _declspec(dllexport)
void gltexcoord3iv (int* p) 
{
	glTexCoord3iv(p);
}

extern "C" _declspec(dllexport)
void gltexcoord3sv (short* p) 
{
	glTexCoord3sv(p);
}

extern "C" _declspec(dllexport)
void gltexcoord4dv (double* p) 
{
	glTexCoord4dv(p);
}

extern "C" _declspec(dllexport)
void gltexcoord4fv (float* p) 
{
	glTexCoord4fv(p);
}

extern "C" _declspec(dllexport)
void gltexcoord4iv (int* p) 
{
	glTexCoord4iv(p);
}

extern "C" _declspec(dllexport)
void gltexcoord4sv (short* p) 
{
	glTexCoord4sv(p);
}

extern "C" _declspec(dllexport)
void glrasterpos2d (double d1, double d2) 
{
	glRasterPos2d(d1, d2);
}

extern "C" _declspec(dllexport)
void glrasterpos2f (float f1, float f2) 
{
	glRasterPos2f(f1, f2);
}

extern "C" _declspec(dllexport)
void glrasterpos2i (int n1, int n2) 
{
	glRasterPos2i(n1, n2);
}

extern "C" _declspec(dllexport)
void glrasterpos2s (short s1, short s2) 
{
	glRasterPos2s(s1, s2);
}

extern "C" _declspec(dllexport)
void glrasterpos3d (double d1, double d2, double d3) 
{
	glRasterPos3d(d1, d2, d3);
}

extern "C" _declspec(dllexport)
void glrasterpos3f (float f1, float f2, float f3) 
{
	glRasterPos3f(f1, f2, f3);
}

extern "C" _declspec(dllexport)
void glrasterpos3i (int n1, int n2, int n3) 
{
	glRasterPos3i(n1, n2, n3);
}

extern "C" _declspec(dllexport)
void glrasterpos3s (short s1, short s2, short s3) 
{
	glRasterPos3s(s1, s2, s3);
}

extern "C" _declspec(dllexport)
void glrasterpos4d (double d1, double d2, double d3, double d4) 
{
	glRasterPos4d(d1, d2, d3, d4);
}

extern "C" _declspec(dllexport)
void glrasterpos4f (float f1, float f2, float f3, float f4) 
{
	glRasterPos4f(f1, f2, f3, f4);
}

extern "C" _declspec(dllexport)
void glrasterpos4i (int n1, int n2, int n3, int n4) 
{
	glRasterPos4i(n1, n2, n3, n4);
}

extern "C" _declspec(dllexport)
void glrasterpos4s (short s1, short s2, short s3, short s4) 
{
	glRasterPos4s(s1, s2, s3, s4);
}

extern "C" _declspec(dllexport)
void glrasterpos2dv (double* p) 
{
	glRasterPos2dv(p);
}

extern "C" _declspec(dllexport)
void glrasterpos2fv (float* p) 
{
	glRasterPos2fv(p);
}

extern "C" _declspec(dllexport)
void glrasterpos2iv (int* p) 
{
	glRasterPos2iv(p);
}

extern "C" _declspec(dllexport)
void glrasterpos2sv (short* p) 
{
	glRasterPos2sv(p);
}

extern "C" _declspec(dllexport)
void glrasterpos3dv (double* p) 
{
	glRasterPos3dv(p);
}

extern "C" _declspec(dllexport)
void glrasterpos3fv (float* p) 
{
	glRasterPos3fv(p);
}

extern "C" _declspec(dllexport)
void glrasterpos3iv (int* p) 
{
	glRasterPos3iv(p);
}

extern "C" _declspec(dllexport)
void glrasterpos3sv (short* p) 
{
	glRasterPos3sv(p);
}

extern "C" _declspec(dllexport)
void glrasterpos4dv (double* p) 
{
	glRasterPos4dv(p);
}

extern "C" _declspec(dllexport)
void glrasterpos4fv (float* p) 
{
	glRasterPos4fv(p);
}

extern "C" _declspec(dllexport)
void glrasterpos4iv (int* p) 
{
	glRasterPos4iv(p);
}

extern "C" _declspec(dllexport)
void glrasterpos4sv (short* p) 
{
	glRasterPos4sv(p);
}


extern "C" _declspec(dllexport)
void glrectd (double d1, double d2, double d3, double d4) 
{
	glRectd(d1, d2, d3, d4);
}

extern "C" _declspec(dllexport)
void glrectf (float f1, float f2, float f3, float f4) 
{
	glRectf(f1, f2, f3, f4);
}

extern "C" _declspec(dllexport)
void glrecti (int n1, int n2, int n3, int n4) 
{
	glRecti(n1, n2, n3, n4);
}

extern "C" _declspec(dllexport)
void glrects (short s1, short s2, short s3, short s4)
{
	glRects(s1, s2, s3, s4);
}

extern "C" _declspec(dllexport)
void glrectdv (double* p1,  double* p2) 
{
	glRectdv(p1, p2);
}

extern "C" _declspec(dllexport)
void glrectfv (float* p1, float* p2) 
{
	glRectfv(p1, p2);
}

extern "C" _declspec(dllexport)
void glrectiv (int* p1, int* p2) 
{
	glRectiv(p1, p2);
}

extern "C" _declspec(dllexport)
void glrectsv (short* p1, short* p2) 
{
	glRectsv(p1, p2);
}

extern "C" _declspec(dllexport)
void glshademodel (int n) 
{
	glShadeModel(n);
}

extern "C" _declspec(dllexport)
void gllightf (int n1, int n2, float f) 
{
	glLightf(n1, n2, f);
}

extern "C" _declspec(dllexport)
void gllighti (int n1, int n2, int n3) 
{
	glLighti(n1, n2, n3);
}

extern "C" _declspec(dllexport)
void gllightfv (int n1, int n2, float* p) 
{
	glLightfv(n1, n2, p);
}

extern "C" _declspec(dllexport)
void gllightiv (int n1, int n2, int* p) 
{
	glLightiv(n1, n2, p);
}

extern "C" _declspec(dllexport)
void glgetlightfv (int n1, int n2, float* p) 
{
	glGetLightfv(n1, n2, p);
}

extern "C" _declspec(dllexport)
void glgetlightiv (int n1, int n2, int* p) 
{
	glGetLightiv(n1, n2, p);
}

extern "C" _declspec(dllexport)
void gllightmodelf (int n, float f) 
{
	glLightModelf(n, f);
}

extern "C" _declspec(dllexport)
void gllightmodeli (int n1, int n2) 
{
	glLightModeli(n1, n2);
}

extern "C" _declspec(dllexport)
void gllightmodelfv (int n1, float* p) 
{
	glLightModelfv(n1, p);
}

extern "C" _declspec(dllexport)
void gllightmodeliv (int n, int* p) 
{
	glLightModeliv(n, p);
}

extern "C" _declspec(dllexport)
void glmaterialf (int n1, int n2, float f) 
{
	glMaterialf(n1, n2, f);
}

extern "C" _declspec(dllexport)
void glmateriali (int n1, int n2, int n3) 
{
	glMateriali(n1, n2, n3);
}

extern "C" _declspec(dllexport)
void glmaterialfv (int n1, int n2, float* p) 
{
	glMaterialfv(n1, n2, p);
}

extern "C" _declspec(dllexport)
void glmaterialiv (int n1, int n2, int* p) 
{
	glMaterialiv(n1, n2, p);
}

extern "C" _declspec(dllexport)
void glgetmaterialfv (int n1, int n2, float* p) 
{
	glGetMaterialfv(n1, n2, p);
}

extern "C" _declspec(dllexport)
void glgetmaterialiv (int n1, int n2, int* p) 
{
	glGetMaterialiv(n1, n2, p);
}

extern "C" _declspec(dllexport)
void glcolormaterial (int n1, int n2) 
{
	glColorMaterial(n1, n2);
}

extern "C" _declspec(dllexport)
void glpixelzoom (float f1, float f2) 
{
	glPixelZoom(f1, f2);
}

extern "C" _declspec(dllexport)
void glpixelstoref (int n, float f) 
{
	glPixelStoref(n ,f);
}

extern "C" _declspec(dllexport)
void glpixelstorei (int n1, int n2) 
{
	glPixelStorei(n1, n2);
}

extern "C" _declspec(dllexport)
void glpixeltransferf (int n, float f) 
{
	glPixelTransferf(n, f);
}


extern "C" _declspec(dllexport)
void glpixeltransferi (int n1, int n2) 
{
	glPixelTransferi(n1, n2);
}

extern "C" _declspec(dllexport)
void glpixelmapfv (int n1, int n2, float* p) 
{
	glPixelMapfv(n1, n2, p);
}

extern "C" _declspec(dllexport)
void glpixelmapuiv (int n1, int n2, unsigned int* p) 
{
	glPixelMapuiv(n1, n2, p);
}

extern "C" _declspec(dllexport)
void glpixelmapusv (int n1, int n2, unsigned short* p) 
{
	glPixelMapusv(n1, n2, p);
}

extern "C" _declspec(dllexport)
void glgetpixelmapfv (int n1, float* p) 
{
	glGetPixelMapfv(n1, p);
}

extern "C" _declspec(dllexport)
void glgetpixelmapuiv (int n1, unsigned int* p) 
{
	glGetPixelMapuiv(n1, p);
}

extern "C" _declspec(dllexport)
void glgetpixelmapusv (int n, unsigned short* p) 
{
	glGetPixelMapusv(n, p);
}

extern "C" _declspec(dllexport)
void glbitmap (int n1, int n2, float f1, float f2, float f3, float f4, unsigned char* p) 
{
	glBitmap(n1, n2, f1, f2, f3, f4, p);
}

extern "C" _declspec(dllexport)
void glreadpixels (int n1, int n2, int n3, int n4, int n5, int n6, void* p) 
{
	glReadPixels(n1, n2, n3, n4, n5, n6, p);
}

extern "C" _declspec(dllexport)
void gldrawpixels (int n1, int n2, int n3, int n4, void* p) 
{
	glDrawPixels(n1, n2, n3, n4, p);
}

extern "C" _declspec(dllexport)
void glcopypixels (int n1, int n2, int n3, int n4, int n5) 
{
	glCopyPixels(n1, n2, n3, n4, n5);
}

extern "C" _declspec(dllexport)
void glstencilfunc (int n1, int n2, unsigned int u) 
{
	glStencilFunc(n1, n2, u);
}

extern "C" _declspec(dllexport)
void glstencilmask (unsigned int u) 
{
	glStencilMask(u);
}

extern "C" _declspec(dllexport)
void glstencilop (int n1, int n2, int n3) 
{
	glStencilOp(n1, n2, n3);
}

extern "C" _declspec(dllexport)
void glclearstencil (int n) 
{
	glClearStencil(n);
}

extern "C" _declspec(dllexport)
void gltexgend (int n1, int n2, double d) 
{
	glTexGend(n1, n2, d);
}

extern "C" _declspec(dllexport)
void gltexgenf (int n1, int n2, float f) 
{
	glTexGenf(n1, n2, f);
}

extern "C" _declspec(dllexport)
void gltexgeni (int n1, int n2, int n3) 
{
	glTexGeni(n1, n2, n3);
}

extern "C" _declspec(dllexport)
void gltexgendv (int n1, int n2, double* p) 
{
	glTexGendv(n1, n2, p);
}

extern "C" _declspec(dllexport)
void gltexgenfv (int n1, int n2, float* p) 
{
	glTexGenfv(n1, n2, p);
}

extern "C" _declspec(dllexport)
void gltexgeniv (int n1, int n2, int* p) 
{
	glTexGeniv(n1, n2, p);
}

extern "C" _declspec(dllexport)
void glgettexgendv (int n1, int n2, double* p) 
{
	glGetTexGendv(n1, n2, p);
}

extern "C" _declspec(dllexport)
void glgettexgenfv (int n1, int n2, float* p) 
{
	glGetTexGenfv(n1, n2, p);
}

extern "C" _declspec(dllexport)
void glgettexgeniv (int n1, int n2, int* p) 
{
	glGetTexGeniv(n1, n2, p);
}

extern "C" _declspec(dllexport)
void gltexenvf (int n1, int n2, float f) 
{
	glTexEnvf(n1, n2, f);
}

extern "C" _declspec(dllexport)
void gltexenvi (int n1, int n2, int n3) 
{
	glTexEnvi(n1, n2, n3);
}

extern "C" _declspec(dllexport)
void gltexenvfv (int n1, int n2, float* p) 
{
	glTexEnvfv(n1, n2, p);
}

extern "C" _declspec(dllexport)
void gltexenviv (int n1, int n2, int* p) 
{
	glTexEnviv(n1, n2, p);
}

extern "C" _declspec(dllexport)
void glgettexenvfv (int n1, int n2, float* p) 
{
	glGetTexEnvfv(n1, n2, p);
}

extern "C" _declspec(dllexport)
void glgettexenviv (int n1, int n2, int* p) 
{
	glGetTexEnviv(n1, n2, p);
}

extern "C" _declspec(dllexport)
void  gltexparameterf (int n1, int n2, float f) 
{
	glTexParameterf(n1, n2 ,f);
}

extern "C" _declspec(dllexport)
void gltexparameteri (int n1, int n2, int n3) 
{
	glTexParameteri(n1, n2, n3);
}

extern "C" _declspec(dllexport)
void gltexparameterfv (int n1, int n2, float* p) 
{
	glTexParameterfv(n1, n2, p);
}

extern "C" _declspec(dllexport)
void gltexparameteriv (int n1, int n2, int* p) 
{
	glTexParameteriv(n1, n2, p);
}

extern "C" _declspec(dllexport)
void glgettexparameterfv (int n1, int n2, float* p) 
{
	glGetTexParameterfv(n1, n2, p);
}

extern "C" _declspec(dllexport)
void glgettexparameteriv (int n1, int n2, int* p) 
{
	glGetTexParameteriv(n1, n2, p);
}

extern "C" _declspec(dllexport)
void glgettexlevelparameterfv (int n1, int n2, int n3, float* p) 
{
	glGetTexLevelParameterfv(n1, n2, n3, p);
}

extern "C" _declspec(dllexport)
void glgettexlevelparameteriv (int n1, int n2, int n3, int* p) 
{
	glGetTexLevelParameteriv(n1, n2, n3, p);
}

extern "C" _declspec(dllexport)
void glteximage1d (int n1, int n2, int n3, int n4, int n5, int n6, int n7, void* p) 
{
	glTexImage1D(n1, n2, n3, n4, n5, n6, n7, p);
}

extern "C" _declspec(dllexport)
void glteximage2d (int n1, int n2, int n3, int n4, int n5, int n6, int n7, int n8, void* p) 
{
	glTexImage2D(n1, n2, n3, n4, n5, n6, n7, n8, p);
}

extern "C" _declspec(dllexport)
void glgetteximage (int n1, int n2, int n3, int n4, void* p) 
{
	glGetTexImage(n1, n2, n3, n4, p);
}

extern "C" _declspec(dllexport)
void glmap1d (int n1, double d1, double d2, int n2, int n3, double* p) 
{
	glMap1d(n1, d1, d2, n2, n3, p);
}

extern "C" _declspec(dllexport)
void glmap1f (int n1, float f1, float f2, int n2, int n3, float* p) 
{
	glMap1f(n1, f1, f2, n2, n3, p);
}

extern "C" _declspec(dllexport)
void glmap2d (int n1, double d1, double d2, int n2, int n3, double d3, double d4, int n4, int n5, double* p) 
{
	glMap2d(n1, d1, d2, n2, n3, d3, d4, n4, n5, p);
}

extern "C" _declspec(dllexport)
void glmap2f (int n1, float f1, float f2, int n2, int n3, float f3, float f4, int n4, int n5, float* p) 
{
	glMap2f(n1, f1, f2, n2, n3, f3, f4, n4, n5, p);
}

extern "C" _declspec(dllexport)
void glgetmapdv (int n1, int n2, double* p) 
{
	glGetMapdv(n1, n2, p);
}

extern "C" _declspec(dllexport)
void glgetmapfv (int n1, int n2, float* p) 
{
	glGetMapfv(n1, n2, p);
}

extern "C" _declspec(dllexport)
void glgetmapiv (int n1, int n2, int* p) 
{
	glGetMapiv(n1, n2, p);
}

extern "C" _declspec(dllexport)
void glevalcoord1d (double d) 
{
	glEvalCoord1d(d);
}

extern "C" _declspec(dllexport)
void glevalcoord1f (float f) 
{
	glEvalCoord1f(f);
}

extern "C" _declspec(dllexport)
void glevalcoord1dv (double* p) 
{
	glEvalCoord1dv(p);
}

extern "C" _declspec(dllexport)
void glevalcoord1fv (float* p) 
{
	glEvalCoord1fv(p);
}

extern "C" _declspec(dllexport)
void glevalcoord2d (double d1, double d2) 
{
	glEvalCoord2d(d1, d2);
}

extern "C" _declspec(dllexport)
void glevalcoord2f (float f1, float f2) 
{
	glEvalCoord2f(f1, f2);
}

extern "C" _declspec(dllexport)
void glevalcoord2dv (double* p) 
{
	glEvalCoord2dv(p);
}

extern "C" _declspec(dllexport)
void glevalcoord2fv (float* p) 
{
	glEvalCoord2fv(p);
}

extern "C" _declspec(dllexport)
void glmapgrid1d (int n1, double d1, double d2) 
{
	glMapGrid1d(n1, d1, d2);
}

extern "C" _declspec(dllexport)
void glmapgrid1f (int n1, float f1, float f2) 
{
	glMapGrid1f(n1, f1, f2);
}

extern "C" _declspec(dllexport)
void glmapgrid2d (int n1, double d1, double d2, int n2, double d3, double d4) 
{
	glMapGrid2d(n1, d1, d2, n2, d3, d4);
}

extern "C" _declspec(dllexport)
void glmapgrid2f (int n1, float f1, float f2, int n2, float f3, float f4) 
{
	glMapGrid2f(n1, f1, f2, n2, f3, f4);
}

extern "C" _declspec(dllexport)
void glevalpoint1 (int n) 
{
	glEvalPoint1(n);
}

extern "C" _declspec(dllexport)
void glevalpoint2 (int n1, int n2) 
{
	glEvalPoint2(n1, n2);
}

extern "C" _declspec(dllexport)
void glevalmesh1 (int n1, int n2, int n3) 
{
	glEvalMesh1(n1, n2, n3);
}

extern "C" _declspec(dllexport)
void glevalmesh2 (int n1, int n2, int n3, int n4, int n5) 
{
	glEvalMesh2(n1, n2, n3, n4, n5);
}

extern "C" _declspec(dllexport)
void glfogf (int n, float f) 
{
	glFogf(n, f);
}

extern "C" _declspec(dllexport)
void glfogi (int n1, int n2) 
{
	glFogi(n1, n2);
}

extern "C" _declspec(dllexport)
void glfogfv (int n1, float* p) 
{
	glFogfv(n1, p);
}

extern "C" _declspec(dllexport)
void glfogiv (int n, int* p) 
{
	glFogiv(n, p);
}

extern "C" _declspec(dllexport)
void glfeedbackbuffer (int n1, int n2, float* p) 
{
	glFeedbackBuffer(n1, n2, p);
}

extern "C" _declspec(dllexport)
void glpassthrough (float f) 
{
	glPassThrough(f);
}

extern "C" _declspec(dllexport)
void glselectbuffer (int n, unsigned int* p) 
{
	glSelectBuffer(n, p);
}

extern "C" _declspec(dllexport)
void glinitnames () 
{
	glInitNames();
}

extern "C" _declspec(dllexport)
void glloadname (unsigned int u) 
{
	glLoadName(u);
}

extern "C" _declspec(dllexport)
void glpushname (unsigned int u) 
{
	glPushName(u);
}

extern "C" _declspec(dllexport)
void glpopname () 
{
	glPopName();
}

/* These are not declared in the version of OpenGL that I use.
extern "C" _declspec(dllexport)
void glblendequationext (int n) 
{
	glBlendEquationEXT(n);
}

extern "C" _declspec(dllexport)
void glblendcolorext (float f1, float f2, float f3, float f4) 
{
	glBlendColorEXT(f1, f2, f3, f4);
}

extern "C" _declspec(dllexport)
void  glpolygonoffsetext (float f1, float f2) 
{
	glPolygonOffsetEXT(f1, f2);
}
*/

extern "C" _declspec(dllexport)
void glulookat (double d1, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) 
{
	gluLookAt(d1, d2, d3, d4, d5, d6, d7, d8, d9);
}

extern "C" _declspec(dllexport)
void gluortho2d (double d1, double d2, double d3, double d4) 
{
	gluOrtho2D(d1, d2, d3, d4);
}


extern "C" _declspec(dllexport)
void gluperspective (double d1, double d2, double d3, double d4) 
{
	gluPerspective(d1, d2, d3, d4);
}

extern "C" _declspec(dllexport)
void glupickmatrix (double d1, double d2, double d3, double d4, int* p) 
{
	gluPickMatrix(d1, d2, d3, d4, p);
}

extern "C" _declspec(dllexport)
int gluproject (double d1, double d2, double d3, double* p1, double* p2, int* p3, double* p4, double* p5, double* p6) 
{
	return gluProject(d1, d2, d3, p1, p2, p3, p4, p5, p6);
}

extern "C" _declspec(dllexport)
int gluunproject (double d1, double d2, double d3, double* p1, double* p2, int* p3, double* p4, double* p5, double* p6) 
{
	return gluUnProject(d1, d2, d3, p1, p2, p3, p4, p5, p6);
}

extern "C" _declspec(dllexport)
const unsigned char* gluerrorstring (int n)
{
	return gluErrorString(n);
}

extern "C" _declspec(dllexport)
int gluscaleimage (int n1, int n2, int n3, int n4, void* p1, int n5, int n6, int n7, void* p2) 
{
	return gluScaleImage(n1, n2, n3, n4, p1, n5, n6, n7, p2);
}

extern "C" _declspec(dllexport)
int glubuild1dmipmaps (int n1, int n2, int n3, int n4, int n5, void* p) 
{
	return gluBuild1DMipmaps(n1, n2, n3, n4, n5, p);
}

extern "C" _declspec(dllexport)
int glubuild2dmipmaps (int n1, int n2, int n3, int n4, int n5, int n6, void* p) 
{
	return gluBuild2DMipmaps(n1, n2, n3, n4, n5, n6, p);
}


extern "C" _declspec(dllexport)
int* glunewquadric ()
{
	return (int*)gluNewQuadric();
}

extern "C" _declspec(dllexport)
void gludeletequadric (int* p) 
{
	gluDeleteQuadric((GLUquadric*)p);
}


extern "C" _declspec(dllexport)
void gluquadricdrawstyle (int* p,  int n) 
{
	gluQuadricDrawStyle((GLUquadricObj*)p, n);
}

extern "C" _declspec(dllexport)
void gluquadricorientation (int* p, int n) 
{
	gluQuadricOrientation((GLUquadricObj*)p, n);
}

extern "C" _declspec(dllexport)
void gluquadricnormals (int* p, int n) 
{
	gluQuadricNormals((GLUquadricObj*)p, n);
}

extern "C" _declspec(dllexport)
void gluquadrictexture (int* p,  unsigned char c) 
{
	gluQuadricTexture((GLUquadricObj*)p, c);
}

extern "C" _declspec(dllexport)
void gluquadriccallback (int* p, int n, void (__stdcall *func)()) 
{
	gluQuadricCallback((GLUquadricObj*)p, n, func);
}


extern "C" _declspec(dllexport)
void glucylinder (int* p, double d1, double d2, double d3, int n1, int n2) 
{
	gluCylinder((GLUquadricObj*)p, d1, d2, d3, n1, n2);
}

extern "C" _declspec(dllexport)
void glusphere (int* p, double d1, int n1, int n2) 
{
	gluSphere((GLUquadricObj*)p, d1, n1, n2);
}

extern "C" _declspec(dllexport)
void gludisk (int* p, double d1, double d2, int n1, int n2) 
{
	gluDisk((GLUquadricObj*)p, d1, d2, n1, n2);
}

extern "C" _declspec(dllexport)
void glupartialdisk (int* p, double d1, double d2, int n1, int n2, double d3, double d4) 
{
	gluPartialDisk((GLUquadricObj*)p, d1, d2, n1, n2, d3, d4);
}

extern "C" _declspec(dllexport)
int* glunewnurbsrenderer ()
{
	return (int*)gluNewNurbsRenderer();
}


extern "C" _declspec(dllexport)
void gludeletenurbsrenderer (int* p) 
{
	gluDeleteNurbsRenderer((GLUnurbsObj*)p);
}

extern "C" _declspec(dllexport)
void gluloadsamplingmatrices (int* p1, float* p2, float* p3, int* p4) 
{
	gluLoadSamplingMatrices((GLUnurbsObj*)p1, p2, p3, p4);
}

extern "C" _declspec(dllexport)
void glunurbsproperty (int* p, int n, float f) 
{
	gluNurbsProperty((GLUnurbsObj*)p, n, f);
}

extern "C" _declspec(dllexport)
void glugetnurbsproperty (int* p1, int n, float* p2) 
{
	gluGetNurbsProperty((GLUnurbsObj*)p1, n, p2);
}

extern "C" _declspec(dllexport)
void glubegincurve (int* p) 
{
	gluBeginCurve((GLUnurbsObj*)p);
}

extern "C" _declspec(dllexport)
void gluendcurve (int* p) 
{
	gluEndCurve((GLUnurbsObj*)p);
}

extern "C" _declspec(dllexport)
void glunurbscurve (int* p1, int n1, float* p2, int n2, float* p3, int n3, int n4) 
{
	gluNurbsCurve((GLUnurbsObj*)p1, n1, p2, n3, p3, n3, n4);
}

extern "C" _declspec(dllexport)
void glubeginsurface (int* p) 
{
	gluBeginSurface((GLUnurbsObj*)p);
}

extern "C" _declspec(dllexport)
void gluendsurface (int* p) 
{
	gluEndSurface((GLUnurbsObj*)p);
}

extern "C" _declspec(dllexport)
void glunurbssurface (int* p1, int n1, float* p2, int n2, float* p3, int n3, int n4, float* p4, int n5, int n6, int n7) 
{
	gluNurbsSurface((GLUnurbsObj*)p1, n1, p2, n2, p3, n3, n4, p4, n5, n6, n7);
}

extern "C" _declspec(dllexport)
void glubegintrim (int* p) 
{
	gluBeginTrim((GLUnurbsObj*)p);
}

extern "C" _declspec(dllexport)
void gluendtrim (int* p) 
{
	gluEndTrim((GLUnurbsObj*)p);
}

extern "C" _declspec(dllexport)
void glupwlcurve (int* p1, int n1, float* p2, int n2, int n3) 
{
	gluPwlCurve((GLUnurbsObj*)p1, n1, p2, n2, n3);
}

extern "C" _declspec(dllexport)
void glunurbscallback (int* p, int n1, void (__stdcall *func)()) 
{
	gluNurbsCallback((GLUnurbsObj*)p, n1, func);
}


extern "C" _declspec(dllexport)
int* glunewtess ()
{
	return (int*)gluNewTess();
}

extern "C" _declspec(dllexport)
void glutesscallback (int* p, int n1, void (__stdcall *func)()) 
{
	gluTessCallback((GLUtriangulatorObj*)p, n1, func);
}


extern "C" _declspec(dllexport)
void gludeletetess (int* p) 
{
	gluDeleteTess((GLUtriangulatorObj*)p);
}

extern "C" _declspec(dllexport)
void glubeginpolygon (int* p) 
{
	gluBeginPolygon((GLUtriangulatorObj*)p);
}

extern "C" _declspec(dllexport)
void gluendpolygon (int* p) 
{
	gluEndPolygon((GLUtriangulatorObj*)p);
}

extern "C" _declspec(dllexport)
void glunextcontour (int* p, int n) 
{
	gluNextContour((GLUtriangulatorObj*)p, n);
}

extern "C" _declspec(dllexport)
void glutessvertex (int* p1, double* p2, void* p3) 
{
	gluTessVertex((GLUtriangulatorObj*)p1, p2, p3);
}

extern "C" _declspec(dllexport)
const unsigned char* glugetstring (int n)
{
	return gluGetString(n);
}



/* These functions are not part of the version of OpenGL that I am using
extern "C" _declspec(dllexport)
int* glxchoosevisual (int* p1, int n, int* p2)
{
	return (int*)glXChooseVisual(p1, n, p2);
}

extern "C" _declspec(dllexport)
int* glxcreatecontext ((int* p1, int* p2, int* p3, int n)
{
	return (int*)glXCreateContext(p1, p2, p3, n);
}

extern "C" _declspec(dllexport)
void glxdestroycontext (int* p1, int* p2) 
{
	glXDestroyContext(p1, p2);
}

extern "C" _declspec(dllexport)
int glxmakecurrent (int* p1, unsigned long l, int* p2) 
{
	return glXMakeCurrent(p1, l, p2);
}

extern "C" _declspec(dllexport)
void glxcopycontext (int* p1, int* p2, int* p3, unsigned int n) 
{
	glXCopyContext(p1, p2, p3, n);
}

extern "C" _declspec(dllexport)
void glxswapbuffers (int* p1, unsigned long l) 
{
	glXSwapBuffers(p1, l);
}

extern "C" _declspec(dllexport)
unsigned long glxcreateglxpixmap (int* p1, int* p2, unsigned long l)
{
	return glXCreateGLXPixmap(p1, p2, l);
}

extern "C" _declspec(dllexport)
void glxdestroyglxpixmap (int* p, unsigned long l) 
{
	glXDestroyGLXPixmap(p, l);
}

extern "C" _declspec(dllexport)
int glxqueryextension (int* p1, int* p2, int* p3) 
{
	return glXQueryExtension(p1, p2, p3);
}

extern "C" _declspec(dllexport)
int glxqueryversion (int* p1, int* p2, int* p3) 
{
	return glXQueryVersion(p1, p2, p3);
}

extern "C" _declspec(dllexport)
int glxisdirect (int* p1, int* p2) 
{
	return glXIsDirect(p1, p2);
}

extern "C" _declspec(dllexport)
int glxgetconfig (int* p1, int* p2, int n, int* p3) 
{
	return glXGetConfig(p1, p2, n, p3);
}

extern "C" _declspec(dllexport)
int* glxgetcurrentcontext ()
{
	return (int*)glXGetCurrentContext();
}

extern "C" _declspec(dllexport)
unsigned long glxgetcurrentdrawable ()
{
	return glXGetCurrentDrawable();
}

extern "C" _declspec(dllexport)
void glxwaitgl () 
{
	glXWaitGL();
}

extern "C" _declspec(dllexport)
void glxwaitx () 
{
	glXWaitX();
}

extern "C" _declspec(dllexport)
void glxusexfont (unsigned long l, int n1, int n2, int n3) 
{
	glXUseXFont(l, n1, n2, n3);
}

extern "C" _declspec(dllexport)
int* glxqueryextensionsstring (int* p, int n)
{
	return (int*)glXQueryExtensionsString(p, n);
}

extern "C" _declspec(dllexport)
int* glxqueryserverstring (int* p, int n1, int n2)
{
	return (int*)glXQueryServerString(p, n1, n2);
}

extern "C" _declspec(dllexport)
int* glxgetclientstring (int* p, int n1)
{
	return (int*)glXGetClientString(p, n1);
}
*/


extern "C" _declspec(dllexport)
void glutinitdisplaymode (unsigned int n) 
{
	glutInitDisplayMode(n);
}

extern "C" _declspec(dllexport)
void glutinitdisplaystring (char* p) 
{
	glutInitDisplayString(p);
}

extern "C" _declspec(dllexport)
void glutinitwindowposition (int n1, int n2) 
{
	glutInitWindowPosition(n1, n2);
}

extern "C" _declspec(dllexport)
void glutinitwindowsize (int n1, int n2) 
{
	glutInitWindowSize(n1, n2);
}

extern "C" _declspec(dllexport)
void glutmainloop () 
{
	glutMainLoop();
}

extern "C" _declspec(dllexport)
int glutcreatewindow (char* p) 
{
	return glutCreateWindow(p);
}

extern "C" _declspec(dllexport)
int glutcreatesubwindow (int n1, int n2, int n3, int n4, int n5) 
{
	return glutCreateSubWindow(n1, n2, n3, n4, n5);
}

extern "C" _declspec(dllexport)
void glutdestroywindow (int n) 
{
	glutDestroyWindow(n);
}

extern "C" _declspec(dllexport)
void glutpostredisplay () 
{
	glutPostRedisplay();
}

extern "C" _declspec(dllexport)
void glutswapbuffers () 
{
	glutSwapBuffers();
}

extern "C" _declspec(dllexport)
int glutgetwindow () 
{
	return glutGetWindow();
}

extern "C" _declspec(dllexport)
void glutsetwindow (int n) 
{
	glutSetWindow(n);
}

extern "C" _declspec(dllexport)
void glutsetwindowtitle (char* p) 
{
	glutSetWindowTitle(p);
}

extern "C" _declspec(dllexport)
void glutseticontitle (char* p) 
{
	glutSetIconTitle(p);
}


extern "C" _declspec(dllexport)
void glutpositionwindow (int n1, int n2) 
{
	glutPositionWindow(n1, n2);
}

extern "C" _declspec(dllexport)
void glutreshapewindow (int n1, int n2) 
{
	glutReshapeWindow(n1, n2);
}

extern "C" _declspec(dllexport)
void glutpopwindow () 
{
	glutPopWindow();
}

extern "C" _declspec(dllexport)
void glutpushwindow () 
{
	glutPushWindow();
}

extern "C" _declspec(dllexport)
void gluticonifywindow () 
{
	glutIconifyWindow();
}

extern "C" _declspec(dllexport)
void glutshowwindow () 
{
	glutShowWindow();
}

extern "C" _declspec(dllexport)
void gluthidewindow () 
{
	glutHideWindow();
}

extern "C" _declspec(dllexport)
void glutfullscreen () 
{
	glutFullScreen();
}

extern "C" _declspec(dllexport)
void glutsetcursor (int n) 
{
	glutSetCursor(n);
}

extern "C" _declspec(dllexport)
void glutwarppointer (int n1, int n2) 
{
	glutWarpPointer(n1, n2);
}

extern "C" _declspec(dllexport)
void glutestablishoverlay () 
{
	glutEstablishOverlay();
}

extern "C" _declspec(dllexport)
void glutremoveoverlay () 
{
	glutRemoveOverlay();
}

extern "C" _declspec(dllexport)
void glutuselayer (int n) 
{
	glutUseLayer(n);
}

extern "C" _declspec(dllexport)
void glutpostoverlayredisplay () 
{
	glutPostOverlayRedisplay();
}

extern "C" _declspec(dllexport)
void glutshowoverlay () 
{
	glutShowOverlay();
}

extern "C" _declspec(dllexport)
VOID gluthideoverlay () 
{
	glutHideOverlay();
}

extern "C" _declspec(dllexport)
int glutcreatemenu (void (*func)(int)) 
{
	return glutCreateMenu(func);
}


extern "C" _declspec(dllexport)
void glutdestroymenu (int n) 
{
	glutDestroyMenu(n);
}

extern "C" _declspec(dllexport)
int glutgetmenu () 
{
	return glutGetMenu();
}

extern "C" _declspec(dllexport)
void glutsetmenu (int n) 
{
	glutSetMenu(n);
}

extern "C" _declspec(dllexport)
void glutaddmenuentry (char* p, int n) 
{
	glutAddMenuEntry(p, n);
}

extern "C" _declspec(dllexport)
void glutaddsubmenu (char* p, int n) 
{
	glutAddSubMenu(p, n);
}

extern "C" _declspec(dllexport)
void glutchangetomenuentry (int n1, char* p, int n2) 
{
	glutChangeToMenuEntry(n1, p, n2);
}

extern "C" _declspec(dllexport)
void glutchangetosubmenu (int n1, char* p, int n2) 
{
	glutChangeToSubMenu(n1, p, n2);
}

extern "C" _declspec(dllexport)
void glutremovemenuitem (int n) 
{
	glutRemoveMenuItem(n);
}

extern "C" _declspec(dllexport)
void glutattachmenu (int n) 
{
	glutAttachMenu(n);
}

extern "C" _declspec(dllexport)
void glutdetachmenu (int n) 
{
	glutDetachMenu(n);
}

extern "C" _declspec(dllexport)
void glutdisplayfunc (void (*func)()) 
{
	glutDisplayFunc(func);
}

extern "C" _declspec(dllexport)
void glutreshapefunc (void (*func)(int, int)) 
{
	glutReshapeFunc(func);
}

extern "C" _declspec(dllexport)
void glutkeyboardfunc (void (*func)(unsigned char, int, int)) 
{
	glutKeyboardFunc(func);
}

extern "C" _declspec(dllexport)
void glutmousefunc (void (*func)(int, int, int, int)) 
{
	glutMouseFunc(func);
}

extern "C" _declspec(dllexport)
void glutmotionfunc (void (*func)(int, int)) 
{
	glutMotionFunc(func);
}

extern "C" _declspec(dllexport)
void glutpassivemotionfunc (void (*func)(int, int)) 
{
	glutPassiveMotionFunc(func);
}


extern "C" _declspec(dllexport)
void glutentryfunc (void (*func)(int)) 
{
	glutEntryFunc(func);
}

extern "C" _declspec(dllexport)
void glutvisibilityfunc (void (*func)(int)) 
{
	glutVisibilityFunc(func);
}

extern "C" _declspec(dllexport)
void glutidlefunc (void (*func)()) 
{
	glutIdleFunc(func);
}

extern "C" _declspec(dllexport)
void gluttimerfunc (unsigned int u, void (*func)(int), int n) 
{
	glutTimerFunc(u, func, n);
}

extern "C" _declspec(dllexport)
void glutmenustatefunc (void (*func)(int)) 
{
	glutMenuStateFunc(func);
}

extern "C" _declspec(dllexport)
void glutspecialfunc (void (*func)(int, int, int)) 
{
	glutSpecialFunc(func);
}

extern "C" _declspec(dllexport)
void glutspaceballmotionfunc (void (*func)(int, int, int)) 
{
	glutSpaceballMotionFunc(func);
}

extern "C" _declspec(dllexport)
void glutspaceballrotatefunc (void (*func)(int, int, int)) 
{
	glutSpaceballRotateFunc(func);
}

extern "C" _declspec(dllexport)
void glutspaceballbuttonfunc (void (*func)(int, int)) 
{
	glutSpaceballButtonFunc(func);
}

extern "C" _declspec(dllexport)
void glutbuttonboxfunc (void (*func)(int, int)) 
{
	glutButtonBoxFunc(func);
}

extern "C" _declspec(dllexport)
void glutdialsfunc (void (*func)(int, int)) 
{
	glutDialsFunc(func);
}

extern "C" _declspec(dllexport)
void gluttabletmotionfunc (void (*func)(int, int)) 
{
	glutTabletMotionFunc(func);
}

extern "C" _declspec(dllexport)
void gluttabletbuttonfunc (void (*func)(int, int, int, int)) 
{
	glutTabletButtonFunc(func);
}

extern "C" _declspec(dllexport)
void glutmenustatusfunc (void (*func)(int, int, int)) 
{
	glutMenuStatusFunc(func);
}

extern "C" _declspec(dllexport)
void glutoverlaydisplayfunc (void (*func)()) 
{
	glutOverlayDisplayFunc(func);
}

extern "C" _declspec(dllexport)
void glutwindowstatusfunc (void (*func)(int)) 
{
	glutWindowStatusFunc(func);
}

extern "C" _declspec(dllexport)
void glutsetcolor (int n, float f1, float f2, float f3) 
{
	glutSetColor(n, f1, f2, f3);
}

extern "C" _declspec(dllexport)
float glutgetcolor (int n1, int n2)
{
	return glutGetColor(n1, n2);
}

extern "C" _declspec(dllexport)
void glutcopycolormap (int n) 
{
	glutCopyColormap(n);
}

extern "C" _declspec(dllexport)
int glutget (int n) 
{
	return glutGet(n);
}

extern "C" _declspec(dllexport)
int glutdeviceget (int n)
{
	return glutDeviceGet(n);
}

extern "C" _declspec(dllexport)
int glutextensionsupported (char* p) 
{
	return glutExtensionSupported(p);
}

extern "C" _declspec(dllexport)
int glutgetmodifiers () 
{
	return glutGetModifiers();
}

extern "C" _declspec(dllexport)
int glutlayerget (int n) 
{
	return glutLayerGet(n);
}

extern "C" _declspec(dllexport)
void glutbitmapcharacter (void* p, int n) 
{
	glutBitmapCharacter(p, n);
}

extern "C" _declspec(dllexport)
int glutbitmapwidth (void* p, int n) 
{
	return glutBitmapWidth(p, n);
}

extern "C" _declspec(dllexport)
void glutstrokecharacter (void* p, int n) 
{
	glutStrokeCharacter(p, n);
}

extern "C" _declspec(dllexport)
int glutstrokewidth (void* p, int n) 
{
	return glutStrokeWidth(p, n);
}

extern "C" _declspec(dllexport)
int glutbitmaplength (void* p1, unsigned char* p2) 
{
	return glutBitmapLength(p1, p2);
}

extern "C" _declspec(dllexport)
int glutstrokelength (void* p1, unsigned char* p2) 
{
	return glutStrokeLength(p1, p2);
}

extern "C" _declspec(dllexport)
void glutwiresphere (double d, int n1, int n2) 
{
	glutWireSphere(d, n1, n2);
}

extern "C" _declspec(dllexport)
void glutsolidsphere (double d, int n1, int n2) 
{
	glutSolidSphere(d, n1, n2);
}

extern "C" _declspec(dllexport)
void glutwirecone (double d1, double d2, int n1, int n2) 
{
	glutWireCone(d1, d2, n1, n2);
}

extern "C" _declspec(dllexport)
void glutsolidcone (double d1, double d2, int n1, int n2) 
{
	glutSolidCone(d1, d2, n1, n2);
}

extern "C" _declspec(dllexport)
void glutwirecube (double d) 
{
	glutWireCube(d);
}

extern "C" _declspec(dllexport)
void glutsolidcube (double d) 
{
	glutSolidCube(d);
}

extern "C" _declspec(dllexport)
void glutwiretorus (double d1, double d2, int n1, int n2) 
{
	glutWireTorus(d1, d2, n1, n2);
}

extern "C" _declspec(dllexport)
void glutsolidtorus (double d1, double d2, int n1, int n2) 
{
	glutSolidTorus(d1, d2, n1, n2);
}

extern "C" _declspec(dllexport)
void glutwiredodecahedron () 
{
	glutWireDodecahedron();
}

extern "C" _declspec(dllexport)
void glutsoliddodecahedron () 
{
	glutSolidDodecahedron();
}

extern "C" _declspec(dllexport)
void glutwireteapot (double d) 
{
	glutWireTeapot(d);
}

extern "C" _declspec(dllexport)
void glutsolidteapot (double d) 
{
	glutSolidTeapot(d);
}

extern "C" _declspec(dllexport)
void glutwireoctahedron () 
{
	glutWireOctahedron();
}

extern "C" _declspec(dllexport)
void glutsolidoctahedron () 
{
	glutSolidOctahedron();
}

extern "C" _declspec(dllexport)
void glutwiretetrahedron () 
{
	glutWireTetrahedron();
}

extern "C" _declspec(dllexport)
void glutsolidtetrahedron () 
{
	glutSolidTetrahedron();
}

extern "C" _declspec(dllexport)
void glutwireicosahedron () 
{
	glutWireIcosahedron();
}

extern "C" _declspec(dllexport)
void glutsolidicosahedron () 
{
	glutSolidIcosahedron();
}

extern "C" _declspec(dllexport)
int glutvideoresizeget (int n) 
{
	return glutVideoResizeGet(n);
}

extern "C" _declspec(dllexport)
void glutsetupvideoresizing () 
{
	glutSetupVideoResizing();
}

extern "C" _declspec(dllexport)
void glutstopvideoresizing () 
{
	glutStopVideoResizing();
}

extern "C" _declspec(dllexport)
void glutvideoresize (int n1, int n2, int n3, int n4) 
{
	glutVideoResize(n1, n2, n3, n4);
}

extern "C" _declspec(dllexport)
void glutvideopan (int n1, int n2, int n3, int n4) 
{
	glutVideoPan(n1, n2, n3, n4);
}

extern "C" _declspec(dllexport)
void glutreporterrors () 
{
	glutReportErrors();
}

