(**************************************************************************)
(*                   Cameleon                                             *)
(*                                                                        *)
(*      Copyright (C) 2002 Institut National de Recherche en Informatique et   *)
(*      en Automatique. All rights reserved.                              *)
(*                                                                        *)
(*      This program is free software; you can redistribute it and/or modify  *)
(*      it under the terms of the GNU General Public License as published by  *)
(*      the Free Software Foundation; either version 2 of the License, or  *)
(*      any later version.                                                *)
(*                                                                        *)
(*      This program is distributed in the hope that it will be useful,   *)
(*      but WITHOUT ANY WARRANTY; without even the implied warranty of    *)
(*      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     *)
(*      GNU General Public License for more details.                      *)
(*                                                                        *)
(*      You should have received a copy of the GNU General Public License  *)
(*      along with this program; if not, write to the Free Software       *)
(*      Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA          *)
(*      02111-1307  USA                                                   *)
(*                                                                        *)
(*      Contact: Maxence.Guesdon@inria.fr                                *)
(**************************************************************************)

(** Base types *)

open Ocamlcvs.Types


type editor = 
    Efuns
  | Dbforge
  | Emacs
  | XEmacs
  | Report
  | Zoggy
  | Custom_editor of string

let default_editor = ref Efuns

let editor_strings =
  [ "dbforge", Dbforge ;
    "efuns", Efuns ;
    "emacs", Emacs ;
    "xemacs", XEmacs ;
    "report", Report ;
    "zoggy", Zoggy ;
    "", Custom_editor ""
  ] 

let editor_of_string s =
  try List.assoc s editor_strings
  with Not_found -> Custom_editor s

let strings_editor = List.map (fun (e,s) -> (s,e)) editor_strings
let string_of_editor e = 
  match e with
    Custom_editor s -> s
  | _ -> List.assoc e strings_editor


type file_type = {
    mutable ft_regexp_string : string ;
    mutable ft_regexp : Str.regexp ;
    mutable ft_name : string ;
    mutable ft_color : string option;
    mutable ft_edit : editor ;
    mutable ft_templates : string list ;
    mutable ft_binary : bool
  } 

(* The unknown file type. *)
let unknown_file_type () = {
  ft_regexp = Str.regexp "Unknown file type" ;
  ft_regexp_string = "Unknown file type" ;
  ft_name = "" ;
  ft_color = None ;
  ft_edit = !default_editor ;
  ft_templates = [] ;
  ft_binary = false ;
} 

type doc_source = {
    mutable ds_file : string ;
    mutable ds_label_com : (string * string) option ;
  } 

type custom_tool = {
    mutable tool_label : string ;
    mutable tool_pixmap : string ;
    mutable tool_command : string ;
  } 


type file =
    {
      f_name : string ; (* relative or absolute file name *)
      f_abs_name : string ; (* absolute *)
      f_date : float ; (* date of last update of the structure *)
      f_date_string : string ; (* cvs date string *)
      f_work_rev : string ; (* cvs working revision *)
      f_rep_rev : string ; (* cvs repository revision *)
      f_status : cvs_status ; (* cvs status *)
      mutable f_type : file_type ; (* type of file *)
    } 

class type editor_app =
  object
    method close : unit
    method reload : unit
    method save : unit
    method changed : bool
  end

