#include <module.h>
inherit "module";
inherit "caudiumlib";
#include <camas/screens.h>	// For screennames
#include <camas/msg.h>		// MSG() Language macros
#include <camas/globals.h>	// Global definitions

inherit camas_tags;

// ============================================================================
//  MDNDIALOG screen container handler
// ============================================================================
string screen(mapping args, string contents, object id)
{
  CSESSION->screen = "mdndialog";				// Admin screen name
  contents = CAMAS.Parse.parse_html(contents,
                        ([
			  "camas_notifyto"	: tag_mdn_screen,
                          "camas_sendmdn"       : tag_mdn_screen,
                          "camas_nosendmdn"     : tag_mdn_screen
                         ]),
                        ([
                         ]),
                        id);


  if(!id->misc->_xml_parser && QUERY(ent_parse))
    contents = parse_scopes(contents,cb_scopes,id);
  
  args->method  = "post";
  args->name    = "camasmdnform";
  args->enctype = "multipart/form-data";
  args = CAMAS.Tools.set_target(id, args);
  
  contents = CAMAS.Tools.make_container("form", args, contents);
  contents += "<!-- End of screen_MDNDIALOG -->";
  return contents;
}

string tag_mdn_screen(string tag_name, mapping args, object id)
{
  string out = "";                                              // HTML to output
  switch(tag_name)
  {
  case "camas_notifyto":
    //! tag: camas_notifyto
    //!  A string containing the recipient address of the mail delivery notification
    //! note: screen: mdndialog
    object mail = CSESSION->cmail;
    string notify_to = mail->headers["disposition-notification-to"] || mail->headers["return-receipt-to"];
    out = MSGA (M_NOTIFYTO, ({ CAMAS.Tools.fix_header (notify_to) }));
    break;

  case "camas_sendmdn":
    //! tag: camas_sendmdn
    //!  Button for sending the MDN
    //! note: screen: mdndialog
    out = CAMAS.Tools.formdrawbutton(id,"m_sendmdn", "actionsendmdn", MSG(M_YES));
    break;
  case "camas_nosendmdn":
    //! tag: camas_nosendmdn
    //!  Button for not sending the MDN
    //! note: screen: mdndialog
    out = CAMAS.Tools.formdrawbutton(id,"m_read", "actionread", MSG(M_NO));
    break;
  default:
    out += "<!-- " + tag_name + " is not supported yet -->";
    CDEBUG("tag_mdn_screen: " + tag_name + "is not supported yet");
  }

  return out;
}
/*                                                                             
 * Local Variables:                                                            
 * c-basic-offset: 2                                                           
 * End:                                                                        
 *                                                                             
 * vim: softtabstop=2 tabstop=2 expandtab autoindent formatoptions=croqlt smartindent cindent shiftwidth=2
 */
