#include <module.h>
inherit "module";
inherit "caudiumlib";
#include <camas/screens.h>	// For screennames
#include <camas/msg.h>		// MSG() Language macros
#include <camas/globals.h>	// Global definitions
#include <camas/pmods.h>        // Local or normal camas pike modules
#include <camas/addressbook.h> // Address book defines and translations

inherit camas_tags;

// ============================================================================
//  FILTERBOOK screen container handler
// ============================================================================
string screen(mapping args, string contents, object id)
{
  string out = "";
  CSESSION->screen = "filterbook";	// Admin screen name

  mapping tags_handlers = 
    ([
      "camas_newfilter"   : tag_camas_newfilter,
      "camas_backtomailindex"      : tag_camas_readmail,
    ]);
  mapping containers_handlers = 
    ([
      "camas_filterlist"  : container_camas_filterlist,
    ]);
  
  contents = CAMAS.Parse.parse_html(contents, tags_handlers, containers_handlers, id);
  
  if(!id->misc->_xml_parser && QUERY(ent_parse))
    contents = parse_scopes(contents,cb_scopes,id);

  args->method = "post";
  args->name = "camasfilterbookform";

  args = CAMAS.Tools.set_target(id, args);

  out += CAMAS.Tools.make_container("form", args, contents);

  return out;
}

//! container: camas_filterlist
//!  Zone for displaying list of filters
//! note: screen: filterbook
string container_camas_filterlist(string tag_name, mapping args, string contents,object id)
{
  mapping containers_handlers = 
    ([
      "camas_filters"   : container_camas_filterlist_filters,
      "camas_nofilters" : container_camas_filterlist_nofilters,
    ]);
    
  contents = CAMAS.Parse.parse_html(contents, ([ ]), containers_handlers, id);

  return contents;
}

//! container: camas_filters
//!  Zone displayed if there are filters
//! note: screen: filterbook
string container_camas_filterlist_filters(string tag_name, mapping args, string contents,object id)
{
  string out = "";

  // returning and parsing content only if some filters have been set
  if(sizeof (CSESSION->filterbook))
  {
    mapping containers_handlers =
      ([
        "camas_title"     : container_camas_filterlist_filters_title,
        "camas_contents"  : container_camas_filterlist_filters_contents,
      ]);
  
    out = CAMAS.Parse.parse_html(contents, ([ ]), containers_handlers, id);
  }

  return out;
}

//! container: camas_title
//!  Zone for displaying the title
//! note: screen: filterbook
string container_camas_filterlist_filters_title(string tag_name, mapping args, string contents,object id)
{
  array rxmlvariables =
    ({
      ([
        "field"      : MSG(M_INDEXNAMEFIELDFILTER),
        "expression" : MSG(M_INDEXNAMEEDIT),
        "directory"  : MSG(M_ADDRESSFILTER),
      ])
    });
  
  contents = do_output_tag(args, rxmlvariables, contents, id);
  
  return contents;
}

//! container: camas_contents
//!  Zone for diplaying the contents
//! note: screen: filterbook
string container_camas_filterlist_filters_contents(string tag_name, mapping args, string contents,object id)
{
  string out = "";

  int filtercount = 0;
  array(array(string)) filters = CAMAS.Filters.get_filters(id);

  foreach(filters, array filter)
  {
    array rxmlvariables =
        ({
      	  ([
      	    "field"      : CAMAS.Tools.fix_header(filter[0]),
      	    "expression" : CAMAS.Tools.fix_header(filter[1]),
      	    "directory"  : CAMAS.Tools.fix_header(filter[2]),
      	  ])
      	});

    string temp = do_output_tag(args, rxmlvariables, contents, id);
      
    mapping containers_handler =
        ([
      	  "camas_href" : container_camas_filterlist_filters_contents_href,
      	]);

    out += CAMAS.Parse.parse_html(temp, ([ ]), containers_handler, id, filtercount);

    filtercount++;
  }
  
  return out;
}

//! container: camas_href
//!  Actions within the <camas_contents></> container
//! note: screen: filterbook
string container_camas_filterlist_filters_contents_href(string tag_name, mapping args, string contents,object id, int filtercount)
{
  string out = "";

  switch(args->action)
  {
    case "modify":
    case "edit":
      if (id->misc->camas->target != "")
	args -> target = id->misc->camas->target;
      args -> href = id->misc->camas->nexttarget + "-" + 
	CAMAS.Tools.rand_string(20, id->supports->ssl_faulty) + 
	"?actioneditaddressfilter=1&namefield=" + (string)filtercount;
      m_delete(args,"action");

      out += CAMAS.Tools.make_container("a", args, contents);
      break;
   
    // show contents in case the action hasen't been recognized
    default:
      out += contents;
      CDEBUG("FILTERBOOK: camas_action: "+args->action+" not recognized.");
  }

  return out;
}

//! container: camas_nofilters
//!  Zone displayed if there are no filters
//! note: screen: filterbook
string container_camas_filterlist_nofilters(string tag_name, mapping args, string contents,object id)
{
  string out = "";
 
  // returning contents only if no filters have been set
  if(!sizeof (CSESSION->filterbook))
  {
    out = contents;
  }
  
  return out;
}

//! tag: camas_newfilter
//!  Button for adding new filters
//! note: screen: filterbook
string tag_camas_newfilter(string tag_name, mapping args, object id)
{
  object features = id->conf->get_provider ("camas_features");
  if (!objectp(features)){
    CDEBUG("module camas_features is not present");
    return "foobar";
  }
  
  string out = "";
  
  if (features->QUERY(usereditfilterbook))
    out += CAMAS.Tools.formdrawbutton(id,"m_newfilter", "actionnewaddressfilter", MSG(M_NEWADDRESSFILTER)+"...", args);
      
  return out;
}

/*                                                                             
 * Local Variables:                                                            
 * c-basic-offset: 2                                                           
 * End:                                                                        
 *                                                                             
 * vim: softtabstop=2 tabstop=2 expandtab autoindent formatoptions=croqlt smartindent cindent shiftwidth=2
 */
